/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.scilab.modules.commons.gui.ScilabLAF;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.gui.bridge.checkboxmenuitem.SwingScilabCheckBoxMenuItem;
import org.scilab.modules.gui.bridge.menu.SwingScilabMenu;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.checkboxmenuitem.CheckBoxMenuItem;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ScilabToolBar;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.localization.Messages;
import org.scilab.modules.scinotes.SciNotes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class SciNotesGUI {
    private static final String MENU_CONF = System.getenv("SCI") + "/modules/scinotes/etc/scinotesGUIConfiguration.xml";
    private static final String ERROR_READ = "Could not load file: ";
    private static final String MENUBAR = "MenuBar";
    private static final String TOOLBAR = "ToolBar";
    private static final String RIGHTCLICKMENU = "RightClickMenu";
    private static final String MENU = "menu";
    private static final String MNEMONIC = "mnemonic";
    private static final String LABEL = "label";
    private static final String MENUITEM = "menuitem";
    private static final String ACTION = "action";
    private static final String SEPARATOR = "separator";
    private static final String TOOLTIP = "tooltip";
    private static final String ICON = "icon";
    private static final String BUTTON = "button";
    private static final String DOT = ".";
    private static final String DEFAULTACTIONPATH = "org.scilab.modules.scinotes.actions";
    private static Document menuConf;
    private static Map<SciNotes, MenuBar> mapMenuBar;
    private static Map<SciNotes, ToolBar> mapToolBar;
    private static Map<SciNotes, JPopupMenu> mapPopup;
    private static Map<SciNotes, TextBox> mapInfoBar;

    public static void init(SwingScilabWindow swingScilabWindow, SciNotes sciNotes, String string) {
        swingScilabWindow.setTitle(string);
        swingScilabWindow.addTab((SwingScilabPanel)sciNotes);
        swingScilabWindow.setTitle(string);
        swingScilabWindow.setVisible(true);
        SciNotesGUI.init(sciNotes);
    }

    public static void init(SciNotes sciNotes) {
        sciNotes.setMenuBar(SciNotesGUI.generateMenuBar(sciNotes));
        sciNotes.setToolBar(SciNotesGUI.generateToolBar(sciNotes));
        sciNotes.setInfoBar(SciNotesGUI.generateInfoBar(sciNotes));
    }

    public static void clean(SciNotes sciNotes) {
        mapMenuBar.remove((Object)sciNotes);
        mapToolBar.remove((Object)sciNotes);
        mapPopup.remove((Object)sciNotes);
        mapInfoBar.remove((Object)sciNotes);
    }

    public static void reinitMenus(SciNotes sciNotes) {
        mapMenuBar.remove((Object)sciNotes);
        mapPopup.remove((Object)sciNotes);
        sciNotes.setMenuBar(SciNotesGUI.generateMenuBar(sciNotes));
    }

    public static TextBox generateInfoBar(SciNotes sciNotes) {
        if (mapInfoBar.containsKey((Object)sciNotes)) {
            return mapInfoBar.get((Object)sciNotes);
        }
        TextBox textBox = ScilabTextBox.createTextBox();
        mapInfoBar.put(sciNotes, textBox);
        return textBox;
    }

    public static JPopupMenu generateRightClickPopup(SciNotes sciNotes) {
        if (mapPopup.containsKey((Object)sciNotes)) {
            return mapPopup.get((Object)sciNotes);
        }
        SciNotesGUI.readMenusConf();
        JPopupMenu jPopupMenu = new JPopupMenu();
        Element element = menuConf.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagName(RIGHTCLICKMENU).item(0);
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3;
            Node node = nodeList.item(i);
            if (MENUITEM.equals(node.getNodeName())) {
                SwingScilabCheckBoxMenuItem swingScilabCheckBoxMenuItem;
                element3 = (Element)node;
                Object object = SciNotesGUI.getMenuItem(element3.getAttribute(ACTION), element3.getAttribute(LABEL), sciNotes);
                if (object == null) continue;
                if (object instanceof CheckBoxMenuItem) {
                    swingScilabCheckBoxMenuItem = (SwingScilabCheckBoxMenuItem)((CheckBoxMenuItem)object).getAsSimpleCheckBoxMenuItem();
                    jPopupMenu.add((JMenuItem)swingScilabCheckBoxMenuItem);
                    continue;
                }
                if (object instanceof MenuItem) {
                    swingScilabCheckBoxMenuItem = (SwingScilabMenuItem)((MenuItem)object).getAsSimpleMenuItem();
                    jPopupMenu.add((JMenuItem)swingScilabCheckBoxMenuItem);
                    continue;
                }
                if (!(object instanceof Menu)) continue;
                swingScilabCheckBoxMenuItem = (SwingScilabMenu)((Menu)object).getAsSimpleMenu();
                jPopupMenu.add((JMenuItem)swingScilabCheckBoxMenuItem);
                continue;
            }
            if (SEPARATOR.equals(node.getNodeName())) {
                jPopupMenu.addSeparator();
                continue;
            }
            if (!MENU.equals(node.getNodeName())) continue;
            element3 = (SwingScilabMenu)SciNotesGUI.getMenu(sciNotes, (Element)node).getAsSimpleMenu();
            jPopupMenu.add((JMenuItem)((Object)element3));
        }
        mapPopup.put(sciNotes, jPopupMenu);
        return jPopupMenu;
    }

    public static ToolBar generateToolBar(SciNotes sciNotes) {
        if (mapToolBar.containsKey((Object)sciNotes)) {
            return mapToolBar.get((Object)sciNotes);
        }
        SciNotesGUI.readMenusConf();
        ToolBar toolBar = ScilabToolBar.createToolBar();
        Element element = menuConf.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagName(TOOLBAR).item(0);
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (BUTTON.equals(node.getNodeName())) {
                Element element3 = (Element)node;
                JButton jButton = SciNotesGUI.getButton(element3.getAttribute(ACTION), element3.getAttribute(TOOLTIP), element3.getAttribute(ICON), sciNotes);
                ((SwingScilabToolBar)toolBar.getAsSimpleToolBar()).add((Component)jButton);
                continue;
            }
            if (!SEPARATOR.equals(node.getNodeName())) continue;
            toolBar.addSeparator();
        }
        mapToolBar.put(sciNotes, toolBar);
        return toolBar;
    }

    public static MenuBar generateMenuBar(SciNotes sciNotes) {
        if (mapMenuBar.containsKey((Object)sciNotes)) {
            return mapMenuBar.get((Object)sciNotes);
        }
        SciNotesGUI.readMenusConf();
        MenuBar menuBar = ScilabMenuBar.createMenuBar();
        Element element = menuConf.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagName(MENUBAR).item(0);
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!MENU.equals(node.getNodeName())) continue;
            menuBar.add(SciNotesGUI.getMenu(sciNotes, (Element)node));
        }
        mapMenuBar.put(sciNotes, menuBar);
        return menuBar;
    }

    private static void readMenusConf() {
        File file = null;
        DocumentBuilder documentBuilder = null;
        try {
            if (menuConf == null) {
                DocumentBuilderFactory documentBuilderFactory = ScilabDocumentBuilderFactory.newInstance();
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
                file = new File(MENU_CONF);
                menuConf = documentBuilder.parse(file);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(ERROR_READ + MENU_CONF);
        }
        catch (SAXException sAXException) {
            System.err.println(ERROR_READ + MENU_CONF);
        }
        catch (IOException iOException) {
            System.err.println(ERROR_READ + MENU_CONF);
        }
    }

    private static Menu getMenu(SciNotes sciNotes, Element element) {
        Menu menu = ScilabMenu.createMenu();
        menu.setText(Messages.gettext((String)element.getAttribute(LABEL)));
        String string = element.getAttribute(MNEMONIC);
        if (string != null && string.length() != 0) {
            menu.setMnemonic((int)string.charAt(0));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (MENUITEM.equals(node.getNodeName())) {
                Element element2 = (Element)node;
                Object object = SciNotesGUI.getMenuItem(element2.getAttribute(ACTION), element2.getAttribute(LABEL), sciNotes);
                if (object == null) continue;
                if (object instanceof CheckBoxMenuItem) {
                    menu.add((CheckBoxMenuItem)object);
                    continue;
                }
                if (object instanceof MenuItem) {
                    menu.add((MenuItem)object);
                    continue;
                }
                if (!(object instanceof Menu)) continue;
                menu.add((Menu)object);
                continue;
            }
            if (SEPARATOR.equals(node.getNodeName())) {
                menu.addSeparator();
                continue;
            }
            if (!MENU.equals(node.getNodeName())) continue;
            menu.add(SciNotesGUI.getMenu(sciNotes, (Element)node));
        }
        return menu;
    }

    private static Object getMenuItem(String string, String string2, SciNotes sciNotes) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        String string3 = "";
        Method method = null;
        String string4 = SciNotes.getActionName().get(string);
        try {
            string3 = string.lastIndexOf(DOT) != -1 ? string4 : "org.scilab.modules.scinotes.actions." + string4;
            Class<?> clazz = classLoader.loadClass(string3);
            method = clazz.getMethod("createMenu", String.class, SciNotes.class, KeyStroke.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("No action: " + string3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("No valid method createMenu in action: " + string3);
        }
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(null, new Object[]{Messages.gettext((String)string2), sciNotes, SciNotes.getActionKeys().get(string)});
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Warning: problem to create the menu for action: " + string3);
            System.err.println("The menu label is: " + Messages.gettext((String)string2));
            System.err.println("English version will be used instead.");
            System.err.println("Please report a bug at: http://bugzilla.scilab.org");
            try {
                return method.invoke(null, new Object[]{string2, sciNotes, SciNotes.getActionKeys().get(string)});
            }
            catch (InvocationTargetException invocationTargetException2) {
                System.err.println("Problem to create menu of the action: " + string3);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("The method createMenu must be public: " + string3);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("The method createMenu must be public: " + string3);
        }
        return null;
    }

    private static JButton getButton(String string, String string2, String string3, SciNotes sciNotes) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        String string4 = "";
        String string5 = SciNotes.getActionName().get(string);
        try {
            string4 = string.lastIndexOf(DOT) != -1 ? string5 : "org.scilab.modules.scinotes.actions." + string5;
            Class<?> clazz = classLoader.loadClass(string4);
            Method method = clazz.getMethod("createButton", String.class, String.class, SciNotes.class);
            JButton jButton = (JButton)method.invoke(null, new Object[]{Messages.gettext((String)string2), string3, sciNotes});
            ScilabLAF.setDefaultProperties((AbstractButton)jButton);
            return jButton;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("No action: " + string4);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("No valid method createButton in action: " + string4);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("The method createButton must be public: " + string4);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("The method createButton in " + string4 + " threw an exception :");
            invocationTargetException.printStackTrace();
        }
        return null;
    }

    static {
        mapMenuBar = new HashMap<SciNotes, MenuBar>();
        mapToolBar = new HashMap<SciNotes, ToolBar>();
        mapPopup = new HashMap<SciNotes, JPopupMenu>();
        mapInfoBar = new HashMap<SciNotes, TextBox>();
    }
}

