/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes;

import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.View;
import javax.swing.undo.UndoManager;
import org.flexdock.docking.event.DockingEvent;
import org.scilab.modules.commons.CommonFileUtils;
import org.scilab.modules.commons.gui.ScilabGUIUtilities;
import org.scilab.modules.commons.gui.ScilabKeyStroke;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.core.Scilab;
import org.scilab.modules.gui.bridge.filechooser.SwingScilabFileChooser;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.filechooser.ScilabFileChooser;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.messagebox.MessageBox;
import org.scilab.modules.gui.messagebox.ScilabMessageBox;
import org.scilab.modules.gui.messagebox.ScilabModalDialog;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.ConfigManager;
import org.scilab.modules.gui.utils.SciFileFilter;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.scinotes.CompoundUndoManager;
import org.scilab.modules.scinotes.EditorComponent;
import org.scilab.modules.scinotes.HelpOnTypingManager;
import org.scilab.modules.scinotes.SciNotesAutosave;
import org.scilab.modules.scinotes.SciNotesConfiguration;
import org.scilab.modules.scinotes.SciNotesGUI;
import org.scilab.modules.scinotes.SciNotesOptions;
import org.scilab.modules.scinotes.ScilabContext;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorKit;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.ScilabLexer;
import org.scilab.modules.scinotes.ScilabPlainView;
import org.scilab.modules.scinotes.ScilabView;
import org.scilab.modules.scinotes.TabManager;
import org.scilab.modules.scinotes.actions.DoubleQuoteStringAction;
import org.scilab.modules.scinotes.actions.EncodingAction;
import org.scilab.modules.scinotes.actions.EndOfLineAction;
import org.scilab.modules.scinotes.actions.ExitAction;
import org.scilab.modules.scinotes.actions.FindAction;
import org.scilab.modules.scinotes.actions.IncrementalSearchAction;
import org.scilab.modules.scinotes.actions.IndentAction;
import org.scilab.modules.scinotes.actions.InsertOverwriteAction;
import org.scilab.modules.scinotes.actions.LineBeautifierAction;
import org.scilab.modules.scinotes.actions.OpenSourceFileOnKeywordAction;
import org.scilab.modules.scinotes.actions.RecentFileAction;
import org.scilab.modules.scinotes.actions.RegisterFavoriteDirsAction;
import org.scilab.modules.scinotes.actions.RemoveTrailingWhiteAction;
import org.scilab.modules.scinotes.actions.RestoreOpenedFilesAction;
import org.scilab.modules.scinotes.actions.SciNotesCompletionAction;
import org.scilab.modules.scinotes.actions.SearchWordInFilesAction;
import org.scilab.modules.scinotes.tabfactory.CodeNavigatorTab;
import org.scilab.modules.scinotes.tabfactory.SciNotesTab;
import org.scilab.modules.scinotes.tabfactory.SciNotesTabFactory;
import org.scilab.modules.scinotes.tabfactory.SearchInFilesTab;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.DropFilesListener;
import org.scilab.modules.scinotes.utils.NavigatorWindow;
import org.scilab.modules.scinotes.utils.SaveFile;
import org.scilab.modules.scinotes.utils.SciNotesContents;
import org.scilab.modules.scinotes.utils.SciNotesMessages;
import org.scilab.modules.scinotes.utils.ScilabTabbedPane;
import org.scilab.modules.scinotes.utils.SearchFile;

public class SciNotes
extends SwingScilabDockablePanel {
    private static final long serialVersionUID = -6410183357490518676L;
    private static final String XPATH_SCINOTES_KEY = "//general/shortcuts/body/actions/action-folder[@name='Scinotes']/action";
    private static final String XPATH_SCINOTES_ACTION = "/map/scinotes/entry";
    private static final String SCINOTES = "SciNotes";
    private static final String SCI_EXTENSION = ".sci";
    private static final String SCE_EXTENSION = ".sce";
    private static final String TST_EXTENSION = ".tst";
    private static final String QUIT_EXTENSION = ".quit";
    private static final String DEM_EXTENSION = ".dem";
    private static final String START_EXTENSION = ".start";
    private static final String ALL_TST_FILES = "*.tst";
    private static final String ALL_QUIT_FILES = "*.quit";
    private static final String ALL_START_FILES = "*.start";
    private static final String ALL_SCI_FILES = "*.sci";
    private static final String ALL_SCE_FILES = "*.sce";
    private static final String ALL_DEM_FILES = "*.dem";
    private static final String ALL_SCX_FILES = "*.sc*";
    private static final String ALL_SCILAB = "all";
    private static final String ALL_FILES = "*.*";
    private static final String DOT = ".";
    private static final String DEFAULTACTIONPATH = "org.scilab.modules.scinotes.actions";
    private static final Map<String, String> actionToName;
    private static Map<String, KeyStroke> actionKeys;
    private static List<SciNotes> scinotesList;
    private static SciNotes editor;
    private static boolean mustWrapLines;
    private SwingScilabWindow parentWindow;
    private UUID uuid;
    private ScilabTabbedPane tabPane;
    private final SciNotesContents contentPane;
    private NavigatorWindow navigator;
    private SearchFile searchInFiles;
    private int numberOfUntitled;
    private EditorKit editorKit;
    private JButton undoButton;
    private JButton redoButton;
    private boolean protectOpenFileList;
    private boolean restored;
    private boolean firstOpen = true;
    private final List<Integer> tabList = new ArrayList<Integer>();
    private final List<Integer> closedTabList = new ArrayList<Integer>();

    public SciNotes(String string) {
        super(SCINOTES, string);
        this.setWindowIcon("accessories-text-editor");
        this.setAssociatedXMLIDForHelp("scinotes");
        this.uuid = UUID.fromString(string);
        SciNotesAutosave.autosave();
        editor = this;
        scinotesList.add(this);
        this.numberOfUntitled = 0;
        mustWrapLines = SciNotesOptions.getSciNotesDisplay().wrapLines;
        this.editorKit = new ScilabEditorKit(!mustWrapLines);
        this.protectOpenFileList = false;
        this.contentPane = new SciNotesContents(this);
        this.tabPane = this.contentPane.getScilabTabbedPane();
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (SciNotes.this.getTextPane() != null) {
                    SciNotes.this.getTextPane().updateInfosWhenFocused();
                    SciNotes.this.getTextPane().requestFocus();
                    SciNotes.this.getTextPane().highlightWords(IncrementalSearchAction.getWord(SciNotes.this), IncrementalSearchAction.getExact(SciNotes.this));
                    EncodingAction.updateEncodingMenu((ScilabDocument)SciNotes.this.getTextPane().getDocument());
                    EndOfLineAction.updateEolMenu((ScilabDocument)SciNotes.this.getTextPane().getDocument());
                    SciNotes.this.setTitle(SciNotes.this.getTextPane().getTitle());
                }
            }
        });
        this.setContentPane(this.contentPane);
    }

    public SciNotes() {
        this(UUID.randomUUID().toString());
    }

    public static void configurationChanged(SciNotesConfiguration.Conf conf) {
        SciNotes.setWhereamiLineNumbering();
        SciNotes.setAutoIndent();
        SciNotes.setHorizontalWrap();
        SciNotes.setDefaultTabulation();
        if (conf.keymap) {
            actionKeys = null;
            SciNotes.setKeyStrokeActions();
            SciNotes.setAllMenus();
        }
        if (conf.autosave) {
            SciNotesAutosave.stopAutosave();
            SciNotesAutosave.autosave();
        }
        if (conf.preferences) {
            RecentFileAction.updateRecentOpenedFilesMenu();
        }
        SciNotes.updatePanes(conf);
    }

    public static Map<String, KeyStroke> getActionKeys() {
        if (actionKeys == null) {
            org.w3c.dom.Document document = XConfiguration.getXConfigurationDocument();
            actionKeys = XConfiguration.get((org.w3c.dom.Document)document, (String)"name", String.class, (String)"key", KeyStroke.class, (String)XPATH_SCINOTES_KEY);
        }
        return actionKeys;
    }

    public static Map<String, String> getActionName() {
        return actionToName;
    }

    public static SciNotes getEditorFromUUID(String string) {
        for (SciNotes sciNotes : scinotesList) {
            if (!sciNotes.getPersistentId().equals(string)) continue;
            return sciNotes;
        }
        return null;
    }

    public void setParentWindow() {
        this.parentWindow = SwingScilabWindow.createWindow((boolean)true);
        this.parentWindow.setLocation(150, 50);
        this.parentWindow.setSize(650, 550);
    }

    public void setTitle(String string) {
        super.setTitle(string);
        SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, this.tabPane);
        if (swingScilabWindow != null) {
            swingScilabWindow.setTitle(string);
        }
    }

    public void insertBottomComponent(Component component) {
        this.contentPane.insertBottomComponent(component);
    }

    public SwingScilabWindow getSwingParentWindow() {
        return (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)this));
    }

    public void undockingComplete(DockingEvent dockingEvent) {
        super.undockingComplete(dockingEvent);
        if (this.navigator != null) {
            this.navigator.addToolBar(null);
        }
        if (this.searchInFiles != null) {
            this.searchInFiles.addToolBar(null);
        }
    }

    public void dockingComplete(DockingEvent dockingEvent) {
        super.dockingComplete(dockingEvent);
        if (this.navigator != null) {
            this.navigator.changeToolBar();
        }
        if (this.searchInFiles != null) {
            this.searchInFiles.changeToolBar();
        }
    }

    public void addNavigator() {
        if (this.navigator == null) {
            String string = ConfigSciNotesManager.getCodeNavigatorStateForEditor(this.getPersistentId());
            boolean bl = WindowsConfigurationManager.restoreUUID((String)string);
            if (!bl) {
                this.navigator = CodeNavigatorTab.getCodeNavigatorInstance(this, null);
                this.navigator.setParentWindow();
            }
            int n = this.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                this.navigator.addEditorPane(this.getTextPane(i));
            }
        }
    }

    public void addNavigator(NavigatorWindow navigatorWindow) {
        this.navigator = navigatorWindow;
    }

    public void removeNavigator() {
        this.navigator = null;
    }

    public NavigatorWindow getNavigator() {
        return this.navigator;
    }

    public void addSearchInFiles() {
        String string;
        boolean bl;
        if (this.searchInFiles == null && !(bl = WindowsConfigurationManager.restoreUUID((String)(string = ConfigSciNotesManager.getSearchInFilesStateForEditor(this.getPersistentId()))))) {
            this.searchInFiles = SearchInFilesTab.getSearchInFilesTabInstance(this, null);
            this.searchInFiles.setParentWindow();
        }
    }

    public void addSearchInFiles(SearchFile searchFile) {
        this.searchInFiles = searchFile;
    }

    public void removeSearchInFiles() {
        this.searchInFiles = null;
    }

    public SearchFile getSearchInFiles() {
        return this.searchInFiles;
    }

    public static void updateSciNotes() {
        ScilabLexer.update();
        for (SciNotes sciNotes : scinotesList) {
            if (sciNotes.getTextPane() == null) continue;
            sciNotes.getTextPane().repaint();
        }
    }

    public static void scinotes() {
        ScilabLexer.update();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SciNotes.launchSciNotes();
                    if (editor.getTabPane().getTabCount() == 0) {
                        editor.openFile(null, 0, null);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(SciNotes.class.getName()).severe(interruptedException.toString());
            throw new RuntimeException(interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(SciNotes.class.getName()).severe(invocationTargetException.toString());
            invocationTargetException.printStackTrace();
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static void scinotes(final String string) {
        ScilabLexer.update();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SciNotes.launchSciNotes();
                    editor.openFile(string, 0, null);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(SciNotes.class.getName()).severe(interruptedException.toString());
            throw new RuntimeException(interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Logger.getLogger(SciNotes.class.getName()).severe(invocationTargetException.toString());
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static void scinotes(final String string, final int n, final String string2) {
        ScilabLexer.update();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SciNotes.launchSciNotes();
                    editor.openFile(string, n, string2);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(SciNotes.class.getName()).severe(interruptedException.toString());
            throw new RuntimeException(interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Logger.getLogger(SciNotes.class.getName()).severe(invocationTargetException.toString());
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static void scinotes(final String string, final String[] stringArray) throws Exception {
        boolean bl = false;
        if (stringArray != null && stringArray.length != 0) {
            try {
                bl = SciNotes.executeAction(string, stringArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception(String.format(SciNotesMessages.INVALID_FILE, string));
            }
            catch (IOException iOException) {
                throw new Exception(String.format(SciNotesMessages.IO_EXCEPTION, iOException.getLocalizedMessage()));
            }
        }
        if (bl) {
            return;
        }
        ScilabLexer.update();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SciNotes.launchSciNotes();
                    if (stringArray != null && stringArray.length != 0) {
                        editor.openFile(string, 0, stringArray[0]);
                    } else {
                        editor.openFile(string, 0, "");
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(SciNotes.class.getName()).severe(interruptedException.toString());
            throw new RuntimeException(interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Logger.getLogger(SciNotes.class.getName()).severe(invocationTargetException.toString());
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static void scinotesWithText(String string) {
        Object object;
        ScilabLexer.update();
        SciNotes.launchSciNotes();
        ScilabEditorPane scilabEditorPane = editor.getTabPane().getTabCount() != 0 && editor.getTextPane(0) != null ? ((object = editor.getTextPane(0).getName()) == null ? editor.getTextPane(0) : editor.addEmptyTab()) : editor.addEmptyTab();
        object = (ScilabDocument)scilabEditorPane.getDocument();
        try {
            editor.getEditorKit().read(new StringReader(string), (Document)object, scilabEditorPane.getCaretPosition());
        }
        catch (IOException iOException) {
            System.err.println(SciNotesMessages.ERROR_WITH_STRING);
        }
        catch (BadLocationException badLocationException) {
            System.err.println(SciNotesMessages.ERROR_WITH_STRING);
        }
    }

    public static void cloneAndCloseCurrentTab(SciNotes sciNotes, boolean bl) {
        ScilabDocument scilabDocument = (ScilabDocument)sciNotes.getTextPane().getDocument();
        String string = sciNotes.getTabPane().getScilabTitleAt(sciNotes.getTabPane().getSelectedIndex());
        ScilabEditorPane scilabEditorPane = sciNotes.getTextPane();
        String string2 = sciNotes.getTitle();
        if (bl) {
            sciNotes.closeTabAtWithoutConfirmation(sciNotes.getTabPane().getSelectedIndex());
            if (sciNotes.getTabPane().getTabCount() == 0) {
                ClosingOperationsManager.startClosingOperationWithoutSave((SwingScilabDockablePanel)sciNotes);
                ConfigSciNotesManager.removeEditorUUID(sciNotes.uuid.toString());
            }
        }
        editor = null;
        SciNotes.scinotesWithText(scilabDocument.getText());
        ScilabEditorPane scilabEditorPane2 = editor.getTextPane();
        if (scilabEditorPane.getName() != null) {
            scilabEditorPane2.setTitle(string);
            editor.setTitle(string2);
        }
        scilabEditorPane.copyProps(scilabEditorPane2);
        ScilabDocument scilabDocument2 = (ScilabDocument)scilabEditorPane2.getDocument();
        scilabDocument2.setContentModified(scilabDocument.isContentModified());
        scilabDocument2.getUndoManager().discardAllEdits();
        scilabEditorPane2.setCaretPosition(0);
        editor.enableUndoButton(false);
        editor.enableRedoButton(false);
        ConfigSciNotesManager.saveToOpenFiles(scilabEditorPane2.getName(), editor, editor.getTextPane());
        editor.activeRestoreTab();
    }

    public static void cloneAndCloseCurrentTab(SciNotes sciNotes, boolean bl, int n, int n2) {
        SciNotes.cloneAndCloseCurrentTab(sciNotes, bl);
        editor.getSwingParentWindow().setLocation(n, n2);
    }

    public void endedRestoration() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SciNotes.this.restorePreviousSession();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(SciNotes.class.getName()).severe(interruptedException.toString());
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(SciNotes.class.getName()).severe(invocationTargetException.toString());
                throw new RuntimeException(invocationTargetException);
            }
        } else {
            this.restorePreviousSession();
        }
    }

    public void restorePreviousSession() {
        this.restored = true;
        if (!SciNotesOptions.getSciNotesPreferences().restartOpen || !ConfigSciNotesManager.getRestoreOpenedFiles() || ConfigSciNotesManager.countExistingOpenFiles(this.getUUID()) == 0) {
            if (this.getTabPane().getTabCount() == 0) {
                this.openFile(null, 0, null);
            }
            WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)this);
            return;
        }
        this.addRestoreTab();
        WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)this);
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            RestoreOpenedFilesAction.restoreEnabledComponents(this);
        }
    }

    public static void launchSciNotes() {
        int n;
        if (editor == null) {
            List<String> list = ConfigSciNotesManager.getEditorsUUID();
            boolean bl = false;
            if (!list.isEmpty()) {
                for (String string : list) {
                    boolean bl2 = false;
                    for (SciNotes sciNotes : scinotesList) {
                        if (!sciNotes.uuid.toString().equals(string)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    bl = WindowsConfigurationManager.restoreUUID((String)string);
                    if (bl) break;
                    ConfigSciNotesManager.removeEditorUUID(string);
                }
            }
            if (!bl) {
                editor = SciNotesTab.getEditorInstance(null);
                editor.setParentWindow();
                ConfigSciNotesManager.saveEditorUUID(editor.getPersistentId());
                SciNotesGUI.init(editor.getParentWindow(), editor, SCINOTES);
                WindowsConfigurationManager.unregisterEndedRestoration((SwingScilabDockablePanel)editor);
            }
        } else if (editor.getParentWindow() != null && ((n = editor.getParentWindow().getExtendedState()) & 1) == 1) {
            editor.getParentWindow().setExtendedState(n - 1);
        }
        if (!SciNotes.editor.restored) {
            editor.restorePreviousSession();
        }
        ScilabGUIUtilities.toFront((org.flexdock.view.View)editor, (String)SciNotesMessages.SCILAB_EDITOR);
    }

    public void openFile(String string, int n, String string2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("called outside the EDT thread.");
        }
        if (string == null) {
            this.addEmptyTab();
            this.activeRestoreTab();
            return;
        }
        File file = SciNotes.fileToCanonicalFile(new File(string));
        if (!file.getParentFile().exists()) {
            JOptionPane.showMessageDialog((Component)((Object)this), SciNotesMessages.OPEN_ERROR);
            this.addEmptyTab();
            this.activeRestoreTab();
            return;
        }
        if (file.isDirectory()) {
            ConfigManager.saveLastOpenedDirectory((String)file.getPath());
            this.addEmptyTab();
            this.activeRestoreTab();
            return;
        }
        this.readFileAndWait(file);
        if (string2 == null || string2.length() == 0 || "readonly".equals(string2.toLowerCase())) {
            this.getTextPane().scrollTextToLineNumber(n, true);
        } else {
            this.getTextPane().scrollTextToLineNumberInWhereami(n, string2, true);
        }
        if (string2 != null && "readonly".equals(string2.toLowerCase())) {
            this.getTextPane().setReadOnly(true);
            this.getInfoBar().setText(this.getTextPane().getInfoBarText());
            ConfigSciNotesManager.removeFromOpenFiles(this, this.getTextPane());
        } else {
            ConfigSciNotesManager.saveToRecentOpenedFiles(string);
            RecentFileAction.updateRecentOpenedFilesMenu(this);
        }
        this.activeRestoreTab();
    }

    public void activeRestoreTab() {
        if (this.getTextPane(0) == null) {
            this.tabPane.setSelectedIndex(0);
            this.getInfoBar().setText("");
        }
    }

    public void closeSciNotes() {
        for (int i = 0; i < this.getTabPane().getTabCount(); ++i) {
            ScilabEditorPane scilabEditorPane = this.getTextPane(i);
            if (scilabEditorPane == null) continue;
            scilabEditorPane.destroy();
        }
        FindAction.close();
        IncrementalSearchAction.close(this);
        RecentFileAction.close(this);
        OpenSourceFileOnKeywordAction.closeOpenSourceWindow();
        SearchWordInFilesAction.closeWindow();
        scinotesList.remove((Object)this);
        if (scinotesList.size() == 0) {
            SciNotesAutosave.stopAutosave();
            ScilabEditorPane.clean();
            RegisterFavoriteDirsAction.close();
            OpenSourceFileOnKeywordAction.close();
            EncodingAction.close();
            EndOfLineAction.close();
            HelpOnTypingManager.close();
        }
        editor = null;
        SciNotesGUI.clean(this);
        this.close();
        ConfigSciNotesManager.resetDocument();
    }

    public boolean canClose() {
        int n = this.getTabPane().getTabCount();
        this.setProtectOpenFileList(true);
        for (int i = 0; i < n; ++i) {
            boolean bl = this.checkToCloseTabAt(i);
            if (bl) continue;
            this.setProtectOpenFileList(false);
            return false;
        }
        this.setProtectOpenFileList(false);
        return true;
    }

    public String askForClosing() {
        int n = this.getTabPane().getTabCount();
        boolean bl = false;
        for (int i = 0; i < this.getTabPane().getTabCount(); ++i) {
            ScilabEditorPane scilabEditorPane = this.getTextPane(i);
            if (scilabEditorPane == null || !((ScilabDocument)scilabEditorPane.getDocument()).isContentModified()) continue;
            bl = true;
            break;
        }
        if (bl) {
            return SCINOTES;
        }
        return null;
    }

    public static void closeEditor(SciNotes sciNotes) {
        if (scinotesList.size() > 1) {
            ClosingOperationsManager.startClosingOperationWithoutSave((SwingScilabDockablePanel)sciNotes);
        } else {
            ClosingOperationsManager.startClosingOperation((SwingScilabDockablePanel)sciNotes);
        }
    }

    public boolean closeTabAtWithoutConfirmation(int n) {
        return this.closeTabAt(n, false, false);
    }

    public boolean closeTabAt(int n) {
        return this.closeTabAt(n, false, true);
    }

    public boolean closeTabAt(int n, boolean bl, boolean bl2) {
        ScilabEditorPane scilabEditorPane = this.getTextPane(n);
        if (bl2 && ((ScilabDocument)scilabEditorPane.getDocument()).isContentModified() && !this.save(n, false, bl)) {
            return false;
        }
        scilabEditorPane.close();
        if (scilabEditorPane.getName() == null) {
            String string = this.tabPane.getScilabTitleAt(n);
            String string2 = string.substring(string.length() - 1, string.length());
            this.tabList.remove(Integer.valueOf(string2));
            this.closedTabList.add(Integer.valueOf(string2));
        }
        if (n == 0 && this.getTabPane().getTabCount() == 1) {
            for (int i = 0; i < this.tabPane.getChangeListeners().length; ++i) {
                this.tabPane.removeChangeListener(this.tabPane.getChangeListeners()[i]);
            }
        }
        if (!this.protectOpenFileList) {
            ConfigSciNotesManager.removeFromOpenFiles(this, scilabEditorPane);
        }
        if (this.navigator != null) {
            this.navigator.removePane(scilabEditorPane);
        }
        this.tabPane.remove(n);
        scilabEditorPane = this.getTextPane();
        if (scilabEditorPane != null && this.navigator != null) {
            this.navigator.update((ScilabDocument)scilabEditorPane.getDocument());
        }
        return true;
    }

    public boolean checkToCloseTabAt(int n) {
        ScilabEditorPane scilabEditorPane = this.getTextPane(n);
        return scilabEditorPane == null || !((ScilabDocument)scilabEditorPane.getDocument()).isContentModified() || this.save(n, false, false);
    }

    public void setProtectOpenFileList(boolean bl) {
        this.protectOpenFileList = bl;
    }

    public boolean isOnlyInstance() {
        return scinotesList.size() <= 1;
    }

    public static List<SciNotes> getSciNotesList() {
        return scinotesList;
    }

    public boolean save(int n) {
        return this.save(n, false, false);
    }

    public boolean save(int n, boolean bl) {
        return this.save(n, bl, false);
    }

    public boolean save(int n, boolean bl, boolean bl2) {
        String string;
        ScilabEditorPane scilabEditorPane = this.getTextPane(n);
        this.getTabPane().setSelectedIndex(n);
        if (!scilabEditorPane.checkExternalModif() && !((ScilabDocument)scilabEditorPane.getDocument()).isContentModified() && scilabEditorPane.getName() != null) {
            return true;
        }
        if (!bl) {
            string = bl2 ? ScilabModalDialog.show((SimpleTab)this, (String)String.format(SciNotesMessages.MODIFIED, scilabEditorPane.getShortName()), (String)SciNotesMessages.SCILAB_EDITOR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) : ScilabModalDialog.show((SimpleTab)this, (String)String.format(SciNotesMessages.MODIFIED, scilabEditorPane.getShortName()), (String)SciNotesMessages.SCILAB_EDITOR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO_CANCEL);
            switch (10.$SwitchMap$org$scilab$modules$gui$messagebox$ScilabModalDialog$AnswerOption[string.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
        }
        if ((string = (string = scilabEditorPane.getName()) == null ? this.chooseFileToSave(SciNotesMessages.SAVE) : this.checkExternalModification(string)) == null || string.length() == 0) {
            return true;
        }
        File file = new File(string);
        if (!SaveFile.doSave(scilabEditorPane, n, file, this.editorKit)) {
            return false;
        }
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        scilabDocument.setContentModified(false);
        scilabEditorPane.setLastModified(file.lastModified());
        if (scilabEditorPane.getName() == null) {
            String string2 = this.getTabPane().getScilabTitleAt(n);
            String string3 = string2.substring(string2.length() - 1, string2.length());
            this.tabList.remove(Integer.valueOf(string3));
            this.closedTabList.add(Integer.valueOf(string3));
        }
        scilabEditorPane.setName(string);
        this.getTabPane().setTitleAt(n, file.getName());
        this.setTitle(scilabEditorPane.getTitle());
        ConfigSciNotesManager.saveToOpenFiles(string, this, scilabEditorPane);
        return true;
    }

    public boolean overwrite(int n) {
        ScilabEditorPane scilabEditorPane = this.getTextPane(n);
        String string = scilabEditorPane.getName();
        if (string == null) {
            return true;
        }
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        if (!SaveFile.doSave(scilabEditorPane, n, file, this.editorKit)) {
            return false;
        }
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        scilabDocument.setContentModified(false);
        this.getTabPane().setTitleAt(this.getTabPane().getSelectedIndex(), file.getName());
        this.getTextPane().setLastModified(file.lastModified());
        scilabEditorPane.setName(string);
        this.setTitle(scilabEditorPane.getTitle());
        return true;
    }

    public String checkExternalModification(String string) {
        File file = new File(string);
        if (file.lastModified() > this.getTextPane().getLastModified() && ScilabModalDialog.show((SimpleTab)this, (String)String.format(SciNotesMessages.EXTERNAL_MODIFICATION, file.getPath()), (String)SciNotesMessages.REPLACE_FILE_TITLE, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) == ScilabModalDialog.AnswerOption.NO_OPTION) {
            return this.chooseFileToSave(SciNotesMessages.SAVE);
        }
        return string;
    }

    public String chooseFileToSave(String string) {
        return this.chooseFileToSave(string, null);
    }

    public String chooseFileToSave(String string, String string2) {
        int n;
        String string3 = new String();
        String string4 = string2;
        if (string4 == null) {
            string4 = this.getTextPane().getName();
        }
        if (string4 == null) {
            if (this.firstOpen) {
                string4 = CommonFileUtils.getCWD();
                this.firstOpen = false;
            } else {
                string4 = ConfigManager.getLastOpenedDirectory();
            }
        }
        SciFileFilter sciFileFilter = new SciFileFilter(ALL_SCE_FILES, null, 0);
        SciFileFilter sciFileFilter2 = new SciFileFilter(ALL_SCI_FILES, null, 1);
        SciFileFilter sciFileFilter3 = new SciFileFilter(ALL_SCX_FILES, null, 2);
        SciFileFilter sciFileFilter4 = new SciFileFilter(ALL_TST_FILES, null, 3);
        SciFileFilter sciFileFilter5 = new SciFileFilter(ALL_START_FILES, null, 4);
        SciFileFilter sciFileFilter6 = new SciFileFilter(ALL_QUIT_FILES, null, 5);
        SciFileFilter sciFileFilter7 = new SciFileFilter(ALL_DEM_FILES, null, 6);
        SciFileFilter sciFileFilter8 = new SciFileFilter(ALL_FILES, null, 7);
        SciFileFilter sciFileFilter9 = new SciFileFilter(ALL_SCILAB, null, 8);
        SwingScilabFileChooser swingScilabFileChooser = (SwingScilabFileChooser)ScilabFileChooser.createFileChooser().getAsSimpleFileChooser();
        swingScilabFileChooser.setAcceptAllFileFilterUsed(false);
        swingScilabFileChooser.setInitialDirectory(string4);
        swingScilabFileChooser.setUiDialogType(1);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter2);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter3);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter4);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter5);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter6);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter7);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter8);
        swingScilabFileChooser.addChoosableFileFilter((FileFilter)sciFileFilter9);
        String string5 = string4;
        File file = new File(string5);
        SciFileFilter sciFileFilter10 = sciFileFilter;
        for (FileFilter object : swingScilabFileChooser.getChoosableFileFilters()) {
            if (!((SciFileFilter)object).accept(file)) continue;
            sciFileFilter10 = (SciFileFilter)object;
            break;
        }
        swingScilabFileChooser.setFileFilter((FileFilter)sciFileFilter10);
        swingScilabFileChooser.setTitle(string);
        if (string5 == null && (string5 = ((ScilabDocument)this.getTextPane().getDocument()).getFirstFunctionName()) != null) {
            string5 = string5 + SCI_EXTENSION;
        }
        if (string5 != null) {
            swingScilabFileChooser.setSelectedFile(new File(string5));
        }
        if ((n = swingScilabFileChooser.showSaveDialog((Component)((Object)this))) == 0) {
            File file2 = SciNotes.fileToCanonicalFile(swingScilabFileChooser.getSelectedFile());
            string4 = file2.getPath();
            if (file2.exists() && ScilabModalDialog.show((SimpleTab)this, (String)SciNotesMessages.REPLACE_FILE_TITLE, (String)SciNotesMessages.FILE_ALREADY_EXIST, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.QUESTION_ICON, (ScilabModalDialog.ButtonType)ScilabModalDialog.ButtonType.YES_NO) == ScilabModalDialog.AnswerOption.NO_OPTION) {
                return this.chooseFileToSave(SciNotesMessages.SAVE);
            }
            int n2 = 1;
            String string6 = file2.getName();
            if (string6.lastIndexOf(DOT) != -1 && string6.substring(string6.lastIndexOf(DOT), string6.length()).length() >= 2 && string6.substring(string6.lastIndexOf(DOT), string6.length()).length() <= 4) {
                n2 = 0;
            }
            if (n2 != 0) {
                string3 = swingScilabFileChooser.getFileFilter() == sciFileFilter2 ? SCI_EXTENSION : (swingScilabFileChooser.getFileFilter() == sciFileFilter ? SCE_EXTENSION : (swingScilabFileChooser.getFileFilter() == sciFileFilter3 ? SCE_EXTENSION : (swingScilabFileChooser.getFileFilter() == sciFileFilter4 ? TST_EXTENSION : (swingScilabFileChooser.getFileFilter() == sciFileFilter5 ? START_EXTENSION : (swingScilabFileChooser.getFileFilter() == sciFileFilter6 ? QUIT_EXTENSION : (swingScilabFileChooser.getFileFilter() == sciFileFilter7 ? DEM_EXTENSION : ""))))));
                return file2.getPath() + string3;
            }
            if (string4 != null) {
                ConfigManager.saveLastOpenedDirectory((String)string4);
            }
            return file2.getPath();
        }
        if (n == 1) {
            return "";
        }
        return null;
    }

    public boolean saveAs(String string) {
        String string2 = this.chooseFileToSave(SciNotesMessages.SAVE_AS, string);
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        File file = new File(string2);
        ScilabDocument scilabDocument = (ScilabDocument)this.getTextPane().getDocument();
        if (!SaveFile.doSave(this.getTextPane(), this.getTabPane().getSelectedIndex(), file, this.editorKit)) {
            return false;
        }
        if (this.getTextPane().getName() == null) {
            String string3 = this.getTabPane().getScilabTitleAt(this.getTabPane().getSelectedIndex());
            String string4 = string3.substring(string3.length() - 1, string3.length());
            this.tabList.remove(Integer.valueOf(string4));
            this.closedTabList.add(Integer.valueOf(string4));
        }
        this.firstOpen = false;
        ConfigManager.saveLastOpenedDirectory((String)file.getPath());
        ConfigSciNotesManager.saveToRecentOpenedFiles(file.getPath());
        ConfigSciNotesManager.renameOpenFilesItem(file.getPath(), this, this.getTextPane());
        this.getTextPane().setName(file.getPath());
        this.getTabPane().setTitleAt(this.getTabPane().getSelectedIndex(), file.getName());
        this.setTitle(this.getTextPane().getTitle());
        RecentFileAction.updateRecentOpenedFilesMenu(this);
        if (this.navigator != null) {
            this.navigator.update(scilabDocument);
        }
        scilabDocument.setContentModified(false);
        this.getTextPane().setLastModified(file.lastModified());
        this.getTextPane().setReadOnly(false);
        this.getInfoBar().setText(this.getTextPane().getInfoBarText());
        return true;
    }

    public ScilabEditorPane addTab(String string) {
        return this.addTab(string, Integer.MAX_VALUE);
    }

    public ScilabEditorPane addTab(String string, int n) {
        return this.addTab(string, n, 0);
    }

    public ScilabEditorPane addTab(String string, int n, int n2) {
        ScilabEditorPane scilabEditorPane = new ScilabEditorPane(this);
        this.initPane(scilabEditorPane);
        int n3 = Math.min(Math.max(0, n), this.tabPane.getTabCount());
        this.tabPane.insertTab(string, null, scilabEditorPane.getEditorComponent(), "", n3);
        this.tabPane.setSelectedIndex(n3);
        this.initInputMap(scilabEditorPane);
        this.updateTabTitle();
        this.getInfoBar().setText(scilabEditorPane.getInfoBarText());
        this.repaint();
        scilabEditorPane.init(n2);
        return scilabEditorPane;
    }

    public void addRestoreTab() {
        try {
            JPanel jPanel = RestoreOpenedFilesAction.getTab(this, this.getUUID().toString());
            if (jPanel != null) {
                this.tabPane.addTab("Restore", jPanel);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void initPane(ScilabEditorPane scilabEditorPane) {
        this.initPane(scilabEditorPane, !SciNotesOptions.getSciNotesDisplay().wrapLines);
    }

    public void initPane(ScilabEditorPane scilabEditorPane, boolean bl) {
        SciNotes.setHighlight(scilabEditorPane);
        ScilabEditorKit scilabEditorKit = new ScilabEditorKit(bl);
        scilabEditorPane.setEditorKit(scilabEditorKit);
        scilabEditorPane.getXln().setWhereamiLineNumbering(SciNotesOptions.getSciNotesDisplay().showLineNumbers, SciNotesOptions.getSciNotesDisplay().whereami);
        SciNotes.activateHelpOnTyping(scilabEditorPane);
        scilabEditorPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        scilabEditorPane.setFont(scilabEditorKit.getStylePreferences().tokenFonts[0]);
        scilabEditorPane.setBackground(SciNotesOptions.getSciNotesDisplay().backgroundColor);
        scilabEditorPane.setCaretColor(SciNotesOptions.getSciNotesDisplay().caretColor);
        scilabEditorPane.setFocusable(true);
        scilabEditorPane.setRequestFocusEnabled(true);
        scilabEditorPane.setDragEnabled(true);
        DropFilesListener dropFilesListener = new DropFilesListener(scilabEditorPane);
        scilabEditorPane.setComponentPopupMenu(SciNotesGUI.generateRightClickPopup(this));
    }

    public void initInputMap(ScilabEditorPane scilabEditorPane) {
        SciNotes.setKeyStrokeAction(scilabEditorPane, this);
        LineBeautifierAction.putInInputMap(scilabEditorPane);
        InsertOverwriteAction.putInInputMap(scilabEditorPane);
    }

    public void splitTab(boolean bl) {
        ScilabEditorPane scilabEditorPane = this.getTextPane();
        Component component = scilabEditorPane.getEditorComponent().getBottom();
        int n = scilabEditorPane.getXln().getState();
        ScilabEditorPane scilabEditorPane2 = new ScilabEditorPane(editor);
        ScilabEditorPane scilabEditorPane3 = new ScilabEditorPane(editor);
        if (this.navigator != null) {
            this.navigator.changePaneOnSplit(scilabEditorPane, scilabEditorPane2);
        }
        this.initPane(scilabEditorPane2, true);
        this.initPane(scilabEditorPane3, true);
        scilabEditorPane2.setOtherPaneInSplit(scilabEditorPane3);
        scilabEditorPane3.setOtherPaneInSplit(scilabEditorPane2);
        scilabEditorPane.copyProps(scilabEditorPane2);
        scilabEditorPane.copyProps(scilabEditorPane3);
        ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
        scilabEditorPane2.setDocument(scilabDocument);
        scilabEditorPane3.setDocument(scilabDocument);
        scilabEditorPane2.setCaretPosition(0);
        scilabEditorPane3.setCaretPosition(0);
        JSplitPane jSplitPane = bl ? new JSplitPane(0) : new JSplitPane(1);
        scilabEditorPane2.getXln().setWhereamiLineNumbering(n);
        scilabEditorPane3.getXln().setWhereamiLineNumbering(n);
        jSplitPane.setLeftComponent(scilabEditorPane2.getScrollPane());
        jSplitPane.setRightComponent(scilabEditorPane3.getScrollPane());
        jSplitPane.setResizeWeight(0.5);
        scilabEditorPane3.setEditorComponent(scilabEditorPane2.getEditorComponent());
        scilabEditorPane2.setSplitPane(jSplitPane);
        scilabEditorPane3.setSplitPane(jSplitPane);
        SciNotes.activateHelpOnTyping(scilabEditorPane2);
        SciNotes.activateHelpOnTyping(scilabEditorPane3);
        this.initInputMap(scilabEditorPane2);
        this.initInputMap(scilabEditorPane3);
        if (scilabDocument.getBinary()) {
            scilabEditorPane2.setBinary(true);
            scilabEditorPane3.setBinary(true);
        }
        this.getInfoBar().setText(scilabEditorPane2.getInfoBarText());
        this.updateTabTitle();
        this.tabPane.setComponentAt(this.tabPane.getSelectedIndex(), scilabEditorPane2.getEditorComponent());
        scilabEditorPane2.getEditorComponent().insertBottomComponent(component);
        scilabEditorPane2.requestFocus();
    }

    public void removeSplit() {
        if (((EditorComponent)this.tabPane.getSelectedComponent()).isSplited()) {
            ScilabEditorPane scilabEditorPane = new ScilabEditorPane(editor);
            ScilabEditorPane scilabEditorPane2 = this.getTextPane();
            Component component = scilabEditorPane2.getEditorComponent().getBottom();
            if (this.navigator != null) {
                this.navigator.changePaneOnSplit(scilabEditorPane2, scilabEditorPane);
            }
            this.initPane(scilabEditorPane);
            scilabEditorPane2.setOtherPaneInSplit(null);
            scilabEditorPane2.copyProps(scilabEditorPane);
            ScilabDocument scilabDocument = (ScilabDocument)scilabEditorPane2.getDocument();
            scilabEditorPane.setDocument(scilabDocument);
            scilabEditorPane.setCaretPosition(0);
            SciNotes.activateHelpOnTyping(scilabEditorPane);
            this.tabPane.setComponentAt(this.tabPane.getSelectedIndex(), scilabEditorPane.getEditorComponent());
            this.initInputMap(scilabEditorPane);
            if (scilabDocument.getBinary()) {
                scilabEditorPane.setBinary(true);
            }
            this.getInfoBar().setText(scilabEditorPane.getInfoBarText());
            this.updateTabTitle();
            scilabEditorPane.getEditorComponent().insertBottomComponent(component);
            scilabEditorPane.requestFocus();
        }
    }

    public ScilabEditorPane addEmptyTab() {
        int n = this.getNumberForEmptyTab();
        ScilabEditorPane scilabEditorPane = this.addTab(SciNotesMessages.UNTITLED + n);
        scilabEditorPane.setShortName(SciNotesMessages.UNTITLED + n);
        scilabEditorPane.setTitle(SciNotesMessages.UNTITLED + n);
        this.setTitle(scilabEditorPane.getTitle());
        SciNotesOptions.Header header = SciNotesOptions.getSciNotesHeader();
        if (header.header != null) {
            ((ScilabDocument)scilabEditorPane.getDocument()).disableUndoManager();
            try {
                scilabEditorPane.getDocument().insertString(0, header.header, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            scilabEditorPane.init(header.header.length());
            ((ScilabDocument)scilabEditorPane.getDocument()).setContentModified(false);
            ((ScilabDocument)scilabEditorPane.getDocument()).enableUndoManager();
        }
        return scilabEditorPane;
    }

    public int getNumberForEmptyTab() {
        if (this.closedTabList.size() > 0) {
            Integer n = Collections.min(this.closedTabList);
            this.closedTabList.remove(n);
            return n;
        }
        ++this.numberOfUntitled;
        this.tabList.add(this.numberOfUntitled);
        return this.numberOfUntitled;
    }

    public void updateTabTitle() {
        this.updateTabTitle(this.getTabPane().getSelectedIndex());
    }

    public void updateTabTitle(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        ScilabEditorPane scilabEditorPane = this.getTextPane(n);
        if (((ScilabDocument)scilabEditorPane.getDocument()).isContentModified()) {
            stringBuffer.append('*');
        }
        String string = scilabEditorPane.getName();
        try {
            File file = new File(string);
            stringBuffer.append(file.getName());
        }
        catch (NullPointerException nullPointerException) {
            string = this.getTabPane().getScilabTitleAt(n);
            if (string.charAt(0) == '*') {
                stringBuffer.append(string.substring(1, string.length()));
            }
            stringBuffer.append(string);
        }
        this.getTabPane().setTitleAt(n, stringBuffer.toString());
    }

    public void setUndoButton(JButton jButton) {
        this.undoButton = jButton;
        this.enableUndoButton(false);
    }

    public void enableUndoButton(boolean bl) {
        if (this.undoButton != null) {
            this.undoButton.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        ScilabDocument scilabDocument;
        ScilabDocument scilabDocument2 = scilabDocument = (ScilabDocument)this.getTextPane().getDocument();
        synchronized (scilabDocument2) {
            scilabDocument.getUndoManager().undo();
        }
    }

    public void setRedoButton(JButton jButton) {
        this.redoButton = jButton;
        this.enableRedoButton(false);
    }

    public void enableRedoButton(boolean bl) {
        if (this.redoButton != null) {
            this.redoButton.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        ScilabDocument scilabDocument;
        ScilabDocument scilabDocument2 = scilabDocument = (ScilabDocument)this.getTextPane().getDocument();
        synchronized (scilabDocument2) {
            scilabDocument.getUndoManager().redo();
        }
    }

    public void reload(int n) {
        ScilabEditorPane scilabEditorPane = this.getTextPane(n);
        if (scilabEditorPane != null && scilabEditorPane.getName() != null) {
            if (n == 0 && this.getTabPane().getTabCount() == 1) {
                for (int i = 0; i < this.tabPane.getChangeListeners().length; ++i) {
                    this.tabPane.removeChangeListener(this.tabPane.getChangeListeners()[i]);
                }
            }
            ConfigSciNotesManager.removeFromOpenFiles(this, scilabEditorPane);
            this.tabPane.remove(n);
            File file = new File(scilabEditorPane.getName());
            if (file.exists()) {
                this.loadFile(file, n);
            } else {
                this.createNewFile(file);
            }
        }
    }

    public void readFile(File file) {
        boolean bl = false;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            ScilabEditorPane scilabEditorPane = this.getTextPane(i);
            if (!file.getAbsolutePath().equals(scilabEditorPane.getName())) continue;
            this.tabPane.setSelectedIndex(i);
            bl = true;
            break;
        }
        if (!bl) {
            if (file.exists()) {
                this.loadFile(file);
            } else {
                this.createNewFile(file);
            }
        }
    }

    public void readFileAndWait(File file) {
        File file2 = file;
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            ScilabEditorPane scilabEditorPane = this.getTextPane(i);
            if (scilabEditorPane == null || !file2.getAbsolutePath().equals(scilabEditorPane.getName())) continue;
            this.tabPane.setSelectedIndex(i);
            if (file2.lastModified() > scilabEditorPane.getLastModified()) {
                MessageBox messageBox = ScilabMessageBox.createMessageBox();
                messageBox.setTitle(SciNotesMessages.REPLACE_FILE_TITLE);
                messageBox.setMessage(String.format(SciNotesMessages.EXTERNAL_MODIFICATION, scilabEditorPane.getName()));
                String[] stringArray = new String[]{SciNotesMessages.RELOAD, SciNotesMessages.OVERWRITE, SciNotesMessages.IGNORE};
                messageBox.setButtonsLabels(stringArray);
                messageBox.setIcon("question");
                messageBox.setParentForLocation((SimpleTab)this);
                messageBox.displayAndWait();
                switch (messageBox.getSelectedButton()) {
                    case 1: {
                        if (i == 0 && this.getTabPane().getTabCount() == 1) {
                            for (int j = 0; j < this.tabPane.getChangeListeners().length; ++j) {
                                this.tabPane.removeChangeListener(this.tabPane.getChangeListeners()[j]);
                            }
                        }
                        this.tabPane.remove(i);
                        file2 = new File(scilabEditorPane.getName());
                        n = i;
                        break;
                    }
                    case 2: {
                        this.overwrite(i);
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
                break;
            }
            bl = true;
            break;
        }
        if (!bl) {
            if (file2.exists()) {
                this.loadFile(file2, n);
            } else {
                this.createNewFile(file2);
            }
        }
    }

    public int getTextPaneIndex(ScilabEditorPane scilabEditorPane) {
        int n = this.tabPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            ScilabEditorPane scilabEditorPane2 = this.getTextPane(i);
            if (scilabEditorPane2 == null || scilabEditorPane2 != scilabEditorPane && scilabEditorPane2.getOtherPaneInSplit() != scilabEditorPane) continue;
            return i;
        }
        return -1;
    }

    public ScilabEditorPane getTextPane() {
        try {
            if (this.tabPane.getSelectedComponent() instanceof EditorComponent) {
                EditorComponent editorComponent = (EditorComponent)this.tabPane.getSelectedComponent();
                ScilabEditorPane scilabEditorPane = editorComponent.getEditorPane();
                if (ScilabEditorPane.getFocusedPane() == scilabEditorPane.getOtherPaneInSplit()) {
                    return scilabEditorPane.getOtherPaneInSplit();
                }
                return scilabEditorPane;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public ScilabEditorPane getTextPane(int n) {
        try {
            if (this.tabPane.getComponentAt(n) instanceof EditorComponent) {
                EditorComponent editorComponent = (EditorComponent)this.tabPane.getComponentAt(n);
                ScilabEditorPane scilabEditorPane = editorComponent.getEditorPane();
                if (ScilabEditorPane.getFocusedPane() == scilabEditorPane.getOtherPaneInSplit()) {
                    return scilabEditorPane.getOtherPaneInSplit();
                }
                return scilabEditorPane;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public static void setAllMenus() {
        for (SciNotes sciNotes : scinotesList) {
            SciNotesGUI.reinitMenus(sciNotes);
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                scilabEditorPane.setComponentPopupMenu(SciNotesGUI.generateRightClickPopup(sciNotes));
                if (scilabEditorPane.getOtherPaneInSplit() == null) continue;
                scilabEditorPane.getOtherPaneInSplit().setComponentPopupMenu(SciNotesGUI.generateRightClickPopup(sciNotes));
            }
        }
    }

    public static void setKeyStrokeActions() {
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                sciNotes.initInputMap(scilabEditorPane);
                if (scilabEditorPane.getOtherPaneInSplit() == null) continue;
                sciNotes.initInputMap(scilabEditorPane.getOtherPaneInSplit());
            }
        }
    }

    public static void setWhereamiLineNumbering() {
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                scilabEditorPane.getXln().setWhereamiLineNumbering(SciNotesOptions.getSciNotesDisplay().showLineNumbers, SciNotesOptions.getSciNotesDisplay().whereami);
                if (scilabEditorPane.getOtherPaneInSplit() == null) continue;
                scilabEditorPane.getOtherPaneInSplit().getXln().setWhereamiLineNumbering(SciNotesOptions.getSciNotesDisplay().showLineNumbers, SciNotesOptions.getSciNotesDisplay().whereami);
            }
            sciNotes.repaint();
        }
    }

    public static void setAutoIndent() {
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                ((ScilabDocument)scilabEditorPane.getDocument()).setAutoIndent(SciNotesOptions.getSciNotesDisplay().automaticIndent);
                if (scilabEditorPane.getOtherPaneInSplit() == null) continue;
                ((ScilabDocument)scilabEditorPane.getOtherPaneInSplit().getDocument()).setAutoIndent(SciNotesOptions.getSciNotesDisplay().automaticIndent);
            }
        }
    }

    public static void setHorizontalWrap() {
        if (SciNotesOptions.getSciNotesDisplay().wrapLines != mustWrapLines) {
            mustWrapLines = SciNotesOptions.getSciNotesDisplay().wrapLines;
            for (SciNotes sciNotes : scinotesList) {
                int n = sciNotes.getTabPane().getTabCount();
                for (int i = 0; i < n; ++i) {
                    ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                    if (scilabEditorPane.getOtherPaneInSplit() != null) continue;
                    ScilabEditorPane scilabEditorPane2 = new ScilabEditorPane(editor);
                    sciNotes.initPane(scilabEditorPane2, !mustWrapLines);
                    scilabEditorPane.copyProps(scilabEditorPane2);
                    scilabEditorPane2.setDocument(scilabEditorPane.getDocument());
                    scilabEditorPane2.setCaretPosition(scilabEditorPane.getCaretPosition());
                    scilabEditorPane2.getXln().setWhereamiLineNumbering(SciNotesOptions.getSciNotesDisplay().showLineNumbers, SciNotesOptions.getSciNotesDisplay().whereami);
                    sciNotes.tabPane.setComponentAt(i, scilabEditorPane2.getEditorComponent());
                    SciNotes.activateHelpOnTyping(scilabEditorPane2);
                    sciNotes.initInputMap(scilabEditorPane2);
                    if (((ScilabDocument)scilabEditorPane.getDocument()).getBinary()) {
                        scilabEditorPane2.setBinary(true);
                    }
                    sciNotes.getInfoBar().setText(scilabEditorPane2.getInfoBarText());
                }
            }
        }
    }

    public static void enableHighlightedLine(boolean bl) {
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                scilabEditorPane.enableHighlightedLine(SciNotesOptions.getSciNotesDisplay().highlightCurrentLine);
                if (scilabEditorPane.getOtherPaneInSplit() == null) continue;
                scilabEditorPane.getOtherPaneInSplit().enableHighlightedLine(SciNotesOptions.getSciNotesDisplay().highlightCurrentLine);
            }
        }
    }

    public static void activateHelpOnTyping(ScilabEditorPane scilabEditorPane) {
        scilabEditorPane.activateHelpOnTyping();
    }

    public static void activateHelpOnTyping() {
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                scilabEditorPane.activateHelpOnTyping();
                if (scilabEditorPane.getOtherPaneInSplit() == null) continue;
                scilabEditorPane.getOtherPaneInSplit().activateHelpOnTyping();
            }
        }
    }

    public static void setDefaultTabulation() {
        TabManager.Tabulation tabulation = new TabManager.Tabulation();
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                scilabEditorPane.getTabManager().setTabulation(tabulation);
                View view = ((ScilabDocument)scilabEditorPane.getDocument()).getView();
                if (view == null) continue;
                if (view instanceof ScilabView) {
                    ((ScilabView)view).setTabRepresentation(tabulation);
                    ((ScilabView)view).reinitialize();
                    continue;
                }
                ((ScilabPlainView)view).setTabRepresentation(tabulation);
                ((ScilabPlainView)view).reinitialize();
            }
        }
    }

    public static void updatePanes(SciNotesConfiguration.Conf conf) {
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                scilabEditorPane.configurationChanged(conf);
                if (scilabEditorPane.getOtherPaneInSplit() != null) {
                    scilabEditorPane.getOtherPaneInSplit().configurationChanged(conf);
                }
                scilabEditorPane.repaint();
            }
        }
    }

    public static void updateFontSize(int n) {
        Font font = null;
        for (SciNotes sciNotes : scinotesList) {
            int n2 = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n2; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                ((ScilabEditorKit)scilabEditorPane.getEditorKit()).getStylePreferences().changeBaseFontSize(-n);
                if (font == null) {
                    font = ((ScilabEditorKit)scilabEditorPane.getEditorKit()).getStylePreferences().getBaseFont();
                }
                if (scilabEditorPane.getOtherPaneInSplit() != null) {
                    ((ScilabEditorKit)scilabEditorPane.getOtherPaneInSplit().getEditorKit()).getStylePreferences().changeBaseFontSize(-n);
                    scilabEditorPane.getOtherPaneInSplit().resetFont();
                }
                scilabEditorPane.resetFont();
            }
        }
        if (font != null) {
            ScilabContext.saveFont(font);
        }
    }

    public static void setHighlightedLineColor() {
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                scilabEditorPane.setHighlightedLineColor(SciNotesOptions.getSciNotesDisplay().currentLineColor);
                if (scilabEditorPane.getOtherPaneInSplit() == null) continue;
                scilabEditorPane.getOtherPaneInSplit().setHighlightedLineColor(SciNotesOptions.getSciNotesDisplay().currentLineColor);
            }
        }
    }

    public static void setHighlightedContourColor() {
        for (SciNotes sciNotes : scinotesList) {
            int n = sciNotes.getTabPane().getTabCount();
            for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                scilabEditorPane.setHighlightedContourColor(null);
                if (scilabEditorPane.getOtherPaneInSplit() == null) continue;
                scilabEditorPane.getOtherPaneInSplit().setHighlightedContourColor(null);
            }
        }
    }

    public static void setHighlight(ScilabEditorPane scilabEditorPane) {
        scilabEditorPane.enableHighlightedLine(SciNotesOptions.getSciNotesDisplay().highlightCurrentLine);
        scilabEditorPane.setHighlightedLineColor(SciNotesOptions.getSciNotesDisplay().currentLineColor);
        scilabEditorPane.setHighlightedContourColor(null);
    }

    public SimpleTab getAsSimpleTab() {
        return this;
    }

    public SwingScilabWindow getParentWindow() {
        if (this.parentWindow == null) {
            return super.getParentWindow();
        }
        return this.parentWindow;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void addInfoBar(TextBox textBox) {
        this.setInfoBar(textBox);
    }

    public void addMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
    }

    public void addToolBar(ToolBar toolBar) {
        this.setToolBar(toolBar);
    }

    public ScilabTabbedPane getTabPane() {
        return this.tabPane;
    }

    public void setTabPane(ScilabTabbedPane scilabTabbedPane) {
        this.tabPane = scilabTabbedPane;
    }

    public void loadFile(File file) {
        this.loadFile(file, -1);
    }

    public void loadFile(File file, int n) {
        ScilabDocument scilabDocument = null;
        if (file.exists()) {
            ScilabEditorPane scilabEditorPane;
            if (!file.canRead()) {
                ScilabModalDialog.show((SimpleTab)this, (String)SciNotesMessages.NOTREADABLE, (String)SciNotesMessages.SCINOTES_ERROR, (ScilabModalDialog.IconType)ScilabModalDialog.IconType.ERROR_ICON);
                if (this.getTabPane().getTabCount() == 0) {
                    this.addEmptyTab();
                }
                return;
            }
            this.getInfoBar().setText(SciNotesMessages.LOADING);
            ScilabEditorPane scilabEditorPane2 = n != -1 ? this.addTab(file.getName(), n) : this.addTab(file.getName());
            scilabDocument = (ScilabDocument)scilabEditorPane2.getDocument();
            scilabDocument.disableUndoManager();
            scilabEditorPane2.setLastModified(file.lastModified());
            try {
                scilabDocument.setUpdater(false);
                boolean bl = scilabDocument.getAutoIndent();
                scilabDocument.setAutoIndent(false);
                try {
                    ((ScilabEditorKit)this.editorKit).read(this, file, scilabDocument, 0);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                scilabDocument.setAutoIndent(bl);
                scilabDocument.setUpdater(true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            scilabEditorPane2.setName(file.getAbsolutePath());
            this.getTabPane().setTitleAt(this.getTabPane().getSelectedIndex(), file.getName());
            this.setTitle(scilabEditorPane2.getTitle());
            scilabDocument.setContentModified(false);
            scilabDocument.enableUndoManager();
            if (scilabDocument.getBinary()) {
                scilabEditorPane2.setBinary(true);
            }
            if (!file.canWrite()) {
                this.getTextPane().setReadOnly(true);
                JOptionPane.showMessageDialog((Component)((Object)this), SciNotesMessages.READONLY);
            }
            this.getInfoBar().setText(scilabEditorPane2.getInfoBarText());
            EncodingAction.updateEncodingMenu((ScilabDocument)this.getTextPane().getDocument());
            this.firstOpen = false;
            ConfigManager.saveLastOpenedDirectory((String)file.getPath());
            ConfigSciNotesManager.saveToRecentOpenedFiles(file.getPath());
            ConfigSciNotesManager.saveToOpenFiles(file.getPath(), this, this.getTextPane());
            CompoundUndoManager compoundUndoManager = ((ScilabDocument)this.getTextPane().getDocument()).getUndoManager();
            ((UndoManager)compoundUndoManager).discardAllEdits();
            if (this.getTabPane().getTabCount() == 2 && (scilabEditorPane = this.getTextPane(0)) != null && scilabEditorPane.getName() == null && !((ScilabDocument)scilabEditorPane.getDocument()).isContentModified()) {
                this.closeTabAt(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewFile(File file) {
        ScilabEditorPane scilabEditorPane = this.addEmptyTab();
        ScilabDocument scilabDocument = null;
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), String.format(SciNotesMessages.FILE_DOESNT_EXIST, file.getName()), SCINOTES, 0);
        if (n == 0) {
            scilabDocument = (ScilabDocument)scilabEditorPane.getDocument();
            scilabDocument.disableUndoManager();
            BufferedWriter bufferedWriter = null;
            OutputStreamWriter outputStreamWriter = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, scilabDocument.getEncoding());
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                this.editorKit.write(bufferedWriter, (Document)scilabDocument, 0, scilabDocument.getLength());
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
            this.firstOpen = false;
            ConfigManager.saveLastOpenedDirectory((String)file.getPath());
            ConfigSciNotesManager.saveToRecentOpenedFiles(file.getPath());
            ConfigSciNotesManager.saveToOpenFiles(scilabEditorPane.getName(), this, scilabEditorPane);
            scilabEditorPane.setName(file.getPath());
            this.getTabPane().setTitleAt(this.getTabPane().getSelectedIndex(), file.getName());
            this.setTitle(scilabEditorPane.getTitle());
            RecentFileAction.updateRecentOpenedFilesMenu(this);
            scilabDocument.setContentModified(false);
            scilabDocument.enableUndoManager();
            scilabEditorPane.setLastModified(file.lastModified());
        }
        this.getInfoBar().setText("");
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public static void setEditor(SciNotes sciNotes) {
        editor = sciNotes;
    }

    public static SciNotes getEditor() {
        return editor;
    }

    public void setEditorKit(EditorKit editorKit) {
        this.editorKit = editorKit;
    }

    public static void closeSciNotesFromScilab() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SciNotes[] sciNotesArray = scinotesList.toArray(new SciNotes[0]);
                    for (int i = 0; i < sciNotesArray.length; ++i) {
                        sciNotesArray[i].setProtectOpenFileList(true);
                        ExitAction.doExit(sciNotesArray[i]);
                    }
                    scinotesList.clear();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(SciNotes.class.getName()).severe(interruptedException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(SciNotes.class.getName()).severe(invocationTargetException.toString());
        }
    }

    public static File fileToCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    private static void setKeyStrokeAction(ScilabEditorPane scilabEditorPane, SciNotes sciNotes) {
        ScilabEditorPane scilabEditorPane2 = sciNotes.getTextPane(0);
        if (scilabEditorPane2 != null && scilabEditorPane2 != scilabEditorPane) {
            scilabEditorPane.setInputMap(0, scilabEditorPane2.getInputMap());
            return;
        }
        Map<String, KeyStroke> map = SciNotes.getActionKeys();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        for (Map.Entry<String, KeyStroke> entry : map.entrySet()) {
            String string = entry.getKey();
            KeyStroke keyStroke = entry.getValue();
            String string2 = actionToName.get(string);
            if (keyStroke == null) continue;
            if (!string2.equals("SciNotesCompletionAction")) {
                String string3 = string2.lastIndexOf(DOT) != -1 ? string2 : "org.scilab.modules.scinotes.actions." + string2;
                try {
                    Class<?> clazz = classLoader.loadClass(string3);
                    Constructor<?> constructor = clazz.getConstructor(String.class, SciNotes.class);
                    Object obj = constructor.newInstance(new Object[]{"", sciNotes});
                    scilabEditorPane.getInputMap().put(keyStroke, obj);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("No action: " + string3);
                }
                catch (InstantiationException instantiationException) {
                    System.err.println("Problem to instantiate in action: " + string3);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.err.println("No valid constructor in action: " + string3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("The constructor must be public: " + string3);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println("The constructor in " + string3 + " threw an exception :");
                    invocationTargetException.printStackTrace();
                }
                continue;
            }
            scilabEditorPane.getInputMap().put(keyStroke, (Object)new SciNotesCompletionAction(scilabEditorPane, sciNotes));
        }
        scilabEditorPane.getInputMap().put(KeyStroke.getKeyStroke("shift DELETE"), scilabEditorPane.getInputMap().get(map.get("scinotes-cut")));
        scilabEditorPane.getInputMap().put(KeyStroke.getKeyStroke("CUT"), scilabEditorPane.getInputMap().get(map.get("scinotes-cut")));
        scilabEditorPane.getInputMap().put(ScilabKeyStroke.getKeyStroke((String)"OSSCKEY INSERT"), scilabEditorPane.getInputMap().get(map.get("scinotes-copy")));
        scilabEditorPane.getInputMap().put(KeyStroke.getKeyStroke("COPY"), scilabEditorPane.getInputMap().get(map.get("scinotes-copy")));
        scilabEditorPane.getInputMap().put(KeyStroke.getKeyStroke("shift INSERT"), scilabEditorPane.getInputMap().get(map.get("scinotes-paste")));
        scilabEditorPane.getInputMap().put(KeyStroke.getKeyStroke("PASTE"), scilabEditorPane.getInputMap().get(map.get("scinotes-paste")));
    }

    public static void executeAction(String string, ActionOnDocument actionOnDocument) throws IOException {
        Charset charset = null;
        try {
            charset = ScilabEditorKit.tryToGuessEncoding(new File(string));
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IOException(SciNotesMessages.CANNOT_GUESS_ENCODING + ": " + string);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        ScilabDocument scilabDocument = new ScilabDocument();
        ScilabEditorKit scilabEditorKit = new ScilabEditorKit();
        try {
            scilabEditorKit.read(bufferedReader, (Document)scilabDocument, 0);
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
        scilabDocument.addDocumentListener(scilabDocument);
        if (!scilabDocument.getBinary()) {
            actionOnDocument.actionOn(scilabDocument);
        }
        bufferedReader.close();
        if (scilabDocument.isContentModified()) {
            SaveFile.doSave(scilabDocument, new File(string), scilabEditorKit);
        }
    }

    public static boolean executeAction(String string, final String[] stringArray) throws IOException {
        final boolean[] blArray = new boolean[]{false};
        ActionOnDocument actionOnDocument = new ActionOnDocument(){

            @Override
            public void actionOn(ScilabDocument scilabDocument) throws IOException {
                for (String string : stringArray) {
                    if (string.equalsIgnoreCase("indent")) {
                        blArray[0] = true;
                        IndentAction.getActionOnDocument().actionOn(scilabDocument);
                        continue;
                    }
                    if (string.equalsIgnoreCase("trailing")) {
                        blArray[0] = true;
                        RemoveTrailingWhiteAction.getActionOnDocument().actionOn(scilabDocument);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("quote")) continue;
                    blArray[0] = true;
                    DoubleQuoteStringAction.getActionOnDocument().actionOn(scilabDocument);
                }
            }
        };
        SciNotes.executeAction(string, actionOnDocument);
        return blArray[0];
    }

    public static void executeAction(String string, String string2) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",;");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        SciNotes.executeAction(string, stringArray);
    }

    static {
        scinotesList = new ArrayList<SciNotes>();
        ConfigSciNotesManager.createUserCopy();
        ScilabTabFactory.getInstance().addTabFactory((AbstractScilabTabFactory)SciNotesTabFactory.getInstance());
        Scilab.registerInitialHook((Runnable)new Runnable(){

            @Override
            public void run() {
                SciNotes.updateSciNotes();
            }
        });
        org.w3c.dom.Document document = ScilabXMLUtilities.readDocument((String)(System.getenv("SCI") + "/modules/console/etc/Actions-Configuration.xml"));
        actionToName = XConfiguration.get((org.w3c.dom.Document)document, (String)"name", String.class, (String)"action", String.class, (String)XPATH_SCINOTES_ACTION);
        XConfiguration.addXConfigurationListener((XConfigurationListener)new SciNotesConfiguration());
    }

    public static interface ActionOnDocument {
        public void actionOn(ScilabDocument var1) throws IOException;
    }
}

