/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.debug;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public final class EventDispatchThreadHangMonitor
extends EventQueue {
    private static final EventDispatchThreadHangMonitor INSTANCE = new EventDispatchThreadHangMonitor();
    private static final long CHECK_INTERVAL_MS = 100L;
    private static final long UNREASONABLE_DISPATCH_DURATION_MS = 1000L;
    private static int hangCount = 0;
    private boolean haveShownSomeComponent = false;
    private final LinkedList<DispatchInfo> dispatches = new LinkedList();

    private EventDispatchThreadHangMonitor() {
        this.initTimer();
    }

    private void initTimer() {
        Timer timer = new Timer("EventDispatchThreadHangMonitor", true);
        timer.schedule((TimerTask)new HangChecker(), 0L, 100L);
    }

    public static void initMonitoring() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent aWTEvent) {
        try {
            this.preDispatchEvent();
            super.dispatchEvent(aWTEvent);
        }
        finally {
            this.postDispatchEvent();
            if (!this.haveShownSomeComponent && aWTEvent instanceof WindowEvent && aWTEvent.getID() == 200) {
                this.haveShownSomeComponent = true;
            }
        }
    }

    private void debug(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void preDispatchEvent() {
        this.debug("pre");
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            this.dispatches.addLast(new DispatchInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void postDispatchEvent() {
        LinkedList<DispatchInfo> linkedList = this.dispatches;
        synchronized (linkedList) {
            DispatchInfo dispatchInfo = this.dispatches.removeLast();
            dispatchInfo.dispose();
            Thread thread = Thread.currentThread();
            for (DispatchInfo dispatchInfo2 : this.dispatches) {
                if (dispatchInfo2.eventDispatchThread != thread) continue;
                dispatchInfo2.lastDispatchTimeMillis = System.currentTimeMillis();
            }
        }
        this.debug("post");
    }

    private static void checkForDeadlock() {
        ThreadInfo[] threadInfoArray;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.findMonitorDeadlockedThreads();
        if (lArray == null) {
            return;
        }
        Log.warn("deadlock detected involving the following threads:");
        for (ThreadInfo threadInfo : threadInfoArray = threadMXBean.getThreadInfo(lArray, Integer.MAX_VALUE)) {
            Log.warn("Thread #" + threadInfo.getThreadId() + " " + threadInfo.getThreadName() + " (" + (Object)((Object)threadInfo.getThreadState()) + ") waiting on " + threadInfo.getLockName() + " held by " + threadInfo.getLockOwnerName() + EventDispatchThreadHangMonitor.stackTraceToString(threadInfo.getStackTrace()));
        }
    }

    private static String stackTraceToString(StackTraceElement[] stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = "    ";
            stringBuilder.append("\n" + string + stackTraceElement);
        }
        return stringBuilder.toString();
    }

    private static synchronized int getNewHangNumber() {
        return ++hangCount;
    }

    public static void main(String[] stringArray) {
        EventDispatchThreadHangMonitor.initMonitoring();
        if (stringArray.length > 0 && "deadlock".equals(stringArray[0])) {
            EventDispatchThreadHangMonitor.INSTANCE.haveShownSomeComponent = true;
            Tests.runDeadlockTest();
            return;
        }
        Tests.main(stringArray);
    }

    private static class Log {
        private Log() {
        }

        public static void warn(String string) {
            System.out.println(string);
        }
    }

    private static class Tests {
        private Tests() {
        }

        public static void main(final String[] stringArray) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    for (String string : stringArray) {
                        JFrame jFrame = new JFrame();
                        jFrame.setDefaultCloseOperation(3);
                        jFrame.setLocationRelativeTo(null);
                        if (string.equals("exception")) {
                            Tests.runExceptionTest(jFrame);
                        } else if (string.equals("focus")) {
                            Tests.runFocusTest(jFrame);
                        } else if (string.equals("modal-hang")) {
                            Tests.runModalTest(jFrame, true);
                        } else if (string.equals("modal-no-hang")) {
                            Tests.runModalTest(jFrame, false);
                        } else {
                            System.err.println("unknown regression test '" + string + "'");
                            System.exit(1);
                        }
                        jFrame.pack();
                        jFrame.setVisible(true);
                    }
                }
            });
        }

        private static void runDeadlockTest() {
            class Locker {
                private Locker locker;

                Locker() {
                }

                public void setLocker(Locker locker) {
                    this.locker = locker;
                }

                public synchronized void tryToDeadlock() {
                    this.locker.toString();
                }

                public synchronized String toString() {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    return super.toString();
                }
            }
            final Locker locker = new Locker();
            Locker locker2 = new Locker();
            locker.setLocker(locker2);
            locker2.setLocker(locker);
            for (int i = 0; i < 100; ++i) {
                SwingUtilities.invokeLater(new Runnable(){
                    {
                    }

                    public void run() {
                        locker.tryToDeadlock();
                    }
                });
                locker2.tryToDeadlock();
            }
        }

        private static void runExceptionTest(JFrame jFrame) {
            JButton jButton = new JButton("Throw Exception");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    throw new RuntimeException("Nobody expects the Spanish Inquisition!");
                }
            });
            jFrame.add(jButton);
        }

        private static void runFocusTest(JFrame jFrame) {
            final JDialog jDialog = new JDialog((Frame)jFrame, "Non-Modal Dialog");
            jDialog.add(new JLabel("Close me!"));
            jDialog.pack();
            jDialog.setLocationRelativeTo(jFrame);
            jDialog.addWindowFocusListener(new WindowAdapter(){

                public void windowGainedFocus(WindowEvent windowEvent) {
                    System.out.println("FocusTest.windowGainedFocus");
                    Tests.sleep(2500L);
                }
            });
            JButton jButton = new JButton("Show Non-Modal Dialog");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.setVisible(true);
                }
            });
            jFrame.add(jButton);
        }

        private static void runModalTest(final JFrame jFrame, final boolean bl) {
            System.out.println(bl ? "Expect hangs!" : "There should be no hangs...");
            JButton jButton = new JButton("Show Modal Dialog");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl) {
                        Tests.sleep(2500L);
                    }
                    JDialog jDialog = new JDialog(jFrame, "Modal dialog", true);
                    jDialog.setLayout(new FlowLayout());
                    jDialog.add(new JLabel("Close this dialog!"));
                    final JLabel jLabel = new JLabel(" ");
                    jDialog.add(jLabel);
                    jDialog.pack();
                    jDialog.setLocation(jFrame.getX() - 100, jFrame.getY());
                    new Thread(new Runnable(){

                        public void run() {
                            int n = 0;
                            while (n <= 100000) {
                                final int n2 = n++;
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        jLabel.setText(Integer.toString(n2));
                                    }
                                });
                            }
                        }
                    }).start();
                    jDialog.setVisible(true);
                    if (bl) {
                        Tests.sleep(2500L);
                    }
                }
            });
            jFrame.add(jButton);
        }

        private static void sleep(long l) {
            try {
                System.out.println("Sleeping for " + l + " ms on " + Thread.currentThread() + "...");
                Thread.sleep(l);
                System.out.println("Finished sleeping...");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class HangChecker
    extends TimerTask {
        private HangChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = EventDispatchThreadHangMonitor.this.dispatches;
            synchronized (linkedList) {
                if (EventDispatchThreadHangMonitor.this.dispatches.isEmpty() || !EventDispatchThreadHangMonitor.this.haveShownSomeComponent) {
                    return;
                }
                ((DispatchInfo)EventDispatchThreadHangMonitor.this.dispatches.getLast()).checkForHang();
            }
        }
    }

    private static class DispatchInfo {
        private StackTraceElement[] lastReportedStack;
        private int hangNumber;
        private final Thread eventDispatchThread = Thread.currentThread();
        private long lastDispatchTimeMillis = System.currentTimeMillis();

        public void checkForHang() {
            if (this.timeSoFar() > 1000L) {
                this.examineHang();
            }
        }

        private static boolean stackTraceElementIs(StackTraceElement stackTraceElement, String string, String string2, boolean bl) {
            return stackTraceElement.getClassName().equals(string) && stackTraceElement.getMethodName().equals(string2) && stackTraceElement.isNativeMethod() == bl;
        }

        private boolean isWaitingForNextEvent(StackTraceElement[] stackTraceElementArray) {
            return DispatchInfo.stackTraceElementIs(stackTraceElementArray[0], "java.lang.Object", "wait", true) && DispatchInfo.stackTraceElementIs(stackTraceElementArray[1], "java.lang.Object", "wait", false) && DispatchInfo.stackTraceElementIs(stackTraceElementArray[2], "java.awt.EventQueue", "getNextEvent", false);
        }

        private void examineHang() {
            StackTraceElement[] stackTraceElementArray = this.eventDispatchThread.getStackTrace();
            if (this.isWaitingForNextEvent(stackTraceElementArray)) {
                return;
            }
            if (DispatchInfo.stacksEqual(this.lastReportedStack, stackTraceElementArray)) {
                return;
            }
            this.hangNumber = EventDispatchThreadHangMonitor.getNewHangNumber();
            String string = EventDispatchThreadHangMonitor.stackTraceToString(stackTraceElementArray);
            this.lastReportedStack = stackTraceElementArray;
            Log.warn("(hang #" + this.hangNumber + ") event dispatch thread stuck processing event for " + this.timeSoFar() + " ms:" + string);
            EventDispatchThreadHangMonitor.checkForDeadlock();
        }

        private static boolean stacksEqual(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
            if (stackTraceElementArray == null) {
                return false;
            }
            if (stackTraceElementArray.length != stackTraceElementArray2.length) {
                return false;
            }
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (stackTraceElementArray[i].equals(stackTraceElementArray2[i])) continue;
                return false;
            }
            return true;
        }

        private long timeSoFar() {
            return System.currentTimeMillis() - this.lastDispatchTimeMillis;
        }

        public void dispose() {
            if (this.lastReportedStack != null) {
                Log.warn("(hang #" + this.hangNumber + ") event dispatch thread unstuck after " + this.timeSoFar() + " ms.");
            }
        }
    }
}

