/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.commons.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.commons.xml.ScilabTransformerFactory;
import org.scilab.modules.localization.Messages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ScilabXMLUtilities {
    private static final String ENCODING = "UTF-8";
    private static final String ERROR_WRITE = Messages.gettext((String)"Could not save file: ");
    private static final String ERROR_READ = Messages.gettext((String)"Could not load file: ");
    private static final Integer INDENTATION = new Integer(4);
    private static Transformer transformer;

    public static Document readDocument(String string) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = ScilabDocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new File(string));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(ERROR_READ + string);
        }
        catch (SAXException sAXException) {
            System.err.println(ERROR_READ + string);
        }
        catch (IOException iOException) {
            System.err.println(ERROR_READ + string);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, String string) {
        if (document != null && string != null) {
            if (transformer == null) {
                ScilabXMLUtilities.initTransformer();
            }
            if (transformer != null) {
                ScilabXMLUtilities.removeEmptyLines(document.getDocumentElement());
                FileOutputStream fileOutputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    fileOutputStream = new FileOutputStream(string, false);
                    outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING);
                    transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(ERROR_WRITE + string);
                    System.err.println(fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println(ERROR_WRITE + string);
                    System.err.println(unsupportedEncodingException);
                }
                catch (TransformerException transformerException) {
                    System.err.println(ERROR_WRITE + string);
                    System.err.println(transformerException);
                }
                finally {
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                        }
                        catch (IOException iOException) {
                            System.err.println(iOException);
                        }
                    }
                }
            }
        }
    }

    public static void removeEmptyLines(Node node) {
        HashSet<Node> hashSet = new HashSet<Node>();
        ScilabXMLUtilities.collectEmptyLines(node, hashSet);
        for (Node node2 : hashSet) {
            node2.getParentNode().removeChild(node2);
        }
    }

    private static void collectEmptyLines(Node node, Set<Node> set) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            int n = ScilabXMLUtilities.getNodeListLength(nodeList);
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2 == null) continue;
                if (node2.getNodeType() == 3) {
                    set.add(node2);
                    continue;
                }
                ScilabXMLUtilities.collectEmptyLines(node2, set);
            }
        }
    }

    public static Element replaceNamedNode(Document document, Element element, String string, Object[] objectArray) {
        Element element2;
        NodeList nodeList = element.getElementsByTagName(string);
        if (ScilabXMLUtilities.getNodeListLength(nodeList) > 0) {
            element2 = (Element)nodeList.item(0);
        } else {
            element2 = document.createElement(string);
            element.appendChild(element2);
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            element2.setAttribute(objectArray[i].toString(), objectArray[i + 1].toString());
        }
        return element2;
    }

    public static Element replaceNamedNode(Document document, String string, String string2, Object[] objectArray) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(string);
        if (ScilabXMLUtilities.getNodeListLength(nodeList) > 0) {
            return ScilabXMLUtilities.replaceNamedNode(document, (Element)nodeList.item(0), string2, objectArray);
        }
        return null;
    }

    public static Element replaceNamedNode(Document document, Element element, String string, Map<String, Object> map) {
        Element element2;
        NodeList nodeList = element.getElementsByTagName(string);
        if (ScilabXMLUtilities.getNodeListLength(nodeList) > 0) {
            element2 = (Element)nodeList.item(0);
        } else {
            element2 = document.createElement(string);
            element.appendChild(element2);
        }
        for (String string2 : map.keySet()) {
            element2.setAttribute(string2, map.get(string2).toString());
        }
        return element2;
    }

    public static Element replaceNamedNode(Document document, String string, String string2, Map<String, Object> map) {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(string);
        if (ScilabXMLUtilities.getNodeListLength(nodeList) > 0) {
            return ScilabXMLUtilities.replaceNamedNode(document, (Element)nodeList.item(0), string2, map);
        }
        return null;
    }

    public static Element createNode(Document document, Element element, String string, Object[] objectArray) {
        Element element2 = document.createElement(string);
        for (int i = 0; i < objectArray.length; i += 2) {
            element2.setAttribute(objectArray[i].toString(), objectArray[i + 1].toString());
        }
        element.appendChild(element2);
        return element2;
    }

    public static Element createNode(Document document, Element element, String string, Map<String, Object> map) {
        Element element2 = document.createElement(string);
        for (String string2 : map.keySet()) {
            element2.setAttribute(string2, map.get(string2).toString());
        }
        element.appendChild(element2);
        return element2;
    }

    public static void readNodeAttributes(Element element, Map<String, Object> map) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getName();
            if (!map.containsKey(string)) continue;
            map.put(string, ScilabXMLUtilities.convert(attr.getValue(), (Class)map.get(string)));
        }
    }

    public static void readNodeAttributes(Element element, Object[] objectArray) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string = attr.getName();
            for (int j = 0; j < objectArray.length; j += 2) {
                if (!objectArray[j].equals(string)) continue;
                objectArray[j + 1] = ScilabXMLUtilities.convert(attr.getValue(), (Class)objectArray[j + 1]);
            }
        }
    }

    public static Element readNodeAttributes(Document document, String string, Map<String, Object> map) {
        Node node;
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(string);
        if (ScilabXMLUtilities.getNodeListLength(nodeList) > 0 && (node = nodeList.item(0)) instanceof Element) {
            ScilabXMLUtilities.readNodeAttributes((Element)node, map);
            return (Element)node;
        }
        return null;
    }

    public static Element readNodeAttributes(Document document, String string, Object[] objectArray) {
        Node node;
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(string);
        if (ScilabXMLUtilities.getNodeListLength(nodeList) > 0 && (node = nodeList.item(0)) instanceof Element) {
            ScilabXMLUtilities.readNodeAttributes((Element)node, objectArray);
            return (Element)node;
        }
        return null;
    }

    public static List<Element> getElementsWithAttributeEquals(Element element, String string, String string2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        ScilabXMLUtilities.getElementsWithAttributeEquals(element, string, string2, arrayList);
        return arrayList;
    }

    private static final void getElementsWithAttributeEquals(Element element, String string, String string2, List<Element> list) {
        if (element.getAttribute(string).equals(string2)) {
            list.add(element);
        }
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element2 = (Element)nodeList.item(i);
                ScilabXMLUtilities.getElementsWithAttributeEquals(element2, string, string2, list);
            }
        }
    }

    private static final Object convert(String string, Class clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.parseInt(string);
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.parseBoolean(string);
        }
        if (clazz == Double.TYPE) {
            return Double.parseDouble(string);
        }
        if (clazz == Short.TYPE) {
            return Short.parseShort(string);
        }
        if (clazz == Long.TYPE) {
            return Long.parseLong(string);
        }
        if (clazz == Byte.TYPE) {
            return Byte.parseByte(string);
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf(string.length() == 0 ? (char)'\u0000' : string.charAt(0));
        }
        if (clazz == String[].class) {
            return ScilabXMLUtilities.getArray(string, ";");
        }
        return string;
    }

    private static final String[] getArray(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static final void initTransformer() {
        try {
            TransformerFactory transformerFactory = ScilabTransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", INDENTATION);
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("encoding", ENCODING);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println("Problem to init the Transformer to write xml files");
            System.err.println(transformerConfigurationException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            System.err.println("Problem to init the Transformer to write xml files");
            System.err.println(transformerFactoryConfigurationError);
        }
    }

    private static int getNodeListLength(NodeList nodeList) {
        int n = 0;
        try {
            n = nodeList.getLength();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n;
    }

    public static String getXMLString(String string) {
        if (string != null && !string.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = string.toCharArray();
            int n = 0;
            block7: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case '\'': {
                        stringBuilder.append(cArray, n, i - n).append("&apos;");
                        n = i + 1;
                        continue block7;
                    }
                    case '\"': {
                        stringBuilder.append(cArray, n, i - n).append("&quot;");
                        n = i + 1;
                        continue block7;
                    }
                    case '<': {
                        stringBuilder.append(cArray, n, i - n).append("&lt;");
                        n = i + 1;
                        continue block7;
                    }
                    case '>': {
                        stringBuilder.append(cArray, n, i - n).append("&gt;");
                        n = i + 1;
                        continue block7;
                    }
                    case '&': {
                        stringBuilder.append(cArray, n, i - n).append("&amp;");
                        n = i + 1;
                        continue block7;
                    }
                }
            }
            if (n == 0) {
                return string;
            }
            if (n < cArray.length) {
                stringBuilder.append(cArray, n, cArray.length - n);
            }
            return stringBuilder.toString();
        }
        return string;
    }
}

