/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.commons.gui;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.scilab.modules.commons.OS;
import org.scilab.modules.commons.ScilabCommonsUtils;

public final class FindIconHelper {
    private static final Logger LOG = Logger.getLogger(FindIconHelper.class.getName());
    private static final String SCI = System.getenv("SCI");
    private static final String SEP = System.getProperty("file.separator");
    private static final String DOT = ".";
    private static final String HICOLOR = "hicolor";
    private static final List<String> ICONS_EXTENSIONS = Arrays.asList("png", "svg", "xpm");
    private static final HashMap<File, TreeSet<String>> THEME_SUBDIR_CACHE = new HashMap();
    private static final FileFilter DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static final List<String> THEME_BASENAME = new ArrayList<String>();

    public static String findIcon(String string) {
        return FindIconHelper.findIcon(string, "16x16", true);
    }

    public static String findIcon(String string, boolean bl) {
        return FindIconHelper.findIcon(string, "16x16", bl);
    }

    public static String findIcon(String string, String string2) {
        return FindIconHelper.findIcon(string, string2, true);
    }

    public static String findIcon(String string, String string2, boolean bl) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        String string3 = FindIconHelper.findIconHelper(string, string2, "Tango");
        if (string3 != null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(string + '[' + string2 + ']' + " i " + string3);
            }
            return string3;
        }
        String string4 = FindIconHelper.lookupFallbackIcon(string);
        if (bl && string4 == null) {
            LOG.warning("Unable to found icon: " + string + '[' + string2 + ']');
            return System.getenv("SCI") + "/modules/gui/images/icons/16x16/status/error.png";
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer(string + '[' + string2 + ']' + " f " + string4);
        }
        return string4;
    }

    private static String findIconHelper(String string, String string2, String string3) {
        try {
            String string4 = FindIconHelper.lookupIcon(string, string2, string3);
            if (string4 != null) {
                return string4;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!string3.isEmpty() && string3 != HICOLOR) {
            return FindIconHelper.findIconHelper(string, string2, HICOLOR);
        }
        if (!string3.isEmpty()) {
            return FindIconHelper.findIconHelper(string, string2, "");
        }
        return null;
    }

    private static String lookupIcon(String string, String string2, String string3) throws IOException {
        if (string.contains("<html>")) {
            return null;
        }
        for (String string4 : THEME_BASENAME) {
            Serializable serializable;
            File file = new File(string4 + SEP + string3);
            if (!file.exists() || !file.isDirectory()) continue;
            for (String string5 : ICONS_EXTENSIONS) {
                serializable = new File(file, string + DOT + string5);
                if (!((File)serializable).exists()) continue;
                return ((File)serializable).getCanonicalPath();
            }
            int n = file.getCanonicalPath().length();
            TreeSet<String> object2 = FindIconHelper.findThemeSubdir(file, n);
            serializable = FindIconHelper.findSizedSubdirs(string2, object2);
            Iterator<String> iterator = ((TreeSet)serializable).iterator();
            while (iterator.hasNext()) {
                String string6 = iterator.next();
                for (String string7 : ICONS_EXTENSIONS) {
                    File file2 = new File(file, string6 + SEP + string + DOT + string7);
                    if (!file2.exists()) continue;
                    return file2.getCanonicalPath();
                }
            }
        }
        return null;
    }

    private static TreeSet<String> findSizedSubdirs(String string, TreeSet<String> treeSet) {
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (String string2 : treeSet) {
            if (!string2.startsWith(string)) continue;
            treeSet2.add(string2);
        }
        return treeSet2;
    }

    private static TreeSet<String> findThemeSubdir(File file, int n) throws IOException {
        TreeSet<String> treeSet = THEME_SUBDIR_CACHE.get(file);
        if (treeSet != null) {
            return treeSet;
        }
        TreeSet<String> treeSet2 = new TreeSet<String>();
        LinkedList<File> linkedList = new LinkedList<File>(Arrays.asList(file.listFiles(DIR_FILTER)));
        while (!linkedList.isEmpty()) {
            File file2 = linkedList.poll();
            File[] fileArray = file2.listFiles(DIR_FILTER);
            if (fileArray == null) continue;
            List<File> list = Arrays.asList(fileArray);
            if (list.isEmpty()) {
                String string = file2.getCanonicalPath();
                treeSet2.add(string.substring(n + 1));
                continue;
            }
            linkedList.addAll(list);
        }
        THEME_SUBDIR_CACHE.put(file, treeSet2);
        return treeSet2;
    }

    public static String findImage(String string) {
        return FindIconHelper.findImage(string, true);
    }

    public static String findImage(String string, boolean bl) {
        File file = new File(ScilabCommonsUtils.getCorrectedPath(string));
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        for (String string2 : THEME_BASENAME) {
            File file2 = new File(string2 + SEP + string);
            if (!file2.exists()) continue;
            return file2.getAbsolutePath();
        }
        return FindIconHelper.findIcon(string, bl);
    }

    private static String lookupFallbackIcon(String string) {
        for (String string2 : THEME_BASENAME) {
            for (String string3 : ICONS_EXTENSIONS) {
                File file = new File(string2 + SEP + string + DOT + string3);
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public static void addThemePath(String string) {
        if (THEME_BASENAME.contains(string)) {
            return;
        }
        THEME_BASENAME.add(string);
    }

    public static Icon loadIcon(String string) throws IOException {
        File file;
        String string2 = FindIconHelper.findIcon(string, false);
        if (string2 == null) {
            string2 = "";
        }
        if (!(file = new File(string2)).exists()) {
            String string3 = FindIconHelper.findImage(string2, false);
            if (string3 == null) {
                string3 = "";
            }
            file = new File(string3);
        }
        return new ImageIcon(ImageIO.read(file));
    }

    static {
        switch (OS.get()) {
            case UNIX: {
                THEME_BASENAME.add("~/.icons");
                THEME_BASENAME.add("/usr/share/icons");
                THEME_BASENAME.add("/usr/share/pixmaps");
                THEME_BASENAME.add(SCI + "/../icons");
                break;
            }
            case MAC: {
                THEME_BASENAME.add(SCI + "/../icons");
                break;
            }
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(new File(SCI + SEP + "desktop"));
        arrayList.addAll(Arrays.asList(new File(SCI + SEP + "modules").listFiles(DIR_FILTER)));
        for (File file : arrayList) {
            File file2 = new File(file, "images" + SEP + "icons");
            boolean bl = file2.isDirectory();
            if (bl) {
                THEME_BASENAME.add(file2.getAbsolutePath());
            }
            if (!bl) continue;
            for (File file3 : file2.listFiles(DIR_FILTER)) {
                for (File file4 : file3.listFiles(DIR_FILTER)) {
                    THEME_BASENAME.add(file4.getAbsolutePath());
                }
            }
        }
    }
}

