/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.commons;

public enum OS {
    WINDOWS{

        @Override
        public Object getVersion() {
            return Double.valueOf(System.getProperty("os.version"));
        }
    }
    ,
    MAC{

        @Override
        public Object getVersion() {
            String[] stringArray = System.getProperty("os.version").split("\\.");
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            return nArray;
        }
    }
    ,
    UNIX;


    public static OS get() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.contains("windows")) {
            return WINDOWS;
        }
        if (string.contains("mac")) {
            return MAC;
        }
        return UNIX;
    }

    public Object getVersion() {
        return null;
    }

    public static String getVersionName() {
        switch (OS.get()) {
            case WINDOWS: {
                return "Windows";
            }
            case MAC: {
                return "Mac";
            }
        }
        return "Linux";
    }
}

