/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.common.os.MachineDescription;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.BitType;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.DoubleType;
import com.jogamp.gluegen.cgram.types.EnumType;
import com.jogamp.gluegen.cgram.types.FloatType;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.IntType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import com.jogamp.gluegen.cgram.types.VoidType;
import java.util.List;

public abstract class Type
implements Cloneable {
    private String name;
    private SizeThunk size;
    private final int cvAttributes;
    private int typedefedCVAttributes;
    private boolean hasTypedefName;

    protected Type(String string, SizeThunk sizeThunk, int n) {
        this.setName(string);
        this.size = sizeThunk;
        this.cvAttributes = n;
        this.hasTypedefName = false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final String getName() {
        return this.getName(false);
    }

    public String getName(boolean bl) {
        if (!bl) {
            return this.name;
        }
        return this.getCVAttributesString() + this.name;
    }

    private void append(StringBuilder stringBuilder, String string, boolean bl) {
        if (bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append(string);
    }

    public String getDebugString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder.append("CType[");
        if (null != this.name) {
            this.append(stringBuilder, "'" + this.name + "'", bl);
            bl = true;
        } else {
            this.append(stringBuilder, "ANON", bl);
            bl = true;
        }
        if (this.hasTypedefName()) {
            stringBuilder.append(" (typedef)");
        }
        this.append(stringBuilder, "size ", bl);
        bl = true;
        if (null != this.size) {
            long l = -1L;
            try {
                l = this.size.computeSize(MachineDescription.StaticConfig.X86_64_UNIX.md);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l2 = l;
            stringBuilder.append("[fixed ").append(this.size.hasFixedNativeSize()).append(", lnx64 ").append(l2).append("]");
        } else {
            stringBuilder.append(" ZERO");
        }
        this.append(stringBuilder, "[", bl);
        bl = false;
        if (this.isConst()) {
            this.append(stringBuilder, "const ", false);
        }
        if (this.isVolatile()) {
            this.append(stringBuilder, "volatile ", false);
        }
        if (this.isPointer()) {
            this.append(stringBuilder, "pointer*" + this.pointerDepth(), bl);
            bl = true;
        }
        if (this.isArray()) {
            this.append(stringBuilder, "array*" + this.arrayDimension(), bl);
            bl = true;
        }
        if (this.isBit()) {
            this.append(stringBuilder, "bit", bl);
            bl = true;
        }
        if (this.isCompound()) {
            stringBuilder.append("struct{").append(this.asCompound().getNumFields());
            this.append(stringBuilder, "}", bl);
            bl = true;
        }
        if (this.isDouble()) {
            this.append(stringBuilder, "double", bl);
            bl = true;
        }
        if (this.isEnum()) {
            this.append(stringBuilder, "enum", bl);
            bl = true;
        }
        if (this.isFloat()) {
            this.append(stringBuilder, "float", bl);
            bl = true;
        }
        if (this.isFunction()) {
            this.append(stringBuilder, "function", bl);
            bl = true;
        }
        if (this.isFunctionPointer()) {
            this.append(stringBuilder, "funcPointer", bl);
            bl = true;
        }
        if (this.isInt()) {
            this.append(stringBuilder, "int", bl);
            bl = true;
        }
        if (this.isVoid()) {
            this.append(stringBuilder, "void", bl);
            bl = true;
        }
        stringBuilder.append("]]");
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.name = string == null ? string : string.intern();
        this.typedefedCVAttributes = this.cvAttributes;
        this.hasTypedefName = true;
    }

    public SizeThunk getSize() {
        return this.size;
    }

    public long getSize(MachineDescription machineDescription) {
        SizeThunk sizeThunk = this.getSize();
        if (sizeThunk == null) {
            throw new RuntimeException("No size set for type \"" + this.getName() + "\"");
        }
        return sizeThunk.computeSize(machineDescription);
    }

    void setSize(SizeThunk sizeThunk) {
        this.size = sizeThunk;
    }

    public BitType asBit() {
        return null;
    }

    public IntType asInt() {
        return null;
    }

    public EnumType asEnum() {
        return null;
    }

    public FloatType asFloat() {
        return null;
    }

    public DoubleType asDouble() {
        return null;
    }

    public PointerType asPointer() {
        return null;
    }

    public ArrayType asArray() {
        return null;
    }

    public CompoundType asCompound() {
        return null;
    }

    public FunctionType asFunction() {
        return null;
    }

    public VoidType asVoid() {
        return null;
    }

    public boolean isBit() {
        return this.asBit() != null;
    }

    public boolean isInt() {
        return this.asInt() != null;
    }

    public boolean isEnum() {
        return this.asEnum() != null;
    }

    public boolean isFloat() {
        return this.asFloat() != null;
    }

    public boolean isDouble() {
        return this.asDouble() != null;
    }

    public boolean isPointer() {
        return this.asPointer() != null;
    }

    public boolean isArray() {
        return this.asArray() != null;
    }

    public boolean isCompound() {
        return this.asCompound() != null;
    }

    public boolean isFunction() {
        return this.asFunction() != null;
    }

    public boolean isVoid() {
        return this.asVoid() != null;
    }

    public boolean isConst() {
        return (this.cvAttributes & ~this.typedefedCVAttributes & 1) != 0;
    }

    public boolean isVolatile() {
        return (this.cvAttributes & ~this.typedefedCVAttributes & 2) != 0;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isFunctionPointer() {
        return this.isPointer() && this.asPointer().getTargetType().isFunction();
    }

    public int hashCode() {
        if (this.name == null) {
            return 0;
        }
        if (this.cvAttributes != 0) {
            String string = this.name + this.cvAttributes;
            return string.hashCode();
        }
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        Type type = (Type)object;
        return this.size == type.size && this.cvAttributes == type.cvAttributes && (null == this.name ? null == type.name : this.name.equals(type.name));
    }

    public String toString() {
        return this.getName(true);
    }

    public void visit(TypeVisitor typeVisitor) {
        typeVisitor.visitType(this);
    }

    public final int getCVAttributes() {
        return this.cvAttributes;
    }

    public final String getCVAttributesString() {
        if (this.isConst() && this.isVolatile()) {
            return "const volatile ";
        }
        if (this.isConst()) {
            return "const ";
        }
        if (this.isVolatile()) {
            return "volatile ";
        }
        return "";
    }

    public final Type getCVVariant(int n) {
        if (this.cvAttributes == n) {
            return this;
        }
        return this.newCVVariant(n);
    }

    abstract Type newCVVariant(int var1);

    public boolean hasTypedefName() {
        return this.hasTypedefName;
    }

    public int pointerDepth() {
        PointerType pointerType = this.asPointer();
        if (pointerType == null) {
            return 0;
        }
        return 1 + pointerType.getTargetType().pointerDepth();
    }

    public int arrayDimension() {
        ArrayType arrayType = this.asArray();
        if (arrayType == null) {
            return 0;
        }
        return 1 + arrayType.getElementType().arrayDimension();
    }

    public Type getBaseElementType() {
        return this;
    }

    static <C> boolean listsEqual(List<C> list, List<C> list2) {
        return list == null && list2 == null || list != null && list2 != null && ((Object)list).equals(list2);
    }
}

