/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.gluegen.ArrayTypes;
import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.SymbolFilter;
import com.jogamp.gluegen.TypeInfo;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.Field;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.IntType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.StructLayout;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jogamp.common.os.MachineDescriptionRuntime;

public class JavaEmitter
implements GlueEmitter {
    private StructLayout layout;
    private TypeDictionary typedefDictionary;
    private Map<Type, Type> canonMap;
    protected JavaConfiguration cfg;
    private boolean requiresStaticInitialization = false;
    private PrintWriter javaWriter;
    private PrintWriter javaImplWriter;
    private PrintWriter cWriter;
    private final MachineDescription machDescJava;
    private final MachineDescription.StaticConfig[] machDescTargetConfigs;
    protected static final Logger LOG = Logger.getLogger(JavaEmitter.class.getPackage().getName());
    private static final String dummyFuncTypeName = "null *";
    private static final Type int32Type = new IntType("int32_t", SizeThunk.INT32, false, 1);
    private static final String nativeArrayLengthArg = "arrayLength";
    private static final String nativeArrayLengthONE = "1";
    private static final String nativeArrayElemOffsetArg = "elem_offset";
    private static final boolean DEBUG_TYPEC2JAVA = false;
    private static final String staticClassInitCodeCCode = "\nstatic const char * clazzNameBuffers = \"com/jogamp/common/nio/Buffers\";\nstatic const char * clazzNameBuffersStaticNewCstrName = \"newDirectByteBuffer\";\nstatic const char * clazzNameBuffersStaticNewCstrSignature = \"(I)Ljava/nio/ByteBuffer;\";\nstatic jclass clazzBuffers = NULL;\nstatic jmethodID cstrBuffersNew = NULL;\nstatic jboolean _initClazzAccessDone = JNI_FALSE;\n\nstatic jboolean _initClazzAccess(JNIEnv *env) {\n    jclass c;\n\n    if(NULL!=cstrBuffersNew) return JNI_TRUE;\n\n    c = (*env)->FindClass(env, clazzNameBuffers);\n    if(NULL==c) {\n        fprintf(stderr, \"FatalError: Can't find %s\\n\", clazzNameBuffers);\n        (*env)->FatalError(env, clazzNameBuffers);\n        return JNI_FALSE;\n    }\n    clazzBuffers = (jclass)(*env)->NewGlobalRef(env, c);\n    if(NULL==clazzBuffers) {\n        fprintf(stderr, \"FatalError: Can't use %s\\n\", clazzNameBuffers);\n        (*env)->FatalError(env, clazzNameBuffers);\n        return JNI_FALSE;\n    }\n\n    cstrBuffersNew = (*env)->GetStaticMethodID(env, clazzBuffers,\n                            clazzNameBuffersStaticNewCstrName, clazzNameBuffersStaticNewCstrSignature);\n    if(NULL==cstrBuffersNew) {\n        fprintf(stderr, \"FatalError: can't create %s.%s %s\\n\",\n            clazzNameBuffers,\n            clazzNameBuffersStaticNewCstrName, clazzNameBuffersStaticNewCstrSignature);\n        (*env)->FatalError(env, clazzNameBuffersStaticNewCstrName);\n        return JNI_FALSE;\n    }\n    _initClazzAccessDone = JNI_TRUE;\n    return JNI_TRUE;\n}\n\nstatic jobject JVMUtil_NewDirectByteBufferCopy(JNIEnv *env, void * source_address, jlong capacity) {\n    jobject jbyteBuffer;\n    void * byteBufferPtr;\n\n    if( JNI_FALSE == _initClazzAccessDone ) {\n        fprintf(stderr, \"FatalError: initializeImpl() not called\\n\");\n        (*env)->FatalError(env, \"initializeImpl() not called\");\n        return NULL;\n    }\n    jbyteBuffer  = (*env)->CallStaticObjectMethod(env, clazzBuffers, cstrBuffersNew, capacity);\n    byteBufferPtr = (*env)->GetDirectBufferAddress(env, jbyteBuffer);\n    memcpy(byteBufferPtr, source_address, capacity);\n    return jbyteBuffer;\n}\n\n";
    private static final String staticClassInitCallJavaCode = "\n  static {\n    if( !initializeImpl() ) {\n      throw new RuntimeException(\"Initialization failure\");\n    }\n  }\n\n";

    public JavaEmitter() {
        this.machDescJava = MachineDescription.StaticConfig.X86_64_UNIX.md;
        this.machDescTargetConfigs = MachineDescription.StaticConfig.values();
    }

    @Override
    public void readConfigurationFile(String string) throws Exception {
        this.cfg = this.createConfig();
        this.cfg.read(string);
    }

    @Override
    public void beginEmission(GlueEmitterControls glueEmitterControls) throws IOException {
        for (String string : this.cfg.forcedStructs()) {
            glueEmitterControls.forceStructEmission(string);
        }
        if (!this.cfg.structsOnly()) {
            try {
                this.openWriters();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to open files for writing", exception);
            }
            this.emitAllFileHeaders();
            glueEmitterControls.runSymbolFilter(new ConstantRenamer());
        }
    }

    @Override
    public void endEmission() {
        if (!this.cfg.structsOnly()) {
            this.emitAllFileFooters();
            try {
                this.closeWriters();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to close open files", exception);
            }
        }
    }

    @Override
    public void beginDefines() throws Exception {
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            this.javaWriter().println();
        }
    }

    protected static int getJavaRadix(String string, String string2) {
        try {
            String string3;
            int n;
            if (string2.startsWith("0x") || string2.startsWith("0X")) {
                n = 16;
                string3 = string2.substring(2);
            } else if (string2.startsWith("0") && string2.length() > 1) {
                n = 8;
                string3 = string2.substring(1);
            } else {
                n = 10;
                string3 = string2;
            }
            Long.parseLong(string3, n);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(string2);
                return 10;
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Cannot emit define \"" + string + "\": value \"" + string2 + "\" cannot be assigned to a int, long, float, or double", numberFormatException2);
            }
        }
    }

    protected static Object getJavaValue(String string, String string2) {
        Scanner scanner = new Scanner(string2).useDelimiter("[+-/*/></(/)]");
        Object object = null;
        while (scanner.hasNext()) {
            String string3 = scanner.next().trim();
            if (0 >= string3.length()) continue;
            Object object2 = JavaEmitter.getJavaValue2(string, string3);
            if (object2 instanceof Double) {
                return object2;
            }
            if (object != null) {
                if (object instanceof Integer) {
                    if (object2 instanceof Long || object2 instanceof Float || object2 instanceof Double) {
                        object = object2;
                    }
                } else if (object instanceof Long) {
                    if (object2 instanceof Float || object2 instanceof Double) {
                        object = object2;
                    }
                } else if (object instanceof Float && object2 instanceof Float) {
                    object = object2;
                }
            } else {
                object = object2;
            }
            if (!(object instanceof Double)) continue;
            return object2;
        }
        return object;
    }

    private static Object getJavaValue2(String string, String string2) {
        char c = string2.charAt(string2.length() - 1);
        try {
            long l;
            String string3;
            int n;
            if (string2.startsWith("0x") || string2.startsWith("0X")) {
                n = 16;
                string3 = string2.substring(2);
            } else if (string2.startsWith("0") && string2.length() > 1) {
                n = 8;
                string3 = string2.substring(1);
            } else {
                n = 10;
                string3 = string2;
            }
            if (c == 'u' || c == 'U') {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((l = Long.parseLong(string3, n)) > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
                return (int)l;
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(string2);
                double d2 = Math.abs(d);
                if (d2 < (double)1.4E-45f || d2 > 3.4028234663852886E38) {
                    return new Double(d);
                }
                return new Float((float)d);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Cannot emit define \"" + string + "\": value \"" + string2 + "\" cannot be assigned to a int, long, float, or double", numberFormatException2);
            }
        }
    }

    protected static String getJavaType(String string, String string2) {
        Object object = JavaEmitter.getJavaValue(string, string2);
        return JavaEmitter.getJavaType(string, object);
    }

    protected static String getJavaType(String string, Object object) {
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Double) {
            return "double";
        }
        throw new RuntimeException("Cannot emit define (2) \"" + string + "\": value \"" + object + "\" cannot be assigned to a int, long, float, or double");
    }

    protected static String jniMangle(String string) {
        return string.replaceAll("_", "_1").replace('.', '_');
    }

    protected static String getJNIMethodNamePrefix(String string, String string2) {
        return "Java_" + JavaEmitter.jniMangle(string) + "_" + JavaEmitter.jniMangle(string2);
    }

    @Override
    public void emitDefine(ConstantDefinition constantDefinition, String string) throws Exception {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            String string2 = constantDefinition.getName();
            String string3 = constantDefinition.getValue();
            if (!this.cfg.shouldIgnoreInInterface(string2)) {
                String string4 = JavaEmitter.getJavaType(string2, string3);
                if (string != null && string.length() != 0) {
                    this.javaWriter().println("  /** " + string + " */");
                }
                String string5 = "";
                if (!string3.endsWith(")")) {
                    if (string4.equals("float") && !string3.endsWith("f")) {
                        string5 = "f";
                    } else if (string3.endsWith("u") || string3.endsWith("U")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                }
                this.javaWriter().println("  public static final " + string4 + " " + string2 + " = " + string3 + string5 + ";");
            }
        }
    }

    @Override
    public void endDefines() throws Exception {
    }

    @Override
    public void beginFunctions(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        this.typedefDictionary = typeDictionary;
        this.canonMap = map;
        this.requiresStaticInitialization = false;
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            this.javaWriter().println();
        }
    }

    @Override
    public Iterator<FunctionSymbol> emitFunctions(List<FunctionSymbol> list) throws Exception {
        HashSet<FunctionSymbol> hashSet = new HashSet<FunctionSymbol>(100);
        for (FunctionSymbol object2 : list) {
            if (hashSet.contains(object2)) continue;
            hashSet.add(object2);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new Comparator<FunctionSymbol>(){

            @Override
            public int compare(FunctionSymbol functionSymbol, FunctionSymbol functionSymbol2) {
                return functionSymbol.getName().compareTo(functionSymbol2.getName());
            }
        });
        HashSet<MethodBinding> hashSet2 = new HashSet<MethodBinding>();
        ArrayList<? extends FunctionEmitter> arrayList2 = new ArrayList<FunctionEmitter>(2 * arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FunctionSymbol functionSymbol = (FunctionSymbol)iterator.next();
            if (this.cfg.shouldIgnoreInImpl(functionSymbol.getName())) continue;
            arrayList2.addAll(this.generateMethodBindingEmitters(hashSet2, functionSymbol));
        }
        for (FunctionEmitter functionEmitter : arrayList2) {
            try {
                if (functionEmitter.isInterface() && this.cfg.shouldIgnoreInInterface(functionEmitter.getName())) continue;
                functionEmitter.emit();
                functionEmitter.getDefaultOutput().println();
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while emitting binding for \"" + functionEmitter.getName() + "\"", exception);
            }
        }
        return arrayList.iterator();
    }

    protected JavaConfiguration createConfig() {
        return new JavaConfiguration();
    }

    protected JavaConfiguration getConfig() {
        return this.cfg;
    }

    protected final boolean requiresStaticInitialization(String string) {
        return this.requiresStaticInitialization || this.cfg.forceStaticInitCode(string);
    }

    protected void generatePublicEmitters(MethodBinding methodBinding, List<FunctionEmitter> list, boolean bl) {
        boolean bl2;
        if (this.cfg.manuallyImplement(methodBinding.getName()) && !bl) {
            return;
        }
        MethodAccess methodAccess = this.cfg.accessControl(methodBinding.getName());
        if (bl && methodAccess != MethodAccess.PUBLIC) {
            return;
        }
        PrintWriter printWriter = bl || this.cfg.allStatic() ? this.javaWriter() : this.javaImplWriter();
        boolean bl3 = this.cfg.isUnimplemented(methodBinding.getName());
        List<String> list2 = this.cfg.javaPrologueForMethod(methodBinding, false, false);
        List<String> list3 = this.cfg.javaEpilogueForMethod(methodBinding, false, false);
        boolean bl4 = bl2 = bl3 || methodBinding.needsNIOWrappingOrUnwrapping() || methodBinding.signatureUsesJavaPrimitiveArrays() || null != list2 || null != list3;
        if (!this.requiresStaticInitialization) {
            this.requiresStaticInitialization = methodBinding.signatureRequiresStaticInitialization();
            if (this.requiresStaticInitialization) {
                LOG.log(Level.INFO, "StaticInit Trigger.1 \"{0}\"", methodBinding);
            }
        }
        JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), !bl && bl2, this.cfg.tagNativeBinding(), false, this.cfg.useNIOOnly(methodBinding.getName()), this.cfg.useNIODirectOnly(methodBinding.getName()), false, false, false, bl3, bl, this.cfg);
        switch (methodAccess) {
            case PUBLIC: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
                break;
            }
            case PROTECTED: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PROTECTED);
                break;
            }
            case PRIVATE: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                break;
            }
        }
        if (this.cfg.allStatic()) {
            javaMethodBindingEmitter.addModifier(FunctionEmitter.STATIC);
        }
        if (!(bl3 || bl2 || bl)) {
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
        }
        javaMethodBindingEmitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(methodBinding.getName()));
        javaMethodBindingEmitter.setPrologue(list2);
        javaMethodBindingEmitter.setEpilogue(list3);
        list.add(javaMethodBindingEmitter);
    }

    protected void generatePrivateEmitters(MethodBinding methodBinding, List<FunctionEmitter> list) {
        boolean bl;
        if (this.cfg.manuallyImplement(methodBinding.getName())) {
            return;
        }
        boolean bl2 = bl = this.cfg.javaPrologueForMethod(methodBinding, false, false) != null || this.cfg.javaEpilogueForMethod(methodBinding, false, false) != null;
        if (!this.cfg.isUnimplemented(methodBinding.getName())) {
            Object object;
            if (!this.requiresStaticInitialization) {
                this.requiresStaticInitialization = methodBinding.signatureRequiresStaticInitialization();
                if (this.requiresStaticInitialization) {
                    LOG.log(Level.INFO, "StaticInit Trigger.2 \"{0}\"", methodBinding);
                }
            }
            if (!methodBinding.signatureUsesJavaPrimitiveArrays() && (methodBinding.needsNIOWrappingOrUnwrapping() || bl)) {
                object = this.cfg.allStatic() ? this.javaWriter() : this.javaImplWriter();
                JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding, (PrintWriter)object, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, this.cfg.useNIOOnly(methodBinding.getName()), this.cfg.useNIODirectOnly(methodBinding.getName()), true, true, false, false, false, this.cfg);
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                if (this.cfg.allStatic()) {
                    javaMethodBindingEmitter.addModifier(FunctionEmitter.STATIC);
                }
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
                javaMethodBindingEmitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(methodBinding.getName()));
                list.add(javaMethodBindingEmitter);
            }
            if (!methodBinding.signatureUsesJavaPrimitiveArrays()) {
                object = new CMethodBindingEmitter(methodBinding, this.cWriter(), this.cfg.implPackageName(), this.cfg.implClassName(), true, this.cfg.allStatic(), methodBinding.needsNIOWrappingOrUnwrapping() || bl, !this.cfg.useNIODirectOnly(methodBinding.getName()), this.machDescJava);
                this.prepCEmitter(methodBinding.getName(), methodBinding.getJavaReturnType(), (CMethodBindingEmitter)object);
                list.add((FunctionEmitter)object);
            }
        }
    }

    protected void prepCEmitter(String string, JavaType javaType, CMethodBindingEmitter cMethodBindingEmitter) {
        if (javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper()) {
            String string2 = this.cfg.returnValueCapacity(string);
            if (string2 != null) {
                cMethodBindingEmitter.setReturnValueCapacityExpression(new MessageFormat(string2));
            }
        } else if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers()) {
            if (javaType.isPrimitiveArray()) {
                throw new RuntimeException("Primitive array return types not yet supported");
            }
            String string3 = this.cfg.returnValueLength(string);
            if (string3 != null) {
                cMethodBindingEmitter.setReturnValueLengthExpression(new MessageFormat(string3));
            }
        }
        cMethodBindingEmitter.setTemporaryCVariableDeclarations(this.cfg.temporaryCVariableDeclarations(string));
        cMethodBindingEmitter.setTemporaryCVariableAssignments(this.cfg.temporaryCVariableAssignments(string));
    }

    protected List<? extends FunctionEmitter> generateMethodBindingEmitters(Set<MethodBinding> set, FunctionSymbol functionSymbol) throws Exception {
        ArrayList<FunctionEmitter> arrayList = new ArrayList<FunctionEmitter>();
        try {
            MethodBinding methodBinding = this.bindFunction(functionSymbol, null, null, this.machDescJava);
            List<MethodBinding> list = this.expandMethodBinding(methodBinding);
            for (MethodBinding methodBinding2 : list) {
                if (!set.add(methodBinding2)) continue;
                if (this.cfg.allStatic() && methodBinding2.hasContainingType()) {
                    throw new IllegalArgumentException("Cannot create binding in AllStatic mode because method has containing type: \"" + methodBinding2 + "\"");
                }
                if (this.cfg.emitInterface()) {
                    this.generatePublicEmitters(methodBinding2, arrayList, true);
                }
                if (!this.cfg.emitImpl()) continue;
                this.generatePublicEmitters(methodBinding2, arrayList, false);
                this.generatePrivateEmitters(methodBinding2, arrayList);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while generating bindings for \"" + functionSymbol + "\"", exception);
        }
        return arrayList;
    }

    @Override
    public void endFunctions() throws Exception {
        if (!this.cfg.structsOnly()) {
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                this.emitCustomJavaCode(this.javaWriter(), this.cfg.className());
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                this.emitCustomJavaCode(this.javaImplWriter(), this.cfg.implClassName());
            }
            if (this.cfg.allStatic()) {
                this.emitJavaInitCode(this.javaWriter(), this.cfg.className());
            } else if (this.cfg.emitImpl()) {
                this.emitJavaInitCode(this.javaImplWriter(), this.cfg.implClassName());
            }
            if (this.cfg.emitImpl()) {
                this.emitCInitCode(this.cWriter(), this.getImplPackageName(), this.cfg.implClassName());
            }
        }
    }

    @Override
    public void beginStructLayout() throws Exception {
    }

    @Override
    public void layoutStruct(CompoundType compoundType) throws Exception {
        this.getLayout().layout(compoundType);
    }

    @Override
    public void endStructLayout() throws Exception {
    }

    @Override
    public void beginStructs(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        this.typedefDictionary = typeDictionary;
        this.canonMap = map;
    }

    @Override
    public void emitStruct(CompoundType compoundType, String string) throws Exception {
        Object object;
        String string2;
        String string3;
        String string4;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        String string5;
        Object object11 = compoundType.getName();
        if (object11 == null && string != null) {
            object11 = string;
        }
        if ((string5 = object11) == null) {
            object11 = compoundType.getStructName();
            if (null != object11 && this.cfg.shouldIgnoreInInterface((String)object11)) {
                return;
            }
            LOG.log(Level.WARNING, "skipping emission of unnamed struct \"{0}\"", compoundType);
            return;
        }
        if (this.cfg.shouldIgnoreInInterface(string5)) {
            return;
        }
        object11 = this.canonicalize(new PointerType(SizeThunk.POINTER, compoundType, 0));
        JavaType javaType = this.typeToJavaType((Type)object11, null);
        if (!javaType.isCompoundTypeWrapper()) {
            return;
        }
        String string6 = javaType.getName();
        this.requiresStaticInitialization = false;
        boolean bl = false;
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            object10 = compoundType.getField(i);
            object9 = ((Field)object10).getType();
            object8 = JavaConfiguration.canonicalStructFieldSymbol(string5, ((Field)object10).getName());
            if (this.cfg.shouldIgnoreInInterface((String)object8)) continue;
            object7 = this.cfg.getJavaSymbolRename((String)object8);
            object6 = object7 == null ? ((Field)object10).getName() : object7;
            object5 = JavaConfiguration.canonicalStructFieldSymbol(string5, (String)object6);
            if (!((Type)object9).isFunctionPointer() && !((Type)object9).isPointer() && !this.requiresGetCStringLength((Type)object9, (String)object5)) continue;
            bl = true;
            break;
        }
        String string7 = this.cfg.packageForStruct(string5);
        try {
            object10 = this.openFile(this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(string7) + File.separator + string6 + ".java", string6);
            if (null == object10) {
                return;
            }
            CodeGenUtils.emitAutogeneratedWarning((PrintWriter)object10, this);
            if (bl) {
                object8 = this.cfg.nativeOutputDir();
                if (this.cfg.nativeOutputUsesJavaHierarchy()) {
                    object8 = (String)object8 + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
                }
                object9 = this.openFile((String)object8 + File.separator + string6 + "_JNI.c", string6);
                CodeGenUtils.emitAutogeneratedWarning((PrintWriter)object9, this);
                this.emitCHeader((PrintWriter)object9, string7, string6);
            } else {
                object9 = null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to open files for emission of struct class", exception);
        }
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("package " + string7 + ";");
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("import java.nio.*;");
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("import " + this.cfg.gluegenRuntimePackage() + ".*;");
        ((PrintWriter)object10).println("import " + DynamicLookupHelper.class.getPackage().getName() + ".*;");
        ((PrintWriter)object10).println("import " + Buffers.class.getPackage().getName() + ".*;");
        ((PrintWriter)object10).println("import " + MachineDescriptionRuntime.class.getName() + ";");
        ((PrintWriter)object10).println();
        object8 = this.cfg.imports();
        object7 = object8.iterator();
        while (object7.hasNext()) {
            object6 = (String)object7.next();
            ((PrintWriter)object10).print("import ");
            ((PrintWriter)object10).print((String)object6);
            ((PrintWriter)object10).println(";");
        }
        ((PrintWriter)object10).println();
        object7 = this.cfg.javadocForClass(string6);
        object6 = object7.iterator();
        while (object6.hasNext()) {
            object5 = (String)object6.next();
            ((PrintWriter)object10).println((String)object5);
        }
        ((PrintWriter)object10).print("public class " + string6 + " ");
        boolean bl2 = true;
        object5 = this.cfg.implementedInterfaces(string6);
        Iterator iterator = object5.iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            if (bl2) {
                ((PrintWriter)object10).print("implements ");
            }
            bl2 = false;
            ((PrintWriter)object10).print((String)object4);
            ((PrintWriter)object10).print(" ");
        }
        ((PrintWriter)object10).println("{");
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("  StructAccessor accessor;");
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("  private static final int mdIdx = MachineDescriptionRuntime.getStatic().ordinal();");
        ((PrintWriter)object10).println();
        this.generateOffsetAndSizeArrays((PrintWriter)object10, "  ", string6, compoundType, null, null);
        if (GlueGen.debug()) {
            System.err.printf("SE.__: structCType %s%n", compoundType.getDebugString());
            System.err.printf("SE.__: contCTypeName %s%n", ((Type)object11).getDebugString());
            System.err.printf("SE.__: contJTypeName %s%n", javaType.getDebugString());
        }
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            object4 = compoundType.getField(i);
            object3 = ((Field)object4).getType();
            object2 = JavaConfiguration.canonicalStructFieldSymbol(string5, ((Field)object4).getName());
            if (!this.cfg.shouldIgnoreInInterface((String)object2)) {
                string4 = this.cfg.getJavaSymbolRename((String)object2);
                string3 = null == string4 ? ((Field)object4).getName() : string4;
                string2 = JavaConfiguration.canonicalStructFieldSymbol(string5, string3);
                if (((Type)object3).isFunctionPointer()) {
                    if (!GlueGen.debug()) continue;
                    System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, object4, string2, ((Type)object3).getDebugString(), "SKIP FuncPtr");
                    continue;
                }
                if (((Type)object3).isCompound()) {
                    if (((Type)object3).getName() == null) {
                        throw new RuntimeException("Anonymous structs as fields not supported yet, field \"" + string2 + "\", " + ((Type)object3).getDebugString());
                    }
                    if (GlueGen.debug()) {
                        System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, object4, string2, ((Type)object3).getDebugString(), "compound");
                    }
                    this.generateOffsetAndSizeArrays((PrintWriter)object10, "  ", string3, (Type)object3, (Field)object4, null);
                    continue;
                }
                if (((Type)object3).isArray()) {
                    object = ((Field)object4).getType().asArray().getBaseElementType();
                    if (GlueGen.debug()) {
                        System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, object4, string2, ((Type)object3).getDebugString(), "array");
                        System.err.printf("SE.os.%02d: baseType %s%n", i + 1, ((Type)object).getDebugString());
                    }
                    this.generateOffsetAndSizeArrays((PrintWriter)object10, "  ", string3, (Type)object3, (Field)object4, null);
                    continue;
                }
                try {
                    object = this.typeToJavaType((Type)object3, this.machDescJava);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error occurred while creating accessor for field \"" + string2 + "\", " + ((Type)object3).getDebugString(), exception);
                }
                if (GlueGen.debug()) {
                    System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, object4, string3, ((Type)object3).getDebugString(), "MISC");
                    System.err.printf("SE.os.%02d: javaType %s%n", i + 1, ((JavaType)object).getDebugString());
                }
                if (((JavaType)object).isPrimitive()) {
                    this.generateOffsetAndSizeArrays((PrintWriter)object10, "  ", string3, null, (Field)object4, null);
                    this.generateOffsetAndSizeArrays((PrintWriter)object10, "//", string3, (Type)object3, null, null);
                    continue;
                }
                if (((JavaType)object).isCPrimitivePointerType()) {
                    if (this.requiresGetCStringLength((Type)object3, string2)) {
                        this.generateOffsetAndSizeArrays((PrintWriter)object10, "  ", string3, null, (Field)object4, null);
                        this.generateOffsetAndSizeArrays((PrintWriter)object10, "//", string3, (Type)object3, null, "// " + ((JavaType)object).getDebugString());
                        continue;
                    }
                    this.generateOffsetAndSizeArrays((PrintWriter)object10, "//", string3, (Type)object3, (Field)object4, "// " + ((JavaType)object).getDebugString());
                    continue;
                }
                this.generateOffsetAndSizeArrays((PrintWriter)object10, "  ", string3, null, (Field)object4, null);
                this.generateOffsetAndSizeArrays((PrintWriter)object10, "//", string3, (Type)object3, null, "// " + ((JavaType)object).getDebugString());
                continue;
            }
            if (!GlueGen.debug()) continue;
            System.err.printf("SE.os.%02d: %s, %s (IGNORED)%n", i + 1, object4, ((Type)object3).getDebugString());
        }
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("  public static int size() {");
        ((PrintWriter)object10).println("    return " + string6 + "_size[mdIdx];");
        ((PrintWriter)object10).println("  }");
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("  public static " + string6 + " create() {");
        ((PrintWriter)object10).println("    return create(Buffers.newDirectByteBuffer(size()));");
        ((PrintWriter)object10).println("  }");
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("  public static " + string6 + " create(java.nio.ByteBuffer buf) {");
        ((PrintWriter)object10).println("      return new " + string6 + "(buf);");
        ((PrintWriter)object10).println("  }");
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("  " + string6 + "(java.nio.ByteBuffer buf) {");
        ((PrintWriter)object10).println("    accessor = new StructAccessor(buf);");
        ((PrintWriter)object10).println("  }");
        ((PrintWriter)object10).println();
        ((PrintWriter)object10).println("  public java.nio.ByteBuffer getBuffer() {");
        ((PrintWriter)object10).println("    return accessor.getBuffer();");
        ((PrintWriter)object10).println("  }");
        HashSet<MethodBinding> hashSet = new HashSet<MethodBinding>();
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            JavaType javaType2;
            object3 = compoundType.getField(i);
            object2 = ((Field)object3).getType();
            string4 = JavaConfiguration.canonicalStructFieldSymbol(string5, ((Field)object3).getName());
            if (this.cfg.shouldIgnoreInInterface(string4)) continue;
            string3 = this.cfg.getJavaSymbolRename(string4);
            string2 = string3 == null ? ((Field)object3).getName() : string3;
            object = JavaConfiguration.canonicalStructFieldSymbol(string5, string2);
            if (GlueGen.debug()) {
                System.err.printf("SE.ac.%02d: %s / %s, %s%n", i + 1, object3, object, ((Type)object2).getDebugString());
            }
            if (((Type)object2).isFunctionPointer()) {
                this.generateFunctionPointerCode(hashSet, (PrintWriter)object10, (PrintWriter)object9, string5, string7, (Type)object11, javaType, i, new FunctionSymbol(string2, ((Type)object2).asPointer().getTargetType().asFunction()), (String)object);
                continue;
            }
            if (((Type)object2).isCompound()) {
                if (((Type)object2).getName() == null) {
                    throw new RuntimeException("Anonymous structs as fields not supported yet (field \"" + object3 + "\" in type \"" + string5 + "\")");
                }
                ((PrintWriter)object10).println();
                this.generateGetterSignature((PrintWriter)object10, (Type)object2, false, ((Type)object2).getName(), this.capitalizeString(string2), null, null);
                ((PrintWriter)object10).println(" {");
                ((PrintWriter)object10).println("    return " + ((Type)object2).getName() + ".create( accessor.slice( " + string2 + "_offset[mdIdx], " + string2 + "_size[mdIdx] ) );");
                ((PrintWriter)object10).println(" }");
                continue;
            }
            if (((Type)object2).isArray() || ((Type)object2).isPointer()) {
                this.generateArrayGetterSetterCode(hashSet, (PrintWriter)object10, (PrintWriter)object9, string5, string7, (Type)object11, javaType, i, (Field)object3, string2, (String)object);
                continue;
            }
            try {
                javaType2 = this.typeToJavaType((Type)object2, this.machDescJava);
            }
            catch (Exception exception) {
                System.err.println("Error occurred while creating accessor for field \"" + ((Field)object3).getName() + "\", " + ((Type)object2).getDebugString());
                throw exception;
            }
            if (javaType2.isPrimitive()) {
                String string8;
                boolean bl3 = ((Type)object2).getSize().hasFixedNativeSize();
                String string9 = this.isOpaque((Type)object2) ? this.compatiblePrimitiveJavaTypeName((Type)object2, javaType2, this.machDescJava) : javaType2.getName();
                String string10 = this.capitalizeString(string9);
                String string11 = this.capitalizeString(string2);
                String string12 = string8 = ((Type)object2).isPointer() ? "pointer" : string9;
                if (GlueGen.debug()) {
                    System.err.println("Java.StructEmitter.Primitive: " + ((Field)object3).getName() + ", " + ((Type)object2).getDebugString() + ", " + string9 + ", " + ", fixedSize " + bl3 + ", opaque " + this.isOpaque((Type)object2) + ", sizeDenominator " + string8);
                }
                if (!((Type)object2).isConst()) {
                    ((PrintWriter)object10).println();
                    this.generateSetterSignature((PrintWriter)object10, (Type)object2, false, string6, string11, null, string9, null, null);
                    ((PrintWriter)object10).println(" {");
                    if (bl3) {
                        ((PrintWriter)object10).println("    accessor.set" + string10 + "At(" + string2 + "_offset[mdIdx], val);");
                    } else {
                        ((PrintWriter)object10).println("    accessor.set" + string10 + "At(" + string2 + "_offset[mdIdx], val, MachineDescriptionRuntime.getStatic().md." + string8 + "SizeInBytes());");
                    }
                    ((PrintWriter)object10).println("    return this;");
                    ((PrintWriter)object10).println("  }");
                }
                ((PrintWriter)object10).println();
                this.generateGetterSignature((PrintWriter)object10, (Type)object2, false, string9, string11, null, null);
                ((PrintWriter)object10).println(" {");
                ((PrintWriter)object10).print("    return ");
                if (bl3) {
                    ((PrintWriter)object10).println("accessor.get" + string10 + "At(" + string2 + "_offset[mdIdx]);");
                } else {
                    ((PrintWriter)object10).println("accessor.get" + string10 + "At(" + string2 + "_offset[mdIdx], MachineDescriptionRuntime.getStatic().md." + string8 + "SizeInBytes());");
                }
                ((PrintWriter)object10).println("  }");
                continue;
            }
            ((PrintWriter)object10).println();
            ((PrintWriter)object10).println("  /** UNKNOWN: " + (String)object + ": " + ((Type)object2).getDebugString() + ", " + javaType2.getDebugString() + " */");
        }
        this.emitCustomJavaCode((PrintWriter)object10, string6);
        if (bl) {
            ((PrintWriter)object10).println();
            this.emitJavaInitCode((PrintWriter)object10, string6);
            ((PrintWriter)object10).println();
        }
        ((PrintWriter)object10).println("}");
        ((PrintWriter)object10).flush();
        ((PrintWriter)object10).close();
        if (bl) {
            this.emitCInitCode((PrintWriter)object9, string7, string6);
            ((PrintWriter)object9).flush();
            ((PrintWriter)object9).close();
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.XX: structCType %s%n", compoundType.getDebugString());
            System.err.printf("SE.XX: contCTypeName %s%n", ((Type)object11).getDebugString());
            System.err.printf("SE.XX: contJTypeName %s%n", javaType.getDebugString());
        }
    }

    @Override
    public void endStructs() throws Exception {
    }

    public static int addStrings2Buffer(StringBuilder stringBuilder, String string, String string2, Collection<String> collection) {
        int n = 0;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        Iterator<String> iterator = collection.iterator();
        if (null != string2) {
            stringBuilder.append(string2);
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        return n;
    }

    private void generateGetterSignature(PrintWriter printWriter, Type type, boolean bl, String string, String string2, String string3, String string4) {
        printWriter.print("  /** Getter for native field: " + type.getDebugString());
        if (null != string4) {
            printWriter.print(", with array length of <code>" + string4 + "</code>");
        }
        printWriter.println(" */");
        printWriter.print("  public " + (bl ? "abstract " : "") + string + " get" + string2 + "(");
        if (null != string3) {
            printWriter.print(string3);
        }
        printWriter.print(")");
    }

    private void generateSetterSignature(PrintWriter printWriter, Type type, boolean bl, String string, String string2, String string3, String string4, String string5, String string6) {
        printWriter.print("  /** Setter for native field: " + type.getDebugString());
        if (null != string6) {
            printWriter.print(", with array length of <code>" + string6 + "</code>");
        }
        printWriter.println(" */");
        printWriter.print("  public " + (bl ? "abstract " : "") + string + " set" + string2 + "(");
        if (null != string3) {
            printWriter.print(string3 + ", ");
        }
        printWriter.print(string4 + " val");
        if (null != string5) {
            printWriter.print(", " + string5);
        }
        printWriter.print(")");
    }

    private void generateOffsetAndSizeArrays(PrintWriter printWriter, String string, String string2, Type type, Field field, String string3) {
        int n;
        if (null != field) {
            printWriter.print(string + "private static final int[] " + string2 + "_offset = new int[] { ");
            for (n = 0; n < this.machDescTargetConfigs.length; ++n) {
                if (0 < n) {
                    printWriter.print(", ");
                }
                printWriter.print(field.getOffset(this.machDescTargetConfigs[n].md) + " /* " + this.machDescTargetConfigs[n].name() + " */");
            }
            printWriter.println(" };");
        }
        if (null != type) {
            printWriter.print(string + "private static final int[] " + string2 + "_size = new int[] { ");
            for (n = 0; n < this.machDescTargetConfigs.length; ++n) {
                if (0 < n) {
                    printWriter.print(", ");
                }
                printWriter.print(type.getSize(this.machDescTargetConfigs[n].md) + " /* " + this.machDescTargetConfigs[n].name() + " */");
            }
            printWriter.print("  };");
            if (null != string3) {
                printWriter.println(string3);
            } else {
                printWriter.println();
            }
        }
    }

    private void generateFunctionPointerCode(Set<MethodBinding> set, PrintWriter printWriter, PrintWriter printWriter2, String string, String string2, Type type, JavaType javaType, int n, FunctionSymbol functionSymbol, String string3) {
        MethodBinding methodBinding = this.bindFunction(functionSymbol, javaType, type, this.machDescJava);
        methodBinding.findThisPointer();
        List<MethodBinding> list = this.expandMethodBinding(methodBinding);
        for (MethodBinding methodBinding2 : list) {
            if (!set.add(methodBinding2)) continue;
            printWriter.println();
            JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), true, this.cfg.tagNativeBinding(), false, true, true, false, false, false, false, false, this.cfg);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
            javaMethodBindingEmitter.emit();
            javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, true, true, true, true, false, false, false, this.cfg);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
            javaMethodBindingEmitter.emit();
            CMethodBindingEmitter cMethodBindingEmitter = new CMethodBindingEmitter(methodBinding2, printWriter2, string2, javaType.getName(), true, false, true, false, this.machDescJava);
            cMethodBindingEmitter.setIsCStructFunctionPointer(true);
            this.prepCEmitter(string3, methodBinding2.getJavaReturnType(), cMethodBindingEmitter);
            cMethodBindingEmitter.emit();
        }
    }

    private void generateArrayPointerCode(Set<MethodBinding> set, PrintWriter printWriter, PrintWriter printWriter2, String string, String string2, Type type, JavaType javaType, int n, FunctionSymbol functionSymbol, String string3, String string4, String string5) {
        MethodBinding methodBinding = this.bindFunction(functionSymbol, javaType, type, this.machDescJava);
        methodBinding.findThisPointer();
        List<MethodBinding> list = this.expandMethodBinding(methodBinding);
        for (MethodBinding methodBinding2 : list) {
            String string6;
            if (!set.add(methodBinding2)) continue;
            JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, true, true, true, true, false, false, false, this.cfg);
            if (null != string4) {
                javaMethodBindingEmitter.setReturnedArrayLengthExpression(string4, true);
            }
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
            javaMethodBindingEmitter.emit();
            CMethodBindingEmitter cMethodBindingEmitter = new CMethodBindingEmitter(methodBinding2, printWriter2, string2, javaType.getName(), true, false, true, false, this.machDescJava);
            cMethodBindingEmitter.setIsCStructFunctionPointer(false);
            if (null != string5) {
                JavaType javaType2 = methodBinding2.getJavaReturnType();
                if (javaType2.isNIOBuffer() || javaType2.isCompoundTypeWrapper()) {
                    Type type2 = functionSymbol.getReturnType();
                    Type type3 = type2.getBaseElementType();
                    string6 = string5 + " * sizeof(" + type3.getName() + ")";
                    cMethodBindingEmitter.setReturnValueCapacityExpression(new MessageFormat(string6));
                } else if (javaType2.isArray() || javaType2.isArrayOfCompoundTypeWrappers()) {
                    string6 = string5;
                    cMethodBindingEmitter.setReturnValueLengthExpression(new MessageFormat(string6));
                } else {
                    string6 = null;
                }
            } else {
                string6 = null;
            }
            this.prepCEmitter(string3, methodBinding2.getJavaReturnType(), cMethodBindingEmitter);
            cMethodBindingEmitter.emit();
        }
    }

    private String getArrayArrayLengthExpr(ArrayType arrayType, String string, boolean[] blArray, int[][] nArray) {
        int[] nArray2 = new int[arrayType.arrayDimension()];
        nArray[0] = nArray2;
        StringBuilder stringBuilder = new StringBuilder();
        blArray[0] = true;
        ArrayType arrayType2 = arrayType;
        for (int i = 0; i < nArray2.length; ++i) {
            if (null != arrayType2 && arrayType2.hasLength()) {
                nArray2[i] = arrayType2.getLength();
                if (0 < i) {
                    stringBuilder.append("*");
                }
                stringBuilder.append(nArray2[i]);
            } else {
                nArray2[i] = -1;
                blArray[0] = false;
            }
            if (null == arrayType2) continue;
            arrayType2 = arrayType2.getElementType().asArray();
        }
        String string2 = this.cfg.returnedArrayLength(string);
        if (null != string2) {
            if (blArray[0]) {
                System.err.println("WARNING: struct array field '" + string + "' of '" + arrayType + "' length '" + Arrays.toString(nArray2) + "' overwritten by cfg-expression: " + string2);
            }
            return string2;
        }
        if (blArray[0]) {
            return stringBuilder.toString();
        }
        System.err.println("WARNING: struct array field '" + string + "' length '" + Arrays.toString(nArray2) + "' without fixed- nor configured-size: " + arrayType.getDebugString());
        return null;
    }

    private String getPointerArrayLengthExpr(PointerType pointerType, String string) {
        String string2 = this.cfg.returnedArrayLength(string);
        if (null != string2) {
            return string2;
        }
        return null;
    }

    private boolean requiresGetCStringLength(Type type, String string) {
        if (!this.cfg.returnsString(string)) {
            return false;
        }
        PointerType pointerType = type.asPointer();
        if (null != pointerType) {
            return null == this.getPointerArrayLengthExpr(pointerType, string);
        }
        return false;
    }

    private void generateArrayGetterSetterCode(Set<MethodBinding> set, PrintWriter printWriter, PrintWriter printWriter2, String string, String string2, Type type, JavaType javaType, int n, Field field, String string3, String string4) throws Exception {
        boolean bl;
        Object object;
        String string5;
        boolean bl2;
        String string6;
        JavaType javaType2;
        boolean bl3;
        boolean bl4;
        Object object2;
        Object object3;
        boolean bl5;
        JavaType javaType3;
        Type type2 = field.getType();
        try {
            javaType3 = this.typeToJavaType(type2, this.machDescJava);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error occurred while creating array/pointer accessor for field \"" + string4 + "\", " + type2.getDebugString(), exception);
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: javaType  %s%n", n + 1, javaType3.getDebugString());
        }
        String string7 = javaType.getName();
        boolean bl6 = this.isOpaque(type2);
        boolean bl7 = this.cfg.returnsString(string4);
        boolean[] blArray = new boolean[]{false};
        Object object4 = type2.asArray();
        String string8 = null;
        if (bl6 || javaType3.isPrimitive()) {
            bl5 = true;
            string8 = nativeArrayLengthONE;
            object3 = new int[]{1};
            object2 = null;
            bl4 = false;
            bl3 = type2.isConst();
            javaType2 = null;
            string6 = this.compatiblePrimitiveJavaTypeName(type2, javaType3, this.machDescJava);
            bl2 = false;
            string5 = type2.isPointer() ? "pointer" : string6;
        } else {
            if (null != object4) {
                object = new int[1][];
                string8 = this.getArrayArrayLengthExpr((ArrayType)object4, string4, blArray, (int[][])object);
                object3 = object[0];
                object2 = ((ArrayType)object4).getBaseElementType();
                bl4 = false;
            } else {
                object = type2.asPointer();
                string8 = this.getPointerArrayLengthExpr((PointerType)object, string4);
                object3 = null;
                object2 = ((PointerType)object).getBaseElementType();
                bl4 = true;
                if (1 != ((Type)object).pointerDepth()) {
                    printWriter.println();
                    String string9 = "SKIP ptr-ptr (depth " + ((Type)object).pointerDepth() + "): " + string4 + ": " + type2;
                    printWriter.println("  // " + string9);
                    System.err.println("WARNING: " + string9);
                    return;
                }
            }
            if (GlueGen.debug()) {
                System.err.printf("SE.ac.%02d: baseCType %s%n", n + 1, ((Type)object2).getDebugString());
            }
            bl5 = ((Type)object2).isPrimitive();
            bl3 = ((Type)object2).isConst();
            try {
                javaType2 = this.typeToJavaType((Type)object2, this.machDescJava);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error occurred while creating array/pointer accessor for field \"" + string4 + "\", baseType " + ((Type)object2).getDebugString() + ", topType " + type2.getDebugString(), exception);
            }
            string6 = javaType2.getName();
            bl2 = ((Type)object2).isPrimitive() ? ((Type)object2).getSize().hasFixedNativeSize() : true;
            String string10 = string5 = ((Type)object2).isPointer() ? "pointer" : string6;
            if (!bl2) {
                printWriter.println();
                object = "SKIP primitive w/ platform dependent sized type in struct: " + string4 + ": " + type2.getDebugString();
                printWriter.println("  // " + (String)object);
                System.err.println("WARNING: " + (String)object);
                return;
            }
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: baseJElemType %s%n", n + 1, null != javaType2 ? javaType2.getDebugString() : null);
        }
        String string11 = this.capitalizeString(string3);
        String string12 = this.capitalizeString(string6);
        String string13 = string6.toUpperCase();
        boolean bl8 = "Byte".equals(string12);
        if (null == string8 && bl7 && bl4) {
            bl = true;
            string8 = "getCStringLengthImpl(pString)+1";
            this.requiresStaticInitialization = true;
            LOG.log(Level.INFO, "StaticInit Trigger.3 \"{0}\"", string4);
        } else {
            bl = false;
        }
        String string14 = string8;
        if (null == string14) {
            printWriter.println();
            object = "SKIP unsized array in struct: " + string4 + ": " + type2.getDebugString();
            printWriter.println("  // " + (String)object);
            System.err.println("WARNING: " + (String)object);
            return;
        }
        boolean bl9 = false;
        try {
            bl9 = 1 == Integer.parseInt(string8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl10 = bl9;
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: baseJElemTypeName %s, array-lengths %s%n", n + 1, string6, Arrays.toString(object3));
            System.err.printf("SE.ac.%02d: arrayLengthExpr: %s, hasSingleElement %b, isByteBuffer %b, isString %b, isPointer %b, isPrimitive %b, isOpaque %b, baseCElemNativeSizeFixed %b, baseCElemSizeDenominator %s, isConst %b, useGetCStringLength %b%n", n + 1, string14, bl10, bl8, bl7, bl4, bl5, bl6, bl2, string5, bl3, bl);
        }
        if (!bl10 && blArray[0]) {
            printWriter.println();
            this.generateGetterSignature(printWriter, type2, false, "final int", string11 + "ArrayLength", null, string14);
            printWriter.println(" {");
            printWriter.println("    return " + string14 + ";");
            printWriter.println("  }");
        }
        if (!bl3) {
            printWriter.println();
            if (bl5) {
                if (bl4) {
                    object2 = "SKIP setter for primitive-pointer type in struct: " + string4 + ": " + type2.getDebugString();
                    printWriter.println("  // " + (String)object2);
                    System.err.println("INFO: " + (String)object2);
                } else if (bl10) {
                    this.generateSetterSignature(printWriter, type2, false, string7, string11, null, string6, null, string14);
                    printWriter.println(" {");
                    if (bl2) {
                        printWriter.println("    accessor.set" + string12 + "At(" + string3 + "_offset[mdIdx], val);");
                    } else {
                        printWriter.println("    accessor.set" + string12 + "At(" + string3 + "_offset[mdIdx], val, MachineDescriptionRuntime.getStatic().md." + string5 + "SizeInBytes());");
                    }
                    printWriter.println("    return this;");
                    printWriter.println("  }");
                } else {
                    this.generateSetterSignature(printWriter, type2, false, string7, string11, "final int offset", string6 + "[]", null, string14);
                    printWriter.println(" {");
                    printWriter.println("    final int arrayLength = " + string14 + ";");
                    printWriter.println("    if( offset + val.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + val.length \"+val.length+\" > array-length \"+arrayLength); };");
                    printWriter.println("    final int elemSize = Buffers.SIZEOF_" + string13 + ";");
                    printWriter.println("    final ByteBuffer destB = getBuffer();");
                    printWriter.println("    final int bTotal = arrayLength * elemSize;");
                    printWriter.println("    if( bTotal > " + string3 + "_size[mdIdx] ) { throw new IndexOutOfBoundsException(\"bTotal \"+bTotal+\" > size \"+" + string3 + "_size[mdIdx]+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                    printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx];");
                    printWriter.println("    final int bLimes = bOffset + bTotal;");
                    printWriter.println("    if( bLimes > destB.limit() ) { throw new IndexOutOfBoundsException(\"bLimes \"+bLimes+\" > buffer.limit \"+destB.limit()+\", elemOff \"+bOffset+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                    printWriter.println("    bOffset += elemSize * offset;");
                    printWriter.println("    accessor.set" + string12 + "sAt(bOffset, val);");
                    printWriter.println("    return this;");
                    printWriter.println("  }");
                }
            } else if (bl4) {
                object2 = "SKIP setter for complex-pointer type in struct: " + string4 + ": " + type2.getDebugString();
                printWriter.println("  // " + (String)object2);
                System.err.println("INFO: " + (String)object2);
            } else if (bl10) {
                this.generateSetterSignature(printWriter, type2, false, string7, string11, null, string6, null, string14);
                printWriter.println(" {");
                printWriter.println("    final int elemSize = " + string6 + ".size();");
                printWriter.println("    final ByteBuffer destB = getBuffer();");
                printWriter.println("    if( elemSize > " + string3 + "_size[mdIdx] ) { throw new IndexOutOfBoundsException(\"elemSize \"+elemSize+\" > size \"+" + string3 + "_size[mdIdx]); };");
                printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx];");
                printWriter.println("    final int bLimes = bOffset + elemSize;");
                printWriter.println("    if( bLimes > destB.limit() ) { throw new IndexOutOfBoundsException(\"bLimes \"+bLimes+\" > buffer.limit \"+destB.limit()+\", elemOff \"+bOffset+\", elemSize \"+elemSize); };");
                printWriter.println("    final ByteBuffer sourceB = val.getBuffer();");
                printWriter.println("    for(int f=0; f<elemSize; f++) {");
                printWriter.println("      if( bOffset >= bLimes ) { throw new IndexOutOfBoundsException(\"elem-byte[0][\"+f+\"]: bOffset \"+bOffset+\" >= bLimes \"+bLimes+\", elemSize \"+elemSize); };");
                printWriter.println("      destB.put(bOffset++, sourceB.get(f));");
                printWriter.println("    }");
                printWriter.println("    return this;");
                printWriter.println("  }");
            } else {
                this.generateSetterSignature(printWriter, type2, false, string7, string11, "final int offset", string6 + "[]", null, string14);
                printWriter.println(" {");
                printWriter.println("    final int arrayLength = " + string14 + ";");
                printWriter.println("    if( offset + val.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + val.length \"+val.length+\" > array-length \"+arrayLength); };");
                printWriter.println("    final int elemSize = " + string6 + ".size();");
                printWriter.println("    final ByteBuffer destB = getBuffer();");
                printWriter.println("    final int bTotal = arrayLength * elemSize;");
                printWriter.println("    if( bTotal > " + string3 + "_size[mdIdx] ) { throw new IndexOutOfBoundsException(\"bTotal \"+bTotal+\" > size \"+" + string3 + "_size[mdIdx]+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx];");
                printWriter.println("    final int bLimes = bOffset + bTotal;");
                printWriter.println("    if( bLimes > destB.limit() ) { throw new IndexOutOfBoundsException(\"bLimes \"+bLimes+\" > buffer.limit \"+destB.limit()+\", elemOff \"+bOffset+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("    bOffset += elemSize * offset;");
                printWriter.println("    for(int index=0; index<val.length; index++) {");
                printWriter.println("      final ByteBuffer sourceB = val[index].getBuffer();");
                printWriter.println("      for(int f=0; f<elemSize; f++) {");
                printWriter.println("        if( bOffset >= bLimes ) { throw new IndexOutOfBoundsException(\"elem-byte[\"+(offset+index)+\"][\"+f+\"]: bOffset \"+bOffset+\" >= bLimes \"+bLimes+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("        destB.put(bOffset++, sourceB.get(f));");
                printWriter.println("      }");
                printWriter.println("    }");
                printWriter.println("    return this;");
                printWriter.println("  }");
                printWriter.println();
                this.generateSetterSignature(printWriter, type2, false, string7, string11, "final int index", string6, null, string14);
                printWriter.println(" {");
                printWriter.println("    final int arrayLength = " + string14 + ";");
                printWriter.println("    final int elemSize = " + string6 + ".size();");
                printWriter.println("    final ByteBuffer destB = getBuffer();");
                printWriter.println("    final int bTotal = arrayLength * elemSize;");
                printWriter.println("    if( bTotal > " + string3 + "_size[mdIdx] ) { throw new IndexOutOfBoundsException(\"bTotal \"+bTotal+\" > size \"+" + string3 + "_size[mdIdx]+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx];");
                printWriter.println("    final int bLimes = bOffset + bTotal;");
                printWriter.println("    if( bLimes > destB.limit() ) { throw new IndexOutOfBoundsException(\"bLimes \"+bLimes+\" > buffer.limit \"+destB.limit()+\", elemOff \"+bOffset+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("    bOffset += elemSize * index;");
                printWriter.println("    final ByteBuffer sourceB = val.getBuffer();");
                printWriter.println("    for(int f=0; f<elemSize; f++) {");
                printWriter.println("      if( bOffset >= bLimes ) { throw new IndexOutOfBoundsException(\"elem-byte[\"+index+\"][\"+f+\"]: bOffset \"+bOffset+\" >= bLimes \"+bLimes+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("      destB.put(bOffset++, sourceB.get(f));");
                printWriter.println("    }");
                printWriter.println("    return this;");
                printWriter.println("  }");
            }
        }
        printWriter.println();
        if (bl5) {
            if (bl4) {
                object2 = new FunctionType(dummyFuncTypeName, SizeThunk.POINTER, type2, 0);
                ((FunctionType)object2).addArgument(type.getCVVariant(type.getCVAttributes() | 1), CMethodBindingEmitter.cThisArgumentName());
                ((FunctionType)object2).addArgument(int32Type, nativeArrayLengthArg);
                object4 = new FunctionSymbol("get" + string11, (FunctionType)object2);
                printWriter2.println();
                printWriter2.print("static " + ((FunctionSymbol)object4).toString());
                printWriter2.println("{");
                printWriter2.println("  return " + CMethodBindingEmitter.cThisArgumentName() + "->" + field.getName() + ";");
                printWriter2.println("}");
                printWriter2.println();
                this.generateArrayPointerCode(set, printWriter, printWriter2, string, string2, type, javaType, n, (FunctionSymbol)object4, string4, string14, nativeArrayLengthArg);
                printWriter.println();
                this.generateGetterSignature(printWriter, type2, false, string12 + "Buffer", string11, null, string14);
                printWriter.println(" {");
                if (bl) {
                    printWriter.println("    final int arrayLength = get" + string11 + "ArrayLength();");
                } else {
                    printWriter.println("    final int arrayLength = " + string14 + ";");
                }
                printWriter.println("    final ByteBuffer _res = get" + string11 + "0(getBuffer(), arrayLength);");
                printWriter.println("    if (_res == null) return null;");
                printWriter.print("    return Buffers.nativeOrder(_res)");
                if (!bl8) {
                    printWriter.print(".as" + string12 + "Buffer()");
                }
                printWriter.println(";");
                printWriter.println("  }");
                if (bl7 && bl8) {
                    printWriter.println();
                    this.generateGetterSignature(printWriter, type2, false, "String", string11 + "AsString", null, string14);
                    printWriter.println(" {");
                    if (bl) {
                        printWriter.println("    final int arrayLength = get" + string11 + "ArrayLength();");
                    } else {
                        printWriter.println("    final int arrayLength = " + string14 + ";");
                    }
                    printWriter.println("    final ByteBuffer bb = get" + string11 + "0(getBuffer(), arrayLength);");
                    printWriter.println("    if (bb == null) return null;");
                    printWriter.println("    final byte[] ba = new byte[arrayLength];");
                    printWriter.println("    int i = -1;");
                    printWriter.println("    while( ++i < arrayLength ) {");
                    printWriter.println("      ba[i] = bb.get(i);");
                    printWriter.println("      if( (byte)0 == ba[i] ) break;");
                    printWriter.println("    }");
                    printWriter.println("    return new String(ba, 0, i);");
                    printWriter.println("  }");
                }
                if (bl) {
                    printWriter.println();
                    this.generateGetterSignature(printWriter, type2, false, "final int", string11 + "ArrayLength", null, string14);
                    printWriter.println(" {");
                    printWriter.println("    final long pString = PointerBuffer.wrap( accessor.slice(" + string3 + "_offset[mdIdx],  PointerBuffer.ELEMENT_SIZE) ).get(0);");
                    printWriter.println("    return " + string14 + ";");
                    printWriter.println("  }");
                }
            } else if (bl10) {
                this.generateGetterSignature(printWriter, type2, false, string6, string11, null, string14);
                printWriter.println(" {");
                if (bl2) {
                    printWriter.println("    return accessor.get" + string12 + "At(" + string3 + "_offset[mdIdx]);");
                } else {
                    printWriter.println("    return accessor.get" + string12 + "At(" + string3 + "_offset[mdIdx], MachineDescriptionRuntime.getStatic().md." + string5 + "SizeInBytes());");
                }
                printWriter.println("  }");
                printWriter.println();
            } else {
                this.generateGetterSignature(printWriter, type2, false, string12 + "Buffer", string11, null, string14);
                printWriter.println(" {");
                printWriter.print("    return accessor.slice(" + string3 + "_offset[mdIdx],  Buffers.SIZEOF_" + string13 + " * " + string14 + ")");
                if (!bl8) {
                    printWriter.print(".as" + string12 + "Buffer()");
                }
                printWriter.println(";");
                printWriter.println("  }");
                printWriter.println();
                if (bl7 && bl8) {
                    this.generateGetterSignature(printWriter, type2, false, "String", string11 + "AsString", null, string14);
                    printWriter.println(" {");
                    printWriter.println("    final int offset = " + string3 + "_offset[mdIdx];");
                    printWriter.println("    final int arrayLength = " + string14 + ";");
                    printWriter.println("    final ByteBuffer bb = getBuffer();");
                    printWriter.println("    final byte[] ba = new byte[arrayLength];");
                    printWriter.println("    int i = -1;");
                    printWriter.println("    while( ++i < arrayLength ) {");
                    printWriter.println("      ba[i] = bb.get(offset+i);");
                    printWriter.println("      if( (byte)0 == ba[i] ) break;");
                    printWriter.println("    }");
                    printWriter.println("    return new String(ba, 0, i);");
                    printWriter.println("  }");
                } else {
                    this.generateGetterSignature(printWriter, type2, false, string6 + "[]", string11, "final int offset, " + string6 + " result[]", string14);
                    printWriter.println(" {");
                    printWriter.println("    final int arrayLength = " + string14 + ";");
                    printWriter.println("    if( offset + result.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + result.length \"+result.length+\" > array-length \"+arrayLength); };");
                    printWriter.println("    return accessor.get" + string12 + "sAt(" + string3 + "_offset[mdIdx] + (Buffers.SIZEOF_" + string13 + " * offset), result);");
                    printWriter.println("  }");
                    printWriter.println();
                }
            }
        } else if (bl4) {
            object2 = new FunctionType(dummyFuncTypeName, SizeThunk.POINTER, type2, 0);
            ((FunctionType)object2).addArgument(type.getCVVariant(type.getCVAttributes() | 1), CMethodBindingEmitter.cThisArgumentName());
            ((FunctionType)object2).addArgument(int32Type, nativeArrayElemOffsetArg);
            object4 = new FunctionSymbol("get" + string11, (FunctionType)object2);
            printWriter2.println();
            printWriter2.print("static " + ((FunctionSymbol)object4).toString());
            printWriter2.println("{");
            printWriter2.println("  return " + CMethodBindingEmitter.cThisArgumentName() + "->" + field.getName() + "+" + nativeArrayElemOffsetArg + ";");
            printWriter2.println("}");
            printWriter2.println();
            this.generateArrayPointerCode(set, printWriter, printWriter2, string, string2, type, javaType, n, (FunctionSymbol)object4, string4, string14, nativeArrayLengthONE);
            printWriter.println();
            if (bl10) {
                this.generateGetterSignature(printWriter, type2, false, string6, string11, null, string14);
                printWriter.println(" {");
                printWriter.println("    final ByteBuffer source = getBuffer();");
                printWriter.println("    final ByteBuffer _res = get" + string11 + "0(source, 0);");
                printWriter.println("    if (_res == null) return null;");
                printWriter.println("    return " + string6 + ".create(_res);");
                printWriter.println("  }");
            } else {
                this.generateGetterSignature(printWriter, type2, false, string6 + "[]", string11, "final int offset, " + string6 + " result[]", string14);
                printWriter.println(" {");
                printWriter.println("    final int arrayLength = " + string14 + ";");
                printWriter.println("    if( offset + result.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + result.length \"+result.length+\" > array-length \"+arrayLength); };");
                printWriter.println("    final ByteBuffer source = getBuffer();");
                printWriter.println("    for(int index=0; index<result.length; index++) {");
                printWriter.println("      final ByteBuffer _res = get" + string11 + "0(source, offset+index);");
                printWriter.println("      if (_res == null) return null;");
                printWriter.println("      result[index] = " + string6 + ".create(_res);");
                printWriter.println("    }");
                printWriter.println("    return result;");
                printWriter.println("  }");
            }
        } else if (bl10) {
            this.generateGetterSignature(printWriter, type2, false, string6, string11, null, string14);
            printWriter.println(" {");
            printWriter.println("    return " + string6 + ".create(accessor.slice(" + string3 + "_offset[mdIdx], " + string6 + ".size()));");
            printWriter.println("  }");
        } else {
            this.generateGetterSignature(printWriter, type2, false, string6 + "[]", string11, "final int offset, " + string6 + " result[]", string14);
            printWriter.println(" {");
            printWriter.println("    final int arrayLength = " + string14 + ";");
            printWriter.println("    if( offset + result.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + result.length \"+result.length+\" > array-length \"+arrayLength); };");
            printWriter.println("    final int elemSize = " + string6 + ".size();");
            printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx] + ( elemSize * offset );");
            printWriter.println("    for(int index=0; index<result.length; index++) {");
            printWriter.println("      result[index] = " + string6 + ".create(accessor.slice(bOffset, elemSize));");
            printWriter.println("      bOffset += elemSize;");
            printWriter.println("    }");
            printWriter.println("    return result;");
            printWriter.println("  }");
        }
    }

    private JavaType typeToJavaType(Type type, MachineDescription machineDescription) {
        JavaType javaType = this.typeToJavaTypeImpl(type, machineDescription);
        return javaType;
    }

    private boolean isJNIEnvPointer(Type type) {
        PointerType pointerType = type.asPointer();
        return pointerType != null && pointerType.getTargetType().getName() != null && pointerType.getTargetType().getName().equals("JNIEnv");
    }

    private JavaType typeToJavaTypeImpl(Type type, MachineDescription machineDescription) {
        Object object;
        if (this.isJNIEnvPointer(type)) {
            return JavaType.createForJNIEnv();
        }
        TypeInfo typeInfo = this.cfg.typeInfo(type, this.typedefDictionary);
        if (typeInfo != null) {
            boolean bl = false;
            if (type.pointerDepth() > 0 || type.arrayDimension() > 0) {
                object = type.isPointer() ? type.asPointer().getTargetType() : type.asArray().getBaseElementType();
                if ((type.pointerDepth() == 2 || type.arrayDimension() == 2) && ((Type)object).isPointer()) {
                    bl = true;
                    Type type2 = ((Type)object).asPointer().getTargetType();
                    if (GlueGen.debug()) {
                        LOG.log(Level.INFO, "Opaque Type: {0}, targetType: {1}, bottomType: {2} is ptr-ptr", new Object[]{type.getDebugString(), object, type2});
                    }
                }
            }
            if (!bl) {
                return typeInfo.javaType();
            }
        }
        if (type.isInt() || type.isEnum()) {
            switch ((int)type.getSize(machineDescription)) {
                case 1: {
                    return this.javaType(Byte.TYPE);
                }
                case 2: {
                    return this.javaType(Short.TYPE);
                }
                case 4: {
                    return this.javaType(Integer.TYPE);
                }
                case 8: {
                    return this.javaType(Long.TYPE);
                }
            }
            throw new RuntimeException("Unknown integer type of size " + type.getSize(machineDescription) + " and name " + type.getName());
        }
        if (type.isFloat()) {
            return this.javaType(Float.TYPE);
        }
        if (type.isDouble()) {
            return this.javaType(Double.TYPE);
        }
        if (type.isVoid()) {
            return this.javaType(Void.TYPE);
        }
        if (type.pointerDepth() > 0 || type.arrayDimension() > 0) {
            Type type3 = type.isPointer() ? type.asPointer().getTargetType() : type.asArray().getBaseElementType();
            if (type.pointerDepth() == 1 || type.arrayDimension() == 1) {
                if (type3.isVoid()) {
                    return JavaType.createForCVoidPointer();
                }
                if (type3.isInt()) {
                    object = type3.getSize();
                    if (null != object && SizeThunk.POINTER == object) {
                        return JavaType.forNIOPointerBufferClass();
                    }
                    switch ((int)type3.getSize(machineDescription)) {
                        case 1: {
                            return JavaType.createForCCharPointer();
                        }
                        case 2: {
                            return JavaType.createForCShortPointer();
                        }
                        case 4: {
                            return JavaType.createForCInt32Pointer();
                        }
                        case 8: {
                            return JavaType.createForCInt64Pointer();
                        }
                    }
                    throw new RuntimeException("Unknown integer array type of size " + type.getSize(machineDescription) + " and name " + type.getName() + ", " + type.getDebugString());
                }
                if (type3.isFloat()) {
                    return JavaType.createForCFloatPointer();
                }
                if (type3.isDouble()) {
                    return JavaType.createForCDoublePointer();
                }
                if (type3.isCompound()) {
                    if (type.isArray()) {
                        return JavaType.createForCArray(type3);
                    }
                    if (type.getName() != null && type.getName().equals("jobject")) {
                        return this.javaType(Object.class);
                    }
                    object = type3.getName();
                    if (object == null && (object = type.getName()) == null) {
                        throw new RuntimeException("Couldn't find a proper type name for pointer type " + type.getDebugString());
                    }
                    return JavaType.createForCStruct(this.cfg.renameJavaType((String)object));
                }
                throw new RuntimeException("Don't know how to convert pointer/array type \"" + type.getDebugString() + "\"");
            }
            if (type.pointerDepth() == 2 || type.arrayDimension() == 2) {
                if (type3.isPointer()) {
                    object = type3.asPointer().getTargetType();
                    if (GlueGen.debug()) {
                        LOG.log(Level.INFO, "typeToJavaType(ptr-ptr): {0}, targetType: {1}, bottomType: {2}", new Object[]{type.getDebugString(), type3, object});
                    }
                    return JavaType.forNIOPointerBufferClass();
                }
                if (type3.isArray()) {
                    object = type3.asArray().getBaseElementType();
                    if (GlueGen.debug()) {
                        LOG.log(Level.INFO, "typeToJavaType(ptr-ptr.array): {0}, targetType: {1}, bottomType: {2}", new Object[]{type.getDebugString(), type3, object});
                    }
                } else {
                    object = type3;
                    if (GlueGen.debug()) {
                        LOG.log(Level.INFO, "typeToJavaType(ptr-ptr.primitive): {0}, targetType: {1}, bottomType: {2}", new Object[]{type.getDebugString(), type3, object});
                    }
                }
                if (((Type)object).isPrimitive()) {
                    if (((Type)object).isInt()) {
                        switch ((int)((Type)object).getSize(machineDescription)) {
                            case 1: {
                                return this.javaType(ArrayTypes.byteBufferArrayClass);
                            }
                            case 2: {
                                return this.javaType(ArrayTypes.shortBufferArrayClass);
                            }
                            case 4: {
                                return this.javaType(ArrayTypes.intBufferArrayClass);
                            }
                            case 8: {
                                return this.javaType(ArrayTypes.longBufferArrayClass);
                            }
                        }
                        throw new RuntimeException("Unknown two-dimensional integer array type of element size " + ((Type)object).getSize(machineDescription) + " and name " + ((Type)object).getName() + ", " + ((Type)object).getDebugString());
                    }
                    if (((Type)object).isFloat()) {
                        return this.javaType(ArrayTypes.floatBufferArrayClass);
                    }
                    if (((Type)object).isDouble()) {
                        return this.javaType(ArrayTypes.doubleBufferArrayClass);
                    }
                    throw new RuntimeException("Unexpected primitive type " + ((Type)object).getDebugString() + " in two-dimensional array");
                }
                if (((Type)object).isVoid()) {
                    return this.javaType(ArrayTypes.bufferArrayClass);
                }
                if (type3.isPointer() && type3.pointerDepth() == 1 && type3.asPointer().getTargetType().isCompound()) {
                    return JavaType.createForCArray((Type)object);
                }
                throw new RuntimeException("Could not convert C type \"" + type.getDebugString() + "\" " + "to appropriate Java type; need to add more support for " + "depth=2 pointer/array types [debug info: targetType=\"" + type3 + "\"]");
            }
            throw new RuntimeException("Could not convert C pointer/array \"" + type.getDebugString() + "\" to " + "appropriate Java type; types with pointer/array depth " + "greater than 2 are not yet supported [debug info: " + "pointerDepth=" + type.pointerDepth() + " arrayDimension=" + type.arrayDimension() + " targetType=\"" + type3 + "\"]");
        }
        if (type.isCompound()) {
            String string = type.getName();
            if (string == null) {
                throw new RuntimeException("Couldn't find a proper type name for pointer type " + type.getDebugString());
            }
            return JavaType.createForCStruct(this.cfg.renameJavaType(string));
        }
        throw new RuntimeException("Could not convert C type \"" + type.getDebugString() + "\" (class " + type.getClass().getName() + ") to appropriate Java type");
    }

    private static boolean isIntegerType(Class<?> clazz) {
        return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE;
    }

    private StructLayout getLayout() {
        if (this.layout == null) {
            this.layout = StructLayout.create(0);
        }
        return this.layout;
    }

    protected PrintWriter openFile(String string, String string2) throws IOException {
        File file = new File(string);
        String string3 = file.getParent();
        if (string3 != null) {
            new File(string3).mkdirs();
        }
        return new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }

    private boolean isOpaque(Type type) {
        return this.cfg.typeInfo(type, this.typedefDictionary) != null;
    }

    private String compatiblePrimitiveJavaTypeName(Type type, JavaType javaType, MachineDescription machineDescription) {
        Class<?> clazz = javaType.getJavaClass();
        if (!JavaEmitter.isIntegerType(clazz)) {
            throw new RuntimeException("Can't yet handle opaque definitions of structs' fields to non-integer types (byte, short, int, long, etc.): type: " + type + ", javaType " + javaType + ", javaClass " + clazz);
        }
        switch ((int)type.getSize(machineDescription)) {
            case 1: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 8: {
                return "long";
            }
        }
        throw new RuntimeException("Can't handle opaque definitions if the starting type isn't compatible with integral types");
    }

    private void openWriters() throws IOException {
        String string = null;
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            string = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        String string2 = null;
        if (!this.cfg.allStatic()) {
            string2 = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.implPackageName());
        }
        String string3 = this.cfg.nativeOutputDir();
        if (this.cfg.nativeOutputUsesJavaHierarchy()) {
            string3 = string3 + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter = this.openFile(string + File.separator + this.cfg.className() + ".java", this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaImplWriter = this.openFile(string2 + File.separator + this.cfg.implClassName() + ".java", this.cfg.implClassName());
        }
        if (this.cfg.emitImpl()) {
            this.cWriter = this.openFile(string3 + File.separator + this.cfg.implClassName() + "_JNI.c", this.cfg.implClassName());
        }
        if (this.javaWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.javaWriter, this);
        }
        if (this.javaImplWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.javaImplWriter, this);
        }
        if (this.cWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.cWriter, this);
        }
    }

    protected PrintWriter javaWriter() {
        if (!this.cfg.allStatic() && !this.cfg.emitInterface()) {
            throw new InternalError("Should not call this");
        }
        return this.javaWriter;
    }

    protected PrintWriter javaImplWriter() {
        if (this.cfg.allStatic() || !this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.javaImplWriter;
    }

    protected PrintWriter cWriter() {
        if (!this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.cWriter;
    }

    private void closeWriter(PrintWriter printWriter) throws IOException {
        printWriter.flush();
        printWriter.close();
    }

    private void closeWriters() throws IOException {
        if (this.javaWriter != null) {
            this.closeWriter(this.javaWriter);
        }
        if (this.javaImplWriter != null) {
            this.closeWriter(this.javaImplWriter);
        }
        if (this.cWriter != null) {
            this.closeWriter(this.cWriter);
        }
        this.javaWriter = null;
        this.javaImplWriter = null;
        this.cWriter = null;
    }

    protected String getJavaOutputDir() {
        return this.cfg.javaOutputDir();
    }

    protected String getJavaPackageName() {
        return this.cfg.packageName();
    }

    protected String getImplPackageName() {
        return this.cfg.implPackageName();
    }

    protected void emitCustomJavaCode(PrintWriter printWriter, String string) throws Exception {
        List<String> list = this.cfg.customJavaCodeForClass(string);
        if (list.isEmpty()) {
            return;
        }
        printWriter.println();
        printWriter.println("  // --- Begin CustomJavaCode .cfg declarations");
        for (String string2 : list) {
            printWriter.println(string2);
        }
        printWriter.println("  // ---- End CustomJavaCode .cfg declarations");
    }

    protected void emitAllFileHeaders() throws IOException {
        try {
            Object object;
            String[] stringArray;
            String[] stringArray2;
            List<String> list;
            ArrayList<String> arrayList = new ArrayList<String>(this.cfg.imports());
            arrayList.add(this.cfg.gluegenRuntimePackage() + ".*");
            arrayList.add(DynamicLookupHelper.class.getPackage().getName() + ".*");
            arrayList.add(Buffers.class.getPackage().getName() + ".*");
            arrayList.add(Buffer.class.getPackage().getName() + ".*");
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                list = null;
                list = this.cfg.emitInterface() ? this.cfg.extendedInterfaces(this.cfg.className()) : this.cfg.implementedInterfaces(this.cfg.className());
                stringArray2 = new String[list.size()];
                list.toArray(stringArray2);
                stringArray = this.cfg.javadocForClass(this.cfg.className());
                object = new CodeGenUtils.EmissionCallback((List)stringArray){
                    final /* synthetic */ List val$intfDocs;
                    {
                        this.val$intfDocs = list;
                    }

                    @Override
                    public void emit(PrintWriter printWriter) {
                        Iterator iterator = this.val$intfDocs.iterator();
                        while (iterator.hasNext()) {
                            printWriter.println((String)iterator.next());
                        }
                    }
                };
                String[] stringArray3 = null;
                stringArray3 = this.cfg.accessControl(this.cfg.className()) == MethodAccess.PUBLIC_ABSTRACT ? new String[]{"public", "abstract"} : new String[]{"public"};
                CodeGenUtils.emitJavaHeaders(this.javaWriter, this.cfg.packageName(), this.cfg.className(), this.cfg.allStatic(), arrayList, stringArray3, stringArray2, this.cfg.extendedParentClass(this.cfg.className()), (CodeGenUtils.EmissionCallback)object);
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                stringArray2 = this.cfg.javadocForClass(this.cfg.implClassName());
                list = new CodeGenUtils.EmissionCallback((List)stringArray2){
                    final /* synthetic */ List val$implDocs;
                    {
                        this.val$implDocs = list;
                    }

                    @Override
                    public void emit(PrintWriter printWriter) {
                        Iterator iterator = this.val$implDocs.iterator();
                        while (iterator.hasNext()) {
                            printWriter.println((String)iterator.next());
                        }
                    }
                };
                object = null;
                object = this.cfg.implementedInterfaces(this.cfg.implClassName());
                int n = 0;
                if (this.cfg.className() != null) {
                    n = 1;
                }
                stringArray = new String[n + object.size()];
                object.toArray(stringArray);
                if (n == 1) {
                    stringArray[object.size()] = this.cfg.className();
                }
                String[] stringArray4 = null;
                stringArray4 = this.cfg.accessControl(this.cfg.implClassName()) == MethodAccess.PUBLIC_ABSTRACT ? new String[]{"public", "abstract"} : new String[]{"public"};
                CodeGenUtils.emitJavaHeaders(this.javaImplWriter, this.cfg.implPackageName(), this.cfg.implClassName(), true, arrayList, stringArray4, stringArray, this.cfg.extendedParentClass(this.cfg.implClassName()), (CodeGenUtils.EmissionCallback)((Object)list));
            }
            if (this.cfg.emitImpl()) {
                this.emitCHeader(this.cWriter(), this.getImplPackageName(), this.cfg.implClassName());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error emitting all file headers: cfg.allStatic()=" + this.cfg.allStatic() + " cfg.emitImpl()=" + this.cfg.emitImpl() + " cfg.emitInterface()=" + this.cfg.emitInterface(), exception);
        }
    }

    protected void emitCHeader(PrintWriter printWriter, String string, String string2) {
        printWriter.println("#include <jni.h>");
        printWriter.println("#include <stdlib.h>");
        printWriter.println("#include <string.h>");
        printWriter.println();
        if (this.getConfig().emitImpl()) {
            printWriter.println("#include <assert.h>");
            printWriter.println();
            printWriter.println("static jobject JVMUtil_NewDirectByteBufferCopy(JNIEnv *env, void * source_address, jlong capacity); /* forward decl. */");
            printWriter.println();
        }
        for (String string3 : this.cfg.customCCode()) {
            printWriter.println(string3);
        }
        printWriter.println();
    }

    protected void emitCInitCode(PrintWriter printWriter, String string, String string2) {
        if (this.requiresStaticInitialization(string2)) {
            printWriter.println(staticClassInitCodeCCode);
            printWriter.println("JNIEXPORT jboolean JNICALL " + JavaEmitter.getJNIMethodNamePrefix(string, string2) + "_initializeImpl(JNIEnv *env, jclass _unused) {");
            printWriter.println("    return _initClazzAccess(env);");
            printWriter.println("}");
            printWriter.println();
            printWriter.println("JNIEXPORT jint JNICALL " + JavaEmitter.getJNIMethodNamePrefix(string, string2) + "_getCStringLengthImpl(JNIEnv *env, jclass _unused, jlong pString) {");
            printWriter.println("    return 0 != pString ? strlen((const char*)(intptr_t)pString) : 0;");
            printWriter.println("}");
            printWriter.println();
        }
    }

    protected void emitJavaInitCode(PrintWriter printWriter, String string) {
        if (null != printWriter && this.requiresStaticInitialization(string)) {
            printWriter.println();
            printWriter.println("  private static native boolean initializeImpl();");
            printWriter.println();
            printWriter.println();
            printWriter.println("  private static native int getCStringLengthImpl(final long pString);");
            printWriter.println();
            if (!this.cfg.manualStaticInitCall(string)) {
                printWriter.println(staticClassInitCallJavaCode);
            }
        }
    }

    protected void emitAllFileFooters() {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter().println();
            this.javaWriter().println("} // end of class " + this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaImplWriter().println();
            this.javaImplWriter().println("} // end of class " + this.cfg.implClassName());
        }
    }

    private JavaType javaType(Class<?> clazz) {
        return JavaType.createForClass(clazz);
    }

    private MethodBinding bindFunction(FunctionSymbol functionSymbol, JavaType javaType, Type type, MachineDescription machineDescription) {
        Object object;
        MethodBinding methodBinding = new MethodBinding(functionSymbol, javaType, type);
        methodBinding.renameMethodName(this.cfg.getJavaSymbolRename(functionSymbol.getName()));
        if (this.cfg.returnsString(methodBinding.getName())) {
            object = functionSymbol.getReturnType().asPointer();
            if (object == null || ((PointerType)object).getTargetType().asInt() == null || ((PointerType)object).getTargetType().getSize(machineDescription) != 1L) {
                throw new RuntimeException("Cannot apply ReturnsString configuration directive to \"" + functionSymbol + "\". ReturnsString requires native method to have return type \"char *\"");
            }
            methodBinding.setJavaReturnType(this.javaType(String.class));
        } else {
            methodBinding.setJavaReturnType(this.typeToJavaType(functionSymbol.getReturnType(), machineDescription));
        }
        object = this.cfg.stringArguments(methodBinding.getName());
        for (int i = 0; i < functionSymbol.getNumArguments(); ++i) {
            Type type2 = functionSymbol.getArgumentType(i);
            JavaType javaType2 = this.typeToJavaType(type2, machineDescription);
            if (object != null && object.contains(i)) {
                if (javaType2.isCVoidPointerType() || javaType2.isCCharPointerType() || javaType2.isCShortPointerType() || javaType2.isNIOPointerBuffer() || javaType2.isArray() && javaType2.getJavaClass() == ArrayTypes.byteBufferArrayClass || javaType2.getJavaClass() == ArrayTypes.shortBufferArrayClass) {
                    javaType2 = javaType2.isArray() || javaType2.isNIOPointerBuffer() ? this.javaType(ArrayTypes.stringArrayClass) : this.javaType(String.class);
                } else {
                    throw new RuntimeException("Cannot apply ArgumentIsString configuration directive to argument " + i + " of \"" + functionSymbol + "\": argument type is not " + "a \"void*\", \"char *\", \"short *\", \"char**\", or \"short**\" equivalent");
                }
            }
            methodBinding.addJavaArgumentType(javaType2);
        }
        return methodBinding;
    }

    private MethodBinding lowerMethodBindingPointerTypes(MethodBinding methodBinding, boolean bl, boolean[] blArray) {
        MethodBinding methodBinding2 = methodBinding;
        boolean bl2 = false;
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (!javaType.isCPrimitivePointerType()) continue;
            if (javaType.isCVoidPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOBufferClass());
                continue;
            }
            if (javaType.isCCharPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.byteArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOByteBufferClass());
                continue;
            }
            if (javaType.isCShortPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.shortArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOShortBufferClass());
                continue;
            }
            if (javaType.isCInt32PointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.intArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOIntBufferClass());
                continue;
            }
            if (javaType.isCInt64PointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.longArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOLongBufferClass());
                continue;
            }
            if (javaType.isCFloatPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.floatArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOFloatBufferClass());
                continue;
            }
            if (javaType.isCDoublePointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.doubleArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIODoubleBufferClass());
                continue;
            }
            throw new RuntimeException("Unknown C pointer type " + javaType);
        }
        JavaType javaType = methodBinding2.getJavaReturnType();
        if (javaType.isCPrimitivePointerType()) {
            if (javaType.isCVoidPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (javaType.isCCharPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (javaType.isCShortPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOShortBufferClass());
            } else if (javaType.isCInt32PointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOIntBufferClass());
            } else if (javaType.isCInt64PointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOLongBufferClass());
            } else if (javaType.isCFloatPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOFloatBufferClass());
            } else if (javaType.isCDoublePointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIODoubleBufferClass());
            } else {
                throw new RuntimeException("Unknown C pointer type " + javaType);
            }
        }
        if (blArray != null) {
            blArray[0] = bl2;
        }
        return methodBinding2;
    }

    protected List<MethodBinding> expandMethodBinding(MethodBinding methodBinding) {
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>();
        boolean[] blArray = new boolean[1];
        if (methodBinding.signatureUsesCPrimitivePointers() || methodBinding.signatureUsesCVoidPointers() || methodBinding.signatureUsesCArrays()) {
            arrayList.add(this.lowerMethodBindingPointerTypes(methodBinding, false, blArray));
            if (blArray[0] && (methodBinding.signatureUsesCPrimitivePointers() || methodBinding.signatureUsesCArrays()) && !this.cfg.useNIOOnly(methodBinding.getName())) {
                arrayList.add(this.lowerMethodBindingPointerTypes(methodBinding, true, null));
            }
        } else {
            arrayList.add(methodBinding);
        }
        return arrayList;
    }

    private Type canonicalize(Type type) {
        Type type2 = this.canonMap.get(type);
        if (type2 != null) {
            return type2;
        }
        this.canonMap.put(type, type);
        return type;
    }

    private final String capitalizeString(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    class ConstantRenamer
    implements SymbolFilter {
        private List<ConstantDefinition> constants;

        ConstantRenamer() {
        }

        @Override
        public void filterSymbols(List<ConstantDefinition> list, List<FunctionSymbol> list2) {
            this.constants = list;
            this.doWork();
        }

        @Override
        public List<ConstantDefinition> getConstants() {
            return this.constants;
        }

        @Override
        public List<FunctionSymbol> getFunctions() {
            return null;
        }

        private void doWork() {
            ArrayList<ConstantDefinition> arrayList = new ArrayList<ConstantDefinition>();
            JavaConfiguration javaConfiguration = JavaEmitter.this.getConfig();
            for (ConstantDefinition constantDefinition : this.constants) {
                constantDefinition.rename(javaConfiguration.getJavaSymbolRename(constantDefinition.getName()));
                arrayList.add(constantDefinition);
            }
            this.constants = arrayList;
        }
    }

    public static enum MethodAccess {
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private"),
        PACKAGE_PRIVATE("/* pp */"),
        PUBLIC_ABSTRACT("abstract");

        private final String javaName;

        public final String getJavaName() {
            return this.javaName;
        }

        private MethodAccess(String string2) {
            this.javaName = string2;
        }
    }

    public static enum EmissionStyle {
        AllStatic,
        InterfaceAndImpl,
        InterfaceOnly,
        ImplOnly;

    }
}

