/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.jvm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.scilab.modules.commons.xml.ScilabXPathFactory;
import org.scilab.modules.jvm.ClassPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class LoadClassPath {
    private static final String SCI = System.getenv("SCI");
    private static final String CLASSPATH_PATH = SCI + "/etc/classpath.xml";
    private static final String XPATH_EXPRS = "//classpaths/path[@load='onUse']/load";
    private static Set<String> loadedModules = new HashSet<String>();

    public static void loadOnUse(String string) {
        Object object;
        if (loadedModules.contains(string)) {
            return;
        }
        String string2 = "//classpaths/path[@load='onUse']/load[@on='" + string + "']";
        XPathFactory xPathFactory = ScilabXPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        DocumentBuilderFactory documentBuilderFactory = ScilabDocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        Document document = null;
        try {
            object = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(new File(CLASSPATH_PATH));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Error: " + parserConfigurationException.getLocalizedMessage());
            parserConfigurationException.printStackTrace();
            return;
        }
        catch (SAXException sAXException) {
            System.err.println("Error: " + sAXException.getLocalizedMessage());
            sAXException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getLocalizedMessage());
            iOException.printStackTrace();
            return;
        }
        try {
            object = (NodeList)xPath.evaluate(string2, document, XPathConstants.NODESET);
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i).getParentNode();
                String string3 = node.getAttributes().getNamedItem("value").getNodeValue();
                ClassPath.addFile(string3.replace("$SCILAB", SCI), 0);
                loadedModules.add(string);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private LoadClassPath() {
    }
}

