/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;

public class ScilabString
implements ScilabType {
    private static final long serialVersionUID = 359802519980180085L;
    private static final int VERSION = 0;
    private String[][] data;
    private String varName;
    private boolean swaped;

    public ScilabString() {
        this.data = null;
    }

    public ScilabString(String[][] stringArray) {
        this.data = stringArray;
    }

    public ScilabString(String string, String[][] stringArray, boolean bl) {
        this.varName = string;
        this.data = stringArray;
        this.swaped = bl;
    }

    public ScilabString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.data = new String[1][1];
            this.data[0][0] = "";
        } else {
            this.data = new String[1][stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.data[0][i] = stringArray[i];
            }
        }
    }

    public ScilabString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        this.data = new String[1][1];
        this.data[0][0] = string;
    }

    public void setData(String[][] stringArray) {
        this.data = stringArray;
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_strings;
    }

    public String[][] getData() {
        return this.data;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return this.swaped;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public int getHeight() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public int getWidth() {
        if (this.data == null) {
            return 0;
        }
        return this.data[0].length;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.deepHashCode((Object[])this.data);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScilabString) {
            return Arrays.deepEquals((Object[])this.getData(), (Object[])((ScilabString)object).getData());
        }
        return false;
    }

    @Override
    public Object getSerializedObject() {
        return this.data;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                this.data = (String[][])objectInput.readObject();
                this.varName = (String)objectInput.readObject();
                this.swaped = objectInput.readBoolean();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabString with a version " + n + " does not exists");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeObject(this.data);
        objectOutput.writeObject(this.varName);
        objectOutput.writeBoolean(this.swaped);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isEmpty()) {
            return "[]";
        }
        stringBuilder.append("[");
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                stringBuilder.append('\"');
                stringBuilder.append(this.data[i][j].replaceAll("[\"']", "\"\""));
                stringBuilder.append('\"');
                if (j == this.getWidth() - 1) continue;
                stringBuilder.append(", ");
            }
            if (i == this.getHeight() - 1) continue;
            stringBuilder.append(" ; ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

