/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import org.scilab.modules.types.ScilabSparseException;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;

public class ScilabSparse
implements ScilabType {
    private static final long serialVersionUID = 879625048944109684L;
    private static final int VERSION = 0;
    protected int rows;
    protected int cols;
    protected int nbItem;
    protected int[] nbItemRow;
    protected int[] colPos;
    protected double[] realPart;
    protected double[] imaginaryPart;
    protected String varName;
    protected boolean byref;

    public ScilabSparse() {
    }

    public ScilabSparse(double d) {
        if (d != 0.0) {
            this.nbItem = 1;
            this.cols = 1;
            this.rows = 1;
            this.nbItemRow = new int[]{1};
            this.colPos = new int[]{0};
            this.realPart = new double[]{d};
        }
    }

    public ScilabSparse(double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            this.nbItem = 1;
            this.cols = 1;
            this.rows = 1;
            this.nbItemRow = new int[]{1};
            this.colPos = new int[]{0};
            this.realPart = new double[]{d};
            this.imaginaryPart = new double[]{d2};
        }
    }

    public ScilabSparse(int n, int n2, int n3, int[] nArray, int[] nArray2, double[] dArray, boolean bl) throws ScilabSparseException {
        this(n, n2, n3, nArray, nArray2, dArray);
        if (bl) {
            ScilabSparse.checkValidity(n, n2, n3, nArray, nArray2);
            if (this.realPart.length != n3) {
                throw new ScilabSparseException("Invalid length for the array realPart: its length must be equal to the number of non-null items.");
            }
        }
    }

    public ScilabSparse(int n, int n2, int n3, int[] nArray, int[] nArray2, double[] dArray) {
        this.rows = n;
        this.cols = n2;
        this.nbItem = n3;
        this.nbItemRow = nArray;
        this.colPos = nArray2;
        this.realPart = dArray;
    }

    public ScilabSparse(int n, int n2, int n3, int[] nArray, int[] nArray2, double[] dArray, double[] dArray2, boolean bl) throws ScilabSparseException {
        this(n, n2, n3, nArray, nArray2, dArray, dArray2);
        if (bl) {
            ScilabSparse.checkValidity(n, n2, n3, nArray, nArray2);
            if (this.realPart.length != n3) {
                throw new ScilabSparseException("Invalid length for the array realPart: its length must be equal to the number of non-null items.");
            }
            if (this.imaginaryPart.length != n3) {
                throw new ScilabSparseException("Invalid length for the array imaginaryPart: its length must be equal to the number of non-null items.");
            }
        }
    }

    public ScilabSparse(int n, int n2, int n3, int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        this(n, n2, n3, nArray, nArray2, dArray);
        this.imaginaryPart = dArray2;
    }

    static final void checkValidity(int n, int n2, int n3, int[] nArray, int[] nArray2) throws ScilabSparseException {
        int n4;
        if (n3 > n * n2 || n3 < 0) {
            throw new ScilabSparseException("Invalid number of items: between 0 and " + n * n2 + " expected.");
        }
        if (nArray.length > n) {
            throw new ScilabSparseException("Invalid length for the array nbItemRow: a length between 0 and " + n + " expected.");
        }
        int n5 = 0;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray[n4] > n2) {
                throw new ScilabSparseException("Invalid number of non-null items in nbItemRow at position " + n4 + ".");
            }
            n5 += nArray[n4];
        }
        if (n5 != n3) {
            throw new ScilabSparseException("Invalid array nbItemRow: the total sum is not equal to the number of non-null items.");
        }
        if (nArray2.length != n3) {
            throw new ScilabSparseException("Invalid length for the array colPos: its length must be equal to the number of non-null items.");
        }
        for (n4 = 0; n4 < n3; ++n4) {
            if (nArray2[n4] < n2 && nArray2[n4] >= 0) continue;
            throw new ScilabSparseException("Invalid column position at position " + n4 + ".");
        }
    }

    public ScilabSparse(double[][] dArray) {
        if (dArray.length != 0 && dArray[0].length != 0) {
            int n;
            this.rows = dArray.length;
            this.cols = dArray[0].length;
            this.nbItemRow = new int[this.rows];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (n = 0; n < this.rows; ++n) {
                for (int i = 0; i < this.cols; ++i) {
                    if (dArray[n][i] == 0.0) continue;
                    ++this.nbItem;
                    int n2 = n;
                    this.nbItemRow[n2] = this.nbItemRow[n2] + 1;
                    arrayList.add(i);
                    arrayList2.add(dArray[n][i]);
                }
            }
            this.colPos = new int[arrayList.size()];
            this.realPart = new double[this.colPos.length];
            n = 0;
            for (Integer number : arrayList) {
                this.colPos[n++] = number;
            }
            n = 0;
            for (Double d : arrayList2) {
                this.realPart[n++] = d;
            }
        }
    }

    public ScilabSparse(double[][] dArray, double[][] dArray2) {
        if (dArray.length != 0 && dArray[0].length != 0) {
            int n;
            this.rows = dArray.length;
            this.cols = dArray[0].length;
            this.nbItemRow = new int[this.rows];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            for (n = 0; n < this.rows; ++n) {
                for (int i = 0; i < this.cols; ++i) {
                    if (dArray[n][i] == 0.0 && dArray2[n][i] == 0.0) continue;
                    ++this.nbItem;
                    int n2 = n;
                    this.nbItemRow[n2] = this.nbItemRow[n2] + 1;
                    arrayList.add(i);
                    arrayList2.add(dArray[n][i]);
                    arrayList3.add(dArray2[n][i]);
                }
            }
            this.colPos = new int[arrayList.size()];
            this.realPart = new double[this.colPos.length];
            this.imaginaryPart = new double[this.colPos.length];
            n = 0;
            for (Integer number : arrayList) {
                this.colPos[n++] = number;
            }
            n = 0;
            for (Double d : arrayList2) {
                this.realPart[n++] = d;
            }
            n = 0;
            for (Double d : arrayList3) {
                this.imaginaryPart[n++] = d;
            }
        }
    }

    public ScilabSparse(String string, int n, int n2, int n3, int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        this(n, n2, n3, nArray, nArray2, dArray, dArray2);
        this.varName = string;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_sparse;
    }

    @Override
    public boolean isEmpty() {
        return this.rows == 0 && this.cols == 0;
    }

    public boolean isReal() {
        return this.imaginaryPart == null;
    }

    public int getColPosElement(int n) {
        return this.colPos[n];
    }

    public void setColPosElement(int n, int n2) {
        this.colPos[n] = n2;
    }

    public int getNbItemElement(int n) {
        return this.nbItemRow[n];
    }

    public void setNbItemElement(int n, int n2) {
        this.nbItemRow[n] = n2;
    }

    public double getRealElement(int n) {
        return this.realPart[n];
    }

    public double getRealElement(int n, int n2) {
        int n3;
        if (this.getNbItemElement(n) == 0) {
            return 0.0;
        }
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n4 += this.getNbItemElement(n3);
        }
        for (n3 = n4; n3 < n4 + this.getNbItemElement(n); ++n3) {
            if (this.getColPosElement(n3) != n2) continue;
            return this.getRealElement(n3);
        }
        return 0.0;
    }

    public double getImaginaryElement(int n) {
        return this.imaginaryPart[n];
    }

    public double getImaginaryElement(int n, int n2) {
        int n3;
        if (this.getNbItemElement(n) == 0) {
            return 0.0;
        }
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n4 += this.getNbItemElement(n3);
        }
        for (n3 = n4; n3 < n4 + this.getNbItemElement(n); ++n3) {
            if (this.getColPosElement(n3) != n2) continue;
            return this.getImaginaryElement(n3);
        }
        return 0.0;
    }

    public double[] getElement(int n) {
        if (this.isReal()) {
            return new double[]{this.realPart[n], 0.0};
        }
        return new double[]{this.realPart[n], this.imaginaryPart[n]};
    }

    public double[] getElement(int n, int n2) {
        int n3;
        if (this.isReal()) {
            return new double[]{this.getRealElement(n, n2), 0.0};
        }
        if (this.getNbItemElement(n) == 0) {
            return new double[]{0.0, 0.0};
        }
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n4 += this.getNbItemElement(n3);
        }
        for (n3 = n4; n3 < n4 + this.getNbItemElement(n); ++n3) {
            if (this.getColPosElement(n3) != n2) continue;
            return new double[]{this.getRealElement(n3), this.getImaginaryElement(n3)};
        }
        return new double[]{0.0, 0.0};
    }

    public void setRealElement(int n, double d) {
        this.realPart[n] = d;
    }

    public void setRealElement(int n, int n2, double d) {
        int n3;
        if (this.getNbItemElement(n) == 0) {
            return;
        }
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n4 += this.getNbItemElement(n3);
        }
        for (n3 = n4; n3 < n4 + this.getNbItemElement(n); ++n3) {
            if (this.getColPosElement(n3) != n2) continue;
            this.setRealElement(n3, d);
            break;
        }
    }

    public void setImaginaryElement(int n, double d) {
        this.imaginaryPart[n] = d;
    }

    public void setImaginaryElement(int n, int n2, double d) {
        int n3;
        if (this.getNbItemElement(n) == 0) {
            return;
        }
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n4 += this.getNbItemElement(n3);
        }
        for (n3 = n4; n3 < n4 + this.getNbItemElement(n); ++n3) {
            if (this.getColPosElement(n3) != n2) continue;
            this.setImaginaryElement(n3, d);
            break;
        }
    }

    public void setElement(int n, double d, double d2) {
        this.setRealElement(n, d);
        this.setImaginaryElement(n, d2);
    }

    public double[] getRealPart() {
        return this.realPart;
    }

    public void setRealPart(double[] dArray) {
        this.realPart = dArray;
    }

    public double[] getImaginaryPart() {
        return this.imaginaryPart;
    }

    public void setImaginaryPart(double[] dArray) {
        this.imaginaryPart = dArray;
    }

    public int getNbNonNullItems() {
        return this.nbItem;
    }

    public void setNbNonNullItems(int n) {
        this.nbItem = n;
    }

    public int[] getNbItemRow() {
        return this.nbItemRow;
    }

    public void setNbItemRow(int[] nArray) {
        this.nbItemRow = nArray;
    }

    public int[] getScilabColPos() {
        int[] nArray = new int[this.colPos.length];
        for (int i = 0; i < this.colPos.length; ++i) {
            nArray[i] = this.colPos[i] + 1;
        }
        return nArray;
    }

    public int[] getColPos() {
        return this.colPos;
    }

    public void setColPos(int[] nArray) {
        this.colPos = nArray;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return false;
    }

    public double[][] getFullRealPart() {
        int n = 0;
        int n2 = 0;
        double[][] dArray = new double[this.rows][this.cols];
        for (int i = 0; i < this.nbItemRow.length; ++i) {
            while (n2 < n + this.nbItemRow[i]) {
                dArray[i][this.colPos[n2]] = this.realPart[n2];
                ++n2;
            }
            n += this.nbItemRow[i];
        }
        return dArray;
    }

    public double[][] getFullImaginaryPart() {
        int n = 0;
        int n2 = 0;
        double[][] dArray = new double[this.rows][this.cols];
        for (int i = 0; i < this.nbItemRow.length; ++i) {
            while (n2 < n + this.nbItemRow[i]) {
                dArray[i][this.colPos[n2]] = this.imaginaryPart[n2];
                ++n2;
            }
            n += this.nbItemRow[i];
        }
        return dArray;
    }

    public double[][][] getFullMatrix() {
        int n = 0;
        int n2 = 0;
        double[][][] dArray = new double[2][this.rows][this.cols];
        for (int i = 0; i < this.nbItemRow.length; ++i) {
            while (n2 < n + this.nbItemRow[i]) {
                dArray[0][i][this.colPos[n2]] = this.realPart[n2];
                dArray[1][i][this.colPos[n2]] = this.imaginaryPart[n2];
                ++n2;
            }
            n += this.nbItemRow[i];
        }
        return dArray;
    }

    public double[] getSerializedSparseMatrix() {
        return new double[0];
    }

    @Override
    public int getHeight() {
        return this.rows;
    }

    @Override
    public int getWidth() {
        return this.cols;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.colPos);
        n = 31 * n + this.cols;
        n = 31 * n + Arrays.hashCode(this.imaginaryPart);
        n = 31 * n + this.nbItem;
        n = 31 * n + Arrays.hashCode(this.nbItemRow);
        n = 31 * n + Arrays.hashCode(this.realPart);
        n = 31 * n + this.rows;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScilabSparse) {
            ScilabSparse scilabSparse = (ScilabSparse)object;
            if (this.isEmpty() && scilabSparse.isEmpty()) {
                return true;
            }
            if (this.getWidth() != scilabSparse.getWidth() || this.getHeight() != scilabSparse.getHeight()) {
                return false;
            }
            if (this.getNbNonNullItems() == scilabSparse.getNbNonNullItems() && ScilabSparse.compareNbItemRow(this.getNbItemRow(), scilabSparse.getNbItemRow()) && Arrays.equals(this.getColPos(), scilabSparse.getColPos())) {
                if (this.isReal() && scilabSparse.isReal()) {
                    return Arrays.equals(this.getRealPart(), scilabSparse.getRealPart());
                }
                return Arrays.equals(this.getRealPart(), scilabSparse.getRealPart()) && Arrays.equals(this.getImaginaryPart(), scilabSparse.getImaginaryPart());
            }
            return false;
        }
        return false;
    }

    static final boolean compareNbItemRow(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3;
        int[] nArray4;
        if (Arrays.equals(nArray, nArray2)) {
            return true;
        }
        if (nArray.length == nArray2.length) {
            return false;
        }
        if (nArray.length < nArray2.length) {
            nArray4 = nArray;
            nArray3 = nArray2;
        } else {
            nArray4 = nArray2;
            nArray3 = nArray;
        }
        for (n = 0; n < nArray4.length; ++n) {
            if (nArray4[n] == nArray3[n]) continue;
            return false;
        }
        while (n < nArray3.length) {
            if (nArray3[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public Object getSerializedObject() {
        if (this.isReal()) {
            return new Object[]{new int[]{this.getHeight(), this.getWidth()}, this.getNbItemRow(), this.getScilabColPos(), this.getRealPart()};
        }
        return new Object[]{new int[]{this.getHeight(), this.getWidth()}, this.getNbItemRow(), this.getScilabColPos(), this.getRealPart(), this.getImaginaryPart()};
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                this.rows = objectInput.readInt();
                this.cols = objectInput.readInt();
                this.nbItem = objectInput.readInt();
                this.nbItemRow = (int[])objectInput.readObject();
                this.colPos = (int[])objectInput.readObject();
                this.realPart = (double[])objectInput.readObject();
                this.imaginaryPart = (double[])objectInput.readObject();
                this.varName = (String)objectInput.readObject();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabSparse with a version " + n + " does not exists");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeInt(this.rows);
        objectOutput.writeInt(this.cols);
        objectOutput.writeInt(this.nbItem);
        objectOutput.writeObject(this.nbItemRow);
        objectOutput.writeObject(this.colPos);
        objectOutput.writeObject(this.realPart);
        objectOutput.writeObject(this.imaginaryPart);
        objectOutput.writeObject(this.varName);
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isEmpty()) {
            return "[]";
        }
        stringBuilder.append("sparse([");
        int n2 = 0;
        int n3 = 0;
        int[] nArray = this.getNbItemRow();
        int[] nArray2 = this.getColPos();
        for (n = 0; n < nArray.length; ++n) {
            while (n2 < n3 + nArray[n]) {
                stringBuilder.append(Integer.toString(n + 1));
                stringBuilder.append(", ");
                stringBuilder.append(Integer.toString(nArray2[n2] + 1));
                if (n2 < this.nbItem - 1) {
                    stringBuilder.append(" ; ");
                }
                ++n2;
            }
            n3 += nArray[n];
        }
        stringBuilder.append("], [");
        n = this.isReal() ? 1 : 0;
        for (int i = 0; i < this.nbItem; ++i) {
            double d;
            stringBuilder.append(Double.toString(this.getRealElement(i)));
            if (n == 0 && (d = this.getImaginaryElement(i)) != 0.0) {
                if (d > 0.0) {
                    stringBuilder.append("+");
                }
                stringBuilder.append(Double.toString(d));
                stringBuilder.append("*%i");
            }
            if (i < this.nbItem - 1) {
                stringBuilder.append(" ; ");
                continue;
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(", [");
        stringBuilder.append(Integer.toString(this.rows));
        stringBuilder.append(", ");
        stringBuilder.append(Integer.toString(this.cols));
        stringBuilder.append("])");
        return stringBuilder.toString();
    }
}

