/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;

public class ScilabList
extends ArrayList<ScilabType>
implements ScilabType {
    private static final long serialVersionUID = 6884293176289980909L;
    private static final int VERSION = 0;
    private String varName;

    public ScilabList() {
    }

    public ScilabList(Collection<? extends ScilabType> collection) {
        super(collection);
    }

    public ScilabList(String string) {
        this.varName = string;
    }

    public ScilabList(String string, int n) {
        super(n);
        this.varName = string;
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return false;
    }

    @Override
    public int getHeight() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_list;
    }

    @Override
    public int getWidth() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.size();
    }

    public Object[] getSerializedObject() {
        int[] nArray = new int[this.size()];
        Object[] objectArray = new Object[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            ScilabType scilabType = (ScilabType)this.get(i);
            nArray[i] = scilabType.getType().swigValue();
            objectArray[i + 1] = scilabType.getSerializedObject();
        }
        objectArray[0] = nArray;
        return objectArray;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                int n2 = objectInput.readInt();
                this.ensureCapacity(n2 + 1);
                ScilabList scilabList = this;
                for (int i = 0; i < n2; ++i) {
                    scilabList.add(objectInput.readObject());
                }
                this.varName = (String)objectInput.readObject();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabList with a version " + n + " does not exists");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeInt(this.size());
        for (Object e : this) {
            objectOutput.writeObject(e);
        }
        objectOutput.writeObject(this.varName);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isEmpty()) {
            return "list()";
        }
        stringBuffer.append("list(");
        for (int i = 0; i < this.size(); ++i) {
            stringBuffer.append(this.get(i));
            if (i == this.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

