/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.scilab.modules.types.ScilabIntegerTypeEnum;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;
import org.scilab.modules.types.ScilabTypeUtils;

public class ScilabInteger
implements ScilabType {
    private static final long serialVersionUID = 1759633801332932450L;
    private static final int VERSION = 0;
    protected long[][] longData;
    protected short[][] shortData;
    protected int[][] intData;
    protected byte[][] byteData;
    protected ScilabIntegerTypeEnum precision;
    protected String varName;
    protected boolean swaped;
    protected transient boolean byref;

    public ScilabInteger() {
    }

    public ScilabInteger(byte[][] byArray, boolean bl) {
        this.setData(byArray, bl);
    }

    public ScilabInteger(short[][] sArray, boolean bl) {
        this.setData(sArray, bl);
    }

    public ScilabInteger(int[][] nArray, boolean bl) {
        this.setData(nArray, bl);
    }

    public ScilabInteger(long[][] lArray, boolean bl) {
        this.setData(lArray, bl);
    }

    public ScilabInteger(String string, byte[][] byArray, boolean bl, boolean bl2) {
        this.setData(byArray, bl);
        this.varName = string;
        this.swaped = bl2;
    }

    public ScilabInteger(String string, short[][] sArray, boolean bl, boolean bl2) {
        this.setData(sArray, bl);
        this.varName = string;
        this.swaped = bl2;
    }

    public ScilabInteger(String string, int[][] nArray, boolean bl, boolean bl2) {
        this.setData(nArray, bl);
        this.varName = string;
        this.swaped = bl2;
    }

    public ScilabInteger(String string, long[][] lArray, boolean bl, boolean bl2) {
        this.setData(lArray, bl);
        this.varName = string;
        this.swaped = bl2;
    }

    public ScilabInteger(byte by) {
        this.byteData = new byte[1][1];
        this.byteData[0][0] = by;
        this.precision = ScilabIntegerTypeEnum.sci_int8;
    }

    public ScilabInteger(short s) {
        this.shortData = new short[1][1];
        this.shortData[0][0] = s;
        this.precision = ScilabIntegerTypeEnum.sci_int16;
    }

    public ScilabInteger(int n) {
        this.intData = new int[1][1];
        this.intData[0][0] = n;
        this.precision = ScilabIntegerTypeEnum.sci_int32;
    }

    public ScilabInteger(long l) {
        this.longData = new long[1][1];
        this.longData[0][0] = l;
        this.precision = ScilabIntegerTypeEnum.sci_int64;
    }

    public ScilabInteger(byte by, boolean bl) {
        this(by);
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint8 : ScilabIntegerTypeEnum.sci_int8;
    }

    public ScilabInteger(short s, boolean bl) {
        this(s);
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint16 : ScilabIntegerTypeEnum.sci_int16;
    }

    public ScilabInteger(int n, boolean bl) {
        this(n);
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint32 : ScilabIntegerTypeEnum.sci_int32;
    }

    public ScilabInteger(long l, boolean bl) {
        this(l);
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint64 : ScilabIntegerTypeEnum.sci_int64;
    }

    public void setData(byte[][] byArray, boolean bl) {
        this.byteData = byArray;
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint8 : ScilabIntegerTypeEnum.sci_int8;
    }

    public void setData(short[][] sArray, boolean bl) {
        this.shortData = sArray;
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint16 : ScilabIntegerTypeEnum.sci_int16;
    }

    public void setData(int[][] nArray, boolean bl) {
        this.intData = nArray;
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint32 : ScilabIntegerTypeEnum.sci_int32;
    }

    public void setData(long[][] lArray, boolean bl) {
        this.longData = lArray;
        this.precision = bl ? ScilabIntegerTypeEnum.sci_uint64 : ScilabIntegerTypeEnum.sci_int64;
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_ints;
    }

    public long[][] getData() {
        long[][] lArray = new long[this.getHeight()][this.getWidth()];
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                for (int i = 0; i < this.getHeight(); ++i) {
                    for (int j = 0; j < this.getWidth(); ++j) {
                        lArray[i][j] = this.getByteElement(i, j);
                    }
                }
                return lArray;
            }
            case sci_int16: 
            case sci_uint16: {
                for (int i = 0; i < this.getHeight(); ++i) {
                    for (int j = 0; j < this.getWidth(); ++j) {
                        lArray[i][j] = this.getShortElement(i, j);
                    }
                }
                return lArray;
            }
            case sci_int32: 
            case sci_uint32: {
                for (int i = 0; i < this.getHeight(); ++i) {
                    for (int j = 0; j < this.getWidth(); ++j) {
                        lArray[i][j] = this.getIntElement(i, j);
                    }
                }
                return lArray;
            }
            case sci_int64: 
            case sci_uint64: {
                return this.longData;
            }
        }
        return null;
    }

    public short[][] getDataAsShort() {
        return this.shortData;
    }

    public byte[][] getDataAsByte() {
        return this.byteData;
    }

    public int[][] getDataAsInt() {
        return this.intData;
    }

    public long[][] getDataAsLong() {
        return this.longData;
    }

    public ScilabIntegerTypeEnum getPrec() {
        return this.precision;
    }

    public boolean isUnsigned() {
        switch (this.precision) {
            case sci_int8: 
            case sci_int16: 
            case sci_int32: 
            case sci_int64: {
                return false;
            }
            case sci_uint8: 
            case sci_uint16: 
            case sci_uint32: 
            case sci_uint64: {
                return true;
            }
        }
        return false;
    }

    public static ScilabIntegerTypeEnum convertOldType(String string, boolean bl) {
        if (string.equals("type8")) {
            if (bl) {
                return ScilabIntegerTypeEnum.sci_uint8;
            }
            return ScilabIntegerTypeEnum.sci_int8;
        }
        if (string.equals("type16")) {
            if (bl) {
                return ScilabIntegerTypeEnum.sci_uint16;
            }
            return ScilabIntegerTypeEnum.sci_int16;
        }
        if (string.equals("type32")) {
            if (bl) {
                return ScilabIntegerTypeEnum.sci_uint32;
            }
            return ScilabIntegerTypeEnum.sci_int32;
        }
        if (string.equals("type64")) {
            if (bl) {
                return ScilabIntegerTypeEnum.sci_uint64;
            }
            return ScilabIntegerTypeEnum.sci_int64;
        }
        return null;
    }

    @Override
    public int getHeight() {
        if (this.getPrec() == null) {
            return 0;
        }
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                if (this.byteData == null) {
                    return 0;
                }
                return this.byteData.length;
            }
            case sci_int16: 
            case sci_uint16: {
                if (this.shortData == null) {
                    return 0;
                }
                return this.shortData.length;
            }
            case sci_int32: 
            case sci_uint32: {
                if (this.intData == null) {
                    return 0;
                }
                return this.intData.length;
            }
            case sci_int64: 
            case sci_uint64: {
                if (this.longData == null) {
                    return 0;
                }
                return this.longData.length;
            }
        }
        return 0;
    }

    @Override
    public int getWidth() {
        if (this.getPrec() == null) {
            return 0;
        }
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                if (this.byteData == null) {
                    return 0;
                }
                return this.byteData[0].length;
            }
            case sci_int16: 
            case sci_uint16: {
                if (this.shortData == null) {
                    return 0;
                }
                return this.shortData[0].length;
            }
            case sci_int32: 
            case sci_uint32: {
                if (this.intData == null) {
                    return 0;
                }
                return this.intData[0].length;
            }
            case sci_int64: 
            case sci_uint64: {
                if (this.longData == null) {
                    return 0;
                }
                return this.longData[0].length;
            }
        }
        return 0;
    }

    @Override
    public boolean isReference() {
        return this.byref;
    }

    @Override
    public boolean isEmpty() {
        if (this.getPrec() == null) {
            return true;
        }
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                return this.byteData == null;
            }
            case sci_int16: 
            case sci_uint16: {
                return this.shortData == null;
            }
            case sci_int32: 
            case sci_uint32: {
                return this.intData == null;
            }
            case sci_int64: 
            case sci_uint64: {
                return this.longData == null;
            }
        }
        return true;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return this.swaped;
    }

    public byte getByteElement(int n, int n2) {
        return this.byteData[n][n2];
    }

    public short getShortElement(int n, int n2) {
        return this.shortData[n][n2];
    }

    public int getIntElement(int n, int n2) {
        return this.intData[n][n2];
    }

    public long getLongElement(int n, int n2) {
        return this.longData[n][n2];
    }

    public void setByteElement(int n, int n2, byte by) {
        this.byteData[n][n2] = by;
    }

    public void setShortElement(int n, int n2, short s) {
        this.shortData[n][n2] = s;
    }

    public void setIntElement(int n, int n2, int n3) {
        this.intData[n][n2] = n3;
    }

    public void setLongElement(int n, int n2, long l) {
        this.longData[n][n2] = l;
    }

    public long getElement(int n, int n2) {
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                return this.getByteElement(n, n2);
            }
            case sci_int16: 
            case sci_uint16: {
                return this.getShortElement(n, n2);
            }
            case sci_int32: 
            case sci_uint32: {
                return this.getIntElement(n, n2);
            }
            case sci_int64: 
            case sci_uint64: {
                return this.getLongElement(n, n2);
            }
        }
        return 0L;
    }

    public void setElement(int n, int n2, long l) {
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                this.setByteElement(n, n2, (byte)l);
                break;
            }
            case sci_int16: 
            case sci_uint16: {
                this.setShortElement(n, n2, (short)l);
                break;
            }
            case sci_int32: 
            case sci_uint32: {
                this.setIntElement(n, n2, (int)l);
                break;
            }
            case sci_int64: 
            case sci_uint64: {
                this.setLongElement(n, n2, l);
            }
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.deepHashCode((Object[])this.byteData);
        n = 31 * n + Arrays.deepHashCode((Object[])this.intData);
        n = 31 * n + Arrays.deepHashCode((Object[])this.longData);
        n = 31 * n + (this.precision == null ? 0 : this.precision.hashCode());
        n = 31 * n + Arrays.deepHashCode((Object[])this.shortData);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScilabInteger) {
            ScilabInteger scilabInteger = (ScilabInteger)object;
            if (this.isEmpty() && scilabInteger.isEmpty()) {
                return true;
            }
            if (this.getWidth() != scilabInteger.getWidth() || this.getHeight() != scilabInteger.getHeight()) {
                return false;
            }
            return ScilabTypeUtils.equalsInteger(this.getRawData(), this.isSwaped(), scilabInteger.getRawData(), scilabInteger.isSwaped());
        }
        return false;
    }

    public Object getCorrectData() {
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                return this.byteData;
            }
            case sci_int16: 
            case sci_uint16: {
                return this.shortData;
            }
            case sci_int32: 
            case sci_uint32: {
                return this.intData;
            }
            case sci_int64: 
            case sci_uint64: {
                return this.longData;
            }
        }
        return null;
    }

    public Object getRawData() {
        return this.getCorrectData();
    }

    @Override
    public Object getSerializedObject() {
        return new Object[]{new int[]{this.getPrec().swigValue()}, this.getCorrectData()};
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                this.precision = ScilabIntegerTypeEnum.swigToEnum(objectInput.readInt());
                Object object = objectInput.readObject();
                switch (this.precision) {
                    case sci_int8: 
                    case sci_uint8: {
                        this.byteData = (byte[][])object;
                        break;
                    }
                    case sci_int16: 
                    case sci_uint16: {
                        this.shortData = (short[][])object;
                        break;
                    }
                    case sci_int32: 
                    case sci_uint32: {
                        this.intData = (int[][])object;
                        break;
                    }
                    case sci_int64: 
                    case sci_uint64: {
                        this.longData = (long[][])object;
                    }
                }
                this.varName = (String)objectInput.readObject();
                this.swaped = objectInput.readBoolean();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabInteger with a version " + n + " does not exists");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeInt(this.getPrec().swigValue());
        objectOutput.writeObject(this.getCorrectData());
        objectOutput.writeObject(this.varName);
        objectOutput.writeBoolean(this.swaped);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isEmpty()) {
            return "[]";
        }
        if (this.isUnsigned()) {
            stringBuilder.append("u");
        }
        stringBuilder.append("int");
        switch (this.getPrec()) {
            case sci_int8: 
            case sci_uint8: {
                stringBuilder.append("8");
                break;
            }
            case sci_int16: 
            case sci_uint16: {
                stringBuilder.append("16");
                break;
            }
            case sci_int32: 
            case sci_uint32: {
                stringBuilder.append("32");
                break;
            }
            case sci_int64: 
            case sci_uint64: {
                stringBuilder.append("64");
                break;
            }
        }
        stringBuilder.append("([");
        this.appendData(stringBuilder);
        stringBuilder.append("])");
        return stringBuilder.toString();
    }

    private void appendData(StringBuilder stringBuilder) {
        long[][] lArray = this.getData();
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                stringBuilder.append(lArray[i][j]);
                if (j == this.getWidth() - 1) continue;
                stringBuilder.append(", ");
            }
            if (i == this.getHeight() - 1) continue;
            stringBuilder.append(" ; ");
        }
    }
}

