/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.types.ScilabTypeEnum;
import org.scilab.modules.types.ScilabTypeUtils;

public class ScilabDouble
implements ScilabType {
    private static final long serialVersionUID = 879624048944109684L;
    private static final int VERSION = 0;
    protected double[][] realPart;
    protected double[][] imaginaryPart;
    protected String varName;
    protected boolean swaped;
    protected transient boolean byref;

    public ScilabDouble() {
        this.realPart = new double[0][];
        this.imaginaryPart = new double[0][];
    }

    public ScilabDouble(double d) {
        this.realPart = new double[1][1];
        this.realPart[0][0] = d;
        this.imaginaryPart = new double[0][];
    }

    public ScilabDouble(double d, double d2) {
        this.realPart = new double[1][1];
        this.realPart[0][0] = d;
        this.imaginaryPart = new double[1][1];
        this.imaginaryPart[0][0] = d2;
    }

    public ScilabDouble(double[][] dArray) {
        this(dArray, new double[0][]);
    }

    public ScilabDouble(double[][] dArray, double[][] dArray2) {
        if (dArray == null) {
            this.realPart = new double[0][];
            this.imaginaryPart = new double[0][];
        } else {
            this.realPart = dArray;
            this.imaginaryPart = dArray2 == null ? (Object)new double[0][] : dArray2;
        }
    }

    public ScilabDouble(String string, double[][] dArray, double[][] dArray2, boolean bl) {
        this(dArray, dArray2);
        this.varName = string;
        this.swaped = bl;
    }

    @Override
    public ScilabTypeEnum getType() {
        return ScilabTypeEnum.sci_matrix;
    }

    @Override
    public boolean isEmpty() {
        return this.realPart == null || this.realPart.length == 0;
    }

    @Override
    public boolean isReference() {
        return this.byref;
    }

    public boolean isReal() {
        return this.imaginaryPart == null || this.imaginaryPart.length == 0;
    }

    public double[][] getRealPart() {
        return this.realPart;
    }

    public void setRealPart(double[][] dArray) {
        this.realPart = dArray;
    }

    public double[][] getImaginaryPart() {
        return this.imaginaryPart;
    }

    public void setImaginaryPart(double[][] dArray) {
        this.imaginaryPart = dArray;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public boolean isSwaped() {
        return this.swaped;
    }

    public double getRealElement(int n, int n2) {
        return this.realPart[n][n2];
    }

    public double getImaginaryElement(int n, int n2) {
        return this.imaginaryPart[n][n2];
    }

    public double[] getElement(int n, int n2) {
        return new double[]{this.getRealElement(n, n2), this.getImaginaryElement(n, n2)};
    }

    public void setRealElement(int n, int n2, double d) {
        this.realPart[n][n2] = d;
    }

    public void setImaginaryElement(int n, int n2, double d) {
        this.imaginaryPart[n][n2] = d;
    }

    public void setElement(int n, int n2, double d, double d2) {
        this.realPart[n][n2] = d;
        this.imaginaryPart[n][n2] = d2;
    }

    public Object getRawRealPart() {
        return this.realPart;
    }

    public Object getRawImaginaryPart() {
        return this.imaginaryPart;
    }

    public double[] getSerializedComplexMatrix() {
        int n = this.getHeight() * this.getWidth();
        double[] dArray = new double[n * 2];
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                dArray[j * this.getHeight() + i] = this.getRealElement(i, j);
                dArray[n + j * this.getHeight() + i] = this.getImaginaryElement(i, j);
            }
        }
        return dArray;
    }

    @Override
    public Object getSerializedObject() {
        if (this.isReal()) {
            return new Object[]{this.getRealPart()};
        }
        return new Object[]{this.getRealPart(), this.getImaginaryPart()};
    }

    @Override
    public int getHeight() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.realPart.length;
    }

    @Override
    public int getWidth() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.realPart[0].length;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.deepHashCode((Object[])this.imaginaryPart);
        n = 31 * n + Arrays.deepHashCode((Object[])this.realPart);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScilabDouble) {
            ScilabDouble scilabDouble = (ScilabDouble)object;
            if (this.isEmpty() && scilabDouble.isEmpty()) {
                return true;
            }
            if (this.getWidth() != scilabDouble.getWidth() || this.getHeight() != scilabDouble.getHeight()) {
                return false;
            }
            if (this.isReal() && scilabDouble.isReal()) {
                return ScilabTypeUtils.equalsDouble(this.getRawRealPart(), this.isSwaped(), scilabDouble.getRawRealPart(), scilabDouble.isSwaped());
            }
            if (!this.isReal() && !scilabDouble.isReal()) {
                return ScilabTypeUtils.equalsDouble(this.getRawRealPart(), this.isSwaped(), scilabDouble.getRawRealPart(), scilabDouble.isSwaped()) && ScilabTypeUtils.equalsDouble(this.getRawImaginaryPart(), this.isSwaped(), scilabDouble.getRawImaginaryPart(), scilabDouble.isSwaped());
            }
        }
        return false;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        switch (n) {
            case 0: {
                this.realPart = (double[][])objectInput.readObject();
                this.imaginaryPart = (double[][])objectInput.readObject();
                this.varName = (String)objectInput.readObject();
                this.swaped = objectInput.readBoolean();
                break;
            }
            default: {
                throw new ClassNotFoundException("A class ScilabDouble with a version " + n + " does not exists");
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeObject(this.getRealPart());
        objectOutput.writeObject(this.getImaginaryPart());
        objectOutput.writeObject(this.varName);
        objectOutput.writeBoolean(this.swaped);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isEmpty()) {
            return "[]";
        }
        stringBuilder.append("[");
        boolean bl = this.isReal();
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                double d;
                stringBuilder.append(Double.toString(this.getRealElement(i, j)));
                if (!bl && (d = this.getImaginaryElement(i, j)) != 0.0) {
                    if (d > 0.0) {
                        stringBuilder.append(" + ");
                    }
                    stringBuilder.append(Double.toString(d));
                    stringBuilder.append(" * %i");
                }
                if (j == this.getWidth() - 1) continue;
                stringBuilder.append(", ");
            }
            if (i == this.getHeight() - 1) continue;
            stringBuilder.append(" ; ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

