/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console;

import com.artenum.rosetta.interfaces.ui.InputCommandView;
import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.interfaces.ui.PromptView;
import com.artenum.rosetta.ui.ConsoleTextPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.scilab.modules.commons.gui.ScilabCaret;
import org.scilab.modules.console.SciConsole;
import org.scilab.modules.console.SciDropTargetListener;
import org.scilab.modules.console.SciOutputView;
import org.scilab.modules.console.utils.ScilabLaTeXViewer;

public class SciInputCommandView
extends ConsoleTextPane
implements InputCommandView,
CaretListener,
ViewFactory {
    private static final long serialVersionUID = 1L;
    private static final String END_LINE = "\n";
    private static final Point ERROR_POINT = new Point(0, 0);
    private static final int TOP_BORDER = 1;
    private static final int BOTTOM_BORDER = 2;
    private static final Pattern latexPattern = Pattern.compile("['\"]\\$[^\\\\\\$'\"]*(?:(?:[\\\\].?|['\"]{2})[^\\\\\\$'\"]*)*");
    private static BlockingQueue<String> queue = new LinkedBlockingQueue<String>();
    private static BlockingQueue<Boolean> displayQueue = new LinkedBlockingQueue<Boolean>();
    private Thread concurrentThread = null;
    private SciConsole console;
    private int height = -1;
    private int width = -1;
    private boolean isLatex;
    private List<KeyStroke> keysForHistory;

    public SciInputCommandView() {
        this.setEditorKit(new StyledEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return SciInputCommandView.this;
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(1, 0, 2, 0));
        this.setEditable(false);
        ScilabCaret scilabCaret = new ScilabCaret((JTextComponent)((Object)this)){

            public void mousePressed(MouseEvent mouseEvent) {
                ((SciOutputView)SciInputCommandView.this.console.getConfiguration().getOutputView()).removeSelection();
                super.mousePressed(mouseEvent);
            }
        };
        scilabCaret.setBlinkRate(this.getCaret().getBlinkRate());
        this.setCaret((Caret)scilabCaret);
        this.addCaretListener(this);
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container container, Component component) {
                return SciInputCommandView.this;
            }
        });
        this.setFocusCycleRoot(true);
    }

    public Point getCaretLocation() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String[] stringArray = null;
        try {
            stringArray = this.getStyledDocument().getText(0, this.getCaretPosition()).split(END_LINE);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return ERROR_POINT;
        }
        Point point = new Point(fontMetrics.stringWidth(stringArray[stringArray.length - 1]), stringArray.length * fontMetrics.getHeight());
        Object object = this;
        while (object != null) {
            point.translate(((Component)object).getLocation().x, ((Component)object).getLocation().y);
            if (!((object = ((Component)object).getParent()) instanceof JPanel)) continue;
            return point;
        }
        return point;
    }

    public void removeSelection() {
        if (this.getSelectionStart() != this.getSelectionEnd()) {
            this.setSelectionStart(this.getSelectionEnd());
        }
    }

    public String getCmdBuffer() {
        String string = null;
        try {
            if (this.concurrentThread == null) {
                this.concurrentThread = Thread.currentThread();
            } else {
                this.concurrentThread.interrupt();
            }
            string = queue.take();
            if (displayQueue.take().booleanValue()) {
                OutputView outputView = this.console.getConfiguration().getOutputView();
                PromptView promptView = this.console.getConfiguration().getPromptView();
                outputView.append(END_LINE + promptView.getDefaultPrompt() + string + END_LINE);
            }
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
        this.concurrentThread = null;
        return string;
    }

    public final void interrupt() {
        if (this.concurrentThread != null) {
            this.concurrentThread.interrupt();
        }
    }

    public void setCmdBuffer(String string, boolean bl) {
        try {
            queue.put(string);
            displayQueue.put(bl);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void setConsole(SciConsole sciConsole) {
        this.console = sciConsole;
        this.setDropTarget(new DropTarget((Component)((Object)this), 3, new SciDropTargetListener(this.console)));
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                final String string = SciInputCommandView.this.console.getConfiguration().getInputParsingManager().getCommandLine();
                if (documentEvent.getLength() > 1 && string.lastIndexOf(SciInputCommandView.END_LINE) == string.length() - 1) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SciInputCommandView.this.console.sendCommandsToScilab(string, true, true);
                        }
                    });
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (SciInputCommandView.this.keysForHistory == null) {
                    SciInputCommandView.this.getKeysForHistory();
                }
                if (keyEvent.getKeyChar() != '\uffff' && keyEvent.getKeyCode() != 37 && keyEvent.getKeyCode() != 39 && !SciInputCommandView.this.keysForHistory.contains(KeyStroke.getKeyStrokeForEvent(keyEvent)) && SciInputCommandView.this.console.getConfiguration().getHistoryManager().isInHistory()) {
                    SciInputCommandView.this.console.getConfiguration().getHistoryManager().setInHistory(false);
                }
                if (keyEvent.getKeyLocation() == 4 && keyEvent.getKeyCode() == 127 && keyEvent.getKeyChar() != '\u007f') {
                    keyEvent.setKeyCode(110);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        Matcher matcher;
        ((SciOutputView)this.console.getConfiguration().getOutputView()).removeSelection();
        String string = this.getText().substring(0, caretEvent.getDot());
        int n = string.lastIndexOf("\"$");
        if (n != -1) {
            string = string.substring(n);
        }
        if ((matcher = latexPattern.matcher(string)).find() && matcher.end() == string.length()) {
            String string2 = matcher.group().replace("''", "'").replace("\"\"", "\"");
            string2 = string2.substring(2, string2.length());
            int n2 = ScilabLaTeXViewer.displayExpression((JTextComponent)((Object)this), Integer.MAX_VALUE, string2, n, caretEvent.getDot()) + 2;
            int n3 = 0;
            try {
                Rectangle rectangle = this.modelToView(this.getCaretPosition());
                n3 = rectangle.height + rectangle.y + 1;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            int n4 = this.height;
            this.height = n3 + n2;
            if (this.height != n4) {
                this.validate();
                this.console.updateScrollPosition();
            }
            this.isLatex = true;
        } else if (this.isLatex) {
            ScilabLaTeXViewer.removeLaTeXViewer((JTextComponent)((Object)this));
            if (this.height != -1) {
                this.height = -1;
                this.validate();
            }
            this.isLatex = false;
        }
    }

    public int getCaretHeight() {
        return ((ScilabCaret)this.getCaret()).height;
    }

    public void setPreferredHeight(int n) {
        this.height = n;
    }

    public void setPreferredWidth(int n) {
        this.width = n;
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        try {
            dimension = super.getPreferredSize();
        }
        catch (Exception exception) {
            dimension = new Dimension(0, 0);
        }
        if (this.height != -1) {
            dimension.height = Math.max(this.height, dimension.height);
        }
        if (this.width != -1) {
            dimension.width = Math.max(this.width, dimension.width);
        }
        return dimension;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setCaretColor(color);
        this.repaint();
    }

    @Override
    public View create(Element element) {
        return new PlainView(element){

            @Override
            public Container getContainer() {
                return SciInputCommandView.this;
            }
        };
    }

    private void getKeysForHistory() {
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap();
        KeyStroke[] keyStrokeArray = inputMap.keys();
        this.keysForHistory = new ArrayList<KeyStroke>();
        for (KeyStroke keyStroke : keyStrokeArray) {
            Object object = inputMap.get(keyStroke);
            if (!object.equals("PREVIOUS_HISTORY_LINE") && !object.equals("NEXT_HISTORY_LINE")) continue;
            this.keysForHistory.add(keyStroke);
        }
    }
}

