/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.console;

import java.awt.Color;
import java.awt.Font;
import org.scilab.modules.commons.ScilabGeneralPrefs;
import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.console.ConsoleConfiguration;
import org.w3c.dom.Document;

public class ConsoleOptions {
    public static final String COLORSPATH = "//colors/body/desktop-colors";
    public static final String CONSOLEFONTPATH = "//fonts/body/fonts/item[@xconf-uid=\"console-font\"]";
    public static final String FONTPATH = "//fonts/body/fonts";
    public static final String LATEXPATH = "//fonts/body/fonts";
    public static final String DISPLAYPATH = "//console/body/display";
    public static final String KEYMAPPATH = "//general/shortcuts/body/actions/action-folder[@xconf-uid=\"console\"]/action";
    private static ConsoleColor color;
    private static ConsoleFont font;
    private static LaTeXFont latex;
    private static ConsoleDisplay display;
    private static Document doc;

    public static void invalidate(ConsoleConfiguration.Conf conf) {
        if (conf.font) {
            font = null;
            doc = null;
        }
        if (conf.color) {
            color = null;
            doc = null;
        }
        if (conf.display) {
            display = null;
            doc = null;
        }
        if (conf.latex) {
            latex = null;
            doc = null;
        }
    }

    public static final ConsoleDisplay getConsoleDisplay() {
        if (display == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            display = ((ConsoleDisplay[])XConfiguration.get(ConsoleDisplay.class, (Document)doc, (String)DISPLAYPATH))[0];
        }
        return display;
    }

    public static final ConsoleFont getConsoleFont() {
        if (font == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            font = ((ConsoleFont[])XConfiguration.get(ConsoleFont.class, (Document)doc, (String)CONSOLEFONTPATH))[0];
        }
        return font;
    }

    public static final LaTeXFont getLaTeXFont() {
        if (latex == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            latex = ((LaTeXFont[])XConfiguration.get(LaTeXFont.class, (Document)doc, (String)"//fonts/body/fonts"))[0];
        }
        return latex;
    }

    public static final ConsoleColor getConsoleColor() {
        if (color == null) {
            if (doc == null) {
                doc = XConfiguration.getXConfigurationDocument();
            }
            color = ((ConsoleColor[])XConfiguration.get(ConsoleColor.class, (Document)doc, (String)COLORSPATH))[0];
        }
        return color;
    }

    @XConfiguration.XConfAttribute
    public static class LaTeXFont {
        public int size;

        private LaTeXFont() {
        }

        @XConfiguration.XConfAttribute(tag="fonts", attributes={"latex"})
        private void set(double d) {
            this.size = (int)d;
        }
    }

    @XConfiguration.XConfAttribute
    public static class ConsoleFont {
        public Font font;

        private ConsoleFont() {
        }

        @XConfiguration.XConfAttribute(tag="item", attributes={"font-face", "font-name", "font-size", "desktop"})
        private void set(String string, String string2, int n, boolean bl) {
            if (bl) {
                this.font = ScilabGeneralPrefs.getDesktopFont();
            } else {
                this.font = new Font(string2, 0, n);
                int n2 = 0;
                if (string.contains("bold")) {
                    n2 |= 1;
                } else if (string.contains("italic")) {
                    n2 |= 2;
                }
                if (n2 != 0) {
                    this.font = this.font.deriveFont(n2);
                }
            }
        }
    }

    @XConfiguration.XConfAttribute
    public static class ConsoleColor {
        public Color background;
        public Color cursor;
        public Color foreground;

        private ConsoleColor() {
        }

        @XConfiguration.XConfAttribute(tag="desktop-colors", attributes={"background", "cursor", "text", "use-system-color"})
        private void set(Color color, Color color2, Color color3, boolean bl) {
            if (bl) {
                this.background = Color.WHITE;
                this.cursor = Color.BLACK;
                this.foreground = Color.BLACK;
            } else {
                this.background = color;
                this.cursor = color2;
                this.foreground = color3;
            }
        }
    }

    @XConfiguration.XConfAttribute
    public static class ConsoleDisplay {
        public int maxOutputLines;
        public int nbLines;
        public int nbColumns;
        public boolean adaptToDisplay;
        public boolean wrapLines;

        private ConsoleDisplay() {
        }

        @XConfiguration.XConfAttribute(tag="display", attributes={"scroll-size", "lines-to-display", "columns-to-display", "adapt-to-display", "wrap-lines"})
        private void set(int n, int n2, int n3, boolean bl, boolean bl2) {
            this.maxOutputLines = n;
            this.nbLines = n2;
            this.nbColumns = n3;
            this.adaptToDisplay = bl;
            this.wrapLines = bl2;
        }
    }
}

