/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.scilab;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.scilab.modules.helptools.scilab.HTMLWithStyleScilabCodeHandler;

public final class ScilabCodeServer {
    private static final int DEFAULTMAXHANDLERS = 5;
    private Stack<HTMLWithStyleScilabCodeHandler> stack = new Stack();
    private String prim;
    private String macro;
    private int maxHandler;

    public static void main(String[] stringArray) {
        Map<String, String> map = ScilabCodeServer.parseCommandLine(stringArray);
        if (map.containsKey("help")) {
            System.out.println("Usage scicodeserver [OPTION]...");
            System.out.println("Create a multi-thread server to colorize Scilab code");
            System.out.println("");
            System.out.println("-port          An integer giving the port where to listen to");
            System.out.println("-sciprim       A file containing the list of the Scilab primitives");
            System.out.println("-scimacro      A file containing the list of the Scilab macros");
            System.out.println("-maxhandlers   An integer giving the maximum of Scilab code handlers");
            System.out.println("               which must be kept in memory (5 by default)");
            System.out.println("");
            System.out.println("Report bugs on: <http://bugzilla.scilab.org>");
            System.out.println("Project page: <http://forge.scilab.org/index.php/p/scidoc>");
            return;
        }
        if (!map.containsKey("port")) {
            System.err.println("No port");
            System.err.println("Use the option -help");
            return;
        }
        int n = 5;
        if (map.containsKey("maxhandlers")) {
            try {
                n = Integer.parseInt(map.get("maxhandlers"));
            }
            catch (Exception exception) {
                System.err.println("The option -maxhandlers expects a positive integer");
                return;
            }
        }
        int n2 = 0;
        if (map.containsKey("port")) {
            try {
                n2 = Integer.parseInt(map.get("port"));
            }
            catch (Exception exception) {
                System.err.println("The option -port expects a positive integer");
                return;
            }
        }
        ScilabCodeServer scilabCodeServer = new ScilabCodeServer(map.get("sciprim"), map.get("scimacro"), n);
        try {
            ServerSocket serverSocket = new ServerSocket(n2);
            while (true) {
                new ScilabCodeThread(serverSocket.accept(), scilabCodeServer);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private ScilabCodeServer(String string, String string2, int n) {
        this.prim = string;
        this.macro = string2;
        this.maxHandler = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTMLWithStyleScilabCodeHandler getHandler() {
        Stack<HTMLWithStyleScilabCodeHandler> stack = this.stack;
        synchronized (stack) {
            if (this.stack.isEmpty()) {
                return new HTMLWithStyleScilabCodeHandler(this.prim, this.macro);
            }
            return this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushHandler(HTMLWithStyleScilabCodeHandler hTMLWithStyleScilabCodeHandler) {
        Stack<HTMLWithStyleScilabCodeHandler> stack = this.stack;
        synchronized (stack) {
            if (this.stack.size() < this.maxHandler) {
                this.stack.push(hTMLWithStyleScilabCodeHandler);
            }
        }
    }

    private void convert(Reader reader, Writer writer) throws IOException {
        HTMLWithStyleScilabCodeHandler hTMLWithStyleScilabCodeHandler = this.getHandler();
        hTMLWithStyleScilabCodeHandler.convert(reader, writer);
        this.pushHandler(hTMLWithStyleScilabCodeHandler);
    }

    private static Map<String, String> parseCommandLine(String[] stringArray) {
        String string = null;
        boolean bl = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() >= 2 && stringArray[i].charAt(0) == '-') {
                if (string != null) {
                    hashMap.put(string, "");
                    string = null;
                    string = stringArray[i];
                }
                if (stringArray[i].charAt(1) == '-') {
                    string = stringArray[i].substring(2);
                    continue;
                }
                string = stringArray[i].substring(1);
                continue;
            }
            if (string != null) {
                hashMap.put(string, stringArray[i]);
                string = null;
                continue;
            }
            if (!bl) {
                hashMap.put("input", stringArray[i]);
                bl = true;
                continue;
            }
            System.err.println("Not an argument " + stringArray[i]);
            return null;
        }
        if (string != null) {
            hashMap.put(string, "");
        }
        return hashMap;
    }

    private static class ScilabCodeThread
    implements Runnable {
        private Reader in;
        private Writer out;
        private Socket sock;
        private ScilabCodeServer scs;

        ScilabCodeThread(Socket socket, ScilabCodeServer scilabCodeServer) {
            this.sock = socket;
            this.scs = scilabCodeServer;
            try {
                this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.out = new OutputStreamWriter(socket.getOutputStream(), Charset.forName("UTF-8"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            new Thread(this).start();
        }

        @Override
        public void run() {
            try {
                this.scs.convert(this.in, this.out);
                this.out.flush();
                this.out.close();
                this.in.close();
                this.sock.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

