/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.scilab;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.scilab.modules.helptools.scilab.AbstractScilabCodeHandler;

public class HTMLScilabCodeHandler
extends AbstractScilabCodeHandler {
    private static final int BUFCAPACITY = 8192;
    private static HTMLScilabCodeHandler handler = new HTMLScilabCodeHandler();
    private static AbstractScilabCodeHandler.LinkWriter linkWriter = new AbstractScilabCodeHandler.LinkWriter();
    private List<String> undoc = new ArrayList<String>();
    protected String currentCommand;
    protected String currentFileName;
    protected Appendable buffer = new StringBuilder(8192);

    protected HTMLScilabCodeHandler() {
    }

    public static void setLinkWriter(AbstractScilabCodeHandler.LinkWriter linkWriter) {
        HTMLScilabCodeHandler.linkWriter = linkWriter;
    }

    public static AbstractScilabCodeHandler getInstance(String string, String string2) {
        HTMLScilabCodeHandler.handler.currentCommand = string;
        HTMLScilabCodeHandler.handler.currentFileName = string2;
        ((StringBuilder)HTMLScilabCodeHandler.handler.buffer).setLength(0);
        return handler;
    }

    @Override
    public void handleDefault(String string) throws IOException {
        this.buffer.append("<span class=\"scilabdefault\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleOperator(String string) throws IOException {
        this.buffer.append("<span class=\"scilaboperator\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleOpenClose(String string) throws IOException {
        this.buffer.append("<span class=\"scilabopenclose\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleFKeywords(String string) throws IOException {
        this.buffer.append("<span class=\"scilabfkeyword\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleSKeywords(String string) throws IOException {
        this.buffer.append("<span class=\"scilabskeyword\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleCKeywords(String string) throws IOException {
        this.buffer.append("<span class=\"scilabckeyword\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleConstants(String string) throws IOException {
        this.buffer.append("<span class=\"scilabconstants\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleCommand(String string) throws IOException {
        if (string.equals(this.currentCommand)) {
            this.buffer.append("<span class=\"scilabcommand\">");
            this.buffer.append(string);
            this.buffer.append("</span>");
        } else {
            String string2 = linkWriter.getLink(string);
            if (string2 == null) {
                this.buffer.append("<span class=\"scilabcommand\">");
                this.buffer.append(string);
                this.buffer.append("</span>");
                System.err.println("Warning: the command " + string + " is used in an example and is undocumented (" + new File(this.currentFileName).getName() + ").");
                this.undoc.add(string);
            } else {
                this.buffer.append("<a class=\"scilabcommand\" href=\"");
                this.buffer.append(string2);
                this.buffer.append("\">");
                this.buffer.append(string);
                this.buffer.append("</a>");
            }
        }
    }

    @Override
    public void handleMacro(String string) throws IOException {
        if (string.equals(this.currentCommand)) {
            this.buffer.append("<span class=\"scilabmacro\">");
            this.buffer.append(string);
            this.buffer.append("</span>");
        } else {
            String string2 = linkWriter.getLink(string);
            if (string2 == null) {
                this.buffer.append("<span class=\"scilabmacro\">");
                this.buffer.append(string);
                this.buffer.append("</span>");
                System.err.println("Warning: the macro " + string + " is used in an example and is undocumented (" + new File(this.currentFileName).getName() + ").");
                this.undoc.add(string);
            } else {
                this.buffer.append("<a class=\"scilabmacro\" href=\"");
                this.buffer.append(string2);
                this.buffer.append("\">");
                this.buffer.append(string);
                this.buffer.append("</a>");
            }
        }
    }

    @Override
    public void handleFunctionId(String string) throws IOException {
        this.buffer.append("<span class=\"scilabfunctionid\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleFunctionIdDecl(String string) throws IOException {
        this.buffer.append("<span class=\"scilabfunctionid\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleId(String string) throws IOException {
        this.buffer.append("<span class=\"scilabid\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleInputOutputArgs(String string) throws IOException {
        this.buffer.append("<span class=\"scilabinputoutputargs\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleInputOutputArgsDecl(String string) throws IOException {
        this.buffer.append("<span class=\"scilabinputoutputargs\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleNumber(String string) throws IOException {
        this.buffer.append("<span class=\"scilabnumber\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleSpecial(String string) throws IOException {
        this.buffer.append("<span class=\"scilabspecial\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleString(String string) throws IOException {
        this.buffer.append("<span class=\"scilabstring\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleNothing(String string) throws IOException {
        this.buffer.append(string);
    }

    @Override
    public void handleField(String string) throws IOException {
        this.buffer.append("<span class=\"scilabfield\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleComment(String string) throws IOException {
        this.buffer.append("<span class=\"scilabcomment\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    public String toString() {
        return this.buffer.toString();
    }
}

