/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.image;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.scilab.modules.helptools.DocbookTagConverter;
import org.scilab.modules.helptools.image.ExternalImageConverter;

public class XcosImageConverter
implements ExternalImageConverter {
    private final DocbookTagConverter conv;

    public XcosImageConverter(DocbookTagConverter docbookTagConverter) {
        this.conv = docbookTagConverter;
    }

    @Override
    public String getMimeType() {
        return "image/scilab-xcos";
    }

    @Override
    public boolean mustRegenerate() {
        return false;
    }

    @Override
    public String convertToImage(String string, String string2, Map<String, String> map, File file, String string3) {
        return this.conv.getImageConverter().getScilabImageConverter().convertToImage(string, string2, map, file, string3);
    }

    @Override
    public String convertToImage(File file, Map<String, String> map, File file2, String string) {
        try {
            String string2 = file.getName();
            return this.convertToPNG(string2, file.getAbsolutePath(), map, file2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.printf("Problem when exporting Xcos schema %s !\n%s\n", file, exception.toString());
            return null;
        }
    }

    private final String convertToPNG(String string, String string2, Map<String, String> map, File file, String string3) throws Exception {
        Class<?> clazz = Class.forName("org.scilab.modules.xcos.utils.XcosDelegates");
        Method method = clazz.getDeclaredMethod("convertToPNG", String.class, String.class, File.class, String.class);
        try {
            method.invoke(null, string, string2, file, string3);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getCause().printStackTrace();
        }
        return this.conv.generateImageCode(string2, this.conv.getBaseImagePath() + string3, map);
    }
}

