/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.image;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.scilab.modules.commons.ScilabCommons;
import org.scilab.modules.helptools.DocbookTagConverter;
import org.scilab.modules.helptools.image.ExternalImageConverter;

public class ScilabImageConverter
implements ExternalImageConverter {
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    private final StringBuilder buffer = new StringBuilder(8192);
    private final DocbookTagConverter conv;

    public ScilabImageConverter(DocbookTagConverter docbookTagConverter) {
        this.conv = docbookTagConverter;
    }

    @Override
    public String getMimeType() {
        return "image/scilab";
    }

    @Override
    public boolean mustRegenerate() {
        return false;
    }

    public String getFileWithScilabCode() {
        if (this.buffer.length() != 0) {
            try {
                File file = File.createTempFile("help-", ".sce", new File(ScilabCommons.getTMPDIR()));
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                fileOutputStream.write(BOM);
                bufferedWriter.write(this.buffer.toString());
                ((Writer)bufferedWriter).flush();
                ((Writer)bufferedWriter).close();
                fileOutputStream.close();
                return file.getAbsolutePath();
            }
            catch (Exception exception) {
                System.err.println("Cannot generate the file with Scilab code to execute:\n" + exception);
            }
        }
        return null;
    }

    @Override
    public String convertToImage(String string, String string2, Map<String, String> map, File file, String string3) {
        return this.convertToPNG(string, string2, map, file, string3);
    }

    @Override
    public String convertToImage(File file, Map<String, String> map, File file2, String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder(8192);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            bufferedReader.close();
            return this.convertToPNG(file.getName(), stringBuilder.toString(), map, file2, string);
        }
        catch (Exception exception) {
            System.err.println("Problem when exporting Scilab code to " + file2 + "!\n" + exception.toString());
            return null;
        }
    }

    private final String convertToPNG(String string, String string2, Map<String, String> map, File file, String string3) {
        this.buffer.append("function _generate_image_from_doc\n");
        this.buffer.append("__olddrv__=driver();\n");
        this.buffer.append("mprintf(\"Generate image " + string3 + " from Scilab code from file " + new File(string).getName() + "\\n\");");
        this.buffer.append("driver(\"png\");\n");
        this.buffer.append("xinit(\"").append(file.getAbsolutePath()).append("\");\n");
        this.buffer.append("clf();\n");
        this.buffer.append(string2).append("\n");
        this.buffer.append("___f___=gcf();___f___.anti_aliasing=\"2x\";clear(\"___f___\");\n");
        this.buffer.append("xend();\n");
        this.buffer.append("driver(__olddrv__);\n");
        this.buffer.append("endfunction\n");
        this.buffer.append("_generate_image_from_doc();\n");
        this.buffer.append("clear _generate_image_from_doc;\n");
        return this.conv.generateImageCode(string2, this.conv.getBaseImagePath() + string3, map);
    }
}

