/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.image;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.helptools.DocbookTagConverter;
import org.scilab.modules.helptools.image.ExternalImageConverter;
import org.scilab.modules.helptools.image.ScilabImageConverter;

public final class ImageConverter {
    private static final String MD5_FILE = "images_md5.txt";
    private DocbookTagConverter conv;
    private Map<String, ExternalImageConverter> externalConverters = new HashMap<String, ExternalImageConverter>();
    private MimetypesFileTypeMap mimeMap = new MimetypesFileTypeMap();
    private Map<String, String> md5s = null;

    public ImageConverter() {
        this.mimeMap.addMimeTypes("type=image/latex exts=tex,latex");
        this.mimeMap.addMimeTypes("type=image/mathml exts=mml,mathml");
        this.mimeMap.addMimeTypes("type=image/svg exts=svg");
        this.mimeMap.addMimeTypes("type=image/scilab exts=sce");
        this.mimeMap.addMimeTypes("type=image/scilab-xcos exts=xcos,zcos");
    }

    public void setDocbookTagConverter(DocbookTagConverter docbookTagConverter) {
        this.conv = docbookTagConverter;
    }

    public void registerExternalImageConverter(ExternalImageConverter externalImageConverter) {
        if (externalImageConverter != null) {
            this.externalConverters.put(externalImageConverter.getMimeType(), externalImageConverter);
        }
    }

    public ScilabImageConverter getScilabImageConverter() {
        return (ScilabImageConverter)this.externalConverters.get("image/scilab");
    }

    public void loadMD5s(String string) {
        this.md5s = ImageConverter.getMD5s(string);
    }

    public void saveMD5s(String string) {
        ImageConverter.writeMD5s(string, this.md5s);
    }

    public boolean compareMD5(String string, String string2) {
        if (this.md5s != null && string != null && string2 != null && !string2.isEmpty()) {
            string = string.trim().replaceAll("[ \t]*[\n]+[ \t]*", "");
            String string3 = ScilabCommonsUtils.getMD5((String)string);
            String string4 = this.md5s.get(string2);
            if (string4 != null && string3.equals(string4)) {
                return true;
            }
            this.md5s.put(string2, string3);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getMD5s(String string) {
        File file = new File(string + File.separator + MD5_FILE);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (file.exists() && file.canRead()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    String[] stringArray = string2.split("=");
                    hashMap.put(stringArray[0], stringArray[1]);
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeMD5s(String string, Map<String, String> map) {
        File file = new File(string + File.separator + MD5_FILE);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                return;
            }
        }
        if (file.canWrite()) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                TreeMap<String, String> treeMap = new TreeMap<String, String>(map);
                for (Map.Entry entry : treeMap.entrySet()) {
                    String string2 = (String)entry.getKey() + "=" + (String)entry.getValue();
                    bufferedWriter.write(string2, 0, string2.length());
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public String getImageByFile(Map<String, String> map, String string, String string2, String string3, String string4, String string5) {
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(string + File.separator + string2);
        }
        String string6 = string3 + File.separator + string4 + File.separator + file.getName();
        ExternalImageConverter externalImageConverter = this.externalConverters.get(this.mimeMap.getContentType(file));
        if (externalImageConverter != null) {
            string6 = string6 + ".png";
        }
        File file2 = new File(string6);
        String string7 = string4 + "/" + file2.getName();
        if (file.lastModified() > file2.lastModified()) {
            if (externalImageConverter != null) {
                return externalImageConverter.convertToImage(file, map, file2, string7);
            }
            ImageConverter.copyImageFile(file, string3 + File.separator + string4);
        }
        return this.conv.generateImageCode(this.conv.getBaseImagePath() + string7, map);
    }

    public String getImageByCode(String string, String string2, Map<String, String> map, String string3, File file, String string4, String string5, int n, String string6, Boolean bl) {
        ExternalImageConverter externalImageConverter = this.externalConverters.get(string3);
        if (externalImageConverter == null) {
            System.err.println("In file " + string + " at line " + n + ": invalid code:\n" + string2);
            return null;
        }
        if (!file.exists() && this.md5s != null) {
            this.md5s.remove(file.getName());
        }
        File file2 = new File(string);
        if (!(!string6.equals("en_US") && file.exists() && bl == null || this.compareMD5(string2, file.getName()))) {
            if (bl != null && bl.booleanValue() || string6.equals("en_US")) {
                System.err.println("Info: Create image " + file.getName() + " from line " + n + " in " + file2.getName());
            } else if (!string6.equals("en_US") && file.exists()) {
                System.err.println("Warning: Overwrite image " + file.getName() + " from line " + n + " in " + file2.getName() + ". Check the code or use scilab:localized=\"true\" attribute.");
            }
            return externalImageConverter.convertToImage(string, string2, map, file, string4);
        }
        return this.conv.generateImageCode(this.conv.getBaseImagePath() + string4, map);
    }

    public static File imageExists(String string, String string2) {
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(string + File.separator + string2);
        }
        if (file.exists()) {
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyImageFile(File file, String string) {
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
        try {
            File file2 = new File(string + File.separator + file.getName());
            if (!file2.exists()) {
                file2.createNewFile();
            } else if (file.lastModified() <= file2.lastModified()) {
                return;
            }
            abstractInterruptibleChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel2 = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel2).transferFrom((ReadableByteChannel)((Object)abstractInterruptibleChannel), 0L, ((FileChannel)abstractInterruptibleChannel).size());
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        finally {
            try {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                if (abstractInterruptibleChannel2 != null) {
                    abstractInterruptibleChannel2.close();
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }

    public static boolean convertIconToPNG(Icon icon, File file) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file.getAbsoluteFile());
        }
        catch (IOException iOException) {
            return false;
        }
        graphics2D.dispose();
        return true;
    }
}

