/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.external;

import java.io.File;
import java.util.HashMap;
import org.scilab.modules.helptools.HTMLDocbookTagConverter;
import org.scilab.modules.helptools.external.ExternalXMLHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class HTMLMathMLHandler
extends ExternalXMLHandler {
    private static final String MATH = "math";
    private static final String BASENAME = "_MathML_";
    private StringBuilder buffer = new StringBuilder(8192);
    private String baseDir;
    private String outputDir;
    private Boolean isLocalized;
    private int line;

    public HTMLMathMLHandler(String string, String string2) {
        this.outputDir = string + File.separator + string2;
        this.baseDir = string2 + "/";
    }

    @Override
    public String getURI() {
        return "http://www.w3.org/1998/Math/MathML";
    }

    @Override
    public StringBuilder startExternalXML(String string, Attributes attributes, Locator locator) {
        if (MATH.equals(string)) {
            this.isLocalized = HTMLMathMLHandler.getLocalized(this.getScilabURI(), attributes);
            this.line = locator.getLineNumber();
        }
        this.recreateTag(this.buffer, string, attributes);
        if (MATH.equals(string)) {
            return this.buffer;
        }
        return null;
    }

    @Override
    public String endExternalXML(String string) {
        if (MATH.equals(string)) {
            File file;
            this.recreateTag(this.buffer, string, null);
            String string2 = ((HTMLDocbookTagConverter)this.getConverter()).getLanguage();
            if (this.isLocalized != null && this.isLocalized.booleanValue()) {
                file = new File(this.outputDir, BASENAME + this.getConverter().getCurrentBaseName() + "_" + string2 + "_" + this.compt++ + ".png");
            } else {
                if ("ru_RU".equals(string2) && HTMLDocbookTagConverter.containsCyrillic(this.buffer)) {
                    System.err.println("Warning: MathML code in " + this.getConverter().getCurrentFileName() + " at line " + this.line + " contains cyrillic character. The tag <math> should contain the attribute scilab:localized=\"true\"");
                } else if ("ja_JP".equals(string2) && HTMLDocbookTagConverter.containsCJK(this.buffer)) {
                    System.err.println("Warning: MathML code in " + this.getConverter().getCurrentFileName() + " at line " + this.line + " contains CJK character. The tag <math> should contain the attribute scilab:localized=\"true\"");
                }
                file = new File(this.outputDir, BASENAME + this.getConverter().getCurrentBaseName() + "_" + this.compt++ + ".png");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("fontsize", "16");
            String string3 = "";
            if (this.getConverter() instanceof HTMLDocbookTagConverter) {
                string3 = ((HTMLDocbookTagConverter)this.getConverter()).getBaseImagePath();
            }
            String string4 = this.getConverter().getImageConverter().getImageByCode(this.getConverter().getCurrentFileName(), this.buffer.toString(), hashMap, "image/mathml", file, this.baseDir + file.getName(), string3, this.line, string2, this.isLocalized);
            this.buffer.setLength(0);
            return string4;
        }
        this.recreateTag(this.buffer, string, null);
        return null;
    }
}

