/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.File;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.helptools.CHMDocbookTagConverter;
import org.scilab.modules.helptools.Converter;
import org.scilab.modules.helptools.FODocbookTagConverter;
import org.scilab.modules.helptools.FopConverter;
import org.scilab.modules.helptools.HTMLDocbookTagConverter;
import org.scilab.modules.helptools.JarOnlyConverter;
import org.scilab.modules.helptools.JavaHelpDocbookTagConverter;
import org.scilab.modules.helptools.SciDocConfiguration;
import org.scilab.modules.helptools.image.ImageConverter;
import org.xml.sax.SAXException;

public final class SciDocMain {
    private String outputDirectory;
    private String language;
    private Converter.Backend format;
    private String imagedir = ".";
    private SciDocConfiguration conf = new SciDocConfiguration();
    private boolean isToolbox;

    public boolean setOutputDirectory(String string) {
        File file = new File(string);
        if (!file.isDirectory() && !file.mkdirs()) {
            return false;
        }
        this.outputDirectory = new File(string).getAbsolutePath();
        return true;
    }

    public void setWorkingLanguage(String string) {
        this.language = string;
    }

    public void setIsToolbox(boolean bl) {
        this.isToolbox = bl;
    }

    public void setExportFormat(String string) {
        String string2 = string.toUpperCase().replace('-', '_');
        try {
            this.format = Enum.valueOf(Converter.Backend.class, string2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Converter.Backend[] backendArray = Converter.Backend.values();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append((Object)backendArray[0]);
            for (int i = 1; i < backendArray.length; ++i) {
                stringBuilder.append(',').append(' ');
                stringBuilder.append(backendArray[i].toString().toLowerCase());
            }
            stringBuilder.append(']');
            System.err.printf("%s is not a supported format : one of %s expected.\n", string.toString(), stringBuilder);
            return;
        }
    }

    public String process(String string, String string2) throws Throwable {
        String string3 = null;
        if (!new File(string).isFile()) {
            System.err.println("Could not find master document: " + string);
            return null;
        }
        try {
            Converter converter = null;
            ImageConverter imageConverter = new ImageConverter();
            switch (this.format) {
                case JAVAHELP: {
                    if (!this.isToolbox) {
                        imageConverter.loadMD5s(ScilabConstants.SCI.getPath() + "/modules/helptools/etc");
                    }
                    converter = new JavaHelpDocbookTagConverter(string, this, imageConverter);
                    break;
                }
                case HTML: {
                    converter = new HTMLDocbookTagConverter(string, this, imageConverter);
                    break;
                }
                case WEB: {
                    if (!this.isToolbox) {
                        imageConverter.loadMD5s(ScilabConstants.SCI.getPath() + "/modules/helptools/etc");
                    }
                    converter = new HTMLDocbookTagConverter(string, this, imageConverter);
                    break;
                }
                case CHM: {
                    if (!this.isToolbox) {
                        imageConverter.loadMD5s(ScilabConstants.SCI.getPath() + "/modules/helptools/etc");
                    }
                    converter = new CHMDocbookTagConverter(string, this, imageConverter);
                    break;
                }
                case FO: {
                    converter = new FODocbookTagConverter(string, this, imageConverter);
                    break;
                }
                case JAR_ONLY: {
                    converter = new JarOnlyConverter(this);
                    break;
                }
                case PDF: 
                case PS: {
                    converter = new FopConverter(this);
                    break;
                }
                default: {
                    System.err.printf("%s is not a supported format.\n", new Object[]{this.format});
                    return null;
                }
            }
            converter.registerAllExternalXMLHandlers();
            converter.convert();
            converter.install();
            if (imageConverter.getScilabImageConverter() != null) {
                string3 = imageConverter.getScilabImageConverter().getFileWithScilabCode();
            }
        }
        catch (SAXException sAXException) {
            System.err.println("XML parsing error while generating documentation for file " + string + ":");
            System.err.println(sAXException.toString());
        }
        catch (Throwable throwable) {
            System.err.println("Unhandled error while generating documentation for file " + string + ":");
            throwable.printStackTrace();
            throw throwable;
        }
        return string3;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getLanguage() {
        return this.language;
    }

    public Converter.Backend getFormat() {
        return this.format;
    }

    public String getImagedir() {
        return this.imagedir;
    }

    public SciDocConfiguration getConf() {
        return this.conf;
    }

    public boolean isToolbox() {
        return this.isToolbox;
    }
}

