/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.xml.ScilabDocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SciDocConfiguration {
    private static final String SCIVAR = "\\$\\{SCI\\}";
    private static final String SCI = ScilabConstants.SCI.getPath();
    private static final String CONF = SCI + "/modules/helptools/etc/SciDocConf.xml";
    private static final String VERSION = SCI + "/Version.incl";
    private static final String ERROR_READ = "Problem to read the file ";
    private Document doc;

    public SciDocConfiguration() {
        this.readDocument(CONF);
    }

    public void readDocument(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = ScilabDocumentBuilderFactory.newInstance();
            this.doc = documentBuilderFactory.newDocumentBuilder().parse(new File(string));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(ERROR_READ + string);
        }
        catch (SAXException sAXException) {
            System.err.println(ERROR_READ + string);
        }
        catch (IOException iOException) {
            System.err.println(ERROR_READ + string);
        }
    }

    public String getCSS() {
        String string = ((Element)this.doc.getDocumentElement().getElementsByTagName("css").item(0)).getAttribute("doc");
        return string.replaceAll(SCIVAR, Matcher.quoteReplacement(SCI));
    }

    public String getTemplate(String string) {
        String string2 = ((Element)this.doc.getDocumentElement().getElementsByTagName("templates").item(0)).getAttribute(string);
        return string2.replaceAll(SCIVAR, Matcher.quoteReplacement(SCI));
    }

    public String getWebSiteURL() {
        return ((Element)this.doc.getDocumentElement().getElementsByTagName("website").item(0)).getAttribute("url");
    }

    public String[] getMacros() {
        return this.getPathList("macros");
    }

    public String[] getBuiltins() {
        return this.getPathList("builtins");
    }

    private String[] getPathList(String string) {
        Element element = (Element)this.doc.getDocumentElement().getElementsByTagName(string).item(0);
        NodeList nodeList = element.getElementsByTagName("file");
        String[] stringArray = new String[nodeList.getLength()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((Element)nodeList.item(i)).getAttribute("path").replaceAll(SCIVAR, Matcher.quoteReplacement(SCI));
        }
        return stringArray;
    }

    public String getVersion() {
        Element element;
        String string = null;
        NodeList nodeList = this.doc.getDocumentElement().getElementsByTagName("version");
        if (nodeList != null && nodeList.getLength() > 0 && (element = (Element)nodeList.item(0)) != null) {
            string = element.getAttribute("id");
        }
        return SciDocConfiguration.getVersion(string);
    }

    private static String getVersion(String string) {
        String string2 = "";
        if (string == null || string.isEmpty()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(VERSION));
                string2 = bufferedReader.readLine().split("=")[1];
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        } else {
            string2 = string;
        }
        return string2;
    }
}

