/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import com.sun.java.help.search.Indexer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.helptools.ContainerConverter;
import org.scilab.modules.helptools.Helpers;
import org.scilab.modules.helptools.SciDocMain;

public class JarOnlyConverter
extends ContainerConverter {
    private static final String SCI = ScilabConstants.SCI.getPath();
    private static final String JAVAHELPSEARCH_DIR = "/JavaHelpSearch/";
    private static final String COULD_NOT_FIND = "buildDoc: Could not find/access to ";
    private static final String LEFT_PAR = " ( ";
    private static final String RIGHT_PAR = " )";
    private static final String JAR_EXT = ".jar";
    private static final String SLASH = "/";
    private static final int JAR_COMPRESSION_LEVEL = 9;
    private static Indexer indexer = new Indexer();
    private final boolean isToolbox;
    private final String outImages;

    public JarOnlyConverter(SciDocMain sciDocMain) {
        super(sciDocMain.getOutputDirectory(), sciDocMain.getLanguage());
        File file;
        this.isToolbox = sciDocMain.isToolbox();
        String string = sciDocMain.getOutputDirectory() + File.separator;
        if (!this.isToolbox && !(file = new File(string = ScilabConstants.SCI.getPath() + "/modules/helptools/images")).exists()) {
            file.mkdir();
        }
        this.outImages = string;
    }

    @Override
    public void convert() {
        String string = new String(this.outputDirectory + JAVAHELPSEARCH_DIR);
        try {
            Helpers.deleteDirectory(string);
            File file = new File(string);
            file.mkdirs();
            String string2 = new File(string).getAbsolutePath();
            String[] stringArray = new String[]{"-db", string2, "-nostopwords", "."};
            indexer.compile(stringArray);
        }
        catch (Exception exception) {
            System.err.println("buildDoc: Error building search index: " + exception.getLocalizedMessage());
            return;
        }
        JarOnlyConverter.buildJar(this.outputDirectory, this.language);
    }

    @Override
    public void install() {
        if (this.isToolbox) {
            return;
        }
        JarOutputStream jarOutputStream = null;
        FileOutputStream fileOutputStream = null;
        String string = SCI + "/modules/helptools/jar" + SLASH + "scilab_images" + JAR_EXT;
        try {
            fileOutputStream = new FileOutputStream(string);
            jarOutputStream = new JarOutputStream(fileOutputStream);
            jarOutputStream.setLevel(9);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(COULD_NOT_FIND + string + LEFT_PAR + fileNotFoundException.getLocalizedMessage() + RIGHT_PAR);
        }
        catch (IOException iOException) {
            System.err.println(COULD_NOT_FIND + string + LEFT_PAR + iOException.getLocalizedMessage() + RIGHT_PAR);
        }
        File[] fileArray = new File(this.outImages).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                File file = fileArray[i];
                FileInputStream fileInputStream = new FileInputStream(file);
                int n = (int)file.length();
                byte[] byArray = new byte[n];
                try {
                    fileInputStream.read(byArray, 0, n);
                }
                catch (IOException iOException) {
                    System.err.println(COULD_NOT_FIND + file + LEFT_PAR + iOException.getLocalizedMessage() + RIGHT_PAR);
                }
                ZipEntry zipEntry = new ZipEntry(file.getName());
                jarOutputStream.putNextEntry(zipEntry);
                jarOutputStream.write(byArray, 0, n);
                fileInputStream.close();
                continue;
            }
            catch (IOException iOException) {
                System.err.println("buildDoc: An error occurs while building the JavaHelp ( " + iOException.getLocalizedMessage() + RIGHT_PAR);
            }
        }
        try {
            jarOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("buildDoc: An error occurs while closing the JavaHelp ( " + iOException.getLocalizedMessage() + RIGHT_PAR);
        }
    }

    private static ArrayList<File> buildFileList(File file, String string) {
        final String string2 = Helpers.getBaseName(string) + JAR_EXT;
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return !string.equals(string2);
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                arrayList.addAll(JarOnlyConverter.buildFileList(fileArray[i], string));
                continue;
            }
            arrayList.add(fileArray[i]);
        }
        return arrayList;
    }

    static boolean buildJar(String string, String string2) {
        String string3 = Helpers.getBaseName(string2);
        JarOutputStream jarOutputStream = null;
        FileOutputStream fileOutputStream = null;
        String string4 = string + SLASH + string3 + JAR_EXT;
        ArrayList<File> arrayList = JarOnlyConverter.buildFileList(new File(string), string2);
        try {
            fileOutputStream = new FileOutputStream(string4);
            jarOutputStream = new JarOutputStream(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(COULD_NOT_FIND + string4 + LEFT_PAR + fileNotFoundException.getLocalizedMessage() + RIGHT_PAR);
        }
        catch (IOException iOException) {
            System.err.println(COULD_NOT_FIND + string4 + LEFT_PAR + iOException.getLocalizedMessage() + RIGHT_PAR);
        }
        jarOutputStream.setLevel(9);
        File[] fileArray = arrayList.toArray(new File[arrayList.size()]);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                File file = fileArray[i];
                FileInputStream fileInputStream = new FileInputStream(file);
                int n = (int)file.length();
                byte[] byArray = new byte[n];
                try {
                    fileInputStream.read(byArray, 0, n);
                }
                catch (IOException iOException) {
                    System.err.println(COULD_NOT_FIND + file + LEFT_PAR + iOException.getLocalizedMessage() + RIGHT_PAR);
                }
                String string5 = null;
                string5 = file.getPath().indexOf("JavaHelpSearch") == -1 ? string3 + SLASH + file.getName() : string3 + JAVAHELPSEARCH_DIR + file.getName();
                ZipEntry zipEntry = new ZipEntry(string5);
                jarOutputStream.putNextEntry(zipEntry);
                jarOutputStream.write(byArray, 0, n);
                fileInputStream.close();
                continue;
            }
            catch (IOException iOException) {
                System.err.println("buildDoc: An error occurs while building the JavaHelp ( " + iOException.getLocalizedMessage() + RIGHT_PAR);
            }
        }
        try {
            jarOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("buildDoc: An error occurs while closing the JavaHelp ( " + iOException.getLocalizedMessage() + RIGHT_PAR);
        }
        return true;
    }
}

