/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.helptools.Converter;
import org.scilab.modules.helptools.DocbookElement;
import org.scilab.modules.helptools.DocbookTagConverter;
import org.scilab.modules.helptools.HTMLDocbookLinkResolver;
import org.scilab.modules.helptools.SciDocMain;
import org.scilab.modules.helptools.SynopsisLexer;
import org.scilab.modules.helptools.TemplateFiller;
import org.scilab.modules.helptools.TemplateHandler;
import org.scilab.modules.helptools.XML.HTMLXMLCodeHandler;
import org.scilab.modules.helptools.XML.XMLLexer;
import org.scilab.modules.helptools.c.CLexer;
import org.scilab.modules.helptools.c.HTMLCCodeHandler;
import org.scilab.modules.helptools.external.HTMLMathMLHandler;
import org.scilab.modules.helptools.external.HTMLSVGHandler;
import org.scilab.modules.helptools.external.HTMLScilabHandler;
import org.scilab.modules.helptools.image.Image;
import org.scilab.modules.helptools.image.ImageConverter;
import org.scilab.modules.helptools.java.JavaLexer;
import org.scilab.modules.helptools.scilab.AbstractScilabCodeHandler;
import org.scilab.modules.helptools.scilab.HTMLScilabCodeHandler;
import org.scilab.modules.helptools.scilab.ScilabLexer;
import org.scilab.modules.localization.Messages;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HTMLDocbookTagConverter
extends DocbookTagConverter
implements TemplateFiller {
    private static final String SCILAB_URI = "http://www.scilab.org";
    private static final String LATEXBASENAME = "_LaTeX_";
    private static final String VERSION = Messages.gettext((String)"Version");
    private static final String DESCRIPTION = Messages.gettext((String)"Description");
    private final StringBuilder buffer = new StringBuilder(8192);
    private int latexCompt = 1;
    private boolean hasExamples;
    private int warnings;
    private int nbFiles;
    private final String imageDir;
    protected String urlBase;
    protected boolean linkToTheWeb;
    protected final String outName;
    protected String outImages;
    protected final Map<String, String> mapId;
    protected final Map<String, String> tocitem;
    protected final HTMLDocbookLinkResolver.TreeId tree;
    protected final Map<String, HTMLDocbookLinkResolver.TreeId> mapTreeId;
    protected final Map<String, String> mapIdPurpose;
    protected final Map<String, String> mapIdRefname;
    protected final TemplateHandler templateHandler;
    protected final ScilabLexer scilabLexer;
    protected final XMLLexer xmlLexer;
    protected final CLexer cLexer;
    protected final JavaLexer javaLexer;
    protected String bookTitle = "";
    protected String partTitle = "";
    protected String chapterTitle = "";
    protected String sectionTitle = "";
    protected String fileSubtitle = "";
    protected String refpurpose = "";
    protected String refname = "";
    protected String version;
    protected String appendToProgramListing;
    protected String appendForExecToProgramListing;
    protected String prependToProgramListing;
    protected String currentId;
    protected String indexFilename = "index.html";
    protected final String language;
    protected final boolean isToolbox;
    protected final Converter.Backend type;

    public HTMLDocbookTagConverter(String string, SciDocMain sciDocMain, ImageConverter imageConverter) throws IOException, SAXException {
        super(string, imageConverter);
        this.version = sciDocMain.getConf().getVersion();
        this.imageDir = sciDocMain.getImagedir();
        this.outImages = this.outName = sciDocMain.getOutputDirectory() + File.separator;
        imageConverter.setDocbookTagConverter(this);
        HTMLDocbookLinkResolver hTMLDocbookLinkResolver = new HTMLDocbookLinkResolver(string);
        this.mapId = hTMLDocbookLinkResolver.getMapId();
        this.tocitem = hTMLDocbookLinkResolver.getToc();
        this.tree = hTMLDocbookLinkResolver.getTree();
        this.mapTreeId = hTMLDocbookLinkResolver.getMapTreeId();
        this.mapIdPurpose = hTMLDocbookLinkResolver.getMapIdPurpose();
        this.mapIdRefname = hTMLDocbookLinkResolver.getMapIdRefname();
        this.isToolbox = sciDocMain.isToolbox();
        this.language = sciDocMain.getLanguage();
        this.type = sciDocMain.getFormat();
        if (this.isToolbox) {
            this.urlBase = sciDocMain.getConf().getWebSiteURL() + this.language + "/";
            this.linkToTheWeb = true;
        } else {
            this.urlBase = null;
            this.linkToTheWeb = false;
        }
        if (this.isToolbox) {
            HTMLScilabCodeHandler.setLinkWriter(new AbstractScilabCodeHandler.LinkWriter(){

                @Override
                public String getLink(String string) {
                    String string2;
                    if (string.length() > 0 && string.charAt(0) == '%') {
                        string = string.replace("%", "percent");
                    }
                    if ((string2 = HTMLDocbookTagConverter.this.mapId.get(string)) == null) {
                        return HTMLDocbookTagConverter.this.urlBase + string;
                    }
                    return string2;
                }
            });
        } else {
            HTMLScilabCodeHandler.setLinkWriter(new AbstractScilabCodeHandler.LinkWriter(){

                @Override
                public String getLink(String string) {
                    if (string.length() > 0 && string.charAt(0) == '%') {
                        string = string.replace("%", "percent");
                    }
                    return HTMLDocbookTagConverter.this.mapId.get(string);
                }
            });
        }
        this.scilabLexer = new ScilabLexer(sciDocMain.getConf().getBuiltins(), sciDocMain.getConf().getMacros());
        this.xmlLexer = new XMLLexer();
        this.cLexer = new CLexer();
        this.javaLexer = new JavaLexer();
        String string2 = sciDocMain.getConf().getTemplate(sciDocMain.getFormat().toString().toLowerCase());
        File file = new File(string2);
        if (!file.isFile()) {
            String string3 = "Could not find template document: " + string2;
            System.err.println(string3);
            throw new RuntimeException();
        }
        this.templateHandler = new TemplateHandler(this, file, this.language);
    }

    public static boolean containsCJK(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(charSequence.charAt(i));
            if (unicodeBlock != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS && unicodeBlock != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A && unicodeBlock != Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B && unicodeBlock != Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS && unicodeBlock != Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS && unicodeBlock != Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT && unicodeBlock != Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION && unicodeBlock != Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCyrillic(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(charSequence.charAt(i));
            if (unicodeBlock != Character.UnicodeBlock.CYRILLIC && unicodeBlock != Character.UnicodeBlock.CYRILLIC_SUPPLEMENTARY) continue;
            return true;
        }
        return false;
    }

    public static final String replaceEntity(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&#0060;").replaceAll(">", "&#0062;").replaceAll("\"", "&#0034;").replaceAll("'", "&#0039;");
    }

    public final Converter.Backend getGenerationType() {
        return this.type;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public void registerAllExternalXMLHandlers() {
        super.registerAllExternalXMLHandlers();
        this.registerExternalXMLHandler(new HTMLMathMLHandler(this.outImages, this.imageDir));
        this.registerExternalXMLHandler(new HTMLSVGHandler(this.outImages, this.imageDir));
        this.registerExternalXMLHandler(new HTMLScilabHandler(this.outImages, this.imageDir));
    }

    @Override
    public void install() {
        super.install();
        ScilabCommonsUtils.copyFile((File)new File(SCI + "/modules/helptools/data/css/scilab_code.css"), (File)new File(this.outName + "/scilab_code.css"));
        ScilabCommonsUtils.copyFile((File)new File(SCI + "/modules/helptools/data/css/xml_code.css"), (File)new File(this.outName + "/xml_code.css"));
        ScilabCommonsUtils.copyFile((File)new File(SCI + "/modules/helptools/data/css/c_code.css"), (File)new File(this.outName + "/c_code.css"));
        ScilabCommonsUtils.copyFile((File)new File(SCI + "/modules/helptools/data/css/style.css"), (File)new File(this.outName + "/style.css"));
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public String encloseContents(String string, String string2) {
        this.buffer.setLength(0);
        this.buffer.append("<");
        this.buffer.append(string);
        this.buffer.append(">");
        if (string2 != null) {
            this.buffer.append(string2);
        }
        this.buffer.append("</");
        this.buffer.append(string);
        this.buffer.append(">");
        return this.buffer.toString();
    }

    public String encloseContents(String string, String[] stringArray, String string2) {
        this.buffer.setLength(0);
        this.buffer.append("<");
        this.buffer.append(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                if (stringArray[i + 1] == null || stringArray[i + 1].isEmpty()) continue;
                this.buffer.append(" ");
                this.buffer.append(stringArray[i]);
                this.buffer.append("=\"");
                this.buffer.append(stringArray[i + 1]);
                this.buffer.append("\"");
            }
        }
        this.buffer.append(">");
        if (string2 != null) {
            this.buffer.append(string2);
        }
        this.buffer.append("</");
        this.buffer.append(string);
        this.buffer.append(">");
        return this.buffer.toString();
    }

    public String encloseContents(String string, String string2, String string3) {
        this.buffer.setLength(0);
        this.buffer.append("<");
        this.buffer.append(string);
        this.buffer.append(" class=\"");
        this.buffer.append(string2);
        this.buffer.append("\">");
        if (string3 != null) {
            this.buffer.append(string3);
        }
        this.buffer.append("</");
        this.buffer.append(string);
        this.buffer.append(">");
        return this.buffer.toString();
    }

    @Override
    public boolean isEscapable(String string, String string2) {
        return !"latex".equals(string) && !"screen".equals(string) && !"programlisting".equals(string) && !"code".equals(string) && !"synopsis".equals(string) && (!string2.equals(SCILAB_URI) || !string.equals("image"));
    }

    @Override
    public boolean isTrimable(String string) {
        return !"screen".equals(string) && !"programlisting".equals(string) && !"code".equals(string) && !"synopsis".equals(string);
    }

    public void createHTMLFile(String string, String string2, String string3, String string4) {
        if (!this.hasError) {
            this.fileSubtitle = string3;
            ++this.nbFiles;
            this.templateHandler.generateFileFromTemplate(this.outName + string2, string, string4);
        }
    }

    public String generateCode(Image image, String string, Map<String, String> map, String string2) {
        boolean bl;
        String string3 = map.get("style");
        String string4 = "";
        boolean bl2 = bl = string3 != null && string3.equals("display");
        if (!bl) {
            string4 = "top:" + image.descent + "px;";
        }
        String string5 = map.get("align");
        String string6 = "";
        String string7 = "div";
        if (string5 != null) {
            string6 = " style='text-align:" + string5 + "'";
        } else if (bl) {
            string6 = " style='text-align:center'";
        } else {
            string7 = "span";
        }
        return "<" + string7 + string6 + "><img src='" + string + "' style='position:relative;" + string4 + "width:" + image.width + "px;height:" + image.height + "px'/></" + string7 + ">";
    }

    @Override
    public String makeTitle(String string) {
        if (this.refname.length() > 0) {
            return this.tocitem.get(string);
        }
        return "";
    }

    @Override
    public String makeSubtitle(String string) {
        return this.fileSubtitle;
    }

    @Override
    public String makePrevious(String string) {
        this.buffer.setLength(0);
        this.buffer.append("<span class=\"previous\">");
        HTMLDocbookLinkResolver.TreeId treeId = this.mapTreeId.get(string);
        if (treeId == null) {
            return "";
        }
        HTMLDocbookLinkResolver.TreeId treeId2 = treeId.getPrevious();
        if (treeId2.parent != null) {
            this.buffer.append("<a href=\"");
            this.buffer.append(this.mapId.get(treeId2.id));
            this.buffer.append("\">&lt;&lt; ");
            this.buffer.append(this.tocitem.get(treeId2.id));
            this.buffer.append("</a></span>\n");
            return this.buffer.toString();
        }
        return "";
    }

    @Override
    public String makePath(String string) {
        this.buffer.setLength(0);
        this.buffer.append("<span class=\"path\" dir=\"ltr\">");
        HTMLDocbookLinkResolver.TreeId treeId = this.mapTreeId.get(string);
        if (treeId == null) {
            return "";
        }
        String string2 = this.tocitem.get(string);
        treeId = treeId.parent;
        while (treeId != null && !treeId.isRoot()) {
            string2 = "<a href=\"" + this.mapId.get(treeId.id) + "\">" + this.tocitem.get(treeId.id) + "</a> &gt; " + string2;
            treeId = treeId.parent;
        }
        string2 = "<a href=\"" + this.indexFilename + "\">" + this.bookTitle + "</a> &gt;&gt; " + string2;
        this.buffer.append(string2);
        this.buffer.append("</span>\n");
        return this.buffer.toString();
    }

    @Override
    public String makeTop(String string) {
        this.buffer.setLength(0);
        this.buffer.append("<span class=\"top\">");
        HTMLDocbookLinkResolver.TreeId treeId = this.mapTreeId.get(string);
        if (treeId == null) {
            return "";
        }
        treeId = treeId.parent;
        if (treeId != null) {
            this.buffer.append("<a href=\"");
            if (!treeId.isRoot()) {
                this.buffer.append(this.mapId.get(treeId.id));
                this.buffer.append("\">");
                this.buffer.append(this.tocitem.get(treeId.id));
            } else {
                this.buffer.append(this.indexFilename);
                this.buffer.append("\">");
                this.buffer.append(this.bookTitle);
            }
        } else {
            return "";
        }
        this.buffer.append("</a></span>\n");
        return this.buffer.toString();
    }

    @Override
    public String makeNext(String string) {
        this.buffer.setLength(0);
        this.buffer.append("<span class=\"next\">");
        HTMLDocbookLinkResolver.TreeId treeId = this.mapTreeId.get(string);
        if (treeId == null) {
            return "";
        }
        HTMLDocbookLinkResolver.TreeId treeId2 = treeId.getNext();
        if (treeId2 != null) {
            this.buffer.append("<a href=\"");
            this.buffer.append(this.mapId.get(treeId2.id));
            this.buffer.append("\">");
            this.buffer.append(this.tocitem.get(treeId2.id));
            this.buffer.append(" &gt;&gt;</a></span>\n");
            return this.buffer.toString();
        }
        return "";
    }

    @Override
    public String makeStart(String string) {
        this.buffer.setLength(0);
        this.buffer.append("<span class=\"start\">");
        this.buffer.append("<a href=\"");
        this.buffer.append(this.indexFilename);
        this.buffer.append("\">");
        this.buffer.append(this.bookTitle);
        this.buffer.append("</a></span>\n");
        return this.buffer.toString();
    }

    @Override
    public String makeTocList(String string) {
        this.buffer.setLength(0);
        HTMLDocbookLinkResolver.TreeId treeId = this.mapTreeId.get(string);
        if (treeId == null) {
            return "";
        }
        HTMLDocbookLinkResolver.TreeId treeId2 = treeId.parent;
        this.buffer.append("<ul class=\"toc\">\n");
        String string2 = "";
        while (treeId2 != null && !treeId2.isRoot()) {
            string2 = "<li class=\"parent\"><a href=\"" + this.mapId.get(treeId2.id) + "\">" + this.tocitem.get(treeId2.id) + "</a></li>\n" + string2;
            treeId2 = treeId2.parent;
        }
        this.buffer.append("<li class=\"root\"><a href=\"");
        this.buffer.append(this.indexFilename);
        this.buffer.append("\">");
        this.buffer.append(this.bookTitle);
        this.buffer.append("</a></li>\n");
        this.buffer.append(string2);
        treeId2 = treeId.parent;
        for (HTMLDocbookLinkResolver.TreeId treeId3 : treeId2.children) {
            if (treeId3 == treeId) {
                this.buffer.append("<li class=\"list-active\"><a href=\"");
            } else {
                this.buffer.append("<li><a href=\"");
            }
            this.buffer.append(this.mapId.get(treeId3.id));
            this.buffer.append("\">");
            this.buffer.append(this.tocitem.get(treeId3.id));
            this.buffer.append("</a></li>\n");
        }
        this.buffer.append("</ul>\n");
        return this.buffer.toString();
    }

    @Override
    public String makeLastModified(String string) {
        this.buffer.setLength(0);
        try {
            this.buffer.append("<span class=\"lastmodified\">");
            this.buffer.append(new Date(new File(new URI(this.currentFileName)).lastModified()).toString());
            this.buffer.append("</span>\n");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return this.buffer.toString();
    }

    @Override
    public String makeGenerationDate(String string) {
        this.buffer.setLength(0);
        this.buffer.append("<span class=\"generationdate\">");
        this.buffer.append(new Date(System.currentTimeMillis()).toString());
        this.buffer.append("</span>\n");
        return this.buffer.toString();
    }

    @Override
    public String makeVersion(String string) {
        this.buffer.setLength(0);
        this.buffer.append("<span class=\"version\">");
        this.buffer.append(this.version);
        this.buffer.append("</span>\n");
        return this.buffer.toString();
    }

    private boolean isLinkedImage() {
        Stack<DocbookElement> stack = this.getStack();
        return stack.size() >= 3 && ((DocbookElement)stack.get(stack.size() - 3)).getName().equals("link");
    }

    @Override
    public String generateImageCode(String string, String string2, Map<String, String> map) {
        String string3 = map.get("align");
        boolean bl = this.getGenerationType() != Converter.Backend.JAVAHELP || !this.isLinkedImage();
        StringBuilder stringBuilder = new StringBuilder(128);
        if (bl && string3 != null) {
            stringBuilder.append("<div style='text-align:").append(string3).append("'>");
        }
        stringBuilder.append("<img src='").append(string2).append("'/>");
        if (bl && string3 != null) {
            stringBuilder.append("</div>");
        }
        if (this.getGenerationType() == Converter.Backend.WEB) {
            string = HTMLDocbookTagConverter.convertCode(string);
            return "<div rel='tooltip' title='" + string + "'>" + stringBuilder.toString() + "</div>";
        }
        return stringBuilder.toString();
    }

    @Override
    public String generateImageCode(Image image, String string, Map<String, String> map) {
        boolean bl;
        String string2 = map.get("style");
        String string3 = "";
        boolean bl2 = bl = string2 != null && string2.equals("display");
        if (!bl) {
            string3 = "top:" + image.descent + "px;";
        }
        String string4 = map.get("align");
        String string5 = "";
        String string6 = "div";
        if (string4 != null) {
            string5 = " style='text-align:" + string4 + "'";
        } else if (bl) {
            string5 = " style='text-align:center'";
        } else {
            string6 = "span";
        }
        String string7 = map.get("alt");
        string7 = string7 == null ? "" : " alt='" + string7 + "'";
        if (this.getGenerationType() == Converter.Backend.JAVAHELP && this.isLinkedImage()) {
            return "<img src='" + string + "' style='position:relative;" + string3 + "width:" + image.width + "px;height:" + image.height + "px'" + string7 + "/>>";
        }
        return "<" + string6 + string5 + "><img src='" + string + "' style='position:relative;" + string3 + "width:" + image.width + "px;height:" + image.height + "px'" + string7 + "/></" + string6 + ">";
    }

    @Override
    public String generateImageCode(String string, Map<String, String> map) {
        String string2 = map.get("id");
        String string3 = map.get("align");
        String string4 = map.get("width");
        String string5 = map.get("height");
        String string6 = map.get("style");
        String string7 = map.get("alt");
        boolean bl = this.getGenerationType() != Converter.Backend.JAVAHELP || !this.isLinkedImage();
        StringBuilder stringBuilder = new StringBuilder(128);
        if (bl && string3 != null) {
            stringBuilder.append("<div style='text-align:").append(string3).append("'>\n");
        }
        stringBuilder.append("<img src='").append(string).append("' ");
        if (!bl && string3 != null) {
            stringBuilder.append("align='").append(string3).append("' ");
        }
        if (string2 != null) {
            stringBuilder.append("id='").append(string2).append("' ");
        }
        if (string4 != null) {
            stringBuilder.append("width='").append(string4).append("' ");
        } else if (string5 != null) {
            stringBuilder.append("height='").append(string5).append("' ");
        }
        if (string6 != null) {
            stringBuilder.append("style='").append(string6).append("' ");
        }
        if (string7 != null) {
            string7 = string7.replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
            stringBuilder.append("alt='").append(string7).append("'");
        }
        stringBuilder.append("/>\n");
        if (bl && string3 != null) {
            stringBuilder.append("</div>\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        this.latexCompt = 1;
        return super.resolveEntity(string, string2);
    }

    @Override
    public String handleRefentry(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            this.currentId = string2;
        }
        String string3 = this.mapId.get(this.currentId);
        String string4 = map.get("needs-examples");
        this.createHTMLFile(this.currentId, string3, this.refpurpose, string);
        if (!(this.hasExamples || string4 != null && string4.equals("no"))) {
            ++this.warnings;
        } else {
            this.hasExamples = false;
        }
        String string5 = this.encloseContents("span", "refentry-description", this.refpurpose);
        String string6 = this.encloseContents("li", this.encloseContents("a", new String[]{"href", string3, "class", "refentry"}, this.refname) + " &#8212; " + string5);
        this.refpurpose = "";
        this.refname = "";
        this.currentId = null;
        return string6;
    }

    @Override
    public String handleSection(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id") + ".html";
        String string3 = this.encloseContents("ul", "list-refentry", string);
        String string4 = this.encloseContents("h3", "title-section", this.sectionTitle);
        this.createHTMLFile(map.get("id"), string2, this.sectionTitle, string4 + "\n" + string3);
        string3 = this.encloseContents("li", this.encloseContents("a", new String[]{"href", string2, "class", "section"}, this.sectionTitle) + "\n" + string3);
        this.sectionTitle = "";
        return string3;
    }

    @Override
    public String handleBook(Map<String, String> map, String string) throws SAXException {
        String string2 = this.encloseContents("ul", "list-part", string);
        String string3 = this.bookTitle.trim().equalsIgnoreCase("Scilab") ? this.version : this.bookTitle;
        String string4 = this.encloseContents("h3", "book-title", string3);
        this.createHTMLFile("index", this.indexFilename, string3, string4 + "\n" + string2);
        if (this.warnings != 0) {
            System.err.println("Total files without example: " + this.warnings);
            System.err.println("Total generated html files: " + this.nbFiles);
        }
        return this.encloseContents("li", this.encloseContents("a", new String[]{"href", this.indexFilename, "class", "part"}, this.bookTitle) + "\n" + string2);
    }

    @Override
    public String handlePart(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id") + ".html";
        String string3 = this.encloseContents("ul", "list-chapter", string);
        String string4 = this.encloseContents("h3", "title-part", this.partTitle);
        this.createHTMLFile(map.get("id"), string2, this.partTitle, string4 + "\n" + string3);
        string3 = this.encloseContents("li", this.encloseContents("a", new String[]{"href", string2, "class", "part"}, this.partTitle) + "\n" + string3);
        this.partTitle = "";
        return string3;
    }

    @Override
    public String handleChapter(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id") + ".html";
        String string3 = this.encloseContents("ul", "list-refentry", string);
        String string4 = this.encloseContents("h3", "title-chapter", this.chapterTitle);
        this.createHTMLFile(map.get("id"), string2, this.chapterTitle, string4 + "\n" + string3);
        string3 = this.encloseContents("li", this.encloseContents("a", new String[]{"href", string2, "class", "chapter"}, this.chapterTitle) + "\n" + string3);
        this.chapterTitle = "";
        return string3;
    }

    @Override
    public String handleTitle(Map<String, String> map, String string) throws SAXException {
        String string2 = "title";
        String string3 = this.getParentTagName();
        if (string3.equals("chapter")) {
            this.chapterTitle = string;
        } else if (string3.equals("part")) {
            this.partTitle = string;
        } else if (string3.equals("info")) {
            this.bookTitle = string;
        } else if (string3.equals("section")) {
            this.sectionTitle = string;
        } else {
            if (string3.equals("refsection") && Pattern.matches("^[ \\t]*ex[ea]mpl[eo].*", string.toLowerCase())) {
                this.hasExamples = true;
                return this.encloseContents("h3", string2, string);
            }
            if (string3.equals("refsect1")) {
                return this.encloseContents("h3", string2, string);
            }
            if (string3.equals("refsect2")) {
                return this.encloseContents("h4", string2, string);
            }
            if (string3.equals("refsect3")) {
                return this.encloseContents("h5", string2, string);
            }
            return this.encloseContents("h3", string2, string);
        }
        return null;
    }

    @Override
    public String handlePara(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("p", "para", string);
    }

    @Override
    public String handleLiteral(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("code", new String[]{"class", "literal", "dir", "ltr"}, string);
    }

    @Override
    public String handleLiterallayout(Map<String, String> map, String string) throws SAXException {
        String string2 = string.replace("\n", "<BR>");
        string2 = string2.replace(" ", "&nbsp;");
        return this.encloseContents("code", new String[]{"class", "literallayout", "dir", "ltr"}, string2);
    }

    @Override
    public String handleVarname(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("code", "varname", string);
    }

    @Override
    public String handleCommand(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("code", "command", string);
    }

    @Override
    public String handleCode(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("code", "scilabcode", this.scilabLexer.convert(HTMLScilabCodeHandler.getInstance(this.refname, this.currentFileName), string));
    }

    @Override
    public String handleFunction(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("code", "function", string);
    }

    @Override
    public String handleConstant(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("code", "constant", string);
    }

    @Override
    public String handleOption(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("code", "option", string);
    }

    @Override
    public String handleRefnamediv(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            this.currentId = string2;
        }
        return this.encloseContents("div", "refnamediv", string);
    }

    @Override
    public String handleRefname(Map<String, String> map, String string) throws SAXException {
        this.refname = string;
        return this.encloseContents("h1", "refname", string);
    }

    @Override
    public String handleRefpurpose(Map<String, String> map, String string) throws SAXException {
        this.refpurpose = string;
        return this.encloseContents("p", "refpurpose", string);
    }

    @Override
    public String handleRefsynopsisdiv(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "refsynopsisdiv", string);
        }
        return this.encloseContents("div", "refsynopsisdiv", string);
    }

    @Override
    public String handleSynopsis(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = this.encloseContents("div", "synopsis", this.encloseContents("pre", SynopsisLexer.convert(this.refname, string)));
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + string3;
        }
        return string3;
    }

    @Override
    public String handleInfo(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "info", string);
        }
        return this.encloseContents("div", "info", string);
    }

    @Override
    public String handleRefsection(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "refsection", string);
        }
        return this.encloseContents("div", "refsection", string);
    }

    @Override
    public String handleRefsect1(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "refsect1", string);
        }
        return this.encloseContents("div", "refsect1", string);
    }

    @Override
    public String handleRefsect2(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "refsect2", string);
        }
        return this.encloseContents("div", "refsect2", string);
    }

    @Override
    public String handleRefsect3(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "refsect3", string);
        }
        return this.encloseContents("div", "refsect3", string);
    }

    @Override
    public String handleAnchor(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\">" + string + "</a>";
        }
        return string;
    }

    @Override
    public String handleProgramlisting(Map<String, String> map, String string) throws SAXException {
        String string2;
        String string3 = map.get("id");
        String string4 = map.get("role");
        if (string4 == null) {
            String string5 = this.encloseContents("pre", "scilabcode", this.scilabLexer.convert(HTMLScilabCodeHandler.getInstance(this.refname, this.currentFileName), string));
            if (this.prependToProgramListing != null) {
                string5 = this.prependToProgramListing + string5;
            }
            if (this.appendToProgramListing != null) {
                string5 = string5 + this.appendToProgramListing;
            }
            string2 = this.encloseContents("div", "programlisting", string5);
        } else if (string4.equals("xml")) {
            string2 = this.encloseContents("div", "programlisting", this.encloseContents("pre", "xmlcode", this.xmlLexer.convert(HTMLXMLCodeHandler.getInstance(), string)));
        } else if (string4.equals("c") || string4.equals("cpp") || string4.equals("code_gateway")) {
            this.hasExamples = true;
            string2 = this.encloseContents("div", "programlisting", this.encloseContents("pre", "ccode", this.cLexer.convert(HTMLCCodeHandler.getInstance(), string)));
        } else if (string4.equals("java")) {
            this.hasExamples = true;
            string2 = this.encloseContents("div", "programlisting", this.encloseContents("pre", "ccode", this.javaLexer.convert(HTMLCCodeHandler.getInstance(), string)));
        } else if (string4.equals("exec")) {
            String string6 = this.encloseContents("pre", "scilabcode", this.scilabLexer.convert(HTMLScilabCodeHandler.getInstance(this.refname, this.currentFileName), string));
            if (this.prependToProgramListing != null) {
                string6 = this.prependToProgramListing + string6;
            }
            if (this.appendForExecToProgramListing != null) {
                string6 = string6 + this.appendForExecToProgramListing;
            }
            string2 = this.encloseContents("div", "programlisting", string6);
        } else if (string4.equals("no-scilab-exec")) {
            this.hasExamples = true;
            String string7 = this.encloseContents("pre", "scilabcode", this.scilabLexer.convert(HTMLScilabCodeHandler.getInstance(this.refname, this.currentFileName), string));
            string2 = this.encloseContents("div", "programlisting", string7);
        } else {
            String string8 = this.encloseContents("pre", "scilabcode", this.scilabLexer.convert(HTMLScilabCodeHandler.getInstance(this.refname, this.currentFileName), string));
            if (this.prependToProgramListing != null) {
                string8 = this.prependToProgramListing + string8;
            }
            if (this.appendToProgramListing != null) {
                string8 = string8 + this.appendToProgramListing;
            }
            string2 = this.encloseContents("div", "programlisting", string8);
        }
        if (string3 != null) {
            return "<a name=\"" + string3 + "\"></a>" + string2;
        }
        return string2;
    }

    @Override
    public String handleScreen(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = this.encloseContents("div", "screen", this.encloseContents("pre", string.replace("<", "&lt;")));
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + string3;
        }
        return string3;
    }

    @Override
    public String handlePubdate(Map<String, String> map, String string) throws SAXException {
        return null;
    }

    @Override
    public String handleSimplelist(Map<String, String> map, String string) throws SAXException {
        String string2 = "itemizedlist";
        return this.encloseContents("ul", string2, string);
    }

    @Override
    public String handleMember(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("li", "member", string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String handleLink(Map<String, String> map, String string) throws SAXException {
        String string2;
        DocbookElement docbookElement;
        String string3;
        String string4 = map.get("linkend");
        if (string4 == null) {
            throw new SAXException("No linkend attribute in tag link");
        }
        String string5 = map.get("type");
        if (string5 != null && string5.equals("scilab")) {
            if (this.type != Converter.Backend.JAVAHELP && this.type != Converter.Backend.HTML) return string;
            string3 = this.resolvScilabLink(string4);
        } else {
            string3 = string5 != null && string5.equals("remote") ? this.makeRemoteLink(string4) : this.mapId.get(string4);
        }
        if (string3 == null) {
            if (this.isToolbox) {
                if (this.type == Converter.Backend.HTML) {
                    string3 = this.urlBase + string4;
                    if (this.linkToTheWeb) {
                        string3 = string3 + ".html";
                    }
                }
                if (this.type == Converter.Backend.JAVAHELP) {
                    string3 = this.urlBase + string4;
                }
            } else {
                ++this.warnings;
                System.err.println("Warning (should be fixed): invalid internal link to " + string4 + " in " + this.currentFileName + "\nat line " + this.locator.getLineNumber());
                return null;
            }
        }
        Stack<DocbookElement> stack = this.getStack();
        String string6 = this.mapIdRefname.get(string4);
        String string7 = string != null && !string.isEmpty() ? string : string6;
        if (string7 == null) {
            ++this.warnings;
            System.err.println("Warning (should be fixed): empty link (no text will be printed) to " + string4 + " in " + this.currentFileName + "\nat line " + this.locator.getLineNumber());
        }
        String string8 = this.encloseContents("a", new String[]{"href", string3, "class", "link"}, string7);
        int n = stack.size();
        if (n < 3 || !(docbookElement = (DocbookElement)stack.get(n - 3)).getName().equals("refsection") || (string2 = docbookElement.getAttributes().get("role")) == null || !string2.equals("see also")) return string8;
        String string9 = this.mapIdPurpose.get(string4);
        if (string9 == null) return string8;
        return string8 + " &#8212; " + string9;
    }

    protected String resolvScilabLink(String string) {
        int n = string.indexOf("/");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String[] stringArray = string2.split("\\.");
        if (stringArray == null || stringArray.length != 2) {
            return null;
        }
        if (!this.linkToTheWeb) {
            return this.urlBase + string;
        }
        if (stringArray[0].equals("scilab") && stringArray[1].equals("help")) {
            return this.urlBase + string3 + ".html";
        }
        return "#";
    }

    protected String makeRemoteLink(String string) {
        return string;
    }

    @Override
    public String handleUlink(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("url");
        if (string2 == null) {
            throw new SAXException("No url attribute in tag ulink");
        }
        return this.encloseContents("a", new String[]{"href", string2, "class", "ulink"}, string);
    }

    @Override
    public String handleXref(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("linkend");
        if (string2 == null) {
            throw new SAXException("No linkend attribute in tag link");
        }
        String string3 = this.mapId.get(string2);
        if (string3 == null) {
            ++this.warnings;
            System.err.println("Warning (should be fixed): invalid internal link to " + string2 + " in " + this.currentFileName + "\nat line " + this.locator.getLineNumber());
            return null;
        }
        return this.encloseContents("a", new String[]{"href", string3, "class", "xref"}, string);
    }

    @Override
    public String handleLatex(Map<String, String> map, String string) throws SAXException {
        String string2;
        File file;
        boolean bl = "true".equals(map.get("localized"));
        if (bl) {
            file = new File(this.outImages + "/" + this.imageDir, LATEXBASENAME + this.currentBaseName + "_" + this.language + "_" + this.latexCompt++ + ".png");
        } else {
            if ("ru_RU".equals(this.language) && HTMLDocbookTagConverter.containsCyrillic(string)) {
                System.err.println("Warning: LaTeX code in " + this.getCurrentFileName() + " contains cyrillic character. The tag <latex> should contain the attribute scilab:localized=\"true\"");
            } else if ("ja_JP".equals(this.language) && HTMLDocbookTagConverter.containsCJK(string)) {
                System.err.println("Warning: LaTeX code in " + this.getCurrentFileName() + " contains CJK character. The tag <latex> should contain the attribute scilab:localized=\"true\"");
            }
            file = new File(this.outImages + "/" + this.imageDir, LATEXBASENAME + this.currentBaseName + "_" + this.latexCompt++ + ".png");
        }
        String string3 = this.getParentTagName();
        if (string3.equals("para") && !map.containsKey("style")) {
            map.put("style", "text");
        }
        if ((string2 = map.get("fontsize")) == null) {
            map.put("fontsize", "16");
        }
        return this.getImageConverter().getImageByCode(this.currentFileName, string, map, "image/latex", file, this.imageDir + "/" + file.getName(), this.getBaseImagePath(), this.locator.getLineNumber(), this.language, bl);
    }

    @Override
    public String handleTerm(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("span", "term", string);
        }
        return this.encloseContents("span", "term", string);
    }

    @Override
    public String handleListitem(Map<String, String> map, String string) throws SAXException {
        String string2 = this.getParentTagName();
        if (string2.equals("varlistentry")) {
            return this.encloseContents("dd", string);
        }
        return this.encloseContents("li", string);
    }

    @Override
    public String handleVarlistentry(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("dt", string);
    }

    @Override
    public String handleVariablelist(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("dl", string);
    }

    @Override
    public String handleItemizedlist(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("ul", "itemizedlist", string);
        }
        return this.encloseContents("ul", "itemizedlist", string);
    }

    @Override
    public String handleEmphasis(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("role");
        if (string2 != null) {
            if (string2.equals("bold")) {
                return this.encloseContents("b", string);
            }
            if (string2.equals("italic")) {
                return this.encloseContents("i", string);
            }
        }
        return this.encloseContents("em", string);
    }

    @Override
    public String handleTr(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("bgcolor");
        String string3 = map.get("valign");
        String string4 = map.get("id");
        return this.encloseContents("tr", new String[]{"id", string4, "bgcolor", string2, "valign", string3}, string);
    }

    @Override
    public String handleTd(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("align");
        String string3 = map.get("valign");
        String string4 = map.get("bgcolor");
        String string5 = map.get("colspan");
        String string6 = map.get("rowspan");
        String string7 = map.get("style");
        return this.encloseContents("td", new String[]{"align", string2, "valign", string3, "bgcolor", string4, "colspan", string5, "rowspan", string6, "style", string7}, string);
    }

    @Override
    public String handleInformaltable(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = map.get("border");
        String string4 = map.get("cellpadding");
        String string5 = map.get("width");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("table", new String[]{"class", "informaltable", "border", string3, "cellpadding", string4, "width", string5}, string);
        }
        return this.encloseContents("table", new String[]{"class", "informaltable", "border", string3, "cellpadding", string4, "width", string5}, string);
    }

    @Override
    public String handleImagedata(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("fileref");
        if (string2 == null) {
            if (string == null || string.length() == 0) {
                throw new SAXException("No fileref attribute or no data in tag imagedata");
            }
            return string;
        }
        try {
            String string3 = new File(new URI(this.currentFileName)).getParent();
            File file = ImageConverter.imageExists(string3, string2);
            if (file != null) {
                throw new SAXException("The given fileref is not on an existing image file:\n" + string2 + " [" + file + "]");
            }
            return this.getImageConverter().getImageByFile(map, string3, string2, this.outImages, this.imageDir, this.getBaseImagePath());
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println(uRISyntaxException);
            return null;
        }
    }

    @Override
    public String handleImageobject(Map<String, String> map, String string) throws SAXException {
        return string;
    }

    public String handleTextobject(Map<String, String> map, String string) throws SAXException {
        return "<!-- " + string + " -->";
    }

    @Override
    public String handleInlinemediaobject(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("span", string);
    }

    @Override
    public String handleScreenshot(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "screenshot", string);
        }
        return this.encloseContents("div", "screenshot", string);
    }

    @Override
    public String handleMediaobject(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = string.replaceFirst("top:([0-9]+)px;", "");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "mediaobject", string3);
        }
        return this.encloseContents("div", "mediaobject", string3);
    }

    @Override
    public String handleInformalequation(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "informalequation", string);
        }
        return this.encloseContents("div", "informalequation", string);
    }

    @Override
    public String handleOrderedlist(Map<String, String> map, String string) throws SAXException {
        String string2;
        String string3 = "1";
        String string4 = map.get("numeration");
        if (string4 != null) {
            if (string4.equals("loweralpha")) {
                string3 = "a";
            } else if (string4.equals("upperalpha")) {
                string3 = "A";
            } else if (string4.equals("lowerroman")) {
                string3 = "i";
            } else if (string4.equals("upperroman")) {
                string3 = "I";
            }
        }
        if ((string2 = map.get("id")) != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("ol", new String[]{"type", string3}, string);
        }
        return this.encloseContents("ol", new String[]{"type", string3}, string);
    }

    @Override
    public String handleSubscript(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("sub", string);
    }

    @Override
    public String handleSuperscript(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("sup", string);
    }

    @Override
    public String handleReplaceable(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("span", "replaceable", string);
    }

    @Override
    public String handleQuestion(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("dt", this.encloseContents("strong", string));
    }

    @Override
    public String handleAnswer(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("dd", string);
    }

    @Override
    public String handleQandaentry(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("dl", string);
    }

    @Override
    public String handleQandaset(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("div", "qandaset", string);
    }

    @Override
    public String handleCaption(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("caption", this.encloseContents("b", string));
    }

    @Override
    public String handleTbody(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("tbody", "tbody", string);
    }

    @Override
    public String handleTable(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = map.get("bgcolor");
        String string4 = map.get("border");
        String string5 = map.get("cellpadding");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("table", new String[]{"class", "doctable", "bgcolor", string3, "border", string4, "cellpadding", string5}, string);
        }
        return this.encloseContents("table", new String[]{"class", "doctable", "bgcolor", string3, "border", string4, "cellpadding", string5}, string);
    }

    @Override
    public String handleSurname(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("span", "surname", string);
    }

    @Override
    public String handleFirstname(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("span", "firstname", string);
    }

    @Override
    public String handleBibliomset(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "bibliomset", string);
        }
        return this.encloseContents("div", "bibliomset", string);
    }

    @Override
    public String handleBibliomixed(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + this.encloseContents("div", "bibliomixed", string);
        }
        return this.encloseContents("div", "bibliomixed", string);
    }

    @Override
    public String handleTh(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("align");
        String string3 = map.get("valign");
        String string4 = map.get("style");
        return this.encloseContents("th", new String[]{"align", string2, "valign", string3, "style", string4}, string);
    }

    @Override
    public String handleRevhistory(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = "<table class=\"revhistory\"><tr class=\"title\"><td>" + VERSION + "</td><td>" + DESCRIPTION + "</td></tr>" + string + "</table>";
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + string3;
        }
        return string3;
    }

    @Override
    public String handleRevision(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("tr", new String[]{"valign", "top"}, string);
    }

    @Override
    public String handleRevnumber(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("td", "revnumber", string);
    }

    @Override
    public String handleRevremark(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("td", "revremark", string);
    }

    @Override
    public String handleRevdescription(Map<String, String> map, String string) throws SAXException {
        return this.encloseContents("td", "revdescription", string);
    }

    @Override
    public String handleNote(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = "<table><tr><td valign=\"top\"><img src=\"" + this.getBaseImagePath() + "ScilabNote.png\"/></td><td valign=\"top\">" + this.encloseContents("div", "note", string) + "</td></tr></table>";
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + string3;
        }
        return string3;
    }

    @Override
    public String handleWarning(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = "<table><tr><td valign=\"top\"><img src=\"" + this.getBaseImagePath() + "ScilabWarning.png\"/></td><td valign=\"top\">" + this.encloseContents("div", "warning", string) + "</td></tr></table>";
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + string3;
        }
        return string3;
    }

    @Override
    public String handleCaution(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = "<table><tr><td valign=\"top\"><img src=\"" + this.getBaseImagePath() + "ScilabCaution.png\"/></td><td valign=\"top\">" + this.encloseContents("div", "caution", string) + "</td></tr></table>";
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + string3;
        }
        return string3;
    }

    @Override
    public String handleTip(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = "<table><tr><td valign=\"top\"><img src=\"" + this.getBaseImagePath() + "ScilabTip.png\"/></td><td valign=\"top\">" + this.encloseContents("div", "tip", string) + "</td></tr></table>";
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + string3;
        }
        return string3;
    }

    @Override
    public String handleImportant(Map<String, String> map, String string) throws SAXException {
        String string2 = map.get("id");
        String string3 = "<table><tr><td valign=\"top\"><img src=\"" + this.getBaseImagePath() + "ScilabImportant.png\"/></td><td valign=\"top\">" + this.encloseContents("div", "important", string) + "</td></tr></table>";
        if (string2 != null) {
            return "<a name=\"" + string2 + "\"></a>" + string3;
        }
        return string3;
    }

    private static final String convertCode(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(2 * string.length());
        int n = 0;
        int n2 = string.length() - 1;
        char c = string.charAt(0);
        while ((c == ' ' || c == '\t' || c == '\n' || c == '\r') && n < n2) {
            c = string.charAt(++n);
        }
        c = string.charAt(n2);
        while ((c == ' ' || c == '\t' || c == '\n' || c == '\r') && n2 > 0) {
            c = string.charAt(--n2);
        }
        block10: for (int i = n; i <= n2; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block10;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block10;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("<br />");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("&#039;");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static enum GenerationType {
        WEB,
        JAVAHELP,
        CHM,
        HTML;

    }
}

