/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLDocbookLinkResolver
extends DefaultHandler {
    private static boolean isCaseInsensitiveOS = System.getProperty("os.name").toLowerCase().contains("windows") || System.getProperty("os.name").toLowerCase().contains("mac");
    private Map<String, String> mapId = new LinkedHashMap<String, String>();
    private List<String> listIdIgnoreCase = new ArrayList<String>();
    private Map<String, String> toc = new LinkedHashMap<String, String>();
    private Map<String, String> mapIdPurpose = new LinkedHashMap<String, String>();
    private Map<String, String> mapIdRefname = new LinkedHashMap<String, String>();
    private Map<String, TreeId> mapTreeId = new HashMap<String, TreeId>();
    private Map<String, String> mapIdDeclaringFile = new HashMap<String, String>();
    private TreeId tree;
    private TreeId currentLeaf = this.tree = new TreeId(null, "root");
    private String current;
    private String lastId;
    private Locator locator;
    private String currentFileName;
    private boolean waitForRefname;
    private boolean waitForRefpurpose;
    private boolean waitForTitle;
    private boolean getContents;
    private boolean idInRefentry;
    private final File in;
    private StringBuilder buffer = new StringBuilder(256);

    public HTMLDocbookLinkResolver(String string) throws IOException, SAXException {
        this.in = new File(string);
        this.resolvLinks();
        this.mapIdDeclaringFile = null;
    }

    public Map<String, String> getMapId() {
        return this.mapId;
    }

    public Map<String, String> getMapIdPurpose() {
        return this.mapIdPurpose;
    }

    public Map<String, String> getMapIdRefname() {
        return this.mapIdRefname;
    }

    public Map<String, String> getToc() {
        return this.toc;
    }

    public TreeId getTree() {
        return this.tree;
    }

    public Map<String, TreeId> getMapTreeId() {
        return this.mapTreeId;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        this.currentFileName = string2;
        return super.resolveEntity(string, string2);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        String string4 = null;
        for (int i = 0; i < n; ++i) {
            if (!attributes.getLocalName(i).equals("id")) continue;
            string4 = attributes.getValue(i);
            break;
        }
        if (string2.equals("refentry")) {
            this.idInRefentry = false;
        }
        if (string2.equals("title")) {
            if (this.waitForTitle) {
                this.getContents = true;
                this.buffer.setLength(0);
            }
        } else if (string2.equals("refname")) {
            if (this.waitForRefname) {
                this.getContents = true;
                this.buffer.setLength(0);
            }
        } else if (string2.equals("refpurpose")) {
            if (this.waitForRefpurpose) {
                this.getContents = true;
                this.buffer.setLength(0);
            }
        } else if (string4 != null && string2.equals("refentry") || string2.equals("section") || string2.equals("part") || string2.equals("chapter") || !this.idInRefentry && string2.equals("refnamediv")) {
            if (string4 == null) {
                throw new SAXException(this.errorMsg());
            }
            this.current = this.makeFileName(string4);
            this.listIdIgnoreCase.add(string4.toLowerCase());
            this.lastId = string4;
            if (this.mapIdDeclaringFile.containsKey(string4)) {
                String string5 = this.mapIdDeclaringFile.get(string4);
                throw new SAXException("The id " + string4 + " in file " + this.currentFileName + " was previously declared in " + string5);
            }
            this.mapIdDeclaringFile.put(string4, this.currentFileName);
            this.mapId.put(string4, this.current);
            this.waitForTitle = string2.charAt(0) != 'r';
            this.idInRefentry = this.waitForRefname = !this.waitForTitle;
            this.waitForRefpurpose = this.waitForRefname;
            TreeId treeId = new TreeId(this.currentLeaf, string4);
            this.currentLeaf.add(treeId);
            this.currentLeaf = treeId;
        } else if (string4 != null && this.current != null) {
            if (this.mapIdDeclaringFile.containsKey(string4)) {
                String string6 = this.mapIdDeclaringFile.get(string4);
                throw new SAXException("The id " + string4 + " in file " + this.currentFileName + " was previously declared in " + string6);
            }
            this.mapIdDeclaringFile.put(string4, this.currentFileName);
            this.mapId.put(string4, this.current + "#" + string4);
        }
    }

    public String makeFileName(String string) {
        if (isCaseInsensitiveOS && this.listIdIgnoreCase.contains(string.toLowerCase())) {
            return string + "-" + ScilabCommonsUtils.getMD5((String)string) + ".html";
        }
        return string + ".html";
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.getContents) {
            if (string2.equals("refpurpose")) {
                this.mapIdPurpose.put(this.lastId, this.buffer.toString().trim());
                this.waitForRefpurpose = false;
                this.getContents = false;
            } else if (string2.equals("title") || string2.equals("refname")) {
                this.toc.put(this.lastId, this.buffer.toString().trim());
                this.mapIdRefname.put(this.lastId, this.buffer.toString().trim());
                this.getContents = false;
                this.waitForRefname = false;
                this.waitForTitle = false;
            }
        }
        if (string2.equals("refentry") || string2.equals("section") || string2.equals("part") || string2.equals("chapter")) {
            this.currentLeaf = this.currentLeaf.parent;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.getContents) {
            int n3 = n + n2;
            int n4 = n;
            block7: for (int i = n; i < n3; ++i) {
                switch (cArray[i]) {
                    case '\'': {
                        this.buffer.append(cArray, n4, i - n4);
                        this.buffer.append("&#0039;");
                        n4 = i + 1;
                        continue block7;
                    }
                    case '\"': {
                        this.buffer.append(cArray, n4, i - n4);
                        this.buffer.append("&quot;");
                        n4 = i + 1;
                        continue block7;
                    }
                    case '<': {
                        this.buffer.append(cArray, n4, i - n4);
                        this.buffer.append("&lt;");
                        n4 = i + 1;
                        continue block7;
                    }
                    case '>': {
                        this.buffer.append(cArray, n4, i - n4);
                        this.buffer.append("&gt;");
                        n4 = i + 1;
                        continue block7;
                    }
                    case '&': {
                        this.buffer.append(cArray, n4, i - n4);
                        this.buffer.append("&amp;");
                        n4 = i + 1;
                        continue block7;
                    }
                }
            }
            if (n4 < n3) {
                this.buffer.append(cArray, n4, n3 - n4);
            }
        }
    }

    protected void resolvLinks() throws SAXException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setXIncludeAware(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.in, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException);
        }
    }

    private String errorMsg() {
        String string;
        if (this.currentFileName != null) {
            string = this.currentFileName;
        } else {
            try {
                string = this.in.getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                string = null;
            }
        }
        return "No id attribute in <refentry> or <refnamediv> in file " + string + " at line " + this.locator.getLineNumber();
    }

    public class TreeId {
        String id;
        TreeId parent;
        int pos;
        List<TreeId> children;

        TreeId(TreeId treeId, String string) {
            this.parent = treeId;
            this.id = string;
            if (treeId == null) {
                HTMLDocbookLinkResolver.this.mapTreeId.clear();
            }
            HTMLDocbookLinkResolver.this.mapTreeId.put(string, this);
        }

        void add(TreeId treeId) {
            if (this.children == null) {
                this.children = new ArrayList<TreeId>();
            }
            treeId.pos = this.children.size();
            this.children.add(treeId);
        }

        boolean isRoot() {
            return this.parent == null;
        }

        TreeId getPrevious() {
            if (this.pos > 0) {
                return this.parent.children.get(this.pos - 1);
            }
            return this.parent;
        }

        TreeId getNext() {
            TreeId treeId = this;
            while (treeId.parent != null && treeId.pos == treeId.parent.children.size() - 1) {
                treeId = treeId.parent;
            }
            if (treeId.parent == null) {
                return null;
            }
            return treeId.parent.children.get(treeId.pos + 1);
        }
    }
}

