/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.helptools.Converter;
import org.scilab.modules.helptools.DocbookElement;
import org.scilab.modules.helptools.UnhandledDocbookTagException;
import org.scilab.modules.helptools.external.ExternalXMLHandler;
import org.scilab.modules.helptools.image.Image;
import org.scilab.modules.helptools.image.ImageConverter;
import org.scilab.modules.helptools.image.LaTeXImageConverter;
import org.scilab.modules.helptools.image.MathMLImageConverter;
import org.scilab.modules.helptools.image.SVGImageConverter;
import org.scilab.modules.helptools.image.ScilabImageConverter;
import org.scilab.modules.helptools.image.XcosImageConverter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DocbookTagConverter
extends DefaultHandler
implements Converter {
    private static final String DOCBOOKURI = "http://docbook.org/ns/docbook";
    private static final Class<?>[] argsType = new Class[]{Map.class, String.class};
    protected static final String SCI = ScilabConstants.SCI.getPath();
    private Map<String, Method> mapMeth = new HashMap<String, Method>();
    private Map<String, ExternalXMLHandler> externalHandlers = new HashMap<String, ExternalXMLHandler>();
    private List<DocbookTagConverter> converters;
    private final ImageConverter imgConvert;
    private final File in;
    private DocbookElement baseElement = new DocbookElement(null, null, null);
    private Stack<DocbookElement> stack = new Stack();
    private String errors = "";
    protected boolean hasError;
    protected String currentFileName;
    protected String currentBaseName;
    protected Locator locator;

    public DocbookTagConverter(String string, ImageConverter imageConverter) throws IOException {
        this.in = string != null && !string.isEmpty() ? new File(string) : null;
        this.imgConvert = imageConverter;
        imageConverter.registerExternalImageConverter(new LaTeXImageConverter(this));
        imageConverter.registerExternalImageConverter(new MathMLImageConverter(this));
        imageConverter.registerExternalImageConverter(new SVGImageConverter(this));
        imageConverter.registerExternalImageConverter(new ScilabImageConverter(this));
        imageConverter.registerExternalImageConverter(new XcosImageConverter(this));
    }

    public DocbookTagConverter(String string, DocbookElement docbookElement, ImageConverter imageConverter) throws IOException {
        this(string, imageConverter);
        this.baseElement = docbookElement;
    }

    public ImageConverter getImageConverter() {
        return this.imgConvert;
    }

    public String getBaseImagePath() {
        return "";
    }

    public abstract String generateImageCode(String var1, String var2, Map<String, String> var3);

    public abstract String generateImageCode(Image var1, String var2, Map<String, String> var3);

    public abstract String generateImageCode(String var1, Map<String, String> var2);

    public String handleDocbookTag(String string, Map<String, String> map, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            Method method = this.mapMeth.get(string);
            if (method == null) {
                String string3 = "handle" + Character.toString(Character.toUpperCase(string.charAt(0))) + string.substring(1);
                try {
                    method = this.getClass().getMethod(string3, argsType);
                    this.mapMeth.put(string, method);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new UnhandledDocbookTagException(string);
                }
            }
            try {
                return (String)method.invoke((Object)this, map, string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnhandledDocbookTagException(string);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SAXException("Problem with tag " + string + "\n" + invocationTargetException.getCause());
            }
        }
        throw new UnhandledDocbookTagException(string);
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public String getCurrentBaseName() {
        return this.currentBaseName;
    }

    public void registerConverter(DocbookTagConverter docbookTagConverter) {
        if (this.converters == null) {
            this.converters = new ArrayList<DocbookTagConverter>();
        }
        this.converters.add(docbookTagConverter);
        docbookTagConverter.setDocumentLocator(this.locator);
    }

    public void removeConverter(DocbookTagConverter docbookTagConverter) {
        if (this.converters != null) {
            this.converters.remove(docbookTagConverter);
        }
    }

    public DocbookTagConverter[] getConverters() {
        if (this.converters == null) {
            return null;
        }
        return this.converters.toArray(new DocbookTagConverter[0]);
    }

    protected void registerExternalXMLHandler(ExternalXMLHandler externalXMLHandler) {
        if (this.externalHandlers.get(externalXMLHandler.getURI()) == null) {
            this.externalHandlers.put(externalXMLHandler.getURI(), externalXMLHandler);
            externalXMLHandler.setConverter(this);
        }
    }

    @Override
    public void registerAllExternalXMLHandlers() {
    }

    public void unregisterAllExternalXMLHandler() {
        for (ExternalXMLHandler externalXMLHandler : this.externalHandlers.values()) {
            externalXMLHandler.setConverter(null);
        }
        this.externalHandlers.clear();
    }

    public boolean isEscapable(String string, String string2) {
        return true;
    }

    public boolean isTrimable(String string) {
        return true;
    }

    public String getParentTagName() {
        return this.stack.peek().getName();
    }

    public String getParentContent() {
        return this.stack.peek().getStringBuilder().toString();
    }

    @Override
    public void convert() throws SAXException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setXIncludeAware(true);
        try {
            sAXParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.in, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.exceptionOccurred(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        if (this.hasError) {
            throw new SAXException(this.errors);
        }
    }

    @Override
    public void install() {
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        if (string != null) {
            string = string.replaceAll(" ", "%20");
        }
        if (string2 != null) {
            string2 = string2.replaceAll(" ", "%20");
        }
        this.currentFileName = string2;
        this.currentBaseName = new File(string2).getName();
        for (ExternalXMLHandler object : this.externalHandlers.values()) {
            object.resetCompt();
        }
        if (this.converters != null) {
            for (DocbookTagConverter docbookTagConverter : this.converters) {
                docbookTagConverter.resolveEntity(string, string2);
            }
        }
        return super.resolveEntity(string, string2);
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack.push(this.baseElement.getNewInstance(null, null, null));
        if (this.converters != null) {
            for (DocbookTagConverter docbookTagConverter : this.converters) {
                docbookTagConverter.startDocument();
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.stack.clear();
        if (this.converters != null) {
            for (DocbookTagConverter docbookTagConverter : this.converters) {
                docbookTagConverter.endDocument();
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string.equals(DOCBOOKURI)) {
            int n = attributes.getLength();
            HashMap<String, String> object2 = new HashMap<String, String>(n);
            for (int i = 0; i < n; ++i) {
                object2.put(attributes.getLocalName(i), attributes.getValue(i));
            }
            this.stack.push(this.baseElement.getNewInstance(string2, string, object2));
        } else {
            ExternalXMLHandler externalXMLHandler = this.externalHandlers.get(string);
            if (externalXMLHandler == null) {
                this.exceptionOccurred(new SAXException("uri " + string + " not handled"));
                return;
            }
            StringBuilder stringBuilder = externalXMLHandler.startExternalXML(string2, attributes, this.locator);
            if (stringBuilder != null) {
                DocbookElement docbookElement = this.baseElement.getNewInstance(string2, string, null);
                docbookElement.setStringBuilder(stringBuilder);
                this.stack.push(docbookElement);
            }
        }
        if (this.converters != null) {
            for (DocbookTagConverter docbookTagConverter : this.converters) {
                docbookTagConverter.startElement(string, string2, string3, attributes);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void endElement(String var1_1, String var2_2, String var3_3) throws SAXException {
        if (var1_1.equals("http://docbook.org/ns/docbook")) {
            var4_4 = this.stack.pop();
            if (!var4_4.getName().equals(var2_2)) {
                this.exceptionOccurred(new SAXException("tag " + var4_4.getName() + " is closed with tag " + var2_2));
                return;
            }
            try {
                var5_5 = this.stack.peek();
                var5_5.setParent((DocbookElement)var4_4);
                var6_7 = var4_4.getStringBuilder();
                if (this.isTrimable(var4_4.getName())) {
                    var6_7 = DocbookTagConverter.trim(var6_7);
                }
                if ((var7_8 = this.handleDocbookTag(var4_4.getName(), var4_4.getAttributes(), var6_7.toString())) == null) ** GOTO lbl29
                var5_5.getStringBuilder().append(var7_8);
            }
            catch (SAXException var5_6) {
                this.exceptionOccurred(var5_6);
                return;
            }
        } else {
            var4_4 = this.externalHandlers.get(var1_1);
            if (var4_4 == null) {
                this.exceptionOccurred(new SAXException("uri " + var1_1 + " not handled"));
                return;
            }
            var5_5 = var4_4.endExternalXML(var2_2);
            if (var5_5 != null) {
                this.stack.pop();
                this.stack.peek().getStringBuilder().append((String)var5_5);
            }
        }
lbl29:
        // 5 sources

        if (this.converters != null) {
            for (Object var5_5 : this.converters) {
                var5_5.endElement(var1_1, var2_2, var3_3);
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = n + n2;
        if (this.isEscapable(this.stack.peek().getName(), this.stack.peek().getURI())) {
            StringBuilder stringBuilder = this.stack.peek().getStringBuilder();
            int n4 = n;
            block7: for (int i = n; i < n3; ++i) {
                switch (cArray[i]) {
                    case '\'': {
                        stringBuilder.append(cArray, n4, i - n4);
                        stringBuilder.append("&#0039;");
                        n4 = i + 1;
                        continue block7;
                    }
                    case '\"': {
                        stringBuilder.append(cArray, n4, i - n4);
                        stringBuilder.append("&#0034;");
                        n4 = i + 1;
                        continue block7;
                    }
                    case '<': {
                        stringBuilder.append(cArray, n4, i - n4);
                        stringBuilder.append("&lt;");
                        n4 = i + 1;
                        continue block7;
                    }
                    case '>': {
                        stringBuilder.append(cArray, n4, i - n4);
                        stringBuilder.append("&gt;");
                        n4 = i + 1;
                        continue block7;
                    }
                    case '&': {
                        stringBuilder.append(cArray, n4, i - n4);
                        stringBuilder.append("&amp;");
                        n4 = i + 1;
                        continue block7;
                    }
                }
            }
            if (n4 < n3) {
                stringBuilder.append(cArray, n4, n3 - n4);
            }
        } else {
            this.stack.peek().getStringBuilder().append(cArray, n, n2);
        }
        if (this.converters != null) {
            for (DocbookTagConverter docbookTagConverter : this.converters) {
                docbookTagConverter.characters(cArray, n, n2);
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    protected Stack<DocbookElement> getStack() {
        return this.stack;
    }

    protected void fatalExceptionOccurred(Exception exception) throws SAXException {
        throw new SAXException(this.errors + "\nFATAL error:\n" + exception.getMessage());
    }

    protected void exceptionOccurred(Exception exception) {
        if (!this.hasError) {
            this.hasError = true;
        }
        this.errors = this.errors + this.makeErrorMessage(exception);
    }

    private String makeErrorMessage(Exception exception) {
        String string;
        String string2 = "";
        if (this.currentFileName != null) {
            string2 = "SystemID:" + this.currentFileName;
        }
        try {
            string = this.in.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            string = null;
        }
        if (this.locator != null) {
            return "\nCannot parse " + string + ":\n" + exception.getMessage() + "\n" + string2 + " at line " + this.locator.getLineNumber();
        }
        return "\nCannot parse " + string + ":\n" + exception.getMessage() + "\n" + string2;
    }

    private static StringBuilder trim(StringBuilder stringBuilder) {
        char c;
        int n;
        int n2 = stringBuilder.length();
        for (n = 0; n < n2 && ((c = stringBuilder.charAt(n)) == ' ' || c == '\t' || c == '\r' || c == '\n'); ++n) {
        }
        stringBuilder.delete(0, n);
        n2 -= n;
        for (n = n2 - 1; n >= 0 && ((c = stringBuilder.charAt(n)) == ' ' || c == '\t' || c == '\r' || c == '\n'); --n) {
        }
        stringBuilder.setLength(n + 1);
        return stringBuilder;
    }

    public abstract String handleAnswer(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleBibliomixed(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleBibliomset(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleBook(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleCaption(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleCaution(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleChapter(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleCode(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleCommand(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleConstant(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleEmphasis(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleFirstname(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleFunction(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleImagedata(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleImageobject(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleImportant(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleInfo(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleInformalequation(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleInformaltable(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleInlinemediaobject(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleItemizedlist(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleLatex(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleLink(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleListitem(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleLiteral(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleLiterallayout(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleMediaobject(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleMember(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleNote(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleOption(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleOrderedlist(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handlePara(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handlePart(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleProgramlisting(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handlePubdate(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleQandaentry(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleQandaset(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleQuestion(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefentry(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefnamediv(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefname(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefpurpose(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefsection(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefsect1(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefsect2(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefsect3(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRefsynopsisdiv(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleReplaceable(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRevdescription(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRevhistory(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRevision(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRevnumber(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleRevremark(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleScreen(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleScreenshot(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleSection(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleSimplelist(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleSubscript(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleSuperscript(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleSurname(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleSynopsis(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleTable(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleTbody(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleTd(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleTerm(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleTh(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleTip(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleTitle(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleTr(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleUlink(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleVariablelist(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleVarlistentry(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleVarname(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleWarning(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleXref(Map<String, String> var1, String var2) throws SAXException;

    public abstract String handleAnchor(Map<String, String> var1, String var2) throws SAXException;
}

