/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.converter.Converter;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.modules.helptools.Helpers;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CopyConvert
extends DefaultHandler
implements ErrorHandler {
    private static final String MATHML_NS = "http://www.w3.org/1998/Math/MathML";
    public static final File TMPDIR = new File(System.getenv("TMPDIR"));
    private boolean verbose;
    private String printFormat;
    private File outDir;
    private PrintWriter out;
    private SAXParser parser;
    private Locator locator;
    private ArrayList<String[]> inScopePrefixes;
    private PrintWriter mainOut;
    private int graphicsCounter;
    private int embeddedGraphicsIsMathML;
    private int initTeX;
    private File latex;
    private File dvips;
    private File gs;
    private File ps2pdf;
    private LaTeXElement latexElem;
    private boolean isLatexConverted = true;

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setPrintFormat(String string) {
        this.printFormat = string;
    }

    public void setLatexConverted(boolean bl) {
        this.isLatexConverted = bl;
    }

    public void run(File file, File file2) throws SAXParseException, SAXException, IOException {
        File file3 = file2.getCanonicalFile();
        this.outDir = file3.getParentFile();
        if (!this.outDir.isDirectory() && !this.outDir.mkdirs()) {
            throw new IOException("Cannot create directory '" + this.outDir + "'");
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            this.parser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            throw new SAXParseException("Cannot create a properly configured SAX parser: " + Helpers.reason(exception), this.locator);
        }
        this.inScopePrefixes = new ArrayList();
        this.mainOut = null;
        this.graphicsCounter = 0;
        this.embeddedGraphicsIsMathML = -1;
        this.initTeX = -1;
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file3), "UTF-8"));
        try {
            this.parser.parse(file, (DefaultHandler)this);
            this.out.flush();
            if (this.out.checkError()) {
                throw new IOException("Error writing '" + file3 + "'");
            }
        }
        catch (SAXException sAXException) {
            if (this.locator != null) {
                throw new SAXParseException("Cannot parse " + file + " " + Helpers.reason(sAXException), this.locator);
            }
            throw new SAXException("Cannot parse " + file + " " + Helpers.reason(sAXException));
        }
        finally {
            this.out.close();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.out.write("<?xml version='1.0' encoding='UTF-8'?>\n");
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.inScopePrefixes.add(new String[]{string, string2});
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        int n = this.inScopePrefixes.size();
        for (int i = n - 1; i >= 0; --i) {
            String[] stringArray = this.inScopePrefixes.get(i);
            if (!stringArray[0].equals(string)) continue;
            this.inScopePrefixes.remove(i);
            break;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        this.out.write(60);
        if ("latex".equals(string2)) {
            this.latexElem = new LaTeXElement(attributes, this.isLatexConverted);
            return;
        }
        this.out.write(string3);
        boolean bl = "imagedata".equals(string2);
        boolean bl2 = false;
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            object = attributes.getValue(i);
            if (bl && "fileref".equals(attributes.getLocalName(i))) {
                Serializable serializable;
                bl2 = true;
                URL uRL = null;
                try {
                    serializable = new URL(this.locator.getSystemId());
                    uRL = new URL((URL)serializable, (String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    CopyConvert.reportError("Malformed URL '" + (String)object + "'");
                }
                if (uRL != null) {
                    String string4;
                    serializable = null;
                    try {
                        serializable = new File(uRL.toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        CopyConvert.reportError("Malformed URI '" + uRL + "'");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        CopyConvert.reportError("'" + uRL + "', not a 'file:' URL");
                    }
                    if (serializable != null && (string4 = this.copyConvertGraphics((File)serializable)) != null) {
                        object = string4;
                    }
                }
            }
            this.out.write(32);
            this.out.write(attributes.getQName(i));
            this.out.write("='");
            Helpers.escapeXML((String)object, this.out);
            this.out.write(39);
        }
        if (this.mainOut != null) {
            if (this.embeddedGraphicsIsMathML < 0) {
                this.embeddedGraphicsIsMathML = MATHML_NS.equals(string) ? 1 : 0;
            }
            this.declarePrefixes(attributes);
        }
        if (!bl || bl2) {
            this.out.write(62);
        } else {
            File file = new File(this.outDir, "graphics-" + ++this.graphicsCounter + ".tmp");
            try {
                object = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                this.out.flush();
                this.mainOut = this.out;
                this.out = object;
                this.out.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                this.embeddedGraphicsIsMathML = -1;
            }
            catch (IOException iOException) {
                CopyConvert.reportError("Cannot create file '" + file + "': " + Helpers.reason(iOException));
                this.out.write(62);
            }
        }
    }

    private void declarePrefixes(Attributes attributes) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.inScopePrefixes.size();
        for (int i = 0; i < n; ++i) {
            String[] object = this.inScopePrefixes.get(i);
            hashMap.put(object[0], object[1]);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = string.length() == 0 ? "xmlns" : "xmlns:" + string;
            if (attributes.getValue(string3) != null) continue;
            this.out.write(32);
            this.out.write(string3);
            this.out.write("='");
            Helpers.escapeXML(string2, this.out);
            this.out.write(39);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("latex".equals(string2)) {
            this.latexElem.generate(this.locator);
            this.latexElem = null;
            return;
        }
        if ("imagedata".equals(string2) && this.mainOut != null) {
            Object object;
            String string4 = "graphics-" + this.graphicsCounter;
            Object object2 = string4 + ".tmp";
            File file = new File(this.outDir, (String)object2);
            this.out.flush();
            if (this.out.checkError()) {
                CopyConvert.reportError("Error writing '" + file + "'");
                this.out.close();
                file = null;
            } else {
                this.out.close();
                object = new File(this.outDir, string4 + (this.embeddedGraphicsIsMathML == 1 ? ".mml" : ".svg"));
                if (!file.renameTo((File)object)) {
                    CopyConvert.reportError("Cannot rename '" + file + "' to '" + object + "'");
                    file = null;
                } else {
                    file = object;
                }
            }
            this.out = this.mainOut;
            this.mainOut = null;
            if (file != null) {
                this.reportInfo("Extracted embedded graphics from '" + file + "' to '" + file + "'.");
                object = this.copyConvertGraphics(file);
                if (object != null) {
                    object2 = object;
                    if (!file.delete()) {
                        CopyConvert.reportError("Cannot delete '" + file + "'");
                    }
                }
            }
            this.out.write(" fileref='");
            Helpers.escapeXML((String)object2, this.out);
            this.out.write("'/>");
        } else {
            this.out.write("</");
            this.out.write(string3);
            this.out.write(62);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.latexElem != null) {
            this.latexElem.setLaTeX(new String(cArray, n, n2));
            return;
        }
        Helpers.escapeXML(cArray, n, n2, this.out);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.out.write("<?");
        this.out.write(string);
        this.out.write(32);
        this.out.write(string2);
        this.out.write("?>");
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    private String copyConvertGraphics(File file) {
        if (!file.isFile()) {
            CopyConvert.reportError("'" + file + "' not found");
            return null;
        }
        String string = file.getName();
        String string2 = Helpers.setFileExtension(string, null);
        String string3 = Helpers.getFileExtension(string);
        if ("tex".equalsIgnoreCase(string3)) {
            string = "ps".equalsIgnoreCase(this.printFormat) ? string2 + "_tex.eps" : ("pdf".equalsIgnoreCase(this.printFormat) ? string2 + "_tex.pdf" : string2 + "_tex.png");
            File file2 = new File(this.outDir, string);
            if (!file2.exists() || file2.lastModified() < file.lastModified()) {
                this.reportInfo("Converting TeX '" + file + "' to '" + file2 + "'...");
                if (!this.convertTeX(file, file2)) {
                    string = null;
                }
            }
        } else if ("mml".equalsIgnoreCase(string3)) {
            string = string2 + "_mml.png";
            File file3 = new File(this.outDir, string);
            if (!file3.exists() || file3.lastModified() < file.lastModified()) {
                this.reportInfo("Converting MathML '" + file + "' to '" + file3 + "'...");
                if (!this.convertMathML(file, file3)) {
                    string = null;
                }
            }
        } else if ("svg".equalsIgnoreCase(string3) || "svgz".equalsIgnoreCase(string3)) {
            string = string2 + "_svg.png";
            File file4 = new File(this.outDir, string);
            if (!file4.exists() || file4.lastModified() < file.lastModified()) {
                this.reportInfo("Converting SVG '" + file + "' to '" + file4 + "'...");
                if (!this.convertSVG("svgz".equalsIgnoreCase(string3), file, file4)) {
                    string = null;
                }
            }
        } else {
            File file5 = new File(this.outDir, string);
            if (!file5.exists() || file5.lastModified() < file.lastModified()) {
                this.reportInfo("Copying '" + file + "' to '" + file5 + "'...");
                try {
                    Helpers.copyFile(file, file5);
                }
                catch (IOException iOException) {
                    CopyConvert.reportError("Cannot copy '" + file + "' to '" + file5 + "': " + Helpers.reason(iOException));
                }
            }
        }
        return string;
    }

    private boolean convertTeX(File file, File file2) {
        if (!this.initTeX()) {
            return false;
        }
        try {
            this.doConvertTeX(file, file2);
            return true;
        }
        catch (Exception exception) {
            CopyConvert.reportError("Cannot convert '" + file + "' to '" + file2 + "': " + Helpers.reason(exception));
            return false;
        }
    }

    private boolean initTeX() {
        if (this.initTeX == -1) {
            this.latex = Helpers.findInPath("latex");
            if (this.latex == null) {
                CopyConvert.reportError("Don't find executable 'latex' in PATH");
            }
            this.dvips = Helpers.findInPath("dvips");
            if (this.dvips == null) {
                CopyConvert.reportError("Don't find executable 'dvips' in PATH");
            }
            String string = Helpers.IS_WINDOWS ? "gswin32c" : "gs";
            this.gs = Helpers.findInPath(string);
            if (this.gs == null) {
                CopyConvert.reportError("Don't find executable '" + string + "' in PATH");
            }
            this.ps2pdf = Helpers.findInPath("ps2pdf");
            if (this.ps2pdf == null) {
                CopyConvert.reportError("Don't find executable 'ps2pdf' in PATH");
            }
            this.initTeX = this.latex == null || this.dvips == null || this.gs == null || this.ps2pdf == null ? 0 : 1;
        }
        return this.initTeX == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConvertTeX(File file, File file2) throws IOException, InterruptedException {
        File file3 = this.wrapTeX(file);
        File file4 = file3.getParentFile();
        String string = file3.getName();
        String string2 = Helpers.setFileExtension(string, null);
        File file5 = new File(file4, string2 + ".aux");
        File file6 = new File(file4, string2 + ".log");
        File file7 = new File(file4, string2 + ".dvi");
        File file8 = new File(file4, string2 + ".eps");
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\"');
            stringBuilder.append(this.latex);
            stringBuilder.append("\" --interaction batchmode ");
            stringBuilder.append(string);
            this.shellExec(stringBuilder.toString(), file4);
            if (!file7.isFile()) {
                throw new IOException("'" + file + "' has TeX errors");
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append('\"');
            stringBuilder.append(this.dvips);
            stringBuilder.append("\" -E -o \"");
            stringBuilder.append(file8);
            stringBuilder.append("\" \"");
            stringBuilder.append(file7);
            stringBuilder.append("\"");
            this.shellExec(stringBuilder.toString(), file4);
            if ("ps".equalsIgnoreCase(this.printFormat)) {
                Helpers.copyFile(file8, file2);
            } else if ("pdf".equalsIgnoreCase(this.printFormat)) {
                stringBuilder = new StringBuilder();
                stringBuilder.append('\"');
                stringBuilder.append(this.ps2pdf);
                stringBuilder.append("\" -dEPSCrop \"");
                stringBuilder.append(file8);
                stringBuilder.append("\" \"");
                stringBuilder.append(file2);
                stringBuilder.append("\"");
                this.shellExec(stringBuilder.toString(), file4);
            } else {
                stringBuilder = new StringBuilder();
                stringBuilder.append('\"');
                stringBuilder.append(this.gs);
                stringBuilder.append("\" -q -dBATCH -dNOPAUSE -sDEVICE=png16m");
                stringBuilder.append(" -r96 -dTextAlphaBits=4 -dGraphicsAlphaBits=4");
                stringBuilder.append(" -dEPSCrop \"-sOutputFile=");
                stringBuilder.append(file2);
                stringBuilder.append("\" \"");
                stringBuilder.append(file8);
                stringBuilder.append("\"");
                this.shellExec(stringBuilder.toString(), file4);
            }
        }
        finally {
            file3.delete();
            if (file5.isFile()) {
                file5.delete();
            }
            if (file6.isFile()) {
                file6.delete();
            }
            if (file7.isFile()) {
                file7.delete();
            }
            if (file8.isFile()) {
                file8.delete();
            }
        }
    }

    private File wrapTeX(File file) throws IOException {
        String string = Helpers.loadString(file, "ISO-8859-1");
        File file2 = File.createTempFile("CopyConvert", ".tex", TMPDIR);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\documentclass[12pt]{article}\n");
        stringBuilder.append("\\usepackage[latin1]{inputenc}\n");
        stringBuilder.append("\\pagestyle{empty}\n");
        stringBuilder.append("\\begin{document}\n");
        stringBuilder.append(string);
        stringBuilder.append('\n');
        stringBuilder.append("\\end{document}\n");
        Helpers.saveString(stringBuilder.toString(), file2, "ISO-8859-1");
        return file2;
    }

    private void shellExec(String string, File file) throws IOException, InterruptedException {
        int n = Helpers.shellExec(string, null, file, this.verbose);
        if (n != 0) {
            throw new RuntimeException("command '" + string + "' has exited with non-zero status " + n);
        }
    }

    private boolean convertMathML(File file, File file2) {
        LayoutContextImpl layoutContextImpl = new LayoutContextImpl(LayoutContextImpl.getDefaultLayoutContext());
        layoutContextImpl.setParameter(Parameter.ANTIALIAS, (Object)"true");
        layoutContextImpl.setParameter(Parameter.MATHBACKGROUND, (Object)"#FFFFFF");
        layoutContextImpl.setParameter(Parameter.MATHSIZE, (Object)"18");
        try {
            Converter.getInstance().convert(file, file2, "image/png", (MutableLayoutContext)layoutContextImpl);
            return true;
        }
        catch (IOException iOException) {
            CopyConvert.reportError("Cannot convert '" + file + "' to '" + file2 + "': " + Helpers.reason(iOException));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertSVG(boolean bl, File file, File file2) {
        PNGTranscoder pNGTranscoder = new PNGTranscoder();
        pNGTranscoder.addTranscodingHint(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE, (Object)Boolean.TRUE);
        try {
            InputStream inputStream = new FileInputStream(file);
            if (bl) {
                inputStream = new GZIPInputStream(inputStream);
            }
            try {
                TranscoderInput transcoderInput = new TranscoderInput(inputStream);
                transcoderInput.setURI(file.toURI().toASCIIString());
                pNGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, (Object)this.parser.getXMLReader().getClass().getName());
                pNGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
                try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                    TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)fileOutputStream);
                    pNGTranscoder.transcode(transcoderInput, transcoderOutput);
                    fileOutputStream.flush();
                }
            }
            finally {
                inputStream.close();
            }
            return true;
        }
        catch (Exception exception) {
            CopyConvert.reportError("Cannot convert '" + file + "' to '" + file2 + "': " + Helpers.reason(exception));
            return false;
        }
    }

    public void warning(TranscoderException transcoderException) throws TranscoderException {
        String string = "SVG transcoder warning: " + Helpers.reason((Throwable)transcoderException);
        CopyConvert.reportWarning(string);
    }

    public void error(TranscoderException transcoderException) throws TranscoderException {
        String string = "SVG transcoder error: " + Helpers.reason((Throwable)transcoderException);
        CopyConvert.reportError(string);
    }

    public void fatalError(TranscoderException transcoderException) throws TranscoderException {
        String string = "SVG transcoder fatal error: " + Helpers.reason((Throwable)transcoderException);
        CopyConvert.reportError(string);
    }

    private void reportInfo(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    private static void reportWarning(String string) {
        System.err.println("warning: " + string);
    }

    private static void reportError(String string) {
        System.err.println("*** error: " + string);
    }

    public static int main(String[] stringArray) {
        Object object;
        int n;
        boolean bl = false;
        String string = null;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            if ("-v".equalsIgnoreCase((String)object)) {
                bl = true;
                continue;
            }
            if ("-ps".equalsIgnoreCase((String)object)) {
                string = "ps";
                continue;
            }
            if ("-pdf".equalsIgnoreCase((String)object)) {
                string = "pdf";
                continue;
            }
            if (!((String)object).startsWith("-")) break;
            bl2 = true;
            break;
        }
        if (!bl2 && n + 2 != stringArray.length) {
            bl2 = true;
        }
        if (bl2) {
            System.err.println("Usage: java org.scilab.modules.helptools.CopyConvert  {-ps|-pdf}? {-v}? in_xml_file out_xml_file\nCreates out_xml_file as a ``flattened'' copy of\nin_xml_file.\nAll graphics files referenced by <imagedata fileref='XXX'/>\nelements are copied, possibly after being converted to PNG,\nto the directory containing in_xml_file.\n(This directory is assumed to be a temporary \nworking directory.)\nOptions are:\n  -ps  Target format is PostScript rather than HTML.\n  -pdf Target format is PDF rather than HTML.\n  -v   Verbose.");
            return 1;
        }
        object = new File(stringArray[n]);
        File file = new File(stringArray[n + 1]);
        CopyConvert copyConvert = new CopyConvert();
        copyConvert.verbose = bl;
        copyConvert.printFormat = string;
        try {
            copyConvert.run((File)object, file);
        }
        catch (Exception exception) {
            CopyConvert.reportError("Cannot copy/convert '" + object + "' to '" + file + "': " + Helpers.reason(exception));
            return 2;
        }
        return 0;
    }

    protected class LaTeXElement {
        int size = 18;
        Color fg = null;
        Color bg = null;
        int disp = 0;
        String code = "mediaobject><imageobject><imagedata";
        String LaTeX = "";
        boolean exported;
        String attribs;
        String align = "";

        protected LaTeXElement(Attributes attributes, boolean bl) {
            this.exported = bl;
            int n = attributes.getLength();
            String string = "";
            String string2 = "";
            String string3 = "display";
            for (int i = 0; i < n; ++i) {
                String string4 = attributes.getValue(i);
                String string5 = attributes.getLocalName(i);
                if ("align".equals(string5)) {
                    this.code = this.code + " align='" + string4 + "'";
                    this.align = string4;
                    continue;
                }
                if ("style".equals(string5)) {
                    if ("text".equals(string4)) {
                        this.disp = 2;
                    } else if ("script".equals(string4)) {
                        this.disp = 4;
                    } else if ("script_script".equals(string4)) {
                        this.disp = 6;
                    }
                    string3 = string4;
                    continue;
                }
                if ("size".equals(string5)) {
                    try {
                        this.size = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.size = 16;
                    }
                    continue;
                }
                if ("fg".equals(string5)) {
                    this.fg = Color.decode(string4);
                    string = string4;
                    continue;
                }
                if (!"bg".equals(string5)) continue;
                this.bg = Color.decode(string4);
                string2 = string4;
            }
            this.attribs = " align='" + this.align + "'";
            this.attribs = this.attribs + " size='" + this.size + "'";
            this.attribs = this.attribs + " style='" + string3 + "'";
            if (this.bg != null) {
                this.attribs = this.attribs + " bg='" + string2 + "'";
            }
            if (this.fg != null) {
                this.attribs = this.attribs + " fg='" + string + "'";
            }
        }

        protected void setLaTeX(String string) {
            this.LaTeX = this.LaTeX + string;
        }

        protected void generate(Locator locator) throws SAXParseException {
            if (this.exported) {
                this.generatePNG(locator);
                return;
            }
            CopyConvert.this.out.write("latex" + this.attribs + " xmlns=\"http://forge.scilab.org/p/jlatexmath\"><![CDATA[" + this.LaTeX + "]]></latex>");
        }

        protected void generatePNG(Locator locator) throws SAXParseException {
            TeXFormula teXFormula;
            try {
                teXFormula = new TeXFormula(this.LaTeX);
            }
            catch (ParseException parseException) {
                throw new SAXParseException("\nThere was a problem in parsing the LaTeX' formula : \n" + parseException.getMessage(), CopyConvert.this.locator);
            }
            File file = new File(CopyConvert.this.outDir, "graphics-" + ++CopyConvert.this.graphicsCounter + "_latex.png");
            CopyConvert.this.reportInfo("Converting LaTeX formula to " + file + "'...");
            teXFormula.createPNG(this.disp, (float)this.size, file.getPath(), this.bg, this.fg);
            String string = "";
            if (this.align.length() == 0) {
                this.code = "inline" + this.code;
                string = "inline";
            }
            CopyConvert.this.out.write(this.code + " fileref='graphics-" + CopyConvert.this.graphicsCounter + "_latex.png'/>" + "</imageobject></" + string + "mediaobject>");
        }
    }
}

