/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.ObjectValue;

public class XdmExternalObject
extends XdmItem {
    protected XdmExternalObject(Object value) {
        super(new ObjectValue(value));
    }

    public XdmExternalObject(String lexicalForm, ItemType type) throws SaxonApiException {
        net.sf.saxon.type.ItemType it = type.getUnderlyingItemType();
        if (!it.isPlainType()) {
            throw new SaxonApiException("Requested type is not atomic");
        }
        if (((AtomicType)it).isAbstract()) {
            throw new SaxonApiException("Requested type is an abstract type");
        }
        if (((AtomicType)it).isNamespaceSensitive()) {
            throw new SaxonApiException("Requested type is namespace-sensitive");
        }
        try {
            StringConverter converter = type.getConversionRules().getStringConverter((AtomicType)it);
            this.setValue(converter.convertString(lexicalForm).asAtomic());
        }
        catch (ValidationException e) {
            throw new SaxonApiException(e);
        }
    }

    public Object getExternalObject() {
        return ((ObjectValue)this.getUnderlyingValue()).getObject();
    }

    public String toString() {
        return this.getExternalObject().toString();
    }
}

