/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.tranformations;

import java.util.Arrays;

public class Vector3d {
    private final double x;
    private final double y;
    private final double z;
    private Integer hash;

    public Vector3d(Vector3d vector3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
    }

    public Vector3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3d(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public Vector3d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Vector3d(Double[] doubleArray) {
        this.x = doubleArray[0];
        this.y = doubleArray[1];
        this.z = doubleArray[2];
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public double[] getData() {
        return new double[]{this.x, this.y, this.z};
    }

    public float[] getDataAsFloatArray() {
        return new float[]{(float)this.x, (float)this.y, (float)this.z};
    }

    public float[] getDataAsFloatArray(int n) {
        if (n == 4) {
            return new float[]{(float)this.x, (float)this.y, (float)this.z, 1.0f};
        }
        return new float[]{(float)this.x, (float)this.y, (float)this.z};
    }

    public Vector3d plus(Vector3d vector3d) {
        return new Vector3d(this.x + vector3d.x, this.y + vector3d.y, this.z + vector3d.z);
    }

    public Vector3d minus(Vector3d vector3d) {
        return new Vector3d(this.x - vector3d.x, this.y - vector3d.y, this.z - vector3d.z);
    }

    public Vector3d times(double d) {
        return new Vector3d(this.x * d, this.y * d, this.z * d);
    }

    public Vector3d getNormalized() {
        double d = this.getNorm();
        if (d == 0.0) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        return this.times(1.0 / this.getNorm());
    }

    public double getNorm() {
        return Math.sqrt(this.getNorm2());
    }

    public double getNorm2() {
        return this.scalar(this);
    }

    public double scalar(Vector3d vector3d) {
        return this.x * vector3d.x + this.y * vector3d.y + this.z * vector3d.z;
    }

    public static Vector3d product(Vector3d vector3d, Vector3d vector3d2) {
        return new Vector3d(vector3d.y * vector3d2.z - vector3d.z * vector3d2.y, vector3d.z * vector3d2.x - vector3d.x * vector3d2.z, vector3d.x * vector3d2.y - vector3d.y * vector3d2.x);
    }

    public static final double det(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        return vector3d.x * (vector3d2.y * vector3d3.z - vector3d2.z * vector3d3.y) + vector3d.y * (vector3d2.z * vector3d3.x - vector3d2.x * vector3d3.z) + vector3d.z * (vector3d2.x * vector3d3.y - vector3d2.y * vector3d3.x);
    }

    public static final Vector3d getBarycenter(Vector3d vector3d, Vector3d vector3d2, double d, double d2) {
        return new Vector3d(vector3d.x * d + vector3d2.x * d2, vector3d.y * d + vector3d2.y * d2, vector3d.z * d + vector3d2.z * d2);
    }

    public Vector3d setX(double d) {
        return new Vector3d(d, this.y, this.z);
    }

    public Vector3d setY(double d) {
        return new Vector3d(this.x, d, this.z);
    }

    public Vector3d setZ(double d) {
        return new Vector3d(this.x, this.y, d);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean isNearZero() {
        return Math.abs(this.x) <= 1.0E-9 && Math.abs(this.y) <= 1.0E-9 && Math.abs(this.z) <= 1.0E-9;
    }

    public boolean equals(Object object) {
        if (object instanceof Vector3d) {
            Vector3d vector3d = (Vector3d)object;
            return Math.abs(vector3d.x - this.x) <= 1.0E-9 && Math.abs(vector3d.y - this.y) <= 1.0E-9 && Math.abs(vector3d.z - this.z) <= 1.0E-9;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = Arrays.hashCode(new double[]{this.x, this.y, this.z});
        }
        return this.hash;
    }
}

