/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.tranformations;

import javax.swing.event.EventListenerList;
import org.scilab.forge.scirenderer.Canvas;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationFactory;
import org.scilab.forge.scirenderer.tranformations.TransformationManager;
import org.scilab.forge.scirenderer.tranformations.TransformationManagerListener;
import org.scilab.forge.scirenderer.tranformations.TransformationStack;
import org.scilab.forge.scirenderer.tranformations.TransformationStackImpl;
import org.scilab.forge.scirenderer.tranformations.TransformationStackListener;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class TransformationManagerImpl
implements TransformationManager {
    private final EventListenerList listeners;
    private final Canvas canvas;
    private final TransformationStack modelViewStack;
    private final TransformationStack projectionStack;
    private Transformation topTransformation;
    private boolean usingSceneCoordinate = true;

    public TransformationManagerImpl(Canvas canvas) {
        this.canvas = canvas;
        this.listeners = new EventListenerList();
        this.modelViewStack = new TransformationStackImpl();
        this.projectionStack = new TransformationStackImpl();
        this.topTransformation = null;
        TransformationStackListener transformationStackListener = new TransformationStackListener(){

            @Override
            public void changed(TransformationStack transformationStack, TransformationStack.TransformationStackEvent transformationStackEvent, Transformation transformation) {
                TransformationManagerImpl.this.topTransformation = null;
                TransformationManagerImpl.this.fireTransformationChanged();
            }
        };
        this.modelViewStack.addListener(transformationStackListener);
        this.projectionStack.addListener(transformationStackListener);
    }

    @Override
    public void addListener(TransformationManagerListener transformationManagerListener) {
        this.listeners.add(TransformationManagerListener.class, transformationManagerListener);
    }

    @Override
    public void removeListener(TransformationManagerListener transformationManagerListener) {
        this.listeners.remove(TransformationManagerListener.class, transformationManagerListener);
    }

    @Override
    public TransformationStack getModelViewStack() {
        return this.modelViewStack;
    }

    @Override
    public TransformationStack getProjectionStack() {
        return this.projectionStack;
    }

    @Override
    public Transformation getTransformation() {
        if (this.topTransformation == null) {
            Transformation transformation;
            Transformation transformation2 = this.modelViewStack.peek();
            Transformation transformation3 = this.projectionStack.peek();
            this.topTransformation = transformation = transformation3.rightTimes(transformation2);
            return transformation;
        }
        return this.topTransformation;
    }

    @Override
    public Transformation getWindowTransformation() {
        double d = 2.0 / (double)this.canvas.getWidth();
        double d2 = 2.0 / (double)this.canvas.getHeight();
        try {
            return TransformationFactory.getAffineTransformation(new Vector3d(d, d2, 1.0), new Vector3d(-1.0, -1.0, 0.0));
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            throw new Error("Canvas is to big.", degenerateMatrixException);
        }
    }

    @Override
    public Transformation getInverseWindowTransformation() {
        double d = this.canvas.getWidth() / 2;
        double d2 = this.canvas.getHeight() / 2;
        try {
            return TransformationFactory.getAffineTransformation(new Vector3d(d, d2, 1.0), new Vector3d(d, d2, 0.0));
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            throw new Error("Canvas is to big.", degenerateMatrixException);
        }
    }

    @Override
    public Transformation getCanvasProjection() {
        double d = (double)this.canvas.getWidth() / 2.0;
        double d2 = (double)this.canvas.getHeight() / 2.0;
        try {
            Transformation transformation = TransformationFactory.getAffineTransformation(new Vector3d(d, d2, 1.0), new Vector3d(d, d2, 0.0));
            return transformation.rightTimes(this.getTransformation());
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            throw new Error("Canvas is to big.", degenerateMatrixException);
        }
    }

    @Override
    public Transformation getG2DProjection() {
        double d = (double)this.canvas.getWidth() / 2.0;
        double d2 = (double)this.canvas.getHeight() / 2.0;
        try {
            Transformation transformation = TransformationFactory.getAffineTransformation(new Vector3d(d, -d2, 1.0), new Vector3d(d, d2, 0.0));
            return transformation.rightTimes(this.getTransformation());
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            throw new Error("Canvas is to big.", degenerateMatrixException);
        }
    }

    @Override
    public Transformation getG2DSingleProjection() {
        double d = (double)this.canvas.getWidth() / 2.0;
        double d2 = (double)this.canvas.getHeight() / 2.0;
        try {
            Transformation transformation = TransformationFactory.getAffineTransformation(new Vector3d(d, -d2, 1.0), new Vector3d(d, d2, 0.0));
            return transformation.rightTimes(this.projectionStack.peek());
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            throw new Error("Canvas is to big.", degenerateMatrixException);
        }
    }

    @Override
    public Transformation getG2DWindowProjection() {
        double d = this.canvas.getHeight();
        try {
            return TransformationFactory.getAffineTransformation(new Vector3d(1.0, -1.0, 1.0), new Vector3d(0.0, d, 0.0));
        }
        catch (DegenerateMatrixException degenerateMatrixException) {
            throw new Error("Canvas is to big.", degenerateMatrixException);
        }
    }

    @Override
    public void reset() {
        this.modelViewStack.clear();
        this.projectionStack.clear();
    }

    @Override
    public void useWindowCoordinate() {
        if (this.isUsingSceneCoordinate()) {
            this.usingSceneCoordinate = false;
            this.fireTransformationChanged();
        }
    }

    @Override
    public void useSceneCoordinate() {
        if (!this.isUsingSceneCoordinate()) {
            this.usingSceneCoordinate = true;
            this.fireTransformationChanged();
        }
    }

    @Override
    public boolean isUsingSceneCoordinate() {
        return this.usingSceneCoordinate;
    }

    protected void fireTransformationChanged() {
        for (TransformationManagerListener transformationManagerListener : (TransformationManagerListener[])this.listeners.getListeners(TransformationManagerListener.class)) {
            transformationManagerListener.transformationChanged(this);
        }
    }
}

