/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.tranformations;

import java.awt.Dimension;
import org.scilab.forge.scirenderer.tranformations.DegenerateMatrixException;
import org.scilab.forge.scirenderer.tranformations.Rotation;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public final class TransformationFactory {
    static final Transformation IDENTITY_TRANSFORMATION = new IdentityTransformation();

    private TransformationFactory() {
    }

    public static Transformation getIdentity() {
        return IDENTITY_TRANSFORMATION;
    }

    public static Transformation getTranslateTransformation(double d, double d2, double d3) {
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            return IDENTITY_TRANSFORMATION;
        }
        return new TranslateTransformation(d, d2, d3);
    }

    private static Transformation getTranslateTransformation(Vector3d vector3d) {
        return TransformationFactory.getTranslateTransformation(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    public static Transformation getScaleTransformation(double d, double d2, double d3) throws DegenerateMatrixException {
        if (d == 1.0 && d2 == 1.0 && d3 == 1.0) {
            return IDENTITY_TRANSFORMATION;
        }
        if (d == 0.0 || d2 == 0.0 || d3 == 0.0) {
            throw new DegenerateMatrixException("Scale matrix with 0 factor.");
        }
        return new ScaleTransformation(d, d2, d3);
    }

    private static Transformation getScaleTransformation(Vector3d vector3d) throws DegenerateMatrixException {
        return TransformationFactory.getScaleTransformation(vector3d.getX(), vector3d.getY(), vector3d.getZ());
    }

    public static Transformation getScaleTransformation(double d) throws DegenerateMatrixException {
        return TransformationFactory.getScaleTransformation(d, d, d);
    }

    public static Transformation getRotationTransformation(double d, double d2, double d3, double d4) throws DegenerateMatrixException {
        if (d2 == 0.0 && d3 == 0.0 && d4 == 0.0) {
            throw new DegenerateMatrixException("Rotation axes should not be nul.");
        }
        if (d == 0.0) {
            return IDENTITY_TRANSFORMATION;
        }
        return new RotationTransformation(Rotation.getDegreeRotation(d, new Vector3d(d2, d3, d4)));
    }

    public static Transformation getRotationTransformation(Rotation rotation) {
        if (rotation.isIdentity()) {
            return IDENTITY_TRANSFORMATION;
        }
        return new RotationTransformation(rotation);
    }

    public static Transformation getPreferredAspectRatioTransformation(Dimension dimension, double d) throws DegenerateMatrixException {
        double d2 = dimension.getWidth() / dimension.getHeight();
        if (d2 > d) {
            return TransformationFactory.getScaleTransformation(1.0 / d2, 1.0, 1.0);
        }
        return TransformationFactory.getScaleTransformation(1.0, d2, 1.0);
    }

    public static Transformation getPerspectiveTransformation(double d, double d2, double d3) {
        return new PerspectiveTransformation(d, d2, d3);
    }

    public static Transformation getOrthographic(double d, double d2, double d3, double d4, double d5, double d6) {
        return new OrthographicTransformation(d, d2, d3, d4, d5, d6);
    }

    public static Transformation getAffineTransformation(Vector3d vector3d, Vector3d vector3d2) throws DegenerateMatrixException {
        return TransformationFactory.getTranslateTransformation(vector3d2).rightTimes(TransformationFactory.getScaleTransformation(vector3d));
    }

    private static double[] multiply(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double d = 0.0;
                for (int k = 0; k < 4; ++k) {
                    d += dArray[4 * k + j] * dArray2[4 * i + k];
                }
                dArray3[4 * i + j] = d;
            }
        }
        return dArray3;
    }

    private static class ProductTransformation
    extends AbstractTransformation {
        private final double[] matrix;
        private final double[] inverseMatrix;
        private final boolean isIdentity;

        public ProductTransformation(Transformation transformation, Transformation transformation2) {
            this.isIdentity = transformation.isIdentity() && transformation2.isIdentity();
            this.matrix = TransformationFactory.multiply(transformation.getMatrix(), transformation2.getMatrix());
            this.inverseMatrix = TransformationFactory.multiply(transformation2.getInverseMatrix(), transformation.getInverseMatrix());
        }

        @Override
        public boolean isIdentity() {
            return this.isIdentity;
        }

        @Override
        public double[] getMatrix() {
            return (double[])this.matrix.clone();
        }

        @Override
        public double[] getInverseMatrix() {
            return (double[])this.inverseMatrix.clone();
        }
    }

    private static class RotationTransformation
    extends AbstractTransformation {
        private final double[] matrix;
        private final double[] inverseMatrix;

        public RotationTransformation(Rotation rotation) {
            this.matrix = rotation.getRotationMatrix();
            this.inverseMatrix = rotation.getUnRotateMatrix();
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public double[] getMatrix() {
            return (double[])this.matrix.clone();
        }

        @Override
        public double[] getInverseMatrix() {
            return (double[])this.inverseMatrix.clone();
        }
    }

    private static class OrthographicTransformation
    extends AbstractTransformation {
        private final double[] matrix;
        private final double[] inverseMatrix;
        private final boolean isIdentity;

        public OrthographicTransformation(double d, double d2, double d3, double d4, double d5, double d6) {
            double d7 = (d2 + d) / (d - d2);
            double d8 = (d4 + d3) / (d3 - d4);
            double d9 = (d6 + d5) / (d5 - d6);
            this.matrix = new double[]{2.0 / (d2 - d), 0.0, 0.0, 0.0, 0.0, 2.0 / (d4 - d3), 0.0, 0.0, 0.0, 0.0, 2.0 / (d5 - d6), 0.0, d7, d8, d9, 1.0};
            this.inverseMatrix = new double[]{(d2 - d) / 2.0, 0.0, 0.0, 0.0, 0.0, (d4 - d3) / 2.0, 0.0, 0.0, 0.0, 0.0, (d5 - d6) / 2.0, 0.0, (d2 + d) / 2.0, (d4 + d3) / 2.0, -(d5 + d6) / 2.0, 1.0};
            this.isIdentity = d == -1.0 && d2 == 1.0 && d3 == -1.0 && d4 == 1.0 && d6 == -1.0 && d5 == 1.0;
        }

        @Override
        public boolean isIdentity() {
            return this.isIdentity;
        }

        @Override
        public double[] getMatrix() {
            return (double[])this.matrix.clone();
        }

        @Override
        public double[] getInverseMatrix() {
            return (double[])this.inverseMatrix.clone();
        }
    }

    private static class PerspectiveTransformation
    extends AbstractTransformation {
        private final double[] matrix;
        private final double[] inverseMatrix;

        PerspectiveTransformation(double d, double d2, double d3) {
            double d4 = Math.tan(Math.toRadians(d3 / 2.0));
            double d5 = 1.0 / d4;
            this.matrix = new double[]{d5, 0.0, 0.0, 0.0, 0.0, d5, 0.0, 0.0, 0.0, 0.0, (d2 + d) / (d - d2), -1.0, 0.0, 0.0, 2.0 * d2 * d / (d - d2), 0.0};
            this.inverseMatrix = new double[]{d4, 0.0, 0.0, 0.0, 0.0, d4, 0.0, 0.0, 0.0, 0.0, 0.0, (d - d2) / (2.0 * d2 * d), 0.0, 0.0, -1.0, (d + d2) / (2.0 * d2 * d)};
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public double[] getMatrix() {
            return (double[])this.matrix.clone();
        }

        @Override
        public double[] getInverseMatrix() {
            return (double[])this.inverseMatrix.clone();
        }
    }

    private static class ScaleTransformation
    extends AbstractTransformation {
        private final double x;
        private final double y;
        private final double z;

        public ScaleTransformation(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        @Override
        public Vector3d project(Vector3d vector3d) {
            return new Vector3d(vector3d.getX() * this.x, vector3d.getY() * this.y, vector3d.getZ() * this.z);
        }

        @Override
        public Vector3d unproject(Vector3d vector3d) {
            return new Vector3d(vector3d.getX() / this.x, vector3d.getY() / this.y, vector3d.getZ() / this.z);
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public double[] getMatrix() {
            return new double[]{this.x, 0.0, 0.0, 0.0, 0.0, this.y, 0.0, 0.0, 0.0, 0.0, this.z, 0.0, 0.0, 0.0, 0.0, 1.0};
        }

        @Override
        public double[] getInverseMatrix() {
            return new double[]{1.0 / this.x, 0.0, 0.0, 0.0, 0.0, 1.0 / this.y, 0.0, 0.0, 0.0, 0.0, 1.0 / this.z, 0.0, 0.0, 0.0, 0.0, 1.0};
        }
    }

    private static class TranslateTransformation
    extends AbstractTransformation {
        private final double x;
        private final double y;
        private final double z;

        public TranslateTransformation(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        @Override
        public Vector3d project(Vector3d vector3d) {
            return new Vector3d(vector3d.getX() + this.x, vector3d.getY() + this.y, vector3d.getZ() + this.z);
        }

        @Override
        public Vector3d unproject(Vector3d vector3d) {
            return new Vector3d(vector3d.getX() - this.x, vector3d.getY() - this.y, vector3d.getZ() - this.z);
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public double[] getMatrix() {
            return new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, this.x, this.y, this.z, 1.0};
        }

        @Override
        public double[] getInverseMatrix() {
            return new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, -this.x, -this.y, -this.z, 1.0};
        }
    }

    private static class IdentityTransformation
    extends AbstractTransformation {
        private static final double[] IDENTITY_MATRIX = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};

        IdentityTransformation() {
        }

        @Override
        public Transformation rightTimes(Transformation transformation) {
            return transformation;
        }

        @Override
        public Transformation leftTimes(Transformation transformation) {
            return transformation;
        }

        @Override
        public Vector3d project(Vector3d vector3d) {
            return vector3d;
        }

        @Override
        public Vector3d projectDirection(Vector3d vector3d) {
            return vector3d;
        }

        @Override
        public Vector3d unproject(Vector3d vector3d) {
            return vector3d;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public double[] getMatrix() {
            return (double[])IDENTITY_MATRIX.clone();
        }

        @Override
        public double[] getInverseMatrix() {
            return (double[])IDENTITY_MATRIX.clone();
        }
    }

    private static abstract class AbstractTransformation
    implements Transformation {
        private AbstractTransformation() {
        }

        @Override
        public Transformation rightTimes(Transformation transformation) {
            return this.getProductTransformation(this, transformation);
        }

        @Override
        public Transformation leftTimes(Transformation transformation) {
            return this.getProductTransformation(transformation, this);
        }

        @Override
        public Vector3d project(Vector3d vector3d) {
            double[] dArray = this.getMatrix();
            double d = dArray[0] * vector3d.getX() + dArray[4] * vector3d.getY() + dArray[8] * vector3d.getZ() + dArray[12];
            double d2 = dArray[1] * vector3d.getX() + dArray[5] * vector3d.getY() + dArray[9] * vector3d.getZ() + dArray[13];
            double d3 = dArray[2] * vector3d.getX() + dArray[6] * vector3d.getY() + dArray[10] * vector3d.getZ() + dArray[14];
            double d4 = dArray[3] * vector3d.getX() + dArray[7] * vector3d.getY() + dArray[11] * vector3d.getZ() + dArray[15];
            return new Vector3d(d / d4, d2 / d4, d3 / d4);
        }

        @Override
        public Vector3d projectDirection(Vector3d vector3d) {
            double[] dArray = this.getMatrix();
            double d = dArray[0] * vector3d.getX() + dArray[4] * vector3d.getY() + dArray[8] * vector3d.getZ();
            double d2 = dArray[1] * vector3d.getX() + dArray[5] * vector3d.getY() + dArray[9] * vector3d.getZ();
            double d3 = dArray[2] * vector3d.getX() + dArray[6] * vector3d.getY() + dArray[10] * vector3d.getZ();
            double d4 = dArray[3] * vector3d.getX() + dArray[7] * vector3d.getY() + dArray[11] * vector3d.getZ() + dArray[15];
            return new Vector3d(d / d4, d2 / d4, d3 / d4);
        }

        @Override
        public Vector3d unproject(Vector3d vector3d) {
            return this.getInverseTransformation().project(vector3d);
        }

        @Override
        public Transformation getInverseTransformation() {
            return new AbstractTransformation(){

                @Override
                public boolean isIdentity() {
                    return AbstractTransformation.this.isIdentity();
                }

                @Override
                public double[] getMatrix() {
                    return AbstractTransformation.this.getInverseMatrix();
                }

                @Override
                public double[] getInverseMatrix() {
                    return AbstractTransformation.this.getMatrix();
                }
            };
        }

        public String toString() {
            double[] dArray = this.getMatrix();
            String string = "";
            for (int i = 0; i < 16; ++i) {
                string = string + dArray[i];
                string = i % 4 == 3 ? string + "\n" : string + ", ";
            }
            return string;
        }

        private Transformation getProductTransformation(Transformation transformation, Transformation transformation2) {
            if (transformation.isIdentity()) {
                return transformation2;
            }
            if (transformation2.isIdentity()) {
                return transformation;
            }
            return new ProductTransformation(transformation, transformation2);
        }
    }
}

