/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.texture;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class TextureBufferedImage
extends BufferedImage {
    private static final int A_SHIFT = 24;
    private static final int R_SHIFT = 16;
    private static final int G_SHIFT = 8;
    private static final int B_SHIFT = 0;
    private static final int COMPONENT_MASK = 255;
    private static final int NB_COMPONENTS = 4;
    static JLabel label;

    public TextureBufferedImage(int n, int n2) {
        super(n, n2, 2);
    }

    public byte[] getRGBAData() {
        int[] nArray = ((DataBufferInt)this.getRaster().getDataBuffer()).getData();
        byte[] byArray = new byte[nArray.length * 4];
        int n = 0;
        for (int n2 : nArray) {
            byArray[n] = (byte)(n2 >> 16 & 0xFF);
            byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
            byArray[n + 2] = (byte)(n2 >> 0 & 0xFF);
            byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
            n += 4;
        }
        return byArray;
    }

    private static void updateFrame(TextureBufferedImage textureBufferedImage) {
        if (label == null) {
            JFrame jFrame = new JFrame("Test");
            jFrame.setLayout(new BorderLayout());
            label = new JLabel();
            jFrame.add((Component)label, "Center");
            jFrame.setSize(500, 500);
            jFrame.setVisible(true);
        }
        label.setIcon(new ImageIcon(textureBufferedImage));
    }

    public ByteBuffer getRGBABuffer() {
        return ByteBuffer.wrap(this.getRGBAData());
    }
}

