/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.texture;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import org.scilab.forge.scirenderer.shapes.appearance.Color;

public class TextEntity {
    public static final Color DEFAULT_TEXT_COLOR = new Color(0.0f, 0.0f, 0.0f);
    public static final boolean DEFAULT_TEXT_ANTI_ALIASED = true;
    public static final boolean DEFAULT_TEXT_USE_FRACTIONAL_METRICS = true;
    private static final Font DEFAULT_FONT = new Font(null);
    private Color textColor = DEFAULT_TEXT_COLOR;
    private boolean textAntiAliased = true;
    private boolean textUseFractionalMetrics = true;
    private String text;
    private Font font;

    public TextEntity(String string) {
        this.text = string;
        this.font = DEFAULT_FONT;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public boolean isTextAntiAliased() {
        return this.textAntiAliased;
    }

    public void setTextAntiAliased(boolean bl) {
        this.textAntiAliased = bl;
    }

    public boolean isTextUseFractionalMetrics() {
        return this.textUseFractionalMetrics;
    }

    public void setTextUseFractionalMetrics(boolean bl) {
        this.textUseFractionalMetrics = bl;
    }

    public boolean isValid() {
        return this.getFont() != null && this.getText() != null && this.getText().length() > 0;
    }

    public Dimension getSize() {
        if (this.isValid()) {
            FontRenderContext fontRenderContext = new FontRenderContext(null, this.isTextAntiAliased(), this.isTextUseFractionalMetrics());
            TextLayout textLayout = new TextLayout(this.getText(), this.getFont(), fontRenderContext);
            Dimension dimension = new Dimension();
            Rectangle2D rectangle2D = textLayout.getBounds();
            dimension.setSize(rectangle2D.getWidth() + 2.0, rectangle2D.getHeight() + 1.0);
            return dimension;
        }
        return new Dimension(0, 0);
    }
}

