/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.texture;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.scilab.forge.scirenderer.data.AbstractDataProvider;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;

public abstract class AbstractTextureDataProvider
extends AbstractDataProvider<Texture>
implements TextureDataProvider {
    @Override
    public BufferedImage getImage() {
        ByteBuffer byteBuffer = this.getData();
        if (byteBuffer == null) {
            return null;
        }
        byteBuffer.rewind();
        Dimension dimension = this.getTextureSize();
        int n = dimension.width;
        int n2 = dimension.height;
        int[] nArray = new int[byteBuffer.capacity() / 4];
        byte[] byArray = new byte[4];
        for (int i = 0; i < nArray.length; ++i) {
            byteBuffer.get(byArray);
            nArray[i] = ((byArray[3] & 0xFF) << 24) + ((byArray[0] & 0xFF) << 16) + ((byArray[1] & 0xFF) << 8) + (byArray[2] & 0xFF);
        }
        byteBuffer.rewind();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        return bufferedImage;
    }

    @Override
    public BufferedImage getSubImage(int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage = this.getImage();
        if (bufferedImage == null) {
            return null;
        }
        return bufferedImage.getSubimage(n, n2, n3, n4);
    }
}

