/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.texture;

import org.scilab.forge.scirenderer.texture.DrawnTextureDataProvider;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDataProvider;
import org.scilab.forge.scirenderer.texture.TextureDrawer;

public class AbstractTexture
implements Texture {
    protected TextureDataProvider textureDataProvider;
    protected boolean upToDate = false;
    private Texture.Filter magnificationFilter = Texture.Filter.NEAREST;
    private Texture.Filter minifyingFilter = Texture.Filter.NEAREST;
    private Texture.Wrap sWrappingMode = Texture.Wrap.CLAMP;
    private Texture.Wrap tWrappingMode = Texture.Wrap.CLAMP;

    @Override
    public synchronized boolean isValid() {
        return this.textureDataProvider != null && this.textureDataProvider.isValid();
    }

    @Override
    public Texture.Wrap getSWrappingMode() {
        return this.sWrappingMode;
    }

    @Override
    public void setSWrappingMode(Texture.Wrap wrap) {
        this.sWrappingMode = wrap;
    }

    @Override
    public Texture.Wrap getTWrappingMode() {
        return this.tWrappingMode;
    }

    @Override
    public void setTWrappingMode(Texture.Wrap wrap) {
        this.tWrappingMode = wrap;
    }

    @Override
    public Texture.Filter getMinifyingFilter() {
        return this.minifyingFilter;
    }

    @Override
    public void setMinifyingFilter(Texture.Filter filter) {
        this.minifyingFilter = filter;
    }

    @Override
    public Texture.Filter getMagnificationFilter() {
        return this.magnificationFilter;
    }

    @Override
    public void setMagnificationFilter(Texture.Filter filter) {
        this.magnificationFilter = filter;
    }

    @Override
    public synchronized TextureDataProvider getDataProvider() {
        return this.textureDataProvider;
    }

    @Override
    public synchronized void setDataProvider(TextureDataProvider textureDataProvider) {
        if (this.textureDataProvider != null) {
            this.textureDataProvider.removeDataUser(this);
        }
        this.textureDataProvider = textureDataProvider;
        this.upToDate = false;
        if (this.textureDataProvider != null) {
            this.textureDataProvider.addDataUser(this);
        }
    }

    @Override
    public void setDrawer(TextureDrawer textureDrawer) {
        this.setDataProvider(new DrawnTextureDataProvider(textureDrawer));
    }

    @Override
    public void dataUpdated() {
        this.upToDate = false;
    }

    @Override
    public double getSScaleFactor() {
        return 1.0;
    }

    @Override
    public double getTScaleFactor() {
        return 1.0;
    }
}

