/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.ruler.graduations;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.scilab.forge.scirenderer.ruler.graduations.Graduations;

public abstract class AbstractGraduations
implements Graduations {
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private final boolean isLowerBoundIncluded;
    private final boolean isUpperBoundIncluded;
    private final double lowerBound;
    private final double upperBound;
    private final Graduations parentGraduations;
    private DecimalFormat numberFormat;
    private List<Double> subValues;

    public AbstractGraduations(Graduations graduations) {
        this.parentGraduations = graduations;
        this.isLowerBoundIncluded = graduations.isLowerBoundIncluded();
        this.isUpperBoundIncluded = graduations.isUpperBoundIncluded();
        this.lowerBound = graduations.getLowerBound();
        this.upperBound = graduations.getUpperBound();
    }

    public AbstractGraduations(double d, boolean bl, double d2, boolean bl2) {
        this.parentGraduations = null;
        this.isLowerBoundIncluded = bl;
        this.isUpperBoundIncluded = bl2;
        this.lowerBound = d;
        this.upperBound = d2;
    }

    public AbstractGraduations(double d, double d2) {
        this.parentGraduations = null;
        this.isLowerBoundIncluded = true;
        this.isUpperBoundIncluded = true;
        this.lowerBound = d;
        this.upperBound = d2;
    }

    public AbstractGraduations(Graduations graduations, double d, boolean bl, double d2, boolean bl2) {
        this.parentGraduations = graduations;
        this.isLowerBoundIncluded = bl;
        this.isUpperBoundIncluded = bl2;
        this.lowerBound = d;
        this.upperBound = d2;
    }

    @Override
    public final double getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public final boolean isLowerBoundIncluded() {
        return this.isLowerBoundIncluded;
    }

    @Override
    public final double getUpperBound() {
        return this.upperBound;
    }

    @Override
    public final boolean isUpperBoundIncluded() {
        return this.isUpperBoundIncluded;
    }

    @Override
    public final Graduations getParentGraduations() {
        return this.parentGraduations;
    }

    @Override
    public final boolean contain(double d) {
        if (d == this.lowerBound) {
            return this.isLowerBoundIncluded;
        }
        if (d == this.upperBound) {
            return this.isUpperBoundIncluded;
        }
        return this.lowerBound < d && d < this.upperBound;
    }

    public final boolean containRelative(double d) {
        if (d == 0.0) {
            return this.isLowerBoundIncluded;
        }
        if (d == this.upperBound - this.lowerBound || Math.abs(1.0 - d / (this.upperBound - this.lowerBound)) <= 1.0E-15) {
            return this.isUpperBoundIncluded;
        }
        return 0.0 < d && d < this.upperBound - this.lowerBound;
    }

    @Override
    public final DecimalFormat getFormat() {
        if (this.numberFormat == null) {
            double d = Math.max(Math.abs(this.lowerBound), Math.abs(this.upperBound));
            this.numberFormat = d < 0.001 || d >= 1000000.0 ? new DecimalFormat("0.##########E00") : (d < 1.0 ? new DecimalFormat("0.######") : new DecimalFormat());
            DecimalFormatSymbols decimalFormatSymbols = this.numberFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setExponentSeparator("e");
            this.numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        return this.numberFormat;
    }

    @Override
    public List<Double> getSubGraduations(int n) {
        if (this.subValues == null) {
            List<Double> list = this.getAllValues();
            if (n == 0 || list.size() == 0) {
                this.subValues = new LinkedList<Double>();
            } else {
                Collections.sort(list);
                this.subValues = new LinkedList<Double>();
                for (int i = 0; i < list.size() - 1; ++i) {
                    double d = list.get(i);
                    double d2 = list.get(i + 1);
                    double d3 = (d2 - d) / (double)(n + 1);
                    double d4 = d;
                    for (int j = 0; j <= n; ++j) {
                        this.subValues.add(d4);
                        d4 += d3;
                    }
                }
                this.subValues.add(list.get(list.size() - 1));
            }
        }
        return this.subValues;
    }

    public final String toString() {
        String string = this.isLowerBoundIncluded ? LEFT_BRACKET : RIGHT_BRACKET;
        String string2 = this.isUpperBoundIncluded ? RIGHT_BRACKET : LEFT_BRACKET;
        return "Graduation " + string + this.getFormat().format(this.lowerBound) + ", " + this.getFormat().format(this.upperBound) + string2;
    }
}

