/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.texture;

import com.jogamp.opengl.util.awt.TextureRenderer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.texture.AbstractTexture;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureManager;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.TransformationManager;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class JoGLTextureManager
implements TextureManager {
    private final Set<JoGLTexture> allTextures = new HashSet<JoGLTexture>();
    private final Set<JoGLTexture> toDispose = new HashSet<JoGLTexture>();
    JoGLCanvas canvas;

    public JoGLTextureManager(JoGLCanvas joGLCanvas) {
        this.canvas = joGLCanvas;
    }

    public void bind(JoGLDrawingTools joGLDrawingTools, org.scilab.forge.scirenderer.texture.Texture texture) throws SciRendererException {
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture)) {
            ((JoGLTexture)texture).bind(joGLDrawingTools);
        }
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, org.scilab.forge.scirenderer.texture.Texture texture) throws SciRendererException {
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture)) {
            JoGLTexture joGLTexture = (JoGLTexture)texture;
            joGLTexture.preDraw(joGLDrawingTools);
            joGLTexture.draw(joGLDrawingTools);
            joGLTexture.postDraw(joGLDrawingTools);
        }
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, org.scilab.forge.scirenderer.texture.Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, double d) throws SciRendererException {
        FloatBuffer floatBuffer;
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture) && elementsBuffer != null && (floatBuffer = elementsBuffer.getData()) != null) {
            floatBuffer.rewind();
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
            JoGLTexture joGLTexture = (JoGLTexture)texture;
            joGLTexture.preDraw(joGLDrawingTools);
            while (floatBuffer.remaining() >= 4) {
                floatBuffer.get(fArray);
                joGLTexture.draw(joGLDrawingTools, anchorPosition, new Vector3d(fArray), d);
            }
            joGLTexture.postDraw(joGLDrawingTools);
        }
    }

    public void draw(JoGLDrawingTools joGLDrawingTools, org.scilab.forge.scirenderer.texture.Texture texture, AnchorPosition anchorPosition, Vector3d vector3d, double d) throws SciRendererException {
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture)) {
            JoGLTexture joGLTexture = (JoGLTexture)texture;
            joGLTexture.preDraw(joGLDrawingTools);
            joGLTexture.draw(joGLDrawingTools, anchorPosition, vector3d, d);
            joGLTexture.postDraw(joGLDrawingTools);
        }
    }

    public void glReload() {
        for (JoGLTexture joGLTexture : this.allTextures) {
            joGLTexture.glReload();
        }
    }

    @Override
    public org.scilab.forge.scirenderer.texture.Texture createTexture() {
        JoGLTexture joGLTexture = new JoGLTexture();
        this.allTextures.add(joGLTexture);
        return joGLTexture;
    }

    @Override
    public void dispose(Collection<org.scilab.forge.scirenderer.texture.Texture> collection) {
        for (org.scilab.forge.scirenderer.texture.Texture texture : collection) {
            this.dispose(texture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(org.scilab.forge.scirenderer.texture.Texture texture) {
        if (texture instanceof JoGLTexture && this.allTextures.contains((JoGLTexture)texture)) {
            this.allTextures.remove((JoGLTexture)texture);
            Set<JoGLTexture> set = this.toDispose;
            synchronized (set) {
                this.toDispose.add((JoGLTexture)texture);
            }
        }
    }

    public class JoGLTexture
    extends AbstractTexture
    implements org.scilab.forge.scirenderer.texture.Texture {
        private Texture[] textures;
        private int wCuts;
        private int hCuts;
        private double sfactor = 1.0;
        private double tfactor = 1.0;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void bind(JoGLDrawingTools joGLDrawingTools) throws SciRendererException {
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            if (!this.isValid()) throw new SciRendererException("Texture have no data.");
            this.checkData(joGLDrawingTools);
            if (this.textures.length != 1) throw new SciRendererException("Texture is too large");
            gL2.glEnable(3553);
            gL2.glEnable(3042);
            gL2.glBlendFunc(1, 771);
            gL2.glTexEnvi(8960, 8704, 7681);
            this.textures[0].setTexParameteri(gL2, 10240, this.getAsGLFilter(this.getMagnificationFilter(), false));
            this.textures[0].setTexParameteri(gL2, 10241, this.getAsGLFilter(this.getMinifyingFilter(), false));
            if (gL2.isNPOTTextureAvailable()) {
                this.textures[0].setTexParameteri(gL2, 10242, this.getAsGLWrappingMode(this.getSWrappingMode()));
                this.textures[0].setTexParameteri(gL2, 10243, this.getAsGLWrappingMode(this.getTWrappingMode()));
            } else {
                this.textures[0].setTexParameteri(gL2, 10242, 33071);
                this.textures[0].setTexParameteri(gL2, 10243, 33071);
            }
            gL2.glTexEnvi(8960, 8704, 7681);
            this.textures[0].bind(gL2);
            Dimension dimension = this.getDataProvider().getTextureSize();
            this.sfactor = (double)dimension.width / (double)this.textures[0].getWidth();
            this.tfactor = (double)dimension.height / (double)this.textures[0].getHeight();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void checkData(JoGLDrawingTools joGLDrawingTools) throws SciRendererException {
            Object object;
            Object object2 = JoGLTextureManager.this.toDispose;
            synchronized (object2) {
                if (!JoGLTextureManager.this.toDispose.isEmpty()) {
                    object = joGLDrawingTools.getGl().getGL2();
                    for (JoGLTexture joGLTexture : JoGLTextureManager.this.toDispose) {
                        joGLTexture.releaseTextures((GL2)object);
                    }
                    JoGLTextureManager.this.toDispose.clear();
                }
            }
            if (this.isValid() && !this.upToDate) {
                object2 = joGLDrawingTools.getGl().getGL2();
                this.releaseTextures((GL2)object2);
                object = this.getDataProvider().getTextureSize();
                int n = joGLDrawingTools.getGLCapacity().getMaximumTextureSize();
                this.wCuts = (int)Math.ceil(((Dimension)object).getWidth() / (double)n);
                this.hCuts = (int)Math.ceil(((Dimension)object).getHeight() / (double)n);
                this.textures = new Texture[this.wCuts * this.hCuts];
                int n2 = 0;
                for (int i = 0; i < this.wCuts; ++i) {
                    for (int j = 0; j < this.hCuts; ++j) {
                        int n3 = i * n;
                        int n4 = j * n;
                        int n5 = this.getSubTextureSize(i == this.wCuts - 1, ((Dimension)object).width, n);
                        int n6 = this.getSubTextureSize(j == this.hCuts - 1, ((Dimension)object).height, n);
                        TextureRenderer textureRenderer = new TextureRenderer(n5, n6, true, false);
                        Graphics2D graphics2D = textureRenderer.createGraphics();
                        graphics2D.setComposite(AlphaComposite.Src);
                        graphics2D.drawImage(this.getDataProvider().getSubImage(n3, n4, n5, n6), null, 0, 0);
                        graphics2D.dispose();
                        textureRenderer.markDirty(0, 0, n5, n6);
                        this.textures[n2] = textureRenderer.getTexture();
                        ++n2;
                    }
                }
                this.upToDate = true;
            }
        }

        private void releaseTextures(GL2 gL2) {
            if (this.textures != null) {
                for (Texture texture : this.textures) {
                    texture.destroy(gL2);
                }
                this.textures = null;
            }
        }

        public void preDraw(JoGLDrawingTools joGLDrawingTools) throws SciRendererException {
            this.checkData(joGLDrawingTools);
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            gL2.glMatrixMode(5890);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glMatrixMode(5889);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glEnable(3553);
            gL2.glEnable(3042);
            gL2.glBlendFunc(1, 771);
            gL2.glEnable(3008);
            gL2.glAlphaFunc(516, 0.0f);
            gL2.glPushAttrib(1048575);
            gL2.glTexEnvi(8960, 8704, 7681);
            for (int i = 0; i < this.wCuts * this.hCuts; ++i) {
                this.textures[i].enable(gL2);
                this.textures[i].setTexParameteri(gL2, 10240, this.getAsGLFilter(this.getMagnificationFilter(), false));
                this.textures[i].setTexParameteri(gL2, 10241, this.getAsGLFilter(this.getMinifyingFilter(), false));
                if (gL2.isNPOTTextureAvailable()) {
                    this.textures[i].setTexParameteri(gL2, 10242, this.getAsGLWrappingMode(this.getSWrappingMode()));
                    this.textures[i].setTexParameteri(gL2, 10243, this.getAsGLWrappingMode(this.getTWrappingMode()));
                } else {
                    this.textures[i].setTexParameteri(gL2, 10242, 33071);
                    this.textures[i].setTexParameteri(gL2, 10243, 33071);
                }
                this.textures[i].bind(gL2);
            }
        }

        public void draw(JoGLDrawingTools joGLDrawingTools, AnchorPosition anchorPosition, Vector3d vector3d, double d) throws SciRendererException {
            TransformationManager transformationManager = joGLDrawingTools.getTransformationManager();
            Transformation transformation = transformationManager.getCanvasProjection();
            boolean bl = joGLDrawingTools.getTransformationManager().isUsingSceneCoordinate();
            Dimension dimension = joGLDrawingTools.getCanvas().getDimension();
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            Vector3d vector3d2 = bl ? transformation.project(vector3d) : vector3d;
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glOrtho(0.0, dimension.width, 0.0, dimension.height, 1.0, -1.0);
            if (d == 0.0) {
                gL2.glTranslated(Math.round(vector3d2.getX() + this.getAnchorDeltaX(anchorPosition)), Math.round(vector3d2.getY() + this.getAnchorDeltaY(anchorPosition)), vector3d2.getZ());
            } else {
                gL2.glTranslated(Math.round(vector3d2.getX()), Math.round(vector3d2.getY()), vector3d2.getZ());
                gL2.glRotated(d, 0.0, 0.0, 1.0);
                gL2.glTranslated(Math.round(this.getAnchorDeltaX(anchorPosition)), Math.round(this.getAnchorDeltaY(anchorPosition)), 0.0);
            }
            this.draw(joGLDrawingTools);
            gL2.glMatrixMode(5888);
            gL2.glPopMatrix();
        }

        public void postDraw(JoGLDrawingTools joGLDrawingTools) {
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            for (int i = 0; i < this.wCuts * this.hCuts; ++i) {
                this.textures[i].disable(gL2);
            }
            gL2.glPopAttrib();
            gL2.glDisable(3008);
            gL2.glDisable(3553);
            gL2.glDisable(3042);
            gL2.glMatrixMode(5889);
            gL2.glPopMatrix();
            gL2.glMatrixMode(5890);
            gL2.glPopMatrix();
        }

        public void draw(JoGLDrawingTools joGLDrawingTools) throws SciRendererException {
            int n = joGLDrawingTools.getGLCapacity().getMaximumTextureSize();
            Dimension dimension = this.getDataProvider().getTextureSize();
            GL2 gL2 = joGLDrawingTools.getGl().getGL2();
            if (dimension != null) {
                int n2 = 0;
                for (int i = 0; i < this.wCuts; ++i) {
                    for (int j = 0; j < this.hCuts; ++j) {
                        int n3 = i * n;
                        int n4 = j * n;
                        int n5 = this.getSubTextureSize(i == this.wCuts - 1, dimension.width, n);
                        int n6 = this.getSubTextureSize(j == this.hCuts - 1, dimension.height, n);
                        TextureCoords textureCoords = this.textures[n2].getSubImageTexCoords(0, 0, n5, n6);
                        gL2.glBegin(7);
                        gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
                        gL2.glVertex2f(n3, n4);
                        gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
                        gL2.glVertex2f(n3 + n5, n4);
                        gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
                        gL2.glVertex2f(n3 + n5, n4 + n6);
                        gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
                        gL2.glVertex2f(n3, n4 + n6);
                        gL2.glEnd();
                        ++n2;
                    }
                }
            }
        }

        @Override
        public double getSScaleFactor() {
            return this.sfactor;
        }

        @Override
        public double getTScaleFactor() {
            return this.tfactor;
        }

        private int getSubTextureSize(boolean bl, int n, int n2) {
            if (bl) {
                int n3 = n % n2;
                if (n3 == 0) {
                    return n2;
                }
                return n3;
            }
            return n2;
        }

        private int getAsGLWrappingMode(Texture.Wrap wrap) {
            switch (wrap) {
                case CLAMP: {
                    return 33071;
                }
                case REPEAT: {
                    return 10497;
                }
            }
            return 10497;
        }

        private int getAsGLFilter(Texture.Filter filter, boolean bl) {
            int n;
            if (bl) {
                switch (filter) {
                    case LINEAR: {
                        n = 9987;
                        break;
                    }
                    case NEAREST: {
                        n = 9984;
                        break;
                    }
                    default: {
                        n = 9728;
                        break;
                    }
                }
            } else {
                switch (filter) {
                    case LINEAR: {
                        n = 9729;
                        break;
                    }
                    case NEAREST: {
                        n = 9728;
                        break;
                    }
                    default: {
                        n = 9728;
                    }
                }
            }
            return n;
        }

        public void glReload() {
            this.textures = null;
            this.upToDate = false;
        }

        protected double getAnchorDeltaX(AnchorPosition anchorPosition) {
            int n = this.getDataProvider().getTextureSize().width;
            switch (anchorPosition) {
                case LEFT: 
                case LOWER_LEFT: 
                case UPPER_LEFT: {
                    return 0.0;
                }
                case UP: 
                case CENTER: 
                case DOWN: {
                    return (float)(-n) / 2.0f;
                }
                case RIGHT: 
                case LOWER_RIGHT: 
                case UPPER_RIGHT: {
                    return -n;
                }
            }
            return 0.0;
        }

        protected double getAnchorDeltaY(AnchorPosition anchorPosition) {
            int n = this.getDataProvider().getTextureSize().height;
            switch (anchorPosition) {
                case UPPER_LEFT: 
                case UP: 
                case UPPER_RIGHT: {
                    return -n;
                }
                case LEFT: 
                case CENTER: 
                case RIGHT: {
                    return (float)(-n) / 2.0f;
                }
                case LOWER_LEFT: 
                case DOWN: 
                case LOWER_RIGHT: {
                    return 0.0;
                }
            }
            return 0.0;
        }
    }
}

