/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.lightning;

import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.implementation.jogl.lightning.JoGLLight;
import org.scilab.forge.scirenderer.implementation.jogl.utils.GLShortCuts;
import org.scilab.forge.scirenderer.lightning.Light;
import org.scilab.forge.scirenderer.lightning.LightManager;

public class JoGLLightManager
implements LightManager {
    private final JoGLDrawingTools drawingTools;
    private final JoGLLight[] lights;
    private boolean isLightningEnable = false;

    public JoGLLightManager(JoGLDrawingTools joGLDrawingTools) {
        this.drawingTools = joGLDrawingTools;
        this.lights = new JoGLLight[this.getLightNumber()];
    }

    @Override
    public int getLightNumber() {
        return this.drawingTools.getGLCapacity().getLightNumber();
    }

    @Override
    public Light getLight(int n) {
        if (n < 0 || n >= this.getLightNumber()) {
            return null;
        }
        if (this.lights[n] == null) {
            this.lights[n] = new JoGLLight(this.drawingTools.getGl(), n);
        }
        return this.lights[n];
    }

    @Override
    public void setLightningEnable(boolean bl) {
        this.isLightningEnable = bl;
        GLShortCuts.setEnable(this.drawingTools.getGl().getGL2(), 2896, bl);
    }

    @Override
    public boolean isLightningEnable() {
        return this.isLightningEnable;
    }

    public void reload() {
        GL2 gL2 = this.drawingTools.getGl().getGL2();
        GLShortCuts.setEnable(gL2, 2896, this.isLightningEnable);
        for (JoGLLight joGLLight : this.lights) {
            if (joGLLight == null) continue;
            joGLLight.reload(gL2);
        }
    }
}

