/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl.clipping;

import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.clipping.ClippingManager;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLDrawingTools;
import org.scilab.forge.scirenderer.implementation.jogl.clipping.JoGLClippingPlane;

public class JoGLClippingManager
implements ClippingManager {
    private final JoGLDrawingTools drawingTools;
    private final JoGLClippingPlane[] clippingPlanes;

    public JoGLClippingManager(JoGLDrawingTools joGLDrawingTools) {
        this.drawingTools = joGLDrawingTools;
        this.clippingPlanes = new JoGLClippingPlane[this.getClippingPlaneNumber()];
    }

    @Override
    public int getClippingPlaneNumber() {
        return this.drawingTools.getGLCapacity().getClippingPlaneNumber();
    }

    @Override
    public JoGLClippingPlane getClippingPlane(int n) {
        if (n < 0 || n >= this.getClippingPlaneNumber()) {
            return null;
        }
        if (this.clippingPlanes[n] == null) {
            this.clippingPlanes[n] = new JoGLClippingPlane(this.drawingTools.getGl().getGL2(), n);
        }
        return this.clippingPlanes[n];
    }

    @Override
    public void disableClipping() {
        for (JoGLClippingPlane joGLClippingPlane : this.clippingPlanes) {
            if (joGLClippingPlane == null) continue;
            joGLClippingPlane.setEnable(false);
        }
    }

    public void reload() {
        GL2 gL2 = this.drawingTools.getGl().getGL2();
        for (JoGLClippingPlane joGLClippingPlane : this.clippingPlanes) {
            if (joGLClippingPlane == null) continue;
            joGLClippingPlane.reload(gL2);
        }
    }
}

