/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.jogl;

import java.awt.Color;
import javax.media.opengl.GL2;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.clipping.ClippingManager;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCanvas;
import org.scilab.forge.scirenderer.implementation.jogl.JoGLCapacity;
import org.scilab.forge.scirenderer.implementation.jogl.clipping.JoGLClippingManager;
import org.scilab.forge.scirenderer.implementation.jogl.drawer.JoGLShapeDrawer;
import org.scilab.forge.scirenderer.implementation.jogl.lightning.JoGLLightManager;
import org.scilab.forge.scirenderer.lightning.LightManager;
import org.scilab.forge.scirenderer.renderer.Renderer;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.TransformationManager;
import org.scilab.forge.scirenderer.tranformations.TransformationManagerImpl;
import org.scilab.forge.scirenderer.tranformations.TransformationManagerListener;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class JoGLDrawingTools
implements DrawingTools {
    private final JoGLCapacity capacity = new JoGLCapacity();
    private final TransformationManager transformationManager;
    private final JoGLLightManager lightManager;
    private final JoGLClippingManager clippingManager;
    private final JoGLCanvas canvas;
    private GL2 gl;

    JoGLDrawingTools(JoGLCanvas joGLCanvas) {
        this.transformationManager = new TransformationManagerImpl(joGLCanvas);
        this.lightManager = new JoGLLightManager(this);
        this.clippingManager = new JoGLClippingManager(this);
        this.canvas = joGLCanvas;
        this.transformationManager.addListener(new TransformationManagerListener(){

            @Override
            public void transformationChanged(TransformationManager transformationManager) {
                JoGLDrawingTools.this.gl.glMatrixMode(5888);
                if (transformationManager.isUsingSceneCoordinate()) {
                    JoGLDrawingTools.this.gl.glLoadMatrixd(transformationManager.getTransformation().getMatrix(), 0);
                } else {
                    JoGLDrawingTools.this.gl.glLoadMatrixd(transformationManager.getWindowTransformation().getMatrix(), 0);
                }
            }
        });
    }

    void glSynchronize(GL2 gL2) {
        this.gl = gL2;
        this.transformationManager.reset();
        this.capacity.glReload(gL2);
        this.lightManager.reload();
        this.clippingManager.reload();
    }

    @Override
    public JoGLCanvas getCanvas() {
        return this.canvas;
    }

    public GL2 getGl() {
        return this.gl;
    }

    public JoGLCapacity getGLCapacity() {
        return this.capacity;
    }

    @Override
    public TransformationManager getTransformationManager() {
        return this.transformationManager;
    }

    @Override
    public LightManager getLightManager() {
        return this.lightManager;
    }

    @Override
    public ClippingManager getClippingManager() {
        return this.clippingManager;
    }

    @Override
    public void clear(org.scilab.forge.scirenderer.shapes.appearance.Color color) {
        this.gl.glClearColor(color.getRedAsFloat(), color.getGreenAsFloat(), color.getBlueAsFloat(), 1.0f);
        this.gl.glClear(16384);
    }

    @Override
    public void clear(Color color) {
        float[] fArray = color.getRGBColorComponents(null);
        this.gl.glClearColor(fArray[0], fArray[1], fArray[2], 1.0f);
        this.gl.glClear(16384);
    }

    @Override
    public void clearDepthBuffer() {
        this.gl.glClear(256);
    }

    @Override
    public void draw(Renderer renderer) {
        this.canvas.getRendererManager().draw(this, renderer);
    }

    @Override
    public void draw(Geometry geometry) throws SciRendererException {
        JoGLShapeDrawer.getDrawer().draw(this, geometry, Appearance.getDefault());
    }

    @Override
    public void draw(Geometry geometry, Appearance appearance) throws SciRendererException {
        JoGLShapeDrawer.getDrawer().draw(this, geometry, appearance);
    }

    @Override
    public void draw(Texture texture) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, elementsBuffer, 0.0);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, double d) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, elementsBuffer, d);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, Vector3d vector3d) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, vector3d, 0.0);
    }

    @Override
    public void draw(Texture texture, AnchorPosition anchorPosition, Vector3d vector3d, double d) throws SciRendererException {
        this.canvas.getTextureManager().draw(this, texture, anchorPosition, vector3d, d);
    }

    public void bind(Texture texture) throws SciRendererException {
        this.canvas.getTextureManager().bind(this, texture);
    }
}

