/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.texture;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.scirenderer.SciRendererException;
import org.scilab.forge.scirenderer.implementation.g2d.G2DCanvas;
import org.scilab.forge.scirenderer.implementation.g2d.G2DDrawingTools;
import org.scilab.forge.scirenderer.texture.AbstractTexture;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.texture.TextureDrawer;
import org.scilab.forge.scirenderer.texture.TextureManager;

public class G2DTextureManager
implements TextureManager {
    private static Map<ImageBuffer, ImageBuffer> images = new HashMap<ImageBuffer, ImageBuffer>();

    public G2DTextureManager(G2DCanvas g2DCanvas) {
    }

    public static void clear() {
        images.clear();
    }

    public void draw(G2DDrawingTools g2DDrawingTools, Texture texture) throws SciRendererException {
        if (texture instanceof G2DTexture) {
            ((G2DTexture)texture).draw(g2DDrawingTools);
        }
    }

    @Override
    public Texture createTexture() {
        return new G2DTexture();
    }

    @Override
    public void dispose(Collection<Texture> collection) {
        for (Texture texture : collection) {
            this.dispose(texture);
        }
    }

    @Override
    public void dispose(Texture texture) {
        if (texture instanceof G2DTexture) {
            ((G2DTexture)texture).dispose();
        }
    }

    private static class ImageBuffer {
        private byte[] buffer;
        private int hash;
        private int width;
        private int height;
        private BufferedImage image;

        ImageBuffer(byte[] byArray, int n, int n2) {
            this.buffer = byArray;
            this.hash = Arrays.hashCode(byArray);
            this.width = n;
            this.height = n2;
        }

        BufferedImage getImage() {
            if (this.image == null) {
                int[] nArray = new int[this.buffer.length / 4];
                for (int i = 0; i < nArray.length; ++i) {
                    int n = this.buffer[4 * i + 3] & 0xFF;
                    int n2 = this.buffer[4 * i] & 0xFF;
                    int n3 = this.buffer[4 * i + 1] & 0xFF;
                    int n4 = this.buffer[4 * i + 2] & 0xFF;
                    nArray[i] = n << 24 | n2 << 16 | n3 << 8 | n4;
                }
                this.image = new BufferedImage(this.width, this.height, 2);
                this.image.setRGB(0, 0, this.width, this.height, nArray, 0, this.width);
            }
            return this.image;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ImageBuffer) {
                ImageBuffer imageBuffer = (ImageBuffer)object;
                return Arrays.equals(this.buffer, imageBuffer.buffer);
            }
            return false;
        }
    }

    public class G2DTexture
    extends AbstractTexture
    implements Texture {
        private ImageBuffer image;
        private TextureDrawer drawer;

        public void dispose() {
            images.remove(this.image);
        }

        @Override
        public void setDrawer(TextureDrawer textureDrawer) {
            this.drawer = textureDrawer;
            super.setDrawer(textureDrawer);
        }

        public TextureDrawer getDrawer() {
            return this.drawer;
        }

        public void draw(G2DDrawingTools g2DDrawingTools) {
            g2DDrawingTools.getMotor3D().drawTexture(g2DDrawingTools, this.getImage(), this);
        }

        public BufferedImage getImage() {
            if (this.image == null) {
                byte[] byArray;
                Dimension dimension = this.getDataProvider().getTextureSize();
                ByteBuffer byteBuffer = this.getDataProvider().getData();
                if (byteBuffer.hasArray()) {
                    byArray = byteBuffer.array();
                } else {
                    byArray = new byte[byteBuffer.capacity()];
                    byteBuffer.get(byArray);
                }
                ImageBuffer imageBuffer = new ImageBuffer(byArray, (int)dimension.getWidth(), (int)dimension.getHeight());
                ImageBuffer imageBuffer2 = (ImageBuffer)images.get(imageBuffer);
                if (imageBuffer2 == null) {
                    images.put(imageBuffer, imageBuffer);
                    imageBuffer2 = imageBuffer;
                }
                this.image = imageBuffer2;
            }
            return this.image.getImage();
        }
    }
}

