/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.scilab.forge.scirenderer.implementation.g2d.motor.ConvexObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.DrawTools;
import org.scilab.forge.scirenderer.implementation.g2d.motor.InvalidPolygonException;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Segment;
import org.scilab.forge.scirenderer.implementation.g2d.motor.SpritedRectangle;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.tranformations.Vector4d;

public class Triangle
extends ConvexObject {
    private static final Color[] COLORS = new Color[]{Color.BLACK, Color.BLACK, Color.BLACK};
    private static final Stroke stroke = new BasicStroke(1.0f, 0, 2);
    private static final Stroke EMPTYSTROKE = new BasicStroke(0.0f, 0, 2);
    private SpritedRectangle sprite;
    private BufferedImage image;
    private Vector3d[] textureCoords;
    private Texture.Filter filter;
    protected List<Segment> segments;

    public Triangle(Vector3d[] vector3dArray, Color[] colorArray, Vector3d vector3d) throws InvalidPolygonException {
        super(vector3dArray, colorArray);
        if (vector3dArray.length != 3) {
            throw new InvalidPolygonException("Invalid triangle: must have 3 vertices.");
        }
    }

    public Triangle(Vector3d[] vector3dArray, Color[] colorArray) throws InvalidPolygonException {
        this(vector3dArray, colorArray, null);
    }

    public Triangle(Vector3d[] vector3dArray, Vector3d[] vector3dArray2, BufferedImage bufferedImage, Texture.Filter filter) throws InvalidPolygonException {
        this(vector3dArray, COLORS, null);
        this.textureCoords = vector3dArray2;
        this.image = bufferedImage;
        this.filter = filter;
    }

    @Override
    public int isBehind(ConvexObject convexObject) {
        if (convexObject instanceof Segment && this.isSegmentAcross((Segment)convexObject)) {
            return -1;
        }
        return super.isBehind(convexObject);
    }

    public boolean isIn2D() {
        return this.vertices[0].getZ() == 0.0 && this.vertices[1].getZ() == 0.0 && this.vertices[2].getZ() == 0.0;
    }

    public boolean addSegment(Segment segment) {
        if (this.isSegmentInside(segment)) {
            if (this.segments == null) {
                this.segments = new ArrayList<Segment>(3);
            }
            if (this.segments.contains(segment)) {
                this.segments.remove(segment);
                segment.removeConvexObject(this);
            }
            this.segments.add(segment);
            segment.addConvexObject(this);
            return true;
        }
        return false;
    }

    public boolean pointOnVertices(Vector3d vector3d) {
        return vector3d.equals(this.vertices[0]) || vector3d.equals(this.vertices[1]) || vector3d.equals(this.vertices[2]);
    }

    public void removeSegment(Segment segment) {
        if (this.segments != null) {
            this.segments.remove(segment);
            segment.removeConvexObject(this);
        }
    }

    public void replaceSegment(Segment segment, List<Segment> list) {
        this.segments.remove(segment);
        for (Segment segment2 : list) {
            if (this.segments.contains(segment2)) {
                this.segments.remove(segment2);
                segment2.removeConvexObject(this);
            }
            this.segments.add(segment2);
            segment2.addConvexObject(this);
        }
    }

    @Override
    public List<ConvexObject> breakObject(ConvexObject convexObject) {
        if (convexObject instanceof Triangle) {
            return this.breakObject((Triangle)convexObject);
        }
        if (convexObject instanceof Segment) {
            return this.breakObject((Segment)convexObject);
        }
        if (convexObject instanceof SpritedRectangle) {
            return ((SpritedRectangle)convexObject).breakObject(this);
        }
        return null;
    }

    public List<ConvexObject> breakObject(Triangle triangle) {
        Vector3d vector3d = Vector3d.product(this.v0v1, triangle.v0v1);
        vector3d = vector3d.times(1.0 / vector3d.getNorm2());
        Vector3d vector3d2 = Vector3d.product(triangle.v0v1, vector3d);
        Vector3d vector3d3 = Vector3d.product(vector3d, this.v0v1);
        Vector3d vector3d4 = Vector3d.getBarycenter(vector3d2, vector3d3, this.v0v1.scalar(this.vertices[0]), triangle.v0v1.scalar(triangle.vertices[0]));
        List<ConvexObject> list = Triangle.breakTriangleOnLine(triangle, vector3d4, this.v0v1);
        List<ConvexObject> list2 = Triangle.breakTriangleOnLine(this, vector3d4, triangle.v0v1);
        list.addAll(list2);
        return list;
    }

    public List<ConvexObject> breakObject(Segment segment) {
        double d = this.getSegmentIntersection(segment);
        if (Double.isNaN(d)) {
            return null;
        }
        ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(5);
        Vector3d vector3d = Vector3d.getBarycenter(segment.vertices[0], segment.vertices[1], d, 1.0 - d);
        Color color = Triangle.getColorsBarycenter(segment.colors[0], segment.colors[1], d, 1.0 - d);
        try {
            arrayList.add(new Segment(new Vector3d[]{segment.vertices[0], vector3d}, new Color[]{segment.colors[0], color}, segment.stroke));
            arrayList.add(new Segment(new Vector3d[]{vector3d, segment.vertices[1]}, new Color[]{color, segment.colors[1]}, segment.stroke));
        }
        catch (InvalidPolygonException invalidPolygonException) {
            // empty catch block
        }
        List<ConvexObject> list = Triangle.breakTriangleOnLine(this, vector3d, Vector3d.product(this.v0v1, this.vertices[0].minus(vector3d)));
        arrayList.addAll(list);
        return arrayList;
    }

    protected void setSprite(SpritedRectangle spritedRectangle) {
        this.sprite = spritedRectangle;
    }

    protected SpritedRectangle getSprite() {
        return this.sprite;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Object object2;
        if (this.sprite != null) {
            object2 = graphics2D.getClip();
            Path2D object3 = this.getProjectedContour();
            Area area = new Area(object3);
            area.add(new Area(stroke.createStrokedShape(object3)));
            graphics2D.clip(area);
            this.sprite.draw(graphics2D);
            graphics2D.setClip((Shape)object2);
        } else if (this.image != null) {
            object2 = this.filter == Texture.Filter.LINEAR ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            DrawTools.drawTriangleTexture(graphics2D, this.image, new double[]{this.textureCoords[0].getX(), this.textureCoords[1].getX(), this.textureCoords[2].getX()}, new double[]{this.textureCoords[0].getY(), this.textureCoords[1].getY(), this.textureCoords[2].getY()}, new double[]{this.vertices[0].getX(), this.vertices[1].getX(), this.vertices[2].getX()}, new double[]{this.vertices[0].getY(), this.vertices[1].getY(), this.vertices[2].getY()}, object2);
        } else if (this.colors[0].equals(this.colors[1]) && this.colors[1].equals(this.colors[2])) {
            object2 = this.getProjectedContour();
            Area area = new Area((Shape)object2);
            area.add(new Area(stroke.createStrokedShape((Shape)object2)));
            graphics2D.setStroke(EMPTYSTROKE);
            graphics2D.setColor(this.colors[0]);
            graphics2D.fill(area);
        } else {
            DrawTools.fillGouraud(graphics2D, this);
        }
        if (this.segments != null) {
            for (Segment segment : this.segments) {
                segment.removeConvexObject(this);
                segment.draw(graphics2D);
            }
        }
        this.drawAreas(graphics2D);
    }

    @Override
    public List<ConvexObject> breakObject(Vector4d vector4d) {
        double[] dArray = vector4d.getData();
        Vector3d vector3d = new Vector3d(dArray);
        int n = this.isBehind(vector3d, dArray[3]);
        if (n == 1) {
            ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(1);
            arrayList.add(this);
            return arrayList;
        }
        if (n == -1) {
            return null;
        }
        Vector3d vector3d2 = Vector3d.product(this.v0v1, vector3d);
        vector3d2 = vector3d2.times(1.0 / vector3d2.getNorm2());
        Vector3d vector3d3 = Vector3d.product(vector3d, vector3d2);
        Vector3d vector3d4 = Vector3d.product(vector3d2, this.v0v1);
        Vector3d vector3d5 = Vector3d.getBarycenter(vector3d3, vector3d4, this.v0v1.scalar(this.vertices[0]), -dArray[3]);
        List<ConvexObject> list = Triangle.breakTriangleOnLine(this, vector3d5, vector3d);
        ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(3);
        for (ConvexObject convexObject : list) {
            if (convexObject.isBehind(vector3d, dArray[3]) != 1) continue;
            arrayList.add(convexObject);
        }
        return arrayList;
    }

    protected boolean isPointInside(Vector3d vector3d) {
        return this.isPointInside(vector3d, true);
    }

    protected boolean isPointInside(Vector3d vector3d, boolean bl) {
        Vector3d vector3d2 = vector3d.minus(this.vertices[0]);
        if (bl && !Triangle.isNull(vector3d2.scalar(this.v0v1))) {
            return false;
        }
        Vector3d vector3d3 = Vector3d.product(this.v0v1, vector3d2);
        double d = -vector3d3.scalar(this.v1);
        if (d < 0.0 || Triangle.isNull(d)) {
            return false;
        }
        double d2 = vector3d3.scalar(this.v0);
        if (d2 < 0.0 || Triangle.isNull(d2)) {
            return false;
        }
        return d + d2 < this.nv0v1 || Triangle.isEqual(d + d2, this.nv0v1);
    }

    protected boolean isCoplanar(Segment segment) {
        double d = this.vertices[0].scalar(this.v0v1);
        return Triangle.isEqual(d, segment.vertices[0].scalar(this.v0v1)) && Triangle.isEqual(d, segment.vertices[1].scalar(this.v0v1));
    }

    protected boolean isCoplanar(Triangle triangle) {
        double d = this.vertices[0].scalar(this.v0v1);
        return Triangle.isEqual(d, triangle.vertices[0].scalar(this.v0v1)) && Triangle.isEqual(d, triangle.vertices[1].scalar(this.v0v1)) && Triangle.isEqual(d, triangle.vertices[2].scalar(this.v0v1));
    }

    protected boolean isSegmentAcross(Segment segment) {
        if (!this.isCoplanar(segment)) {
            return false;
        }
        return this.check2DTrueIntersection(segment);
    }

    protected boolean isSegmentInside(Segment segment) {
        if (!this.isCoplanar(segment)) {
            return false;
        }
        if ((segment.vertices[0].equals(this.vertices[0]) || segment.vertices[0].equals(this.vertices[1]) || segment.vertices[0].equals(this.vertices[2])) && (segment.vertices[1].equals(this.vertices[0]) || segment.vertices[1].equals(this.vertices[1]) || segment.vertices[1].equals(this.vertices[2]))) {
            return true;
        }
        return this.isPointInside(segment.vertices[0], false) || this.isPointInside(segment.vertices[1], false) || this.check2DIntersection(segment);
    }

    protected boolean isSegmentIntersects(Segment segment) {
        Vector3d vector3d = segment.vertices[0].minus(this.vertices[0]);
        Vector3d vector3d2 = segment.vertices[1].minus(this.vertices[0]);
        double d = vector3d.scalar(this.v0v1);
        if (Math.signum(d) == Math.signum(vector3d2.scalar(this.v0v1))) {
            return false;
        }
        Vector3d vector3d3 = segment.vertices[0].minus(segment.vertices[1]);
        Vector3d vector3d4 = Vector3d.product(this.v1, vector3d3);
        double d2 = vector3d.scalar(vector3d4);
        double d3 = Vector3d.det(vector3d, vector3d3, this.v0);
        double d4 = this.v0.scalar(vector3d4);
        double d5 = Math.signum(d4);
        return Math.signum(d2) == d5 && Math.signum(d3) == d5 && Math.signum(d) == d5 && d2 + d3 <= d4 && d <= d4;
    }

    protected double getSegmentIntersection(Segment segment) {
        Vector3d vector3d = segment.vertices[1].minus(this.vertices[0]);
        double d = vector3d.scalar(this.v0v1) / segment.v0.scalar(this.v0v1);
        if (Triangle.isNegativeOrNull(d) || Triangle.isGreaterOrEqual(d, 1.0)) {
            return Double.NaN;
        }
        Vector3d vector3d2 = Vector3d.getBarycenter(segment.vertices[0], segment.vertices[1], d, 1.0 - d);
        if (this.isPointInside(vector3d2, false)) {
            return d;
        }
        return Double.NaN;
    }

    protected static List<ConvexObject> breakSegmentOnTriangle(Triangle triangle, Segment segment) {
        double d = triangle.getSegmentIntersection(segment);
        if (Double.isNaN(d)) {
            return null;
        }
        ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(2);
        Vector3d vector3d = Vector3d.getBarycenter(segment.vertices[0], segment.vertices[1], d, 1.0 - d);
        Color color = Triangle.getColorsBarycenter(segment.colors[0], segment.colors[1], d, 1.0 - d);
        try {
            arrayList.add(new Segment(new Vector3d[]{segment.vertices[0], vector3d}, new Color[]{segment.colors[0], color}, segment.stroke));
            arrayList.add(new Segment(new Vector3d[]{vector3d, segment.vertices[1]}, new Color[]{color, segment.colors[1]}, segment.stroke));
        }
        catch (InvalidPolygonException invalidPolygonException) {
            // empty catch block
        }
        return arrayList;
    }

    protected static List<ConvexObject> breakTriangleOnLine(Triangle triangle, Vector3d vector3d, Vector3d vector3d2) {
        Color color;
        Color color2;
        Vector3d vector3d3;
        Vector3d vector3d4;
        double d = triangle.vertices[1].minus(vector3d).scalar(vector3d2) / triangle.v0.scalar(vector3d2);
        double d2 = triangle.vertices[2].minus(vector3d).scalar(vector3d2) / triangle.v1.scalar(vector3d2);
        Vector3d vector3d5 = triangle.vertices[2].minus(triangle.vertices[1]);
        double d3 = triangle.vertices[2].minus(vector3d).scalar(vector3d2) / vector3d5.scalar(vector3d2);
        ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(3);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d4 = -1.0;
        if (Triangle.isNull(d)) {
            n = 1;
            n2 = 2;
            n3 = 0;
            d4 = d2;
        }
        if (Triangle.isNull(d - 1.0)) {
            if (d4 != -1.0) {
                arrayList.add(triangle);
                return arrayList;
            }
            n = 0;
            n2 = 1;
            n3 = 2;
            d4 = d3;
        }
        if (Triangle.isNull(d2)) {
            if (d4 != -1.0) {
                arrayList.add(triangle);
                return arrayList;
            }
            n = 2;
            n2 = 0;
            n3 = 1;
            d4 = d;
        }
        if (n != -1) {
            if (d4 >= 0.0 && d4 <= 1.0) {
                Object object;
                Vector3d vector3d6 = Vector3d.getBarycenter(triangle.vertices[n2], triangle.vertices[n3], d4, 1.0 - d4);
                Color color3 = Triangle.getColorsBarycenter(triangle.colors[n2], triangle.colors[n3], d4, 1.0 - d4);
                Vector3d[] vector3dArray = new Vector3d[]{triangle.vertices[n], triangle.vertices[n2], vector3d6};
                Vector3d[] vector3dArray2 = new Vector3d[]{triangle.vertices[n], vector3d6, triangle.vertices[n3]};
                Color[] colorArray = new Color[]{triangle.colors[n], triangle.colors[n2], color3};
                Color[] colorArray2 = new Color[]{triangle.colors[n], color3, triangle.colors[n3]};
                Vector3d[] vector3dArray3 = null;
                Vector3d[] vector3dArray4 = null;
                if (triangle.textureCoords != null) {
                    object = Vector3d.getBarycenter(triangle.textureCoords[n2], triangle.textureCoords[n3], d4, 1.0 - d4);
                    vector3dArray3 = new Vector3d[]{triangle.textureCoords[n], triangle.textureCoords[n2], object};
                    vector3dArray4 = new Vector3d[]{triangle.textureCoords[n], object, triangle.textureCoords[n3]};
                }
                try {
                    object = new Triangle(vector3dArray, colorArray, null);
                    ((Triangle)object).setSprite(triangle.getSprite());
                    arrayList.add((ConvexObject)object);
                    Triangle triangle2 = new Triangle(vector3dArray2, colorArray2, null);
                    triangle2.setSprite(triangle.getSprite());
                    arrayList.add(triangle2);
                    if (triangle.textureCoords != null) {
                        ((Triangle)object).textureCoords = vector3dArray3;
                        triangle2.textureCoords = vector3dArray4;
                        ((Triangle)object).image = triangle2.image = triangle.image;
                        ((Triangle)object).filter = triangle2.filter = triangle.filter;
                    }
                }
                catch (InvalidPolygonException invalidPolygonException) {
                    // empty catch block
                }
                Triangle.addSegments(arrayList, triangle, vector3d, Vector3d.product(triangle.v0v1, vector3d2), vector3d2);
                return arrayList;
            }
            arrayList.add(triangle);
            return arrayList;
        }
        Vector3d vector3d7 = null;
        Vector3d vector3d8 = null;
        if (d < 0.0 || d > 1.0) {
            n = 2;
            n2 = 0;
            n3 = 1;
            vector3d4 = Vector3d.getBarycenter(triangle.vertices[1], triangle.vertices[2], d3, 1.0 - d3);
            vector3d3 = Vector3d.getBarycenter(triangle.vertices[0], triangle.vertices[2], d2, 1.0 - d2);
            color2 = Triangle.getColorsBarycenter(triangle.colors[1], triangle.colors[2], d3, 1.0 - d3);
            color = Triangle.getColorsBarycenter(triangle.colors[0], triangle.colors[2], d2, 1.0 - d2);
            if (triangle.textureCoords != null) {
                vector3d7 = Vector3d.getBarycenter(triangle.textureCoords[1], triangle.textureCoords[2], d3, 1.0 - d3);
                vector3d8 = Vector3d.getBarycenter(triangle.textureCoords[0], triangle.textureCoords[2], d2, 1.0 - d2);
            }
        } else if (d2 < 0.0 || d2 > 1.0) {
            n = 1;
            n2 = 2;
            n3 = 0;
            vector3d4 = Vector3d.getBarycenter(triangle.vertices[0], triangle.vertices[1], d, 1.0 - d);
            vector3d3 = Vector3d.getBarycenter(triangle.vertices[1], triangle.vertices[2], d3, 1.0 - d3);
            color2 = Triangle.getColorsBarycenter(triangle.colors[0], triangle.colors[1], d, 1.0 - d);
            color = Triangle.getColorsBarycenter(triangle.colors[1], triangle.colors[2], d3, 1.0 - d3);
            if (triangle.textureCoords != null) {
                vector3d7 = Vector3d.getBarycenter(triangle.textureCoords[0], triangle.textureCoords[1], d, 1.0 - d);
                vector3d8 = Vector3d.getBarycenter(triangle.textureCoords[1], triangle.textureCoords[2], d3, 1.0 - d3);
            }
        } else {
            n = 0;
            n2 = 1;
            n3 = 2;
            vector3d4 = Vector3d.getBarycenter(triangle.vertices[0], triangle.vertices[2], d2, 1.0 - d2);
            vector3d3 = Vector3d.getBarycenter(triangle.vertices[0], triangle.vertices[1], d, 1.0 - d);
            color2 = Triangle.getColorsBarycenter(triangle.colors[0], triangle.colors[2], d2, 1.0 - d2);
            color = Triangle.getColorsBarycenter(triangle.colors[0], triangle.colors[1], d, 1.0 - d);
            if (triangle.textureCoords != null) {
                vector3d7 = Vector3d.getBarycenter(triangle.textureCoords[0], triangle.textureCoords[2], d2, 1.0 - d2);
                vector3d8 = Vector3d.getBarycenter(triangle.textureCoords[0], triangle.textureCoords[1], d, 1.0 - d);
            }
        }
        Vector3d[] vector3dArray = new Vector3d[]{vector3d4, triangle.vertices[n], vector3d3};
        Color[] colorArray = new Color[]{color2, triangle.colors[n], color};
        Vector3d[] vector3dArray5 = new Vector3d[]{vector3d4, vector3d3, triangle.vertices[n2]};
        Color[] colorArray3 = new Color[]{color2, color, triangle.colors[n2]};
        Vector3d[] vector3dArray6 = new Vector3d[]{vector3d4, triangle.vertices[n2], triangle.vertices[n3]};
        Color[] colorArray4 = new Color[]{color2, triangle.colors[n2], triangle.colors[n3]};
        Vector3d[] vector3dArray7 = null;
        Vector3d[] vector3dArray8 = null;
        Vector3d[] vector3dArray9 = null;
        if (triangle.textureCoords != null) {
            vector3dArray7 = new Vector3d[]{vector3d7, triangle.textureCoords[n], vector3d8};
            vector3dArray8 = new Vector3d[]{vector3d7, vector3d8, triangle.textureCoords[n2]};
            vector3dArray9 = new Vector3d[]{vector3d7, triangle.textureCoords[n2], triangle.textureCoords[n3]};
        }
        try {
            Triangle triangle3 = new Triangle(vector3dArray, colorArray, null);
            triangle3.setSprite(triangle.getSprite());
            arrayList.add(triangle3);
            Triangle triangle4 = new Triangle(vector3dArray5, colorArray3, null);
            triangle4.setSprite(triangle.getSprite());
            arrayList.add(triangle4);
            Triangle triangle5 = new Triangle(vector3dArray6, colorArray4, null);
            triangle5.setSprite(triangle.getSprite());
            arrayList.add(triangle5);
            if (triangle.textureCoords != null) {
                triangle3.textureCoords = vector3dArray7;
                triangle4.textureCoords = vector3dArray8;
                triangle5.textureCoords = vector3dArray9;
                triangle4.image = triangle5.image = triangle.image;
                triangle3.image = triangle5.image;
                triangle4.filter = triangle5.filter = triangle.filter;
                triangle3.filter = triangle5.filter;
            }
        }
        catch (InvalidPolygonException invalidPolygonException) {
            // empty catch block
        }
        Triangle.addSegments(arrayList, triangle, vector3d, Vector3d.product(triangle.v0v1, vector3d2), vector3d2);
        return arrayList;
    }

    private static final void addSegments(List<ConvexObject> list, Triangle triangle, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        if (triangle.segments != null) {
            ArrayList arrayList = new ArrayList();
            for (Segment segment : triangle.segments) {
                segment.removeConvexObject(triangle);
                List<Segment> list2 = segment.breakObject(vector3d, vector3d2, vector3d3);
                if (list2 == null || list2.isEmpty()) continue;
                arrayList.addAll(list2);
                segment.replaceSegment(list2);
            }
            triangle.textureCoords = null;
            for (Segment segment : arrayList) {
                for (ConvexObject convexObject : list) {
                    ((Triangle)convexObject).addSegment(segment);
                }
            }
        }
    }

    protected static List<ConvexObject> breakIntersectingTriangles(Triangle triangle, Triangle triangle2) {
        Vector3d vector3d = Vector3d.product(triangle.v0v1, triangle2.v0v1);
        vector3d = vector3d.times(1.0 / vector3d.getNorm2());
        Vector3d vector3d2 = Vector3d.product(triangle2.v0v1, vector3d);
        Vector3d vector3d3 = Vector3d.product(vector3d, triangle.v0v1);
        Vector3d vector3d4 = Vector3d.getBarycenter(vector3d2, vector3d3, triangle.v0v1.scalar(triangle.vertices[0]), triangle2.v0v1.scalar(triangle2.vertices[0]));
        List<ConvexObject> list = Triangle.breakTriangleOnLine(triangle, vector3d4, triangle2.v0v1);
        List<ConvexObject> list2 = Triangle.breakTriangleOnLine(triangle2, vector3d4, triangle.v0v1);
        list.addAll(list2);
        return list;
    }

    public String toString() {
        return "Triangle: " + this.vertices[0].toString() + " " + this.vertices[1].toString() + " " + this.vertices[2].toString() + "\nColor: " + this.colors[0] + "\nPrecedence: " + this.precedence;
    }
}

