/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.scilab.forge.scirenderer.implementation.g2d.motor.ConvexObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.DrawTools;
import org.scilab.forge.scirenderer.implementation.g2d.motor.InvalidPolygonException;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Segment;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Triangle;
import org.scilab.forge.scirenderer.implementation.g2d.texture.G2DTextureDrawingTools;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.tranformations.Vector4d;

public class SpritedRectangle
extends ConvexObject {
    private static final Color[] COLORS = new Color[]{Color.BLACK, Color.BLACK, Color.BLACK};
    private Texture sprite;
    private BufferedImage image;
    private G2DTextureDrawingTools drawingTools;
    private double rotationAngle;
    private Texture.Filter filter;
    private Vector3d position;

    public SpritedRectangle(Vector3d vector3d, Texture texture, AnchorPosition anchorPosition, G2DTextureDrawingTools g2DTextureDrawingTools, double d) throws InvalidPolygonException {
        super(SpritedRectangle.getSpriteVertices(vector3d, texture, anchorPosition), null);
        this.sprite = texture;
        this.drawingTools = g2DTextureDrawingTools;
        this.rotationAngle = d;
        this.position = vector3d;
    }

    public SpritedRectangle(Vector3d vector3d, Transformation transformation, BufferedImage bufferedImage, Texture.Filter filter) throws InvalidPolygonException {
        super(SpritedRectangle.getSpriteVertices(vector3d, transformation, bufferedImage), null);
        this.image = bufferedImage;
        this.filter = filter;
        this.position = vector3d;
    }

    @Override
    public List<ConvexObject> breakObject(ConvexObject convexObject) {
        if (convexObject instanceof Triangle) {
            return this.breakObject((Triangle)convexObject);
        }
        if (convexObject instanceof Segment) {
            return this.breakObject((Segment)convexObject);
        }
        if (convexObject instanceof SpritedRectangle) {
            return this.breakObject((SpritedRectangle)convexObject);
        }
        return null;
    }

    public List<ConvexObject> breakObject(Triangle triangle) {
        try {
            List<ConvexObject> list;
            Vector3d[] vector3dArray = new Vector3d[]{this.vertices[0], this.vertices[1], this.vertices[2]};
            Vector3d[] vector3dArray2 = new Vector3d[]{this.vertices[0], this.vertices[2], this.vertices[3]};
            Triangle triangle2 = new Triangle(vector3dArray, COLORS);
            Triangle triangle3 = new Triangle(vector3dArray2, COLORS);
            triangle2.setSprite(this);
            triangle3.setSprite(this);
            ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>();
            if (triangle.isBehind(triangle2) == 2) {
                list = triangle.breakObject(triangle2);
                if (list != null) {
                    arrayList.addAll(list);
                }
            } else {
                arrayList.add(triangle2);
            }
            if (triangle.isBehind(triangle3) == 2) {
                list = triangle.breakObject(triangle3);
                if (list != null) {
                    arrayList.addAll(list);
                }
            } else {
                arrayList.add(triangle3);
            }
            return arrayList;
        }
        catch (InvalidPolygonException invalidPolygonException) {
            return null;
        }
    }

    public List<ConvexObject> breakObject(Segment segment) {
        try {
            Vector3d[] vector3dArray = new Vector3d[]{this.vertices[0], this.vertices[1], this.vertices[2]};
            Triangle triangle = new Triangle(vector3dArray, COLORS);
            triangle.setSprite(this);
            vector3dArray = new Vector3d[]{this.vertices[0], this.vertices[2], this.vertices[3]};
            Triangle triangle2 = new Triangle(vector3dArray, COLORS);
            triangle2.setSprite(this);
            List<ConvexObject> list = triangle.breakObject(segment);
            if (list != null) {
                list.add(triangle2);
                return list;
            }
            list = triangle2.breakObject(segment);
            if (list != null) {
                list.add(triangle);
                return list;
            }
        }
        catch (InvalidPolygonException invalidPolygonException) {
            // empty catch block
        }
        return null;
    }

    public List<ConvexObject> breakObject(SpritedRectangle spritedRectangle) {
        try {
            Vector3d[] vector3dArray = new Vector3d[]{this.vertices[0], this.vertices[1], this.vertices[2]};
            Vector3d[] vector3dArray2 = new Vector3d[]{this.vertices[0], this.vertices[2], this.vertices[3]};
            Triangle triangle = new Triangle(vector3dArray, COLORS);
            Triangle triangle2 = new Triangle(vector3dArray2, COLORS);
            triangle.setSprite(this);
            triangle2.setSprite(this);
            List<ConvexObject> list = spritedRectangle.breakObject(triangle);
            if (list == null) {
                list = spritedRectangle.breakObject(triangle2);
            } else {
                List<ConvexObject> list2 = spritedRectangle.breakObject(triangle2);
                if (list2 != null) {
                    list.addAll(list2);
                }
            }
            return list;
        }
        catch (InvalidPolygonException invalidPolygonException) {
            return null;
        }
    }

    @Override
    public List<ConvexObject> breakObject(Vector4d vector4d) {
        try {
            double[] dArray = vector4d.getData();
            Vector3d vector3d = new Vector3d(dArray);
            int n = this.isBehind(vector3d, dArray[3]);
            if (n == 1) {
                ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>();
                arrayList.add(this);
                return arrayList;
            }
            if (n == -1) {
                return null;
            }
            Vector3d[] vector3dArray = new Vector3d[]{this.vertices[0], this.vertices[1], this.vertices[2]};
            Vector3d[] vector3dArray2 = new Vector3d[]{this.vertices[0], this.vertices[2], this.vertices[3]};
            Triangle triangle = new Triangle(vector3dArray, COLORS);
            Triangle triangle2 = new Triangle(vector3dArray2, COLORS);
            triangle.setSprite(this);
            triangle2.setSprite(this);
            List<ConvexObject> list = triangle.breakObject(vector4d);
            if (list != null) {
                List<ConvexObject> list2 = triangle2.breakObject(vector4d);
                if (list2 != null) {
                    list.addAll(list2);
                }
                return list;
            }
            return triangle2.breakObject(vector4d);
        }
        catch (InvalidPolygonException invalidPolygonException) {
            return null;
        }
    }

    private static Vector3d[] getSpriteVertices(Vector3d vector3d, Transformation transformation, BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        double d = vector3d.getX();
        double d2 = vector3d.getY();
        double d3 = vector3d.getZ();
        return new Vector3d[]{transformation.project(new Vector3d(d, d2, d3)), transformation.project(new Vector3d(d + (double)n, d2, d3)), transformation.project(new Vector3d(d + (double)n, d2 + (double)n2, d3)), transformation.project(new Vector3d(d, d2 + (double)n2, d3))};
    }

    private static Vector3d[] getSpriteVertices(Vector3d vector3d, Texture texture, AnchorPosition anchorPosition) {
        Dimension dimension = texture.getDataProvider().getTextureSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        double d3 = 0.0;
        double d4 = 0.0;
        switch (anchorPosition) {
            case LEFT: {
                d3 = d / 2.0;
                break;
            }
            case LOWER_LEFT: {
                d3 = d / 2.0;
                d4 = d2 / 2.0;
                break;
            }
            case UPPER_LEFT: {
                d3 = d / 2.0;
                d4 = -d2 / 2.0;
                break;
            }
            case UP: {
                d4 = -d2 / 2.0;
                break;
            }
            case CENTER: {
                break;
            }
            case DOWN: {
                d4 = d2 / 2.0;
                break;
            }
            case RIGHT: {
                d3 = -d / 2.0;
                break;
            }
            case LOWER_RIGHT: {
                d3 = -d / 2.0;
                d4 = d2 / 2.0;
                break;
            }
            case UPPER_RIGHT: {
                d3 = -d / 2.0;
                d4 = -d2 / 2.0;
                break;
            }
        }
        double d5 = vector3d.getX() + d3;
        double d6 = vector3d.getY() - d4;
        double d7 = vector3d.getZ();
        return new Vector3d[]{new Vector3d(d5 - d / 2.0, d6 - d2 / 2.0, d7), new Vector3d(d5 - d / 2.0, d6 + d2 / 2.0, d7), new Vector3d(d5 + d / 2.0, d6 + d2 / 2.0, d7), new Vector3d(d5 + d / 2.0, d6 - d2 / 2.0, d7)};
    }

    public Texture getSprite() {
        return this.sprite;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.sprite != null) {
            Path2D path2D = this.getProjectedContour();
            AffineTransform affineTransform = graphics2D.getTransform();
            Stroke stroke = graphics2D.getStroke();
            if (this.rotationAngle != 0.0) {
                graphics2D.translate(this.position.getX(), this.position.getY());
                graphics2D.rotate(-this.rotationAngle * Math.PI / 180.0);
                graphics2D.translate(this.vertices[0].getX() - this.position.getX(), this.vertices[0].getY() - this.position.getY());
            } else {
                graphics2D.translate(this.vertices[0].getX(), this.vertices[0].getY());
            }
            this.drawingTools.accept(this.sprite);
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(stroke);
        } else {
            Object object = this.filter == Texture.Filter.LINEAR ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            DrawTools.drawParallelogramTexture(graphics2D, this.image, new double[]{0.0, 1.0, 1.0, 0.0}, new double[]{0.0, 0.0, 1.0, 1.0}, new double[]{this.vertices[3].getX(), this.vertices[2].getX(), this.vertices[1].getX(), this.vertices[0].getX()}, new double[]{this.vertices[3].getY(), this.vertices[2].getY(), this.vertices[1].getY(), this.vertices[0].getY()}, object);
        }
    }

    public String toString() {
        return "SpritedRectangle: " + this.vertices[0].toString() + " " + this.vertices[1].toString() + " " + this.vertices[2].toString() + " " + this.vertices[3].toString() + "\nPrecedence: " + this.precedence;
    }
}

