/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scilab.forge.scirenderer.implementation.g2d.motor.ConvexObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.InvalidPolygonException;
import org.scilab.forge.scirenderer.implementation.g2d.motor.SpritedRectangle;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Triangle;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.tranformations.Vector4d;

public class Segment
extends ConvexObject
implements Comparable<Segment> {
    private Integer hash;
    protected Stroke stroke;
    protected List<ConvexObject> segmentOn;

    public Segment(Vector3d[] vector3dArray, Color[] colorArray, Stroke stroke) throws InvalidPolygonException {
        super(vector3dArray, colorArray);
        if (vector3dArray.length != 2) {
            throw new InvalidPolygonException("Invalid segment: must have 2 vertices.");
        }
        this.stroke = stroke;
    }

    public Segment(Vector3d[] vector3dArray, Color[] colorArray) throws InvalidPolygonException {
        this(vector3dArray, colorArray, null);
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public double getLength() {
        return this.vertices[0].minus(this.vertices[1]).getNorm();
    }

    public static double getLength(Vector3d[] vector3dArray) {
        return vector3dArray[0].minus(vector3dArray[1]).getNorm();
    }

    public void addConvexObject(ConvexObject convexObject) {
        if (this.segmentOn == null) {
            this.segmentOn = new ArrayList<ConvexObject>(2);
        }
        this.segmentOn.add(convexObject);
    }

    public void removeConvexObject(ConvexObject convexObject) {
        if (this.segmentOn != null) {
            this.segmentOn.remove(convexObject);
        }
    }

    public void replaceSegment(List<Segment> list) {
        if (this.segmentOn != null) {
            for (ConvexObject convexObject : this.segmentOn) {
                Triangle triangle = (Triangle)convexObject;
                triangle.replaceSegment(this, list);
            }
        }
    }

    public boolean isIn2D() {
        return Segment.isNull(this.vertices[0].getZ()) && Segment.isNull(this.vertices[1].getZ());
    }

    public boolean isInFront() {
        return Segment.isEqual(this.vertices[0].getZ(), -0.5) && Segment.isEqual(this.vertices[1].getZ(), -0.5);
    }

    @Override
    public int compareTo(Segment segment) {
        if (this.equals(segment)) {
            return 0;
        }
        return this.getPrecedence() - segment.getPrecedence();
    }

    public boolean equals(Object object) {
        if (object instanceof Segment) {
            Segment segment = (Segment)object;
            return segment.vertices[0].equals(this.vertices[0]) && segment.vertices[1].equals(this.vertices[1]) && segment.colors[0].equals(this.colors[0]) && segment.colors[1].equals(this.colors[1]) || segment.vertices[1].equals(this.vertices[0]) && segment.vertices[0].equals(this.vertices[1]) && segment.colors[1].equals(this.colors[0]) && segment.colors[0].equals(this.colors[1]);
        }
        return false;
    }

    @Override
    public int isBehind(ConvexObject convexObject) {
        if (convexObject instanceof Triangle && ((Triangle)convexObject).isSegmentAcross(this)) {
            return 1;
        }
        return super.isBehind(convexObject);
    }

    @Override
    public List<ConvexObject> breakObject(ConvexObject convexObject) {
        if (convexObject instanceof Triangle) {
            return ((Triangle)convexObject).breakObject(this);
        }
        if (convexObject instanceof SpritedRectangle) {
            return ((SpritedRectangle)convexObject).breakObject(this);
        }
        return null;
    }

    @Override
    public List<ConvexObject> breakObject(Vector4d vector4d) {
        double[] dArray = vector4d.getData();
        Vector3d vector3d = new Vector3d(dArray);
        boolean bl = Segment.isBehind(this.vertices[0], vector3d, dArray[3]);
        boolean bl2 = Segment.isBehind(this.vertices[1], vector3d, dArray[3]);
        if (bl && bl2) {
            ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(1);
            arrayList.add(this);
            return arrayList;
        }
        if (!bl && !bl2) {
            return null;
        }
        double d = (dArray[3] + this.vertices[1].scalar(vector3d)) / this.v0.scalar(vector3d);
        Vector3d vector3d2 = Vector3d.getBarycenter(this.vertices[0], this.vertices[1], d, 1.0 - d);
        Color color = Segment.getColorsBarycenter(this.colors[0], this.colors[1], d, 1.0 - d);
        Vector3d[] vector3dArray = null;
        Color[] colorArray = null;
        if (bl) {
            vector3dArray = new Vector3d[]{this.vertices[0], vector3d2};
            colorArray = new Color[]{this.colors[0], color};
        }
        if (bl2) {
            vector3dArray = new Vector3d[]{vector3d2, this.vertices[1]};
            colorArray = new Color[]{color, this.colors[1]};
        }
        try {
            ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(1);
            arrayList.add(new Segment(vector3dArray, colorArray, this.stroke));
            return arrayList;
        }
        catch (InvalidPolygonException invalidPolygonException) {
            return null;
        }
    }

    public List<Segment> breakObject(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d = this.vertices[1].minus(vector3d).scalar(vector3d3) / this.v0.scalar(vector3d3);
        if (d > 0.0 && !Segment.isNull(d) && d < 1.0 && !Segment.isEqual(d, 1.0)) {
            ArrayList<Segment> arrayList = new ArrayList<Segment>(2);
            Vector3d vector3d4 = Vector3d.getBarycenter(this.vertices[0], this.vertices[1], d, 1.0 - d);
            Color color = Segment.getColorsBarycenter(this.colors[0], this.colors[1], d, 1.0 - d);
            try {
                arrayList.add(new Segment(new Vector3d[]{this.vertices[0], vector3d4}, new Color[]{this.colors[0], color}, this.stroke));
                arrayList.add(new Segment(new Vector3d[]{vector3d4, this.vertices[1]}, new Color[]{color, this.colors[1]}, this.stroke));
                return arrayList;
            }
            catch (InvalidPolygonException invalidPolygonException) {}
        } else {
            ArrayList<Segment> arrayList = new ArrayList<Segment>(1);
            try {
                arrayList.add(new Segment(new Vector3d[]{this.vertices[0], this.vertices[1]}, new Color[]{this.colors[0], this.colors[1]}, this.stroke));
                return arrayList;
            }
            catch (InvalidPolygonException invalidPolygonException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.segmentOn == null || this.segmentOn.isEmpty()) {
            Path2D path2D = this.getProjectedPolyLine();
            graphics2D.setColor(this.colors[0]);
            Stroke stroke = graphics2D.getStroke();
            if (stroke != this.stroke) {
                graphics2D.setStroke(this.stroke);
            }
            graphics2D.draw(path2D);
            if (stroke != this.stroke) {
                graphics2D.setStroke(stroke);
            }
            this.drawAreas(graphics2D);
        }
    }

    public int hashCode() {
        if (this.hash == null) {
            this.hash = Arrays.hashCode(this.vertices) + 19 * Arrays.hashCode(this.colors);
        }
        return this.hash;
    }

    public String toString() {
        return "Segment " + this.vertices[0].toString() + " " + this.vertices[1].toString() + " Precedence: " + this.getPrecedence();
    }
}

