/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.scilab.forge.scirenderer.clipping.ClippingPlane;
import org.scilab.forge.scirenderer.implementation.g2d.motor.ConvexObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Segment;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Triangle;

final class Scene {
    private static Set<Scene> faces2d = new TreeSet<Scene>(new Comparator<Scene>(){

        @Override
        public int compare(Scene scene, Scene scene2) {
            if (((Scene)scene).object.vertices[0].getZ() == ((Scene)scene2).object.vertices[0].getZ()) {
                return scene.object.getPrecedence() - scene2.object.getPrecedence();
            }
            return (int)Math.signum(((Scene)scene2).object.vertices[0].getZ() - ((Scene)scene).object.vertices[0].getZ());
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    });
    private static List<Scene> faces = new ArrayList<Scene>();
    private static List<Scene> disabledFaces = new ArrayList<Scene>();
    private static List<ClippingPlane> clippingPlanes;
    private static Stack<Scene> stack;
    private List<Scene> behind;
    private List<Scene> onfront;
    private ConvexObject object;
    private boolean drawn;

    private Scene(ConvexObject convexObject) {
        this.object = convexObject;
    }

    public static final void setClippingPlanes(List<ClippingPlane> list) {
        clippingPlanes = list;
    }

    private static final List<ConvexObject> breakOnClippingPlane(ConvexObject convexObject) {
        ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>();
        ArrayList<ConvexObject> arrayList2 = new ArrayList<ConvexObject>();
        arrayList.add(convexObject);
        if (clippingPlanes != null) {
            for (ClippingPlane clippingPlane : clippingPlanes) {
                if (!clippingPlane.isEnable()) continue;
                arrayList2.clear();
                for (ConvexObject convexObject2 : arrayList) {
                    List<ConvexObject> list = convexObject2.breakObject(clippingPlane.getEquation());
                    if (list == null) continue;
                    arrayList2.addAll(list);
                }
                arrayList.clear();
                arrayList.addAll(arrayList2);
                if (!arrayList.isEmpty()) continue;
                break;
            }
        }
        return arrayList;
    }

    static final void addToRoot(boolean bl, ConvexObject convexObject) {
        List<ConvexObject> list = Scene.breakOnClippingPlane(convexObject);
        for (ConvexObject convexObject2 : list) {
            Scene.add(bl, convexObject2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void add(boolean bl, ConvexObject convexObject) {
        List<Scene> list = faces;
        synchronized (list) {
            Scene scene = new Scene(convexObject);
            if (bl) {
                faces2d.add(scene);
            } else {
                HashSet<Scene> hashSet = new HashSet<Scene>();
                List<ConvexObject> list2 = null;
                for (Scene object : faces) {
                    if (object.object instanceof Triangle && convexObject instanceof Segment) {
                        if (((Triangle)object.object).addSegment((Segment)convexObject) && scene != null) {
                            hashSet.add(scene);
                            scene = null;
                        }
                    } else if (convexObject instanceof Triangle && object.object instanceof Segment && ((Triangle)convexObject).addSegment((Segment)object.object)) {
                        hashSet.add(object);
                    }
                    if (scene == null) continue;
                    int n = object.object.isBehind(scene.object);
                    if (n == 1) {
                        Scene.addBehind(object, scene);
                        Scene.addOnFront(scene, object);
                        continue;
                    }
                    if (n == -1) {
                        Scene.addBehind(scene, object);
                        Scene.addOnFront(object, scene);
                        continue;
                    }
                    if (n != 2 || (list2 = object.object.breakObject(scene.object)) == null || list2.isEmpty()) continue;
                    hashSet.add(object);
                    hashSet.add(scene);
                    scene = null;
                    break;
                }
                if (scene != null) {
                    faces.add(scene);
                }
                for (Scene scene2 : hashSet) {
                    faces.remove(scene2);
                    if (scene2.onfront == null) continue;
                    for (Scene scene3 : scene2.onfront) {
                        scene3.behind.remove(scene2);
                    }
                }
                if (list2 != null) {
                    for (ConvexObject convexObject2 : list2) {
                        Scene.add(bl, convexObject2);
                    }
                }
            }
        }
    }

    static final void clearDepth() {
        disabledFaces.addAll(faces);
        disabledFaces.addAll(faces2d);
        faces.clear();
        faces2d.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void drawRoot(Graphics2D graphics2D) {
        List<Scene> list = faces;
        synchronized (list) {
            for (Scene scene : disabledFaces) {
                scene.draw(graphics2D);
            }
            for (Scene scene : disabledFaces) {
                scene.drawn = false;
            }
            for (Scene scene : faces) {
                scene.draw(graphics2D);
            }
            for (Scene scene : faces2d) {
                scene.draw(graphics2D);
            }
        }
    }

    static final void clear() {
        disabledFaces.clear();
        faces.clear();
        faces2d.clear();
        stack.clear();
    }

    static final void clearAll() {
        Scene.clear();
        clippingPlanes.clear();
    }

    private final void draw(Graphics2D graphics2D) {
        if (stack.contains(this)) {
            this.object.addArea(Scene.stack.peek().object);
            return;
        }
        if (!this.drawn) {
            stack.push(this);
            this.drawn = true;
            if (this.behind != null && !this.behind.isEmpty()) {
                for (Scene scene : this.behind) {
                    scene.draw(graphics2D);
                }
            }
            this.object.draw(graphics2D);
            stack.pop();
        }
    }

    private static final void addBehind(Scene scene, Scene scene2) {
        if (scene.behind == null) {
            scene.behind = new ArrayList<Scene>();
        }
        scene.behind.add(scene2);
    }

    private static final void addOnFront(Scene scene, Scene scene2) {
        if (scene.onfront == null) {
            scene.onfront = new ArrayList<Scene>();
        }
        scene.onfront.add(scene2);
    }

    static {
        stack = new Stack();
    }
}

