/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import org.scilab.forge.scirenderer.DrawingTools;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.clipping.ClippingPlane;
import org.scilab.forge.scirenderer.implementation.g2d.G2DCanvas;
import org.scilab.forge.scirenderer.implementation.g2d.motor.AbstractDrawable3DObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.G2DStroke;
import org.scilab.forge.scirenderer.implementation.g2d.motor.InvalidPolygonException;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Scene;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Segment;
import org.scilab.forge.scirenderer.implementation.g2d.motor.SpritedRectangle;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Triangle;
import org.scilab.forge.scirenderer.implementation.g2d.texture.G2DTextureDrawingTools;
import org.scilab.forge.scirenderer.implementation.g2d.texture.G2DTextureManager;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;
import org.scilab.forge.scirenderer.shapes.geometry.Geometry;
import org.scilab.forge.scirenderer.texture.AnchorPosition;
import org.scilab.forge.scirenderer.texture.Texture;
import org.scilab.forge.scirenderer.tranformations.Transformation;
import org.scilab.forge.scirenderer.tranformations.Vector3d;

public class Motor3D {
    private Transformation transf;
    private Transformation singleTransf;
    private Geometry.FaceCullingMode mode = Geometry.FaceCullingMode.BOTH;
    private Graphics2D g2d;
    private Dimension dim;
    private G2DTextureDrawingTools textureDrawingTools;
    private G2DCanvas canvas;

    public Motor3D(G2DCanvas g2DCanvas, Graphics2D graphics2D, Dimension dimension) {
        this.canvas = g2DCanvas;
        this.g2d = graphics2D;
        this.dim = dimension;
        this.textureDrawingTools = new G2DTextureDrawingTools(graphics2D);
        AbstractDrawable3DObject.resetDefaultPrecedence();
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g2d = graphics2D;
        this.textureDrawingTools.setGraphics(graphics2D);
    }

    public void setAntialiased(boolean bl) {
        if (bl) {
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public boolean is2DView() {
        return this.canvas.getMainDrawer().is2DView();
    }

    public void setClippingPlanes(List<ClippingPlane> list) {
        Scene.setClippingPlanes(list);
    }

    public void setFaceCullingMode(Geometry.FaceCullingMode faceCullingMode) {
        this.mode = faceCullingMode;
    }

    public void setTransformation(Transformation transformation, Transformation transformation2) {
        this.transf = transformation;
        this.singleTransf = transformation2;
    }

    public Transformation getCurrentTransformation() {
        return this.transf;
    }

    public Transformation getCurrentSingleTransformation() {
        return this.singleTransf;
    }

    public void reset(Color color) {
        this.transf = null;
        this.mode = Geometry.FaceCullingMode.BOTH;
        this.g2d.setColor(color);
        this.g2d.fillRect(0, 0, (int)this.dim.getWidth(), (int)this.dim.getHeight());
        Scene.clear();
    }

    public void clearDepth() {
        Scene.clearDepth();
    }

    public void draw() {
        Scene.drawRoot(this.g2d);
        Scene.clearAll();
        G2DTextureManager.clear();
    }

    public void drawTexture(DrawingTools drawingTools, BufferedImage bufferedImage, Texture texture) {
        try {
            SpritedRectangle spritedRectangle = new SpritedRectangle(new Vector3d(0.0, 0.0, 0.0), this.transf, bufferedImage, texture.getMagnificationFilter());
            this.add(spritedRectangle);
        }
        catch (InvalidPolygonException invalidPolygonException) {
            // empty catch block
        }
    }

    public void draw(DrawingTools drawingTools, Geometry geometry, Appearance appearance) {
        this.setFaceCullingMode(geometry.getFaceCullingMode());
        FloatBuffer floatBuffer = geometry.getVertices().getData();
        IntBuffer intBuffer = null;
        if (geometry.getIndices() != null) {
            intBuffer = geometry.getIndices().getData();
        }
        IntBuffer intBuffer2 = null;
        if (geometry.getWireIndices() != null) {
            intBuffer2 = geometry.getWireIndices().getData();
        }
        FloatBuffer floatBuffer2 = null;
        if (geometry.getColors() != null) {
            floatBuffer2 = geometry.getColors().getData();
        }
        FloatBuffer floatBuffer3 = null;
        if (geometry.getNormals() != null) {
            floatBuffer3 = geometry.getNormals().getData();
        }
        Texture texture = appearance.getTexture();
        FloatBuffer floatBuffer4 = null;
        BufferedImage bufferedImage = null;
        if (texture != null && geometry.getTextureCoordinates() != null) {
            floatBuffer4 = geometry.getTextureCoordinates().getData();
            bufferedImage = ((G2DTextureManager.G2DTexture)texture).getImage();
        }
        if (geometry.getFillDrawingMode() != Geometry.FillDrawingMode.NONE) {
            this.addTriangles(floatBuffer, floatBuffer3, floatBuffer2, appearance.getFillColor(), intBuffer, floatBuffer4, bufferedImage, texture, geometry.getFillDrawingMode());
        }
        if (geometry.getLineDrawingMode() != Geometry.LineDrawingMode.NONE) {
            if (appearance.getLineColor() == null) {
                this.addSegments(floatBuffer, floatBuffer2, null, intBuffer2, geometry.getLineDrawingMode(), appearance);
            } else {
                this.addSegments(floatBuffer, null, appearance.getLineColor(), intBuffer2, geometry.getLineDrawingMode(), appearance);
            }
        }
    }

    public void draw(DrawingTools drawingTools, Texture texture, AnchorPosition anchorPosition, ElementsBuffer elementsBuffer, double d) {
        Vector3d[] vector3dArray;
        float[] fArray;
        FloatBuffer floatBuffer = elementsBuffer.getData();
        floatBuffer.rewind();
        if (floatBuffer.hasArray()) {
            fArray = floatBuffer.array();
        } else {
            fArray = new float[floatBuffer.limit()];
            floatBuffer.get(fArray);
        }
        for (Vector3d vector3d : vector3dArray = Motor3D.getMultiVectors(fArray, this.transf, false)) {
            try {
                SpritedRectangle spritedRectangle = new SpritedRectangle(vector3d, texture, anchorPosition, this.textureDrawingTools, d);
                this.add(spritedRectangle);
            }
            catch (InvalidPolygonException invalidPolygonException) {
                // empty catch block
            }
        }
    }

    public void draw(DrawingTools drawingTools, Texture texture, AnchorPosition anchorPosition, Vector3d vector3d, double d) {
        try {
            this.add(new SpritedRectangle(this.transf.project(vector3d), texture, anchorPosition, this.textureDrawingTools, d));
        }
        catch (InvalidPolygonException invalidPolygonException) {
            // empty catch block
        }
    }

    private void add(Triangle triangle) {
        Vector3d vector3d = triangle.getNormal();
        if (vector3d != null) {
            if (this.mode == Geometry.FaceCullingMode.CW && vector3d.getZ() > 0.0 || this.mode == Geometry.FaceCullingMode.CCW && vector3d.getZ() < 0.0 || this.mode == Geometry.FaceCullingMode.BOTH) {
                Scene.addToRoot(this.is2DView(), triangle);
            }
        } else {
            Scene.addToRoot(this.is2DView(), triangle);
        }
    }

    private void add(Segment segment) {
        Scene.addToRoot(this.is2DView(), segment);
    }

    private void add(SpritedRectangle spritedRectangle) {
        Scene.addToRoot(this.is2DView(), spritedRectangle);
    }

    private Object[] getArrays(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, Color color, FloatBuffer floatBuffer3, IntBuffer intBuffer) {
        Object[] objectArray;
        float[] fArray;
        Vector3d[] vector3dArray = null;
        floatBuffer.rewind();
        if (floatBuffer.hasArray()) {
            fArray = floatBuffer.array();
        } else {
            fArray = new float[floatBuffer.limit()];
            floatBuffer.get(fArray);
        }
        Vector3d[] vector3dArray2 = Motor3D.getMultiVectors(fArray, this.transf, false);
        if (floatBuffer2 != null) {
            floatBuffer2.rewind();
            if (floatBuffer2.hasArray()) {
                fArray = floatBuffer2.array();
            } else {
                fArray = new float[floatBuffer2.limit()];
                floatBuffer2.get(fArray);
            }
            objectArray = Motor3D.getMultiColors(fArray);
        } else {
            objectArray = new Color[floatBuffer.limit()];
            Arrays.fill(objectArray, color);
        }
        if (floatBuffer3 != null) {
            floatBuffer3.rewind();
            if (floatBuffer3.hasArray()) {
                fArray = floatBuffer3.array();
            } else {
                fArray = new float[floatBuffer3.limit()];
                floatBuffer3.get(fArray);
            }
            vector3dArray = Motor3D.getMultiVectors(fArray);
        }
        if (intBuffer != null) {
            int[] nArray;
            intBuffer.rewind();
            if (intBuffer.hasArray()) {
                nArray = intBuffer.array();
            } else {
                nArray = new int[intBuffer.limit()];
                intBuffer.get(nArray);
            }
            Vector3d[] vector3dArray3 = new Vector3d[nArray.length];
            Color[] colorArray = new Color[nArray.length];
            Vector3d[] vector3dArray4 = null;
            if (floatBuffer3 != null) {
                vector3dArray4 = new Vector3d[nArray.length];
            }
            for (int i = 0; i < nArray.length; ++i) {
                vector3dArray3[i] = vector3dArray2[nArray[i]];
                colorArray[i] = objectArray[nArray[i]];
                if (vector3dArray4 == null) continue;
                vector3dArray4[i] = vector3dArray[nArray[i]];
            }
            vector3dArray2 = vector3dArray3;
            objectArray = colorArray;
            vector3dArray = vector3dArray4;
        }
        return new Object[]{vector3dArray2, objectArray, vector3dArray};
    }

    private void addSegments(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, Color color, IntBuffer intBuffer, Geometry.LineDrawingMode lineDrawingMode, Appearance appearance) {
        Object[] objectArray = this.getArrays(floatBuffer, floatBuffer2, color, null, intBuffer);
        Vector3d[] vector3dArray = (Vector3d[])objectArray[0];
        Color[] colorArray = (Color[])objectArray[1];
        double d = 0.0;
        if (vector3dArray.length <= 1) {
            return;
        }
        switch (lineDrawingMode) {
            case SEGMENTS_STRIP: {
                for (int i = 0; i < vector3dArray.length - 1; ++i) {
                    Vector3d[] vector3dArray2 = new Vector3d[]{vector3dArray[i], vector3dArray[i + 1]};
                    Color[] colorArray2 = new Color[]{colorArray[i], colorArray[i + 1]};
                    try {
                        this.add(new Segment(vector3dArray2, colorArray2, G2DStroke.getStroke(appearance, d)));
                        d += Segment.getLength(vector3dArray2);
                        continue;
                    }
                    catch (InvalidPolygonException invalidPolygonException) {
                        d = 0.0;
                    }
                }
                break;
            }
            case SEGMENTS_LOOP: {
                Color[] colorArray3;
                Vector3d[] vector3dArray3;
                int n;
                for (n = 0; n < vector3dArray.length - 1; ++n) {
                    vector3dArray3 = new Vector3d[]{vector3dArray[n], vector3dArray[n + 1]};
                    colorArray3 = new Color[]{colorArray[n], colorArray[n + 1]};
                    try {
                        this.add(new Segment(vector3dArray3, colorArray3, G2DStroke.getStroke(appearance, d)));
                        d += Segment.getLength(vector3dArray3);
                        continue;
                    }
                    catch (InvalidPolygonException invalidPolygonException) {
                        d = 0.0;
                    }
                }
                n = vector3dArray.length - 1;
                vector3dArray3 = new Vector3d[]{vector3dArray[n], vector3dArray[0]};
                colorArray3 = new Color[]{colorArray[n], colorArray[0]};
                try {
                    this.add(new Segment(vector3dArray3, colorArray3, G2DStroke.getStroke(appearance, d)));
                }
                catch (InvalidPolygonException invalidPolygonException) {}
                break;
            }
            default: {
                for (int i = 0; i < vector3dArray.length - 1; i += 2) {
                    Vector3d[] vector3dArray4 = new Vector3d[]{vector3dArray[i], vector3dArray[i + 1]};
                    Color[] colorArray4 = new Color[]{colorArray[i], colorArray[i + 1]};
                    try {
                        this.add(new Segment(vector3dArray4, colorArray4, G2DStroke.getStroke(appearance, 0.0)));
                        continue;
                    }
                    catch (InvalidPolygonException invalidPolygonException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void addTriangles(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, Color color, IntBuffer intBuffer, FloatBuffer floatBuffer4, BufferedImage bufferedImage, Texture texture, Geometry.FillDrawingMode fillDrawingMode) {
        Object[] objectArray = this.getArrays(floatBuffer, floatBuffer3, color, floatBuffer4, intBuffer);
        Vector3d[] vector3dArray = (Vector3d[])objectArray[0];
        Color[] colorArray = (Color[])objectArray[1];
        Vector3d[] vector3dArray2 = (Vector3d[])objectArray[2];
        Texture.Filter filter = Texture.Filter.NEAREST;
        if (texture != null) {
            filter = texture.getMagnificationFilter();
        }
        switch (fillDrawingMode) {
            case TRIANGLE_FAN: {
                Color[] colorArray2;
                Vector3d[] vector3dArray3;
                int n;
                for (n = 1; n < vector3dArray.length - 1; ++n) {
                    vector3dArray3 = new Vector3d[]{vector3dArray[0], vector3dArray[n], vector3dArray[n + 1]};
                    try {
                        if (bufferedImage == null) {
                            colorArray2 = new Color[]{colorArray[0], colorArray[n], colorArray[n + 1]};
                            this.add(new Triangle(vector3dArray3, colorArray2, null));
                            continue;
                        }
                        this.add(new Triangle(vector3dArray3, new Vector3d[]{vector3dArray2[0], vector3dArray2[n], vector3dArray2[n + 1]}, bufferedImage, filter));
                        continue;
                    }
                    catch (InvalidPolygonException invalidPolygonException) {
                        // empty catch block
                    }
                }
                n = vector3dArray.length - 1;
                vector3dArray3 = new Vector3d[]{vector3dArray[0], vector3dArray[n], vector3dArray[1]};
                try {
                    if (bufferedImage == null) {
                        colorArray2 = new Color[]{colorArray[0], colorArray[n], colorArray[1]};
                        this.add(new Triangle(vector3dArray3, colorArray2, null));
                        break;
                    }
                    this.add(new Triangle(vector3dArray3, new Vector3d[]{vector3dArray2[0], vector3dArray2[n], vector3dArray2[1]}, bufferedImage, filter));
                }
                catch (InvalidPolygonException invalidPolygonException) {}
                break;
            }
            case TRIANGLE_STRIP: {
                for (int i = 0; i < vector3dArray.length - 2; ++i) {
                    Vector3d[] vector3dArray4 = new Vector3d[]{vector3dArray[i], vector3dArray[i + 1], vector3dArray[i + 2]};
                    try {
                        if (bufferedImage == null) {
                            Color[] colorArray3 = new Color[]{colorArray[i], colorArray[i + 1], colorArray[i + 2]};
                            this.add(new Triangle(vector3dArray4, colorArray3, null));
                            continue;
                        }
                        this.add(new Triangle(vector3dArray4, new Vector3d[]{vector3dArray2[i], vector3dArray2[i + 1], vector3dArray2[i + 2]}, bufferedImage, filter));
                        continue;
                    }
                    catch (InvalidPolygonException invalidPolygonException) {
                        // empty catch block
                    }
                }
                break;
            }
            default: {
                for (int i = 0; i < vector3dArray.length - 2; i += 3) {
                    Vector3d[] vector3dArray5 = new Vector3d[]{vector3dArray[i], vector3dArray[i + 1], vector3dArray[i + 2]};
                    try {
                        if (bufferedImage == null) {
                            Color[] colorArray4 = new Color[]{colorArray[i], colorArray[i + 1], colorArray[i + 2]};
                            this.add(new Triangle(vector3dArray5, colorArray4, null));
                            continue;
                        }
                        this.add(new Triangle(vector3dArray5, new Vector3d[]{vector3dArray2[i], vector3dArray2[i + 1], vector3dArray2[i + 2]}, bufferedImage, filter));
                        continue;
                    }
                    catch (InvalidPolygonException invalidPolygonException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static final Vector3d[] getMultiVectors(float[] fArray, Transformation transformation, boolean bl) {
        Vector3d[] vector3dArray = new Vector3d[fArray.length / 4];
        if (bl) {
            int n = 0;
            for (int i = 0; i < vector3dArray.length; ++i) {
                vector3dArray[i] = transformation.projectDirection(new Vector3d(fArray[n], fArray[n + 1], fArray[n + 2]));
                n += 4;
            }
        } else {
            int n = 0;
            for (int i = 0; i < vector3dArray.length; ++i) {
                vector3dArray[i] = transformation.project(new Vector3d(fArray[n], fArray[n + 1], fArray[n + 2]));
                n += 4;
            }
        }
        return vector3dArray;
    }

    private static final Vector3d[] getMultiVectors(float[] fArray) {
        Vector3d[] vector3dArray = new Vector3d[fArray.length / 4];
        int n = 0;
        for (int i = 0; i < vector3dArray.length; ++i) {
            vector3dArray[i] = new Vector3d(fArray[n], fArray[n + 1], fArray[n + 2]);
            n += 4;
        }
        return vector3dArray;
    }

    private static final Color[] getMultiColors(float[] fArray) {
        Color[] colorArray = new Color[fArray.length / 4];
        int n = 0;
        Color color = Color.BLACK;
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = new Color(fArray[n], fArray[n + 1], fArray[n + 2], fArray[n + 3]);
            if (color.equals(colorArray[i])) {
                colorArray[i] = color;
            }
            color = colorArray[i];
            n += 4;
        }
        return colorArray;
    }
}

