/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;

public class G2DStroke
extends BasicStroke {
    private static final int[] array = new int[16];
    private static final Stroke BASIC = new G2DStroke(1.0f, null, 0.0f);

    public G2DStroke(float f, float[] fArray, float f2) {
        super(f, 0, 0, 10.0f, fArray, f2);
    }

    public static Stroke getStroke(Appearance appearance, double d) {
        Appearance appearance2 = appearance == null ? new Appearance() : appearance;
        float f = appearance2.getLineWidth();
        if (f == 0.0f) {
            return new G2DStroke(0.0f, null, 0.0f);
        }
        short s = appearance2.getLinePattern();
        if (s == -1) {
            if (f == 1.0f) {
                return BASIC;
            }
            return new G2DStroke(f, null, 0.0f);
        }
        return new G2DStroke(f, G2DStroke.decodePattern(f, s), (float)d);
    }

    private static final float[] decodePattern(float f, short s) {
        int n = 0xFFFF & s;
        int n2 = 0;
        int n3 = Integer.numberOfTrailingZeros(n);
        int n4 = Integer.numberOfLeadingZeros(n >>= n3) - 16;
        while (n != 0) {
            n3 = Integer.numberOfTrailingZeros(n);
            if (n3 == 0) {
                n3 = Integer.numberOfTrailingZeros(65535 - n);
            }
            G2DStroke.array[n2++] = n3;
            n >>= n3;
        }
        G2DStroke.array[n2] = n4;
        float[] fArray = new float[n2 + 1];
        for (int i = 0; i <= n2; ++i) {
            fArray[i] = (float)array[i] * f;
        }
        return fArray;
    }
}

