/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.scilab.forge.scirenderer.implementation.g2d.motor.AbstractDrawable3DObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Triangle;

public final class DrawTools {
    private static final Stroke stroke = new BasicStroke(1.0f, 0, 2);
    private static final Stroke EMPTYSTROKE = new BasicStroke(0.0f, 0, 2);
    private static final Color TRANSLUCENT_BLACK = new Color(0, 0, 0, 0);

    public static final void fillGouraud(Graphics2D graphics2D, Triangle triangle) {
        Path2D path2D = triangle.getProjectedContour();
        double[] dArray = new double[]{triangle.vertices[0].getX(), triangle.vertices[0].getY()};
        double[] dArray2 = new double[]{triangle.vertices[1].getX(), triangle.vertices[1].getY()};
        double[] dArray3 = new double[]{triangle.vertices[2].getX(), triangle.vertices[2].getY()};
        double[] dArray4 = DrawTools.get2DProjection(dArray[0], dArray[1], dArray2[0], dArray2[1], dArray3[0], dArray3[1]);
        double[] dArray5 = DrawTools.get2DProjection(dArray2[0], dArray2[1], dArray[0], dArray[1], dArray3[0], dArray3[1]);
        double[] dArray6 = DrawTools.get2DProjection(dArray3[0], dArray3[1], dArray[0], dArray[1], dArray2[0], dArray2[1]);
        Paint paint = graphics2D.getPaint();
        Area area = new Area(path2D);
        area.add(new Area(stroke.createStrokedShape(path2D)));
        GradientPaint gradientPaint = new GradientPaint((float)dArray[0], (float)dArray[1], triangle.colors[0], (float)dArray4[0], (float)dArray4[1], TRANSLUCENT_BLACK);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(path2D);
        gradientPaint = new GradientPaint((float)dArray2[0], (float)dArray2[1], triangle.colors[1], (float)dArray5[0], (float)dArray5[1], TRANSLUCENT_BLACK);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(path2D);
        gradientPaint = new GradientPaint((float)dArray3[0], (float)dArray3[1], triangle.colors[2], (float)dArray6[0], (float)dArray6[1], TRANSLUCENT_BLACK);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(path2D);
        graphics2D.setPaint(paint);
    }

    public static final void drawTriangleTexture(Graphics2D graphics2D, BufferedImage bufferedImage, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Object object) {
        try {
            double d = bufferedImage.getWidth();
            double d2 = bufferedImage.getHeight();
            Path2D.Double double_ = new Path2D.Double();
            double_.moveTo(dArray3[0], dArray4[0]);
            double_.lineTo(dArray3[1], dArray4[1]);
            double_.lineTo(dArray3[2], dArray4[2]);
            double_.closePath();
            Area area = new Area(double_);
            area.add(new Area(stroke.createStrokedShape(double_)));
            boolean bl = DrawTools.is1d(dArray, dArray2);
            if (DrawTools.checkSourceCoordinates(dArray, dArray2)) {
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n = (int)Math.floor(d * dArray[0]);
                Color color = n >= nArray.length ? new Color(nArray[nArray.length - 1]) : (n < 0 ? new Color(nArray[0]) : new Color(nArray[n]));
                graphics2D.setColor(color);
                graphics2D.fill(area);
                return;
            }
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(dArray3[0], dArray4[0]);
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(-d * dArray[0], -d2 * dArray2[0]);
            AffineTransform affineTransform3 = new AffineTransform(dArray3[1] - dArray3[0], dArray4[1] - dArray4[0], dArray3[2] - dArray3[0], dArray4[2] - dArray4[0], 0.0, 0.0);
            AffineTransform affineTransform4 = new AffineTransform(d * (dArray[1] - dArray[0]), d2 * (dArray2[1] - dArray2[0]), d * (dArray[2] - dArray[0]), d2 * (dArray2[2] - dArray2[0]), 0.0, 0.0).createInverse();
            AffineTransform affineTransform5 = new AffineTransform();
            affineTransform5.concatenate(affineTransform);
            affineTransform5.concatenate(affineTransform3);
            affineTransform5.concatenate(affineTransform4);
            affineTransform5.concatenate(affineTransform2);
            AffineTransform affineTransform6 = graphics2D.getTransform();
            DrawTools.clamp(graphics2D, dArray, dArray2, dArray3, dArray4, affineTransform5, bufferedImage);
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.setStroke(EMPTYSTROKE);
            Shape shape = graphics2D.getClip();
            graphics2D.clip(area);
            graphics2D.drawImage(bufferedImage, affineTransform5, null);
            graphics2D.setClip(shape);
            if (object2 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
            }
            graphics2D.setTransform(affineTransform6);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            System.err.println(noninvertibleTransformException);
        }
    }

    public static final void drawParallelogramTexture(Graphics2D graphics2D, BufferedImage bufferedImage, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Object object) {
        try {
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            double d = bufferedImage.getWidth();
            double d2 = bufferedImage.getHeight();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(dArray3[0], dArray4[0]);
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(-d * dArray[0], -d2 * dArray2[0]);
            AffineTransform affineTransform3 = new AffineTransform(dArray3[1] - dArray3[0], dArray4[1] - dArray4[0], dArray3[2] - dArray3[0], dArray4[2] - dArray4[0], 0.0, 0.0);
            AffineTransform affineTransform4 = new AffineTransform(d * (dArray[1] - dArray[0]), d2 * (dArray2[1] - dArray2[0]), d * (dArray[2] - dArray[0]), d2 * (dArray2[2] - dArray2[0]), 0.0, 0.0).createInverse();
            AffineTransform affineTransform5 = new AffineTransform();
            affineTransform5.concatenate(affineTransform);
            affineTransform5.concatenate(affineTransform3);
            affineTransform5.concatenate(affineTransform4);
            affineTransform5.concatenate(affineTransform2);
            AffineTransform affineTransform6 = graphics2D.getTransform();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage, affineTransform5, null);
            graphics2D.setTransform(affineTransform6);
            if (object2 != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    private static final boolean checkSourceCoordinates(double[] dArray, double[] dArray2) {
        if (DrawTools.is1d(dArray, dArray2)) {
            if (!(AbstractDrawable3DObject.isEqual(dArray[0], dArray[1]) || AbstractDrawable3DObject.isEqual(dArray[1], dArray[2]) || AbstractDrawable3DObject.isEqual(dArray[2], dArray[0]))) {
                dArray2[0] = 1.0;
            } else if (AbstractDrawable3DObject.isEqual(dArray[0], dArray[1]) && !AbstractDrawable3DObject.isEqual(dArray[1], dArray[2])) {
                dArray2[0] = 1.0;
            } else if (AbstractDrawable3DObject.isEqual(dArray[0], dArray[2]) && !AbstractDrawable3DObject.isEqual(dArray[2], dArray[1])) {
                dArray2[2] = 1.0;
            } else if (AbstractDrawable3DObject.isEqual(dArray[1], dArray[2]) && !AbstractDrawable3DObject.isEqual(dArray[2], dArray[0])) {
                dArray2[2] = 1.0;
            } else {
                return true;
            }
            dArray2[0] = !AbstractDrawable3DObject.isNull(dArray2[0]) ? 1.0 : 0.0;
            dArray2[1] = !AbstractDrawable3DObject.isNull(dArray2[1]) ? 1.0 : 0.0;
            dArray2[2] = !AbstractDrawable3DObject.isNull(dArray2[2]) ? 1.0 : 0.0;
        }
        return false;
    }

    private static final boolean is1d(double[] dArray, double[] dArray2) {
        return AbstractDrawable3DObject.isNull(dArray2[0]) && AbstractDrawable3DObject.isNull(dArray2[1]) && AbstractDrawable3DObject.isNull(dArray2[2]);
    }

    private static final void clamp(Graphics2D graphics2D, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, AffineTransform affineTransform, BufferedImage bufferedImage) {
        if (dArray[0] < 0.0 || dArray[1] < 0.0 || dArray[2] < 0.0 || dArray[0] > 1.0 || dArray[1] > 1.0 || dArray[2] > 1.0) {
            Area area;
            double d = bufferedImage.getWidth();
            double d2 = bufferedImage.getHeight();
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            Path2D.Double double_ = new Path2D.Double();
            double_.moveTo(d * dArray[0], d2 * dArray2[0]);
            double_.lineTo(d * dArray[1], d2 * dArray2[1]);
            double_.lineTo(d * dArray[2], d2 * dArray2[2]);
            double_.closePath();
            Area area2 = new Area(double_);
            Rectangle2D rectangle2D = area2.getBounds2D();
            if (rectangle2D.getX() < 0.0) {
                area = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), -rectangle2D.getX(), rectangle2D.getHeight()));
                area2.intersect(area);
                if (!area2.isEmpty()) {
                    area2.transform(affineTransform);
                    graphics2D.setColor(new Color(nArray[0]));
                    graphics2D.fill(area2);
                }
            }
            if (rectangle2D.getX() + rectangle2D.getWidth() > d) {
                area2 = new Area(double_);
                area = new Area(new Rectangle2D.Double(d, rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth() - d, rectangle2D.getHeight()));
                area2.intersect(area);
                if (!area2.isEmpty()) {
                    area2.transform(affineTransform);
                    graphics2D.setColor(new Color(nArray[nArray.length - 1]));
                    graphics2D.fill(area2);
                }
            }
        }
    }

    private static final double[] get2DProjection(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d5 - d3;
        double d8 = d6 - d4;
        double d9 = d7 * d7 + d8 * d8;
        double d10 = (d7 * (d - d3) + d8 * (d2 - d4)) / d9;
        return new double[]{d3 + d10 * d7, d4 + d10 * d8};
    }
}

